/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.capability;

import com.interactivemesh.j3d.capability.CapAbout;
import com.interactivemesh.j3d.capability.CapBitSelector;
import com.interactivemesh.j3d.capability.CapFrqBits;
import com.interactivemesh.j3d.capability.CapSGOType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeSelectionModel;

final class CapBitSelectorFrame
extends JFrame {
    private String[] fontFamilies = null;
    private CapSGOType currSGOtype = null;
    private CapSGOType.State currStateCap = CapSGOType.State.DEFAULT;
    private CapSGOType.State currStateFrq = CapSGOType.State.DEFAULT;
    private long currCapMask = 0L;
    private int currCapCt = 0;
    private long currCapLong = 0L;
    private long currFrqLong = 0L;
    private long defaultCaps = 0L;
    private long defaultFrqs = 0L;
    private boolean[] capArray = new boolean[50];
    private boolean[] frqArray = new boolean[50];
    private String[] classArray = new String[50];
    private String[] nameArray = new String[50];
    private int[] intArray = new int[50];
    private boolean[] bgMask = new boolean[50];
    private JSplitPane jSplitPane = null;
    private JPanel jPanelCaps = null;
    private JPanel buttonsTextPanel = null;
    private JTree jTreeSGO = null;
    private JToolBar jToolBar = null;
    private JLabel jLabelToolSGO = null;
    public CapabilityDataModel dataModel = null;
    private JTable capTable = null;
    private JTableHeader header = null;
    private TableColumnModel columnModel = null;
    private CellRendererCo234 cellRenderer234 = null;
    private CellRendererColActiv cellRendererCap = null;
    private CellRendererColActiv cellRendererFrq = null;
    private CellEditorColActiv cellEditorCap = null;
    private CellEditorColActiv cellEditorFrq = null;
    private JScrollPane jScrollTable = null;
    private JRadioButton jRadioCapAll = new JRadioButton("All");
    private JRadioButton jRadioCapDefault = new JRadioButton("Default  ");
    private JRadioButton jRadioCapNone = new JRadioButton("None");
    private JRadioButton jRadioCapSelect = new JRadioButton("Select");
    private JRadioButton jRadioCapEdit = new JRadioButton("Edit");
    private JRadioButton jRadioCapShow = new JRadioButton("Show");
    private JRadioButton jRadioFrqAll = new JRadioButton("All");
    private JRadioButton jRadioFrqDefault = new JRadioButton("Default  ");
    private JRadioButton jRadioFrqNone = new JRadioButton("None");
    private JRadioButton jRadioFrqSelect = new JRadioButton("Select");
    private JRadioButton jRadioFrqEdit = new JRadioButton("Edit");
    private JRadioButton jRadioFrqShow = new JRadioButton("Show");
    private JTextField jTextCapLong = new JTextField("0");
    private JTextField jTextFrqLong = new JTextField("0");
    private ActionListener capLongListener = null;
    private ActionListener frqLongListener = null;
    private Color bgColorDefault = Color.GREEN;
    private Color rowBgColor0 = Color.GREEN;
    private Color rowBgColor1 = Color.ORANGE;
    private Color signalColor = Color.ORANGE;
    private Font font = null;
    private Font fontI = null;
    private Font fontLong = null;
    private int rowHeight = 18;
    private CapBitSelector capBitSelector = null;

    CapBitSelectorFrame(CapBitSelector capBitSelector, Font font) {
        this.capBitSelector = capBitSelector;
        this.deriveFonts(font);
        this.bgColorDefault = new JPanel().getBackground();
        this.rowBgColor0 = new Color(168, 189, 209);
        this.rowBgColor1 = new Color(184, 207, 229);
        this.signalColor = new Color(255, 102, 51);
        this.createDialogPanel();
        this.setupTreeSelection(CapSGOType.SGO);
        this.jTreeSGO.setSelectionRow(0);
        UIManager.put("OptionPane.cancelButtonText", "Reset");
        UIManager.put("OptionPane.noButtonText", "No");
        UIManager.put("OptionPane.yesButtonText", "Yes");
    }

    void setPrefs() {
        this.capBitSelector.packPref.putInt("divLocation", this.jSplitPane.getDividerLocation());
    }

    private void deriveFonts(Font font) {
        this.font = font;
        int style = font.getStyle();
        this.fontI = font.deriveFont(style |= 2);
        int fontSize = font.getSize();
        this.fontLong = font.deriveFont((float)fontSize * 1.5f);
        GraphicsEnvironment graphEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Graphics2D gr2D = graphEnv.createGraphics(new BufferedImage(10, 10, 6));
        FontRenderContext fontRendCont = gr2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout("ALLOW", font, fontRendCont);
        Rectangle2D bounds = textLayout.getBounds();
        this.rowHeight = (int)(bounds.getHeight() * 2.0 + 0.5);
    }

    void updateComponentTreeUI() {
        this.deriveFonts(this.capBitSelector.theme.getFont());
        this.jTextCapLong.setFont(this.fontLong);
        this.jTextFrqLong.setFont(this.fontLong);
        this.cellRenderer234.updateUI();
        this.cellRendererCap.updateUI();
        this.cellRendererFrq.updateUI();
        this.cellEditorCap.updateUI();
        this.cellEditorFrq.updateUI();
        SwingUtilities.updateComponentTreeUI(this.jTreeSGO);
        SwingUtilities.updateComponentTreeUI(this.capTable);
        SwingUtilities.updateComponentTreeUI(this);
        this.buttonsTextPanel.setMinimumSize(this.buttonsTextPanel.getPreferredSize());
        this.buttonsTextPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.buttonsTextPanel.getPreferredSize().height));
        this.jTreeSGO.setBackground(this.bgColorDefault);
        this.capTable.setRowHeight(this.rowHeight);
        this.header.setPreferredSize(new Dimension(200, (int)((double)this.rowHeight * 1.2 + 0.5)));
        this.jTreeSGO.revalidate();
        this.jTreeSGO.repaint();
        this.capTable.revalidate();
        this.capTable.repaint();
        this.jSplitPane.revalidate();
        this.jSplitPane.repaint();
    }

    private void showAbout() {
        CapAbout capAbout = new CapAbout(this, this.font);
        JDialog jDialogAbout = capAbout.getAboutFrame();
        jDialogAbout.pack();
        Dimension dialogDim = jDialogAbout.getSize();
        Dimension ownerDim = this.getSize();
        Point ownerLoc = this.getLocation();
        jDialogAbout.setLocation(ownerLoc.x + (ownerDim.width - dialogDim.width) / 2, ownerLoc.y + 150);
        jDialogAbout.setVisible(true);
    }

    private void showFont() {
        FontDialog fontDialog = new FontDialog(this, this.font);
        Dimension dialogDim = fontDialog.getSize();
        Dimension ownerDim = this.getSize();
        Point ownerLoc = this.getLocation();
        fontDialog.setLocation(ownerLoc.x + (ownerDim.width - dialogDim.width) / 2, ownerLoc.y + 150);
        fontDialog.setVisible(true);
    }

    private void createDialogPanel() {
        this.jSplitPane = new JSplitPane();
        this.createSGOTree();
        this.jTreeSGO.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
        this.jTreeSGO.expandRow(0);
        this.jTreeSGO.expandRow(1);
        this.jTreeSGO.expandRow(4);
        JScrollPane jScrollPaneTree = new JScrollPane();
        jScrollPaneTree.getViewport().setView(this.jTreeSGO);
        this.jSplitPane.setLeftComponent(jScrollPaneTree);
        String[] no = new String[]{};
        this.setupTable(no);
        this.jScrollTable = new JScrollPane();
        this.dataModel = new CapabilityDataModel(0);
        this.capTable = new JTable(this.dataModel);
        this.capTable.setRowHeight(this.rowHeight);
        this.capTable.setBorder(BorderFactory.createEmptyBorder());
        this.capTable.setRowSelectionAllowed(true);
        this.header = this.capTable.getTableHeader();
        this.header.setReorderingAllowed(false);
        this.header.setPreferredSize(new Dimension(200, (int)((double)this.rowHeight * 1.2)));
        this.header.setBorder(BorderFactory.createEtchedBorder());
        this.cellRendererCap = new CellRendererColActiv();
        this.cellRendererFrq = new CellRendererColActiv();
        this.cellEditorCap = new CellEditorColActiv();
        this.cellEditorFrq = new CellEditorColActiv();
        this.cellRenderer234 = new CellRendererCo234();
        this.columnModel = this.capTable.getColumnModel();
        this.columnModel.setColumnSelectionAllowed(true);
        int fixedWidth = 2 * this.rowHeight;
        this.columnModel.getColumn(0).setMinWidth(fixedWidth);
        this.columnModel.getColumn(0).setMaxWidth(fixedWidth);
        this.columnModel.getColumn(0).setCellRenderer(this.cellRendererCap);
        this.columnModel.getColumn(0).setCellEditor(this.cellEditorCap);
        this.columnModel.getColumn(1).setMinWidth(fixedWidth);
        this.columnModel.getColumn(1).setMaxWidth(fixedWidth);
        this.columnModel.getColumn(1).setCellRenderer(this.cellRendererFrq);
        this.columnModel.getColumn(1).setCellEditor(this.cellEditorFrq);
        this.columnModel.getColumn(2).setPreferredWidth(120);
        this.columnModel.getColumn(2).setCellRenderer(this.cellRenderer234);
        this.columnModel.getColumn(3).setPreferredWidth(250);
        this.columnModel.getColumn(3).setCellRenderer(this.cellRenderer234);
        this.columnModel.getColumn(4).setMinWidth(fixedWidth);
        this.columnModel.getColumn(4).setMaxWidth(fixedWidth);
        this.columnModel.getColumn(4).setCellRenderer(this.cellRenderer234);
        this.jScrollTable.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollTable.getViewport().setView(this.capTable);
        this.jPanelCaps = new JPanel(new BorderLayout());
        this.jPanelCaps.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new BoxLayout(selectPanel, 1));
        this.jToolBar = new JToolBar();
        this.jToolBar.setFloatable(false);
        BoxLayout toolLayout = new BoxLayout(this.jToolBar, 0);
        this.jToolBar.setLayout(toolLayout);
        this.jLabelToolSGO = new JLabel("SceneGraphObject");
        this.jLabelToolSGO.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setOpaque(false);
        jMenuBar.setBorderPainted(false);
        jMenuBar.setAlignmentY(0.5f);
        JMenu jMenu = new JMenu("Menu");
        jMenu.setOpaque(false);
        jMenu.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JMenuItem jMenuItemAbout = new JMenuItem("About ..");
        JMenuItem jMenuItemFont = new JMenuItem("Font ..");
        JMenuItem jMenuItemExit = new JMenuItem("Exit");
        jMenu.add(jMenuItemAbout);
        jMenu.addSeparator();
        jMenu.add(jMenuItemFont);
        jMenu.addSeparator();
        jMenu.add(jMenuItemExit);
        jMenuBar.add(jMenu);
        jMenuItemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CapBitSelectorFrame.this.showAbout();
            }
        });
        jMenuItemFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CapBitSelectorFrame.this.showFont();
            }
        });
        jMenuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                CapBitSelectorFrame.this.capBitSelector.setFramePrefs(CapBitSelectorFrame.this);
                CapBitSelectorFrame.this.dispose();
                System.exit(0);
            }
        });
        this.jToolBar.add(this.jLabelToolSGO);
        this.jToolBar.add(Box.createHorizontalGlue());
        this.jToolBar.add(jMenuBar);
        this.jToolBar.add(Box.createHorizontalStrut(5));
        this.buttonsTextPanel = new JPanel();
        this.buttonsTextPanel.setLayout(new BoxLayout(this.buttonsTextPanel, 1));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        JPanel capPanel = new JPanel();
        capPanel.setLayout(new BoxLayout(capPanel, 1));
        TitledBorder capBorder = BorderFactory.createTitledBorder(" Capability Bits ");
        capBorder.setTitleColor(this.signalColor);
        capPanel.setBorder(BorderFactory.createCompoundBorder(capBorder, BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        JPanel capRadioPanel = new JPanel();
        capRadioPanel.setLayout(new GridLayout(2, 3, 0, 0));
        this.jRadioCapEdit.setBackground(this.rowBgColor0);
        this.jRadioCapShow.setBackground(this.rowBgColor0);
        this.jRadioCapShow.setEnabled(false);
        this.jTextCapLong.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jTextCapLong.setHorizontalAlignment(0);
        this.jTextCapLong.setFont(this.fontLong);
        this.jTextCapLong.setSelectionColor(this.rowBgColor0);
        this.jTextCapLong.setFocusable(true);
        this.jTextCapLong.setEditable(false);
        this.capLongListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (event.getSource() == CapBitSelectorFrame.this.jTextCapLong && CapBitSelectorFrame.this.currStateCap == CapSGOType.State.EDIT) {
                    CapBitSelectorFrame.this.switchCapState(CapSGOType.State.SHOW, false);
                }
            }
        };
        this.jTextCapLong.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    TextPopupMenu menu = new TextPopupMenu(CapBitSelectorFrame.this.jTextCapLong);
                    menu.show(CapBitSelectorFrame.this.jTextCapLong, event.getX() + 3, event.getY() + 3);
                }
            }
        });
        capRadioPanel.add(this.jRadioCapAll);
        capRadioPanel.add(this.jRadioCapDefault);
        capRadioPanel.add(this.jRadioCapNone);
        capRadioPanel.add(this.jRadioCapSelect);
        capRadioPanel.add(this.jRadioCapEdit);
        capRadioPanel.add(this.jRadioCapShow);
        JPanel longCapPanel = new JPanel();
        longCapPanel.setLayout(new GridLayout(0, 2, 0, 0));
        longCapPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 4, 0));
        JLabel longCapLabel = new JLabel("Long");
        longCapLabel.setForeground(this.signalColor);
        longCapPanel.add(longCapLabel);
        capPanel.add(capRadioPanel);
        capPanel.add(longCapPanel);
        capPanel.add(this.jTextCapLong);
        buttonsPanel.add(capPanel);
        buttonsPanel.add(Box.createHorizontalStrut(10));
        JPanel frqPanel = new JPanel();
        frqPanel.setLayout(new BoxLayout(frqPanel, 1));
        TitledBorder frqBorder = BorderFactory.createTitledBorder(" Frequent Bits ");
        frqBorder.setTitleColor(this.signalColor);
        frqPanel.setBorder(BorderFactory.createCompoundBorder(frqBorder, BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        JPanel frqRadioPanel = new JPanel();
        frqRadioPanel.setLayout(new GridLayout(2, 3, 0, 0));
        this.jRadioFrqEdit.setBackground(this.rowBgColor0);
        this.jRadioFrqShow.setBackground(this.rowBgColor0);
        this.jRadioFrqShow.setEnabled(false);
        this.jTextFrqLong.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jTextFrqLong.setHorizontalAlignment(0);
        this.jTextFrqLong.setFont(this.fontLong);
        this.jTextFrqLong.setSelectionColor(this.rowBgColor0);
        this.jTextFrqLong.setEditable(false);
        this.jTextFrqLong.setFocusable(true);
        this.frqLongListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (event.getSource() == CapBitSelectorFrame.this.jTextFrqLong && CapBitSelectorFrame.this.currStateFrq == CapSGOType.State.EDIT) {
                    CapBitSelectorFrame.this.switchFrqState(CapSGOType.State.SHOW, false);
                }
            }
        };
        this.jTextFrqLong.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    TextPopupMenu menu = new TextPopupMenu(CapBitSelectorFrame.this.jTextFrqLong);
                    menu.show(CapBitSelectorFrame.this.jTextFrqLong, event.getX() + 3, event.getY() + 3);
                }
            }
        });
        frqRadioPanel.add(this.jRadioFrqAll);
        frqRadioPanel.add(this.jRadioFrqDefault);
        frqRadioPanel.add(this.jRadioFrqNone);
        frqRadioPanel.add(this.jRadioFrqSelect);
        frqRadioPanel.add(this.jRadioFrqEdit);
        frqRadioPanel.add(this.jRadioFrqShow);
        JPanel longFrqPanel = new JPanel();
        longFrqPanel.setLayout(new GridLayout(0, 2, 0, 0));
        longFrqPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 4, 0));
        JLabel longFrqLabel = new JLabel("Long");
        longFrqLabel.setHorizontalTextPosition(2);
        longFrqLabel.setForeground(this.signalColor);
        longFrqPanel.add(longFrqLabel);
        frqPanel.add(frqRadioPanel);
        frqPanel.add(longFrqPanel);
        frqPanel.add(this.jTextFrqLong);
        buttonsPanel.add(frqPanel);
        this.buttonsTextPanel.add(buttonsPanel);
        ButtonGroup capGroup = new ButtonGroup();
        capGroup.add(this.jRadioCapAll);
        capGroup.add(this.jRadioCapDefault);
        capGroup.add(this.jRadioCapNone);
        capGroup.add(this.jRadioCapSelect);
        capGroup.add(this.jRadioCapEdit);
        capGroup.add(this.jRadioCapShow);
        ButtonGroup frqGroup = new ButtonGroup();
        frqGroup.add(this.jRadioFrqAll);
        frqGroup.add(this.jRadioFrqDefault);
        frqGroup.add(this.jRadioFrqNone);
        frqGroup.add(this.jRadioFrqSelect);
        frqGroup.add(this.jRadioFrqEdit);
        frqGroup.add(this.jRadioFrqShow);
        this.jRadioCapDefault.setSelected(true);
        this.jRadioFrqDefault.setSelected(true);
        ActionListener capActListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CapBitSelectorFrame.this.jRadioCapAll.isSelected() && CapBitSelectorFrame.this.currStateCap != CapSGOType.State.ALL) {
                    CapBitSelectorFrame.this.switchCapState(CapSGOType.State.ALL, false);
                } else if (CapBitSelectorFrame.this.jRadioCapDefault.isSelected() && CapBitSelectorFrame.this.currStateCap != CapSGOType.State.DEFAULT) {
                    CapBitSelectorFrame.this.switchCapState(CapSGOType.State.DEFAULT, false);
                } else if (CapBitSelectorFrame.this.jRadioCapNone.isSelected() && CapBitSelectorFrame.this.currStateCap != CapSGOType.State.NONE) {
                    CapBitSelectorFrame.this.switchCapState(CapSGOType.State.NONE, false);
                } else if (CapBitSelectorFrame.this.jRadioCapSelect.isSelected() && CapBitSelectorFrame.this.currStateCap != CapSGOType.State.SELECT) {
                    CapBitSelectorFrame.this.switchCapState(CapSGOType.State.SELECT, false);
                } else if (CapBitSelectorFrame.this.jRadioCapEdit.isSelected() && CapBitSelectorFrame.this.currStateCap != CapSGOType.State.EDIT) {
                    CapBitSelectorFrame.this.switchCapState(CapSGOType.State.EDIT, false);
                } else if (CapBitSelectorFrame.this.jRadioCapShow.isSelected() && CapBitSelectorFrame.this.currStateCap != CapSGOType.State.SHOW && CapBitSelectorFrame.this.currStateCap == CapSGOType.State.EDIT) {
                    CapBitSelectorFrame.this.switchCapState(CapSGOType.State.SHOW, false);
                }
            }
        };
        this.jRadioCapAll.addActionListener(capActListener);
        this.jRadioCapDefault.addActionListener(capActListener);
        this.jRadioCapNone.addActionListener(capActListener);
        this.jRadioCapSelect.addActionListener(capActListener);
        this.jRadioCapEdit.addActionListener(capActListener);
        this.jRadioCapShow.addActionListener(capActListener);
        ActionListener frqActListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CapBitSelectorFrame.this.jRadioFrqAll.isSelected() && CapBitSelectorFrame.this.currStateFrq != CapSGOType.State.ALL) {
                    CapBitSelectorFrame.this.switchFrqState(CapSGOType.State.ALL, false);
                } else if (CapBitSelectorFrame.this.jRadioFrqDefault.isSelected() && CapBitSelectorFrame.this.currStateFrq != CapSGOType.State.DEFAULT) {
                    CapBitSelectorFrame.this.switchFrqState(CapSGOType.State.DEFAULT, false);
                } else if (CapBitSelectorFrame.this.jRadioFrqNone.isSelected() && CapBitSelectorFrame.this.currStateFrq != CapSGOType.State.NONE) {
                    CapBitSelectorFrame.this.switchFrqState(CapSGOType.State.NONE, false);
                } else if (CapBitSelectorFrame.this.jRadioFrqSelect.isSelected() && CapBitSelectorFrame.this.currStateFrq != CapSGOType.State.SELECT) {
                    CapBitSelectorFrame.this.switchFrqState(CapSGOType.State.SELECT, false);
                } else if (CapBitSelectorFrame.this.jRadioFrqEdit.isSelected() && CapBitSelectorFrame.this.currStateFrq != CapSGOType.State.EDIT) {
                    CapBitSelectorFrame.this.switchFrqState(CapSGOType.State.EDIT, false);
                } else if (CapBitSelectorFrame.this.jRadioFrqShow.isSelected() && CapBitSelectorFrame.this.currStateFrq != CapSGOType.State.SHOW && CapBitSelectorFrame.this.currStateFrq == CapSGOType.State.EDIT) {
                    CapBitSelectorFrame.this.switchFrqState(CapSGOType.State.SHOW, false);
                }
            }
        };
        this.jRadioFrqAll.addActionListener(frqActListener);
        this.jRadioFrqDefault.addActionListener(frqActListener);
        this.jRadioFrqNone.addActionListener(frqActListener);
        this.jRadioFrqSelect.addActionListener(frqActListener);
        this.jRadioFrqEdit.addActionListener(frqActListener);
        this.jRadioFrqShow.addActionListener(frqActListener);
        this.buttonsTextPanel.setMinimumSize(this.buttonsTextPanel.getPreferredSize());
        this.buttonsTextPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.buttonsTextPanel.getPreferredSize().height));
        selectPanel.add(Box.createVerticalStrut(10));
        selectPanel.add(this.buttonsTextPanel);
        selectPanel.add(Box.createVerticalStrut(10));
        selectPanel.add(this.jScrollTable);
        this.jPanelCaps.add((Component)this.jToolBar, "North");
        this.jPanelCaps.add((Component)selectPanel, "Center");
        this.jSplitPane.setRightComponent(this.jPanelCaps);
        int divLoc = this.capBitSelector.packPref.getInt("divLocation", 100);
        if (divLoc >= 0) {
            this.jSplitPane.setDividerLocation(divLoc);
        }
        this.getContentPane().add(this.jSplitPane);
    }

    private void createSGOTree() {
        DefaultMutableTreeNode sgoNode = new DefaultMutableTreeNode((Object)CapSGOType.SGO);
        DefaultTreeModel treeModel = new DefaultTreeModel(sgoNode);
        this.jTreeSGO = new JTree(treeModel);
        this.jTreeSGO.putClientProperty("JTree.lineStyle", "Angled");
        this.jTreeSGO.setRowHeight(-1);
        this.jTreeSGO.setEditable(false);
        this.jTreeSGO.setRootVisible(true);
        this.jTreeSGO.setBackground(this.bgColorDefault);
        this.jTreeSGO.setCellRenderer(new SelectorTreeRenderer());
        final TreeSelectionModel selectionModel = this.jTreeSGO.getSelectionModel();
        selectionModel.setSelectionMode(1);
        selectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                if (selectionModel.isSelectionEmpty()) {
                    return;
                }
                DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selectionModel.getSelectionPath().getLastPathComponent();
                CapSGOType type = (CapSGOType)((Object)selNode.getUserObject());
                CapBitSelectorFrame.this.setupTreeSelection(type);
            }
        });
        DefaultMutableTreeNode nodeNode = new DefaultMutableTreeNode((Object)CapSGOType.NODE);
        DefaultMutableTreeNode nodecompNode = new DefaultMutableTreeNode((Object)CapSGOType.NODECOMP);
        sgoNode.add(nodeNode);
        sgoNode.add(nodecompNode);
        DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode((Object)CapSGOType.GROUP);
        DefaultMutableTreeNode orderedgroupNode = new DefaultMutableTreeNode((Object)CapSGOType.ORDEREDGROUP);
        groupNode.add(new DefaultMutableTreeNode((Object)CapSGOType.BRANCHGROUP));
        orderedgroupNode.add(new DefaultMutableTreeNode((Object)CapSGOType.DECALGROUP));
        groupNode.add(orderedgroupNode);
        groupNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SHAREDGROUP));
        groupNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SWITCH));
        groupNode.add(new DefaultMutableTreeNode((Object)CapSGOType.TRANSFORMGROUP));
        groupNode.add(new DefaultMutableTreeNode((Object)CapSGOType.VIEWSPECGROUP));
        nodeNode.add(groupNode);
        DefaultMutableTreeNode leafNode = new DefaultMutableTreeNode((Object)CapSGOType.LEAF);
        DefaultMutableTreeNode behNode = new DefaultMutableTreeNode((Object)CapSGOType.BEHAVIOR);
        DefaultMutableTreeNode fogNode = new DefaultMutableTreeNode((Object)CapSGOType.FOG);
        DefaultMutableTreeNode interpNode = new DefaultMutableTreeNode((Object)CapSGOType.INTERPOLATOR);
        DefaultMutableTreeNode interpTNode = new DefaultMutableTreeNode((Object)CapSGOType.INTERPOLATOR_T);
        DefaultMutableTreeNode interpPNode = new DefaultMutableTreeNode((Object)CapSGOType.INTERPOLATOR_TP);
        DefaultMutableTreeNode lightNode = new DefaultMutableTreeNode((Object)CapSGOType.LIGHT);
        DefaultMutableTreeNode lightPtNode = new DefaultMutableTreeNode((Object)CapSGOType.LIGHTPOINT);
        DefaultMutableTreeNode lodNode = new DefaultMutableTreeNode((Object)CapSGOType.LOD);
        DefaultMutableTreeNode shape3dNode = new DefaultMutableTreeNode((Object)CapSGOType.SHAPE3D);
        DefaultMutableTreeNode soundNode = new DefaultMutableTreeNode((Object)CapSGOType.SOUND);
        DefaultMutableTreeNode soundPtNode = new DefaultMutableTreeNode((Object)CapSGOType.SOUNDPOINT);
        leafNode.add(new DefaultMutableTreeNode((Object)CapSGOType.ALTAPPEARANCE));
        leafNode.add(new DefaultMutableTreeNode((Object)CapSGOType.BACKGROUND));
        behNode.add(new DefaultMutableTreeNode((Object)CapSGOType.BILLBOARD));
        interpNode.add(new DefaultMutableTreeNode((Object)CapSGOType.INT_COLOR));
        interpNode.add(new DefaultMutableTreeNode((Object)CapSGOType.INT_SWITCH));
        interpPNode.add(new DefaultMutableTreeNode((Object)CapSGOType.INT_PATH_POS));
        interpPNode.add(new DefaultMutableTreeNode((Object)CapSGOType.INT_PATH_ROT));
        interpPNode.add(new DefaultMutableTreeNode((Object)CapSGOType.INT_PATH_ROTPOS));
        interpPNode.add(new DefaultMutableTreeNode((Object)CapSGOType.INT_PATH_ROTPOSSCALE));
        interpTNode.add(interpPNode);
        interpTNode.add(new DefaultMutableTreeNode((Object)CapSGOType.INT_POSITION));
        interpTNode.add(new DefaultMutableTreeNode((Object)CapSGOType.INT_ROTATION));
        interpTNode.add(new DefaultMutableTreeNode((Object)CapSGOType.INT_SCALE));
        interpNode.add(interpTNode);
        interpNode.add(new DefaultMutableTreeNode((Object)CapSGOType.INT_TRANSP));
        behNode.add(interpNode);
        lodNode.add(new DefaultMutableTreeNode((Object)CapSGOType.LOD_DIST));
        behNode.add(lodNode);
        leafNode.add(behNode);
        leafNode.add(new DefaultMutableTreeNode((Object)CapSGOType.BOUNDINGLEAF));
        leafNode.add(new DefaultMutableTreeNode((Object)CapSGOType.CLIP));
        fogNode.add(new DefaultMutableTreeNode((Object)CapSGOType.FOGEXPO));
        fogNode.add(new DefaultMutableTreeNode((Object)CapSGOType.FOGLIN));
        leafNode.add(fogNode);
        lightNode.add(new DefaultMutableTreeNode((Object)CapSGOType.LIGHTAMBIENT));
        lightNode.add(new DefaultMutableTreeNode((Object)CapSGOType.LIGHTDIRECT));
        lightPtNode.add(new DefaultMutableTreeNode((Object)CapSGOType.LIGHTSPOT));
        lightNode.add(lightPtNode);
        leafNode.add(lightNode);
        leafNode.add(new DefaultMutableTreeNode((Object)CapSGOType.LINK));
        leafNode.add(new DefaultMutableTreeNode((Object)CapSGOType.MODELCLIP));
        leafNode.add(new DefaultMutableTreeNode((Object)CapSGOType.MORPH));
        shape3dNode.add(new DefaultMutableTreeNode((Object)CapSGOType.O_SHAPE3D));
        leafNode.add(shape3dNode);
        soundNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SOUNDBACK));
        soundPtNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SOUNDCONE));
        soundNode.add(soundPtNode);
        leafNode.add(soundNode);
        leafNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SOUNDSCAPE));
        leafNode.add(new DefaultMutableTreeNode((Object)CapSGOType.VIEWPLATFORM));
        nodeNode.add(leafNode);
        DefaultMutableTreeNode appearNode = new DefaultMutableTreeNode((Object)CapSGOType.APPEARANCE);
        DefaultMutableTreeNode depthNode = new DefaultMutableTreeNode((Object)CapSGOType.DEPTH);
        DefaultMutableTreeNode geomNode = new DefaultMutableTreeNode((Object)CapSGOType.GEOMETRY);
        DefaultMutableTreeNode geomANode = new DefaultMutableTreeNode((Object)CapSGOType.GEOMETRYARRAY);
        DefaultMutableTreeNode geomStANode = new DefaultMutableTreeNode((Object)CapSGOType.GEOMETRYSTRIPARRAY);
        DefaultMutableTreeNode geomAINode = new DefaultMutableTreeNode((Object)CapSGOType.INDEXEDGEOMETRYARRAY);
        DefaultMutableTreeNode geomStAINode = new DefaultMutableTreeNode((Object)CapSGOType.INDEXEDGEOMETRYSTRIPARRAY);
        DefaultMutableTreeNode imageNode = new DefaultMutableTreeNode((Object)CapSGOType.IMAGE);
        DefaultMutableTreeNode shaderNode = new DefaultMutableTreeNode((Object)CapSGOType.SHADER);
        DefaultMutableTreeNode shaderAttrNode = new DefaultMutableTreeNode((Object)CapSGOType.SHADERATTR);
        DefaultMutableTreeNode shaderAttrObjNode = new DefaultMutableTreeNode((Object)CapSGOType.SHADERATTR_OBJECT);
        DefaultMutableTreeNode shaderPrgNode = new DefaultMutableTreeNode((Object)CapSGOType.SHADERPROG);
        DefaultMutableTreeNode textureNode = new DefaultMutableTreeNode((Object)CapSGOType.TEXTURE);
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.ALPHA));
        appearNode.add(new DefaultMutableTreeNode((Object)CapSGOType.APPEARANCE_SHADER));
        nodecompNode.add(appearNode);
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.AURAL));
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.COLORING));
        depthNode.add(new DefaultMutableTreeNode((Object)CapSGOType.DEPTH_FLOAT));
        depthNode.add(new DefaultMutableTreeNode((Object)CapSGOType.DEPTH_INT));
        depthNode.add(new DefaultMutableTreeNode((Object)CapSGOType.DEPTH_NATIVE));
        nodecompNode.add(depthNode);
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.FONT3D));
        geomNode.add(new DefaultMutableTreeNode((Object)CapSGOType.CG));
        geomStANode.add(new DefaultMutableTreeNode((Object)CapSGOType.LINESTRIP));
        geomStANode.add(new DefaultMutableTreeNode((Object)CapSGOType.TRIAFAN));
        geomStANode.add(new DefaultMutableTreeNode((Object)CapSGOType.TRIASTRIP));
        geomANode.add(geomStANode);
        geomStAINode.add(new DefaultMutableTreeNode((Object)CapSGOType.LINESTRIP_I));
        geomStAINode.add(new DefaultMutableTreeNode((Object)CapSGOType.TRIAFAN_I));
        geomStAINode.add(new DefaultMutableTreeNode((Object)CapSGOType.TRIASTRIP_I));
        geomAINode.add(geomStAINode);
        geomAINode.add(new DefaultMutableTreeNode((Object)CapSGOType.LINEARRAY_I));
        geomAINode.add(new DefaultMutableTreeNode((Object)CapSGOType.POINTARRAY_I));
        geomAINode.add(new DefaultMutableTreeNode((Object)CapSGOType.QUADARRAY_I));
        geomAINode.add(new DefaultMutableTreeNode((Object)CapSGOType.TRIAARRAY_I));
        geomANode.add(geomAINode);
        geomANode.add(new DefaultMutableTreeNode((Object)CapSGOType.LINEARRAY));
        geomANode.add(new DefaultMutableTreeNode((Object)CapSGOType.POINTARRAY));
        geomANode.add(new DefaultMutableTreeNode((Object)CapSGOType.QUADARRAY));
        geomANode.add(new DefaultMutableTreeNode((Object)CapSGOType.TRIAARRAY));
        geomNode.add(geomANode);
        geomNode.add(new DefaultMutableTreeNode((Object)CapSGOType.RASTER));
        geomNode.add(new DefaultMutableTreeNode((Object)CapSGOType.TEXT3D));
        nodecompNode.add(geomNode);
        imageNode.add(new DefaultMutableTreeNode((Object)CapSGOType.IMAGE2D));
        imageNode.add(new DefaultMutableTreeNode((Object)CapSGOType.IMAGE3D));
        nodecompNode.add(imageNode);
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.LINE));
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.MATERIAL));
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.MEDIA));
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.POINT));
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.POLYGON));
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.RENDERING));
        shaderNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SHADER_SOURCECODE));
        nodecompNode.add(shaderNode);
        shaderAttrNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SHADERATTR_BINDING));
        shaderAttrObjNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SHADERATTR_ARRAY));
        shaderAttrObjNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SHADERATTR_VALUE));
        shaderAttrNode.add(shaderAttrObjNode);
        nodecompNode.add(shaderAttrNode);
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SHADERATTRSET));
        shaderPrgNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SHADERPROG_CG));
        shaderPrgNode.add(new DefaultMutableTreeNode((Object)CapSGOType.SHADERPROG_GLSL));
        nodecompNode.add(shaderPrgNode);
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.TEX_COORD));
        textureNode.add(new DefaultMutableTreeNode((Object)CapSGOType.TEX_2D));
        textureNode.add(new DefaultMutableTreeNode((Object)CapSGOType.TEX_3D));
        textureNode.add(new DefaultMutableTreeNode((Object)CapSGOType.TEX_CM));
        nodecompNode.add(textureNode);
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.TEX_ATTRIB));
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.TEX_UNIT));
        nodecompNode.add(new DefaultMutableTreeNode((Object)CapSGOType.TRANSPARENCY));
    }

    private void setupTreeSelection(CapSGOType type) {
        this.currSGOtype = type;
        this.currCapMask = this.currSGOtype.getCapMask();
        this.currCapLong = this.currSGOtype.getCurrCaps();
        this.currFrqLong = this.currSGOtype.getCurrFrqs();
        this.defaultCaps = this.currSGOtype.getDefaultCaps();
        this.defaultFrqs = this.currSGOtype.getDefaultFrqs();
        String[] capStringsArray = null;
        if (this.currSGOtype == CapSGOType.SGO) {
            capStringsArray = new String[]{};
        } else if (this.currSGOtype == CapSGOType.NODE) {
            capStringsArray = CapFrqBits.getCapStringsOfLeaf(this.currSGOtype);
        } else if (this.currSGOtype == CapSGOType.NODECOMP) {
            capStringsArray = new String[]{};
        } else if (this.currSGOtype.isGroup()) {
            capStringsArray = CapFrqBits.getCapStringsOfGroup(this.currSGOtype);
        } else if (this.currSGOtype.isLeaf()) {
            capStringsArray = CapFrqBits.getCapStringsOfLeaf(this.currSGOtype);
        } else if (this.currSGOtype.isAppear()) {
            capStringsArray = CapFrqBits.getCapStringsOfAppear(this.currSGOtype);
        } else if (this.currSGOtype.isGeom()) {
            capStringsArray = CapFrqBits.getCapStringsOfGeom(this.currSGOtype);
        }
        if (capStringsArray == null) {
            capStringsArray = new String[]{};
        }
        this.currCapCt = capStringsArray.length;
        this.setupTable(capStringsArray);
        boolean isButtonEnabled = !this.currSGOtype.isAbstract() && this.currCapCt > 0;
        this.setButtonsEnabled(isButtonEnabled);
        this.dataModel.updateModel(this.currCapCt);
        this.switchCapState(this.currSGOtype.getStateCap(), true);
        this.switchFrqState(this.currSGOtype.getStateFrq(), true);
        this.jLabelToolSGO.setText(this.currSGOtype.getClassName());
        this.jToolBar.repaint();
        this.refreshTable();
        this.refreshButtons();
        this.refreshCapLongText();
        this.refreshFrqLongText();
    }

    private void refreshButtons() {
        if (this.currStateCap == CapSGOType.State.ALL) {
            this.jRadioCapAll.setSelected(true);
        } else if (this.currStateCap == CapSGOType.State.DEFAULT) {
            this.jRadioCapDefault.setSelected(true);
        } else if (this.currStateCap == CapSGOType.State.NONE) {
            this.jRadioCapNone.setSelected(true);
        } else if (this.currStateCap == CapSGOType.State.SELECT) {
            this.jRadioCapSelect.setSelected(true);
        } else if (this.currStateCap == CapSGOType.State.EDIT) {
            this.jRadioCapEdit.setSelected(true);
        } else if (this.currStateCap == CapSGOType.State.SHOW) {
            this.jRadioCapShow.setSelected(true);
        }
        if (this.currStateFrq == CapSGOType.State.ALL) {
            this.jRadioFrqAll.setSelected(true);
        } else if (this.currStateFrq == CapSGOType.State.DEFAULT) {
            this.jRadioFrqDefault.setSelected(true);
        } else if (this.currStateFrq == CapSGOType.State.NONE) {
            this.jRadioFrqNone.setSelected(true);
        } else if (this.currStateFrq == CapSGOType.State.SELECT) {
            this.jRadioFrqSelect.setSelected(true);
        } else if (this.currStateFrq == CapSGOType.State.EDIT) {
            this.jRadioFrqEdit.setSelected(true);
        } else if (this.currStateFrq == CapSGOType.State.SHOW) {
            this.jRadioFrqShow.setSelected(true);
        }
    }

    private void setButtonsEnabled(boolean enable) {
        this.jRadioCapAll.setEnabled(enable);
        this.jRadioCapDefault.setEnabled(enable);
        this.jRadioCapNone.setEnabled(enable);
        this.jRadioCapSelect.setEnabled(enable);
        this.jRadioCapEdit.setEnabled(enable);
        this.jRadioCapShow.setEnabled(false);
        this.jRadioFrqAll.setEnabled(enable);
        this.jRadioFrqDefault.setEnabled(enable);
        this.jRadioFrqNone.setEnabled(enable);
        this.jRadioFrqSelect.setEnabled(enable);
        this.jRadioFrqEdit.setEnabled(enable);
        this.jRadioFrqShow.setEnabled(false);
    }

    private void setCapTextEditable(boolean edit, boolean failed) {
        this.jTextCapLong.setEditable(edit);
        if (edit) {
            if (failed) {
                this.jTextCapLong.setBackground(this.signalColor);
            } else {
                this.jTextCapLong.setBackground(Color.WHITE);
                this.addRemoveTextListenerCap(true);
            }
            this.jTextCapLong.requestFocusInWindow();
        } else {
            this.jTextCapLong.setBackground(this.bgColorDefault);
            this.addRemoveTextListenerCap(false);
        }
        this.jTextCapLong.repaint();
    }

    private void setFrqTextEditable(boolean edit, boolean failed) {
        this.jTextFrqLong.setEditable(edit);
        if (edit) {
            if (failed) {
                this.jTextFrqLong.setBackground(this.signalColor);
            } else {
                this.jTextFrqLong.setBackground(Color.WHITE);
                this.addRemoveTextListenerFrq(true);
            }
            this.jTextFrqLong.requestFocusInWindow();
        } else {
            this.jTextFrqLong.setBackground(this.bgColorDefault);
            this.addRemoveTextListenerFrq(false);
        }
        this.jTextFrqLong.repaint();
    }

    private void addRemoveTextListenerCap(boolean add) {
        if (add) {
            this.jTextCapLong.removeActionListener(this.capLongListener);
            this.jTextCapLong.addActionListener(this.capLongListener);
        } else {
            this.jTextCapLong.removeActionListener(this.capLongListener);
        }
    }

    private void addRemoveTextListenerFrq(boolean add) {
        if (add) {
            this.jTextFrqLong.removeActionListener(this.frqLongListener);
            this.jTextFrqLong.addActionListener(this.frqLongListener);
        } else {
            this.jTextFrqLong.removeActionListener(this.frqLongListener);
        }
    }

    private void refreshCapLongText() {
        this.jTextCapLong.setText(Long.toString(this.currCapLong));
    }

    private void refreshFrqLongText() {
        this.jTextFrqLong.setText(Long.toString(this.currFrqLong));
    }

    private void refreshTable() {
        this.jScrollTable.revalidate();
        this.capTable.revalidate();
        this.jScrollTable.repaint();
        this.capTable.repaint();
    }

    private void switchCapState(CapSGOType.State newState, boolean isLoad) {
        this.cellEditorCap.setCellEditable(false);
        if (newState == CapSGOType.State.SHOW) {
            if (isLoad) {
                this.setCapFrqArray(this.currCapLong, this.intArray, this.capArray);
                this.setCapTextEditable(false, false);
            } else {
                long value = 0L;
                String failedMessage = null;
                String text = this.jTextCapLong.getText();
                if (text != null && text.length() > 0) {
                    try {
                        value = Long.parseLong(text);
                        if (value < 0L) {
                            failedMessage = "Capability bits < 0 !";
                        }
                    }
                    catch (NumberFormatException e) {
                        failedMessage = "No long format !";
                    }
                } else {
                    failedMessage = "No capability bits !";
                }
                if (!this.jRadioCapShow.isSelected()) {
                    this.addRemoveTextListenerCap(false);
                }
                if (failedMessage != null) {
                    JOptionPane.showMessageDialog(this.jPanelCaps, failedMessage, "Capability Bits failed !", 0);
                    value = -1L;
                } else {
                    value = this.checkEditLong(value, this.currCapMask);
                }
                if (!this.jRadioCapShow.isSelected()) {
                    this.addRemoveTextListenerCap(true);
                }
                if (value == -2L) {
                    this.updateCapLong();
                    this.setCapTextEditable(true, false);
                    this.jRadioCapEdit.setSelected(true);
                    return;
                }
                if (value == -1L) {
                    this.setCapTextEditable(true, true);
                    this.jRadioCapEdit.setSelected(true);
                    return;
                }
                this.setCapTextEditable(false, false);
                if (!this.jRadioCapShow.isSelected()) {
                    this.jRadioCapShow.setSelected(true);
                    this.jRadioCapShow.requestFocusInWindow();
                }
                this.jRadioCapShow.setEnabled(false);
                this.jRadioCapEdit.setBackground(this.bgColorDefault);
                this.jRadioCapShow.setBackground(this.bgColorDefault);
                this.setCapFrqArray(value, this.intArray, this.capArray);
                this.updateCapLong();
            }
        } else if (newState == CapSGOType.State.EDIT) {
            this.jRadioCapEdit.setBackground(this.rowBgColor0);
            this.jRadioCapShow.setBackground(this.rowBgColor0);
            this.jRadioCapShow.setEnabled(true);
            this.setCapTextEditable(true, false);
            if (isLoad) {
                this.setCapFrqArray(this.currCapLong, this.intArray, this.capArray);
            }
        } else {
            this.setCapTextEditable(false, false);
            this.jRadioCapEdit.setBackground(this.bgColorDefault);
            this.jRadioCapShow.setBackground(this.bgColorDefault);
            if (newState == CapSGOType.State.SELECT) {
                this.jRadioCapShow.setEnabled(false);
                if (isLoad) {
                    this.setCapFrqArray(this.currCapLong, this.intArray, this.capArray);
                }
                this.cellEditorCap.setCellEditable(true);
            } else {
                this.jRadioCapShow.setEnabled(false);
                if (newState == CapSGOType.State.ALL) {
                    int i = 0;
                    while (i < this.currCapCt) {
                        this.capArray[i] = true;
                        ++i;
                    }
                } else if (newState == CapSGOType.State.NONE) {
                    int i = 0;
                    while (i < this.currCapCt) {
                        this.capArray[i] = false;
                        ++i;
                    }
                } else if (newState == CapSGOType.State.DEFAULT) {
                    this.setCapFrqArray(this.defaultCaps, this.intArray, this.capArray);
                }
                this.updateCapLong();
            }
        }
        this.currStateCap = newState;
        this.currSGOtype.setStateCap(this.currStateCap);
        this.cellEditorCap.setState(newState);
        this.cellRendererCap.setState(newState);
        this.refreshTable();
    }

    private void switchFrqState(CapSGOType.State newState, boolean isLoad) {
        this.cellEditorFrq.setCellEditable(false);
        if (newState == CapSGOType.State.SHOW) {
            if (isLoad) {
                this.setCapFrqArray(this.currFrqLong, this.intArray, this.frqArray);
                this.setFrqTextEditable(false, false);
            } else {
                long value = 0L;
                String failedMessage = null;
                String text = this.jTextFrqLong.getText();
                if (text != null && text.length() > 0) {
                    try {
                        value = Long.parseLong(text);
                        if (value < 0L) {
                            failedMessage = "Frequent bits < 0 !";
                        }
                    }
                    catch (NumberFormatException e) {
                        failedMessage = "No long format !";
                    }
                } else {
                    failedMessage = "No frequent bits !";
                }
                if (!this.jRadioFrqShow.isSelected()) {
                    this.addRemoveTextListenerFrq(false);
                }
                if (failedMessage != null) {
                    JOptionPane.showMessageDialog(this.jPanelCaps, failedMessage, "Frequent Bits failed !", 0);
                    value = -1L;
                } else {
                    value = this.checkEditLong(value, this.currCapMask);
                }
                if (!this.jRadioFrqShow.isSelected()) {
                    this.addRemoveTextListenerFrq(true);
                }
                if (value == -2L) {
                    this.updateFrqLong();
                    this.setFrqTextEditable(true, false);
                    this.jRadioFrqEdit.setSelected(true);
                    return;
                }
                if (value == -1L) {
                    this.setFrqTextEditable(true, true);
                    this.jRadioFrqEdit.setSelected(true);
                    return;
                }
                this.setFrqTextEditable(false, false);
                if (!this.jRadioFrqShow.isSelected()) {
                    this.jRadioFrqShow.setSelected(true);
                    this.jRadioFrqShow.requestFocusInWindow();
                }
                this.jRadioFrqShow.setEnabled(false);
                this.jRadioFrqEdit.setBackground(this.bgColorDefault);
                this.jRadioFrqShow.setBackground(this.bgColorDefault);
                this.setCapFrqArray(value, this.intArray, this.frqArray);
                this.updateFrqLong();
            }
        } else if (newState == CapSGOType.State.EDIT) {
            this.jRadioFrqEdit.setBackground(this.rowBgColor0);
            this.jRadioFrqShow.setBackground(this.rowBgColor0);
            this.jRadioFrqShow.setEnabled(true);
            this.setFrqTextEditable(true, false);
            if (isLoad) {
                this.setCapFrqArray(this.currFrqLong, this.intArray, this.frqArray);
            }
        } else {
            this.setFrqTextEditable(false, false);
            this.jRadioFrqEdit.setBackground(this.bgColorDefault);
            this.jRadioFrqShow.setBackground(this.bgColorDefault);
            if (newState == CapSGOType.State.SELECT) {
                this.jRadioFrqShow.setEnabled(false);
                if (isLoad) {
                    this.setCapFrqArray(this.currFrqLong, this.intArray, this.frqArray);
                }
                this.cellEditorFrq.setCellEditable(true);
            } else {
                this.jRadioFrqShow.setEnabled(false);
                if (newState == CapSGOType.State.ALL) {
                    int i = 0;
                    while (i < this.currCapCt) {
                        this.frqArray[i] = true;
                        ++i;
                    }
                } else if (newState == CapSGOType.State.NONE) {
                    int i = 0;
                    while (i < this.currCapCt) {
                        this.frqArray[i] = false;
                        ++i;
                    }
                } else if (newState == CapSGOType.State.DEFAULT) {
                    this.setCapFrqArray(this.defaultFrqs, this.intArray, this.frqArray);
                }
                this.updateFrqLong();
            }
        }
        this.currStateFrq = newState;
        this.currSGOtype.setStateFrq(this.currStateFrq);
        this.cellEditorFrq.setState(newState);
        this.cellRendererFrq.setState(newState);
        this.refreshTable();
    }

    private void updateCapLong() {
        long caps = 0L;
        int i = 0;
        while (i < this.currCapCt) {
            if (this.capArray[i]) {
                caps |= 1L << this.intArray[i];
            }
            ++i;
        }
        this.currCapLong = caps;
        this.currSGOtype.setCurrCaps(this.currCapLong);
        this.refreshCapLongText();
    }

    private void updateFrqLong() {
        long frqs = 0L;
        int i = 0;
        while (i < this.currCapCt) {
            if (this.frqArray[i]) {
                frqs |= 1L << this.intArray[i];
            }
            ++i;
        }
        this.currFrqLong = frqs;
        this.currSGOtype.setCurrFrqs(this.currFrqLong);
        this.refreshFrqLongText();
    }

    private void setCapFrqArray(long capfrqLong, int[] capInts, boolean[] capfrqBits) {
        int j = 0;
        int capCt = capInts.length;
        while (j < capCt) {
            capfrqBits[j] = (capfrqLong & 1L << capInts[j]) != 0L;
            ++j;
        }
    }

    private long checkEditLong(long editLong, long mask) {
        ArrayList<Integer> bits = new ArrayList<Integer>();
        long bit = 1L;
        int j = 0;
        while (j < 64) {
            bit = 1L << j;
            if ((editLong & bit) != 0L && (mask & bit) == 0L) {
                bits.add(j);
            }
            ++j;
        }
        if (!bits.isEmpty()) {
            StringBuffer bitsBuffer = new StringBuffer();
            int i = 0;
            int z = bits.size();
            while (i < z) {
                bitsBuffer.append(", ");
                bitsBuffer.append(bits.get(i));
                ++i;
            }
            String bitsString = bitsBuffer.substring(2);
            String message = "These bits do not represent capability bits for this class !\n\n" + bitsString + "\n\nDo you want to eliminate these bits ?\n\n";
            JOptionPane jOptionPane = new JOptionPane(message, 3, 1);
            JDialog dialog = jOptionPane.createDialog(this.jPanelCaps, "Bits not supported !");
            dialog.setVisible(true);
            Object selectedOption = jOptionPane.getValue();
            if (selectedOption == null) {
                return -2L;
            }
            if (!(selectedOption instanceof Integer)) {
                return -2L;
            }
            int response = (Integer)selectedOption;
            if (response == 0) {
                int i2 = 0;
                int z2 = bits.size();
                while (i2 < z2) {
                    editLong &= 1L << (Integer)bits.get(i2) ^ 0xFFFFFFFFFFFFFFFFL;
                    ++i2;
                }
                return editLong;
            }
            if (response == 1) {
                return -1L;
            }
            return -2L;
        }
        return editLong;
    }

    private void setupTable(String[] capNamesArray) {
        if (this.currCapCt < 1) {
            this.bgMask[0] = true;
            this.classArray[0] = "";
            this.nameArray[0] = "No Capability Bits";
            this.capArray[0] = false;
            this.frqArray[0] = false;
            this.intArray[0] = 0;
        } else {
            boolean next;
            this.bgMask[0] = next = true;
            String capName = capNamesArray[0];
            this.classArray[0] = capName.substring(0, capName.indexOf("."));
            this.nameArray[0] = capName.substring(capName.indexOf(".") + 1, capName.lastIndexOf("."));
            this.intArray[0] = Integer.parseInt(capName.substring(capName.lastIndexOf(".") + 1));
            String lastClass = this.classArray[0];
            int i = 1;
            while (i < capNamesArray.length) {
                capName = capNamesArray[i];
                this.classArray[i] = capName.substring(0, capName.indexOf("."));
                this.nameArray[i] = capName.substring(capName.indexOf(".") + 1, capName.lastIndexOf("."));
                this.intArray[i] = Integer.parseInt(capName.substring(capName.lastIndexOf(".") + 1));
                if (!lastClass.equalsIgnoreCase(this.classArray[i])) {
                    lastClass = this.classArray[i];
                    next = !next;
                }
                this.bgMask[i] = next;
                ++i;
            }
            this.setCapFrqArray(this.currCapLong, this.intArray, this.capArray);
            this.setCapFrqArray(this.currFrqLong, this.intArray, this.frqArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CapabilityDataModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Cap", "Frq", "Class", "Capability", "Int"};
        private int rowCt = 1;
        private boolean isEmpty = true;

        private CapabilityDataModel(int rows) {
            this.updateModel(rows);
        }

        void updateModel(int rows) {
            this.rowCt = rows;
            this.isEmpty = false;
            if (this.rowCt < 1) {
                this.isEmpty = true;
                ++this.rowCt;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.rowCt;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return (col == 0 || col == 1) && !this.isEmpty;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (this.isEmpty) {
                return;
            }
            if (col == 0) {
                ((CapBitSelectorFrame)CapBitSelectorFrame.this).capArray[row] = (Boolean)value;
                CapBitSelectorFrame.this.updateCapLong();
            } else if (col == 1) {
                ((CapBitSelectorFrame)CapBitSelectorFrame.this).frqArray[row] = (Boolean)value;
                CapBitSelectorFrame.this.updateFrqLong();
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return CapBitSelectorFrame.this.capArray[row];
            }
            if (col == 1) {
                return CapBitSelectorFrame.this.frqArray[row];
            }
            if (col == 2) {
                return CapBitSelectorFrame.this.classArray[row];
            }
            if (col == 3) {
                return CapBitSelectorFrame.this.nameArray[row];
            }
            if (col == 4) {
                if (this.isEmpty) {
                    return new String("");
                }
                return CapBitSelectorFrame.this.intArray[row];
            }
            return null;
        }
    }

    private final class CellEditorColActiv
    extends AbstractCellEditor
    implements TableCellEditor {
        private JPanel jPanelRenderer;
        private Color bgColor = null;
        private boolean isEditable = false;
        private int selRow;
        private int selCol;
        private boolean editorValue = false;
        private ItemListener itemListener;
        private CapSGOType.State currState = CapSGOType.State.DEFAULT;

        public CellEditorColActiv() {
            this.jPanelRenderer = new JPanel();
            this.jPanelRenderer.setLayout(new BorderLayout());
            this.jPanelRenderer.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
            this.itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    CellEditorColActiv.this.editorValue = ((JCheckBox)event.getSource()).isSelected();
                    CapBitSelectorFrame.this.capTable.setValueAt(new Boolean(CellEditorColActiv.this.editorValue), CellEditorColActiv.this.selRow, CellEditorColActiv.this.selCol);
                }
            };
        }

        void setState(CapSGOType.State state) {
            this.currState = state;
        }

        void updateUI() {
            SwingUtilities.updateComponentTreeUI(this.jPanelRenderer);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.selRow = row;
            this.selCol = col;
            if (CapBitSelectorFrame.this.bgMask[row]) {
                this.jPanelRenderer.setBackground(CapBitSelectorFrame.this.rowBgColor1);
            } else {
                this.jPanelRenderer.setBackground(CapBitSelectorFrame.this.rowBgColor0);
            }
            this.bgColor = this.currState == CapSGOType.State.SELECT ? Color.WHITE : (CapBitSelectorFrame.this.bgMask[row] ? CapBitSelectorFrame.this.rowBgColor1 : CapBitSelectorFrame.this.rowBgColor0);
            JCheckBoxCap jCBoxActiv = new JCheckBoxCap();
            jCBoxActiv.addItemListener(this.itemListener);
            jCBoxActiv.setBackground(this.bgColor);
            jCBoxActiv.setSelected((Boolean)value);
            this.jPanelRenderer.removeAll();
            this.jPanelRenderer.add((Component)jCBoxActiv, "Center");
            return this.jPanelRenderer;
        }

        public Object getCellEditorValue() {
            return new Boolean(this.editorValue);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return this.isEditable;
        }

        public void setCellEditable(boolean enable) {
            this.isEditable = enable;
            if (!enable) {
                CapBitSelectorFrame.this.capTable.editCellAt(this.selRow, this.selCol + 2);
            }
        }
    }

    private final class CellRendererCo234
    implements TableCellRenderer {
        private JLabel rendererLabel = null;
        private Color bgColor = null;

        private CellRendererCo234() {
            this.updateSize();
        }

        void updateSize() {
            this.rendererLabel = new JLabel();
            this.rendererLabel.setOpaque(true);
            this.rendererLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        }

        void updateUI() {
            SwingUtilities.updateComponentTreeUI(this.rendererLabel);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.bgColor = CapBitSelectorFrame.this.bgMask[row] ? CapBitSelectorFrame.this.rowBgColor1 : CapBitSelectorFrame.this.rowBgColor0;
            this.rendererLabel.setBackground(this.bgColor);
            this.rendererLabel.setText(value.toString());
            if (column == 2) {
                this.rendererLabel.setHorizontalAlignment(2);
            } else if (column == 3) {
                this.rendererLabel.setHorizontalAlignment(2);
            } else if (column == 4) {
                this.rendererLabel.setHorizontalAlignment(4);
            }
            return this.rendererLabel;
        }
    }

    private final class CellRendererColActiv
    implements TableCellRenderer {
        private JPanel jPanelRenderer;
        private JCheckBoxCap jCBoxActiv;
        private Color bgColor = null;
        private CapSGOType.State currState = CapSGOType.State.DEFAULT;

        private CellRendererColActiv() {
            this.jPanelRenderer = new JPanel();
            this.jPanelRenderer.setLayout(new BorderLayout());
            this.jPanelRenderer.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 6));
            this.jCBoxActiv = new JCheckBoxCap();
            this.jPanelRenderer.add((Component)this.jCBoxActiv, "Center");
        }

        void setState(CapSGOType.State state) {
            this.currState = state;
        }

        void updateUI() {
            SwingUtilities.updateComponentTreeUI(this.jPanelRenderer);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (CapBitSelectorFrame.this.bgMask[row]) {
                this.jPanelRenderer.setBackground(CapBitSelectorFrame.this.rowBgColor1);
            } else {
                this.jPanelRenderer.setBackground(CapBitSelectorFrame.this.rowBgColor0);
            }
            this.bgColor = this.currState == CapSGOType.State.SELECT ? Color.WHITE : (CapBitSelectorFrame.this.bgMask[row] ? CapBitSelectorFrame.this.rowBgColor1 : CapBitSelectorFrame.this.rowBgColor0);
            this.jCBoxActiv.setBackground(this.bgColor);
            this.jCBoxActiv.setSelected((Boolean)value);
            return this.jPanelRenderer;
        }
    }

    private final class FontDialog
    extends JDialog {
        private Font resetFont;
        private String currFamily;
        private int currStyle;
        private int currSize;
        private JComboBox jComboFamily;
        private DefaultComboBoxModel jComboFamModel;
        private ActionListener familyList;
        private JComboBox jComboSize;
        private DefaultComboBoxModel jComboSizeModel;
        private ActionListener sizeList;
        private String[] fontSizes;
        private JRadioButton jRadioBold;
        private JRadioButton jRadioPlain;
        private JButton jButtonOK;
        private JButton jButtonDefault;
        private JButton jButtonCancel;

        private FontDialog(JFrame frame, Font font) {
            super((Frame)frame, true);
            this.resetFont = null;
            this.currStyle = 0;
            this.currSize = 13;
            this.jComboFamily = null;
            this.jComboFamModel = null;
            this.familyList = null;
            this.jComboSize = null;
            this.jComboSizeModel = null;
            this.sizeList = null;
            this.fontSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            this.jRadioBold = null;
            this.jRadioPlain = null;
            this.jButtonOK = null;
            this.jButtonDefault = null;
            this.jButtonCancel = null;
            if (CapBitSelectorFrame.this.fontFamilies == null) {
                GraphicsEnvironment graphEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                CapBitSelectorFrame.this.fontFamilies = graphEnv.getAvailableFontFamilyNames();
            }
            this.resetFont = font;
            this.currFamily = font.getFamily();
            this.currStyle = font.getStyle();
            this.currSize = font.getSize();
            this.createDialog();
            DefaultFocusTraversalPolicy pol = new DefaultFocusTraversalPolicy(){

                public Component getInitialComponent(Window window) {
                    return FontDialog.this.jButtonOK;
                }
            };
            this.setFocusTraversalPolicy(pol);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    FontDialog.this.reset();
                    FontDialog.this.apply();
                }
            });
            this.setTitle("Font");
            this.setResizable(false);
            this.pack();
        }

        private void createDialog() {
            JPanel jPanelDialog = new JPanel();
            jPanelDialog.setLayout(new BoxLayout(jPanelDialog, 1));
            jPanelDialog.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel famPanel = new JPanel();
            famPanel.setLayout(new BoxLayout(famPanel, 1));
            TitledBorder famBorder = BorderFactory.createTitledBorder(" Family ");
            famPanel.setBorder(BorderFactory.createCompoundBorder(famBorder, BorderFactory.createEmptyBorder(2, 7, 5, 7)));
            this.jComboFamModel = new DefaultComboBoxModel<String>(CapBitSelectorFrame.this.fontFamilies);
            this.jComboFamily = new JComboBox(this.jComboFamModel);
            this.jComboFamily.setSelectedItem(this.currFamily);
            this.familyList = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    FontDialog.this.currFamily = (String)FontDialog.this.jComboFamModel.getSelectedItem();
                    FontDialog.this.apply();
                }
            };
            this.jComboFamily.addActionListener(this.familyList);
            famPanel.add(this.jComboFamily);
            jPanelDialog.add(famPanel);
            jPanelDialog.add(Box.createVerticalStrut(10));
            JPanel sizeStylePanel = new JPanel(new GridLayout(0, 2, 6, 0));
            JPanel sizePanel = new JPanel();
            sizePanel.setLayout(new BoxLayout(sizePanel, 1));
            TitledBorder sizeBorder = BorderFactory.createTitledBorder(" Size ");
            sizePanel.setBorder(BorderFactory.createCompoundBorder(sizeBorder, BorderFactory.createEmptyBorder(2, 7, 5, 5)));
            this.jComboSizeModel = new DefaultComboBoxModel<String>(this.fontSizes);
            this.jComboSize = new JComboBox(this.jComboSizeModel);
            this.jComboSize.setSelectedItem(Integer.toString(this.currSize));
            this.sizeList = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    FontDialog.this.currSize = Integer.parseInt((String)FontDialog.this.jComboSizeModel.getSelectedItem());
                    FontDialog.this.apply();
                }
            };
            this.jComboSize.addActionListener(this.sizeList);
            sizePanel.add(this.jComboSize);
            sizeStylePanel.add(sizePanel);
            JPanel jPanelStyle = new JPanel(new GridLayout(0, 2, 0, 0));
            TitledBorder styleBorder = BorderFactory.createTitledBorder(" Style ");
            jPanelStyle.setBorder(BorderFactory.createCompoundBorder(styleBorder, BorderFactory.createEmptyBorder(2, 5, 5, 7)));
            this.jRadioBold = new JRadioButton("Bold");
            this.jRadioPlain = new JRadioButton("Plain");
            ButtonGroup styleGroup = new ButtonGroup();
            styleGroup.add(this.jRadioBold);
            styleGroup.add(this.jRadioPlain);
            if (this.currStyle == 1) {
                this.jRadioBold.setSelected(true);
            } else {
                this.jRadioPlain.setSelected(true);
            }
            ActionListener styleList = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (FontDialog.this.jRadioBold.isSelected() && FontDialog.this.currStyle != 1) {
                        FontDialog.this.currStyle = 1;
                        FontDialog.this.apply();
                    } else if (FontDialog.this.jRadioPlain.isSelected() && FontDialog.this.currStyle != 0) {
                        FontDialog.this.currStyle = 0;
                        FontDialog.this.apply();
                    }
                }
            };
            this.jRadioBold.addActionListener(styleList);
            this.jRadioPlain.addActionListener(styleList);
            jPanelStyle.add(this.jRadioBold);
            jPanelStyle.add(this.jRadioPlain);
            sizeStylePanel.add(jPanelStyle);
            jPanelDialog.add(sizeStylePanel);
            jPanelDialog.add(Box.createVerticalStrut(10));
            JPanel jPanelButtons = new JPanel();
            jPanelButtons.setLayout(new BoxLayout(jPanelButtons, 1));
            jPanelButtons.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            JPanel buttonPanel = new JPanel(new GridLayout(0, 2, 10, 0));
            TitledBorder buttonBorder = BorderFactory.createTitledBorder("");
            buttonPanel.setBorder(BorderFactory.createCompoundBorder(buttonBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.jButtonDefault = new JButton("Default");
            this.jButtonDefault.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Font newFont = ((CapBitSelectorFrame)((FontDialog)FontDialog.this).CapBitSelectorFrame.this).capBitSelector.theme.getDefaultFont();
                    FontDialog.this.currFamily = newFont.getFamily();
                    FontDialog.this.currStyle = newFont.getStyle();
                    FontDialog.this.currSize = newFont.getSize();
                    FontDialog.this.updateState();
                    FontDialog.this.apply();
                }
            });
            buttonPanel.add(this.jButtonDefault);
            this.jButtonCancel = new JButton("Reset");
            this.jButtonCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    FontDialog.this.reset();
                    FontDialog.this.updateState();
                    FontDialog.this.apply();
                }
            });
            buttonPanel.add(this.jButtonCancel);
            jPanelButtons.add(buttonPanel);
            jPanelButtons.add(Box.createVerticalStrut(15));
            JPanel buttonOkPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            this.jButtonOK = new JButton("OK");
            this.jButtonOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    FontDialog.this.dispose();
                }
            });
            buttonOkPanel.add(this.jButtonOK);
            jPanelButtons.add(buttonOkPanel);
            jPanelDialog.add(jPanelButtons);
            this.getContentPane().add((Component)jPanelDialog, "Center");
        }

        private void updateState() {
            this.jComboFamily.removeActionListener(this.familyList);
            this.jComboFamily.setSelectedItem(this.currFamily);
            this.jComboFamily.addActionListener(this.familyList);
            this.jComboSize.removeActionListener(this.sizeList);
            this.jComboSize.setSelectedItem(Integer.toString(this.currSize));
            this.jComboSize.addActionListener(this.sizeList);
            if (this.currStyle == 1) {
                this.jRadioBold.setSelected(true);
            } else {
                this.jRadioPlain.setSelected(true);
            }
        }

        private void reset() {
            this.currFamily = this.resetFont.getFamily();
            this.currStyle = this.resetFont.getStyle();
            this.currSize = this.resetFont.getSize();
        }

        private void apply() {
            Font newFont = new Font(this.currFamily, this.currStyle, this.currSize);
            ((CapBitSelectorFrame)CapBitSelectorFrame.this).capBitSelector.theme.setFont(newFont);
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
            this.repaint();
            CapBitSelectorFrame.this.updateComponentTreeUI();
        }
    }

    private final class JCheckBoxCap
    extends JCheckBox {
        private JCheckBoxCap() {
            this.setIconTextGap(0);
            this.setText("");
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(0);
        }
    }

    private class SelectorTreeRenderer
    implements TreeCellRenderer {
        private JLabel rendererLabel;
        private Color fgColor = null;
        private Color selFgColor = new Color(255, 255, 255);

        SelectorTreeRenderer() {
            this.rendererLabel = new JLabel();
            this.rendererLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.fgColor = this.rendererLabel.getForeground();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            CapSGOType sgoType = (CapSGOType)((Object)((DefaultMutableTreeNode)value).getUserObject());
            if (sgoType.isAbstract()) {
                this.rendererLabel.setFont(CapBitSelectorFrame.this.fontI);
            } else {
                this.rendererLabel.setFont(CapBitSelectorFrame.this.font);
            }
            if (selected) {
                this.rendererLabel.setForeground(this.selFgColor);
                this.rendererLabel.setBackground(CapBitSelectorFrame.this.rowBgColor0);
            } else {
                this.rendererLabel.setForeground(this.fgColor);
            }
            this.rendererLabel.setOpaque(selected);
            this.rendererLabel.setText(sgoType.getClassName());
            return this.rendererLabel;
        }
    }

    private final class TextPopupMenu
    extends JPopupMenu {
        private TextPopupMenu(final JTextField selField) {
            final JMenuItem jMenuItemCutText = new JMenuItem("Cut");
            final JMenuItem jMenuItemCopyText = new JMenuItem("Copy");
            final JMenuItem jMenuItemPasteText = new JMenuItem("Paste");
            ActionListener ccpListener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Object item = event.getSource();
                    if (item == jMenuItemCutText) {
                        selField.cut();
                    } else if (item == jMenuItemCopyText) {
                        selField.copy();
                    } else if (item == jMenuItemPasteText) {
                        selField.paste();
                    }
                    selField.grabFocus();
                }
            };
            jMenuItemCutText.setEnabled(false);
            jMenuItemCutText.addActionListener(ccpListener);
            jMenuItemCopyText.setEnabled(false);
            jMenuItemCopyText.addActionListener(ccpListener);
            jMenuItemPasteText.setEnabled(false);
            jMenuItemPasteText.addActionListener(ccpListener);
            if (selField != null) {
                String selText = selField.getSelectedText();
                if (selText != null) {
                    jMenuItemCopyText.setEnabled(true);
                }
                if (selField.isEditable()) {
                    jMenuItemPasteText.setEnabled(true);
                    if (selText != null) {
                        jMenuItemCutText.setEnabled(true);
                    }
                }
            }
            this.add(jMenuItemCutText);
            this.add(jMenuItemCopyText);
            this.addSeparator();
            this.add(jMenuItemPasteText);
        }
    }
}

