/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.capability;

import com.interactivemesh.j3d.capability.CapSGOType;
import java.util.Iterator;
import java.util.Vector;

final class CapFrqBits {
    private static final String[] capStringsNode = new String[]{"Node.ALLOW_AUTO_COMPUTE_BOUNDS_READ.9", "Node.ALLOW_AUTO_COMPUTE_BOUNDS_WRITE.10", "Node.ALLOW_BOUNDS_READ.3", "Node.ALLOW_BOUNDS_WRITE.4", "Node.ALLOW_COLLIDABLE_READ.7", "Node.ALLOW_COLLIDABLE_WRITE.8", "Node.ALLOW_LOCAL_TO_VWORLD_READ.11", "Node.ALLOW_LOCALE_READ.47", "Node.ALLOW_PARENT_READ.46", "Node.ALLOW_PICKABLE_READ.5", "Node.ALLOW_PICKABLE_WRITE.6", "Node.ENABLE_COLLISION_REPORTING.0", "Node.ENABLE_PICK_REPORTING.1"};
    private static final String[] capStringsLight = new String[]{"Light.ALLOW_COLOR_READ.14", "Light.ALLOW_COLOR_WRITE.15", "Light.ALLOW_INFLUENCING_BOUNDS_READ.16", "Light.ALLOW_INFLUENCING_BOUNDS_WRITE.17", "Light.ALLOW_SCOPE_READ.28", "Light.ALLOW_SCOPE_WRITE.29", "Light.ALLOW_STATE_READ.12", "Light.ALLOW_STATE_WRITE.13"};
    private static final String[] capStringsDirect = new String[]{"DirectionalLight.ALLOW_DIRECTION_READ.18", "DirectionalLight.ALLOW_DIRECTION_WRITE.19"};
    private static final String[] capStringsPoint = new String[]{"PointLight.ALLOW_ATTENUATION_READ.20", "PointLight.ALLOW_ATTENUATION_WRITE.21", "PointLight.ALLOW_POSITION_READ.18", "PointLight.ALLOW_POSITION_WRITE.19"};
    private static final String[] capStringsSpot = new String[]{"SpotLight.ALLOW_CONCENTRATION_READ.25", "SpotLight.ALLOW_CONCENTRATION_WRITE.24", "SpotLight.ALLOW_DIRECTION_READ.27", "SpotLight.ALLOW_DIRECTION_WRITE.26", "SpotLight.ALLOW_SPREAD_ANGLE_READ.23", "SpotLight.ALLOW_SPREAD_ANGLE_WRITE.22"};
    private static final String[] capStringsBoundingLeaf = new String[]{"BoundingLeaf.ALLOW_REGION_READ.12", "BoundingLeaf.ALLOW_REGION_WRITE.13"};
    private static final String[] capStringsShape3D = new String[]{"Shape3D.ALLOW_APPEARANCE_OVERRIDE_READ.18", "Shape3D.ALLOW_APPEARANCE_OVERRIDE_WRITE.19", "Shape3D.ALLOW_APPEARANCE_READ.14", "Shape3D.ALLOW_APPEARANCE_WRITE.15", "Shape3D.ALLOW_COLLISION_BOUNDS_READ.16", "Shape3D.ALLOW_COLLISION_BOUNDS_WRITE.17", "Shape3D.ALLOW_GEOMETRY_READ.12", "Shape3D.ALLOW_GEOMETRY_WRITE.13"};
    private static final String[] capStringsOrientShape3D = new String[]{"OrientedShape3D.ALLOW_AXIS_READ.22", "OrientedShape3D.ALLOW_AXIS_WRITE.23", "OrientedShape3D.ALLOW_MODE_READ.20", "OrientedShape3D.ALLOW_MODE_WRITE.21", "OrientedShape3D.ALLOW_POINT_READ.24", "OrientedShape3D.ALLOW_POINT_WRITE.25", "OrientedShape3D.ALLOW_SCALE_READ.26", "OrientedShape3D.ALLOW_SCALE_WRITE.27"};
    private static final String[] capStringsMorph = new String[]{"Morph.ALLOW_APPEARANCE_OVERRIDE_READ.20", "Morph.ALLOW_APPEARANCE_OVERRIDE_WRITE.21", "Morph.ALLOW_APPEARANCE_READ.14", "Morph.ALLOW_APPEARANCE_WRITE.15", "Morph.ALLOW_COLLISION_BOUNDS_READ.18", "Morph.ALLOW_COLLISION_BOUNDS_WRITE.19", "Morph.ALLOW_GEOMETRY_ARRAY_READ.12", "Morph.ALLOW_GEOMETRY_ARRAY_WRITE.13", "Morph.ALLOW_WEIGHTS_READ.16", "Morph.ALLOW_WEIGHTS_WRITE.17"};
    private static final String[] capStringsViewPlatform = new String[]{"ViewPlatform.ALLOW_POLICY_READ.12", "ViewPlatform.ALLOW_POLICY_WRITE.13"};
    private static final String[] capStringsLink = new String[]{"Link.ALLOW_SHARED_GROUP_READ.12", "Link.ALLOW_SHARED_GROUP_WRITE.13"};
    private static final String[] capStringsBackground = new String[]{"Background.ALLOW_APPLICATION_BOUNDS_READ.12", "Background.ALLOW_APPLICATION_BOUNDS_WRITE.13", "Background.ALLOW_COLOR_READ.16", "Background.ALLOW_COLOR_WRITE.17", "Background.ALLOW_GEOMETRY_READ.18", "Background.ALLOW_GEOMETRY_WRITE.19", "Background.ALLOW_IMAGE_READ.14", "Background.ALLOW_IMAGE_WRITE.15", "Background.ALLOW_IMAGE_SCALE_MODE_READ.20", "Background.ALLOW_IMAGE_SCALE_MODE_WRITE.21"};
    private static final String[] capStringsAltAppearance = new String[]{"AlternateAppearance.ALLOW_APPEARANCE_READ.14", "AlternateAppearance.ALLOW_APPEARANCE_WRITE.15", "AlternateAppearance.ALLOW_INFLUENCING_BOUNDS_READ.12", "AlternateAppearance.ALLOW_INFLUENCING_BOUNDS_WRITE.13", "AlternateAppearance.ALLOW_SCOPE_READ.16", "AlternateAppearance.ALLOW_SCOPE_WRITE.17"};
    private static final String[] capStringsClip = new String[]{"Clip.ALLOW_APPLICATION_BOUNDS_READ.12", "Clip.ALLOW_APPLICATION_BOUNDS_WRITE.13", "Clip.ALLOW_BACK_DISTANCE_READ.14", "Clip.ALLOW_BACK_DISTANCE_WRITE.15"};
    private static final String[] capStringsModelClip = new String[]{"ModelClip.ALLOW_ENABLE_READ.16", "ModelClip.ALLOW_ENABLE_WRITE.17", "ModelClip.ALLOW_INFLUENCING_BOUNDS_READ.12", "ModelClip.ALLOW_INFLUENCING_BOUNDS_WRITE.13", "ModelClip.ALLOW_PLANE_READ.14", "ModelClip.ALLOW_PLANE_WRITE.15", "ModelClip.ALLOW_SCOPE_READ.18", "ModelClip.ALLOW_SCOPE_WRITE.19"};
    private static final String[] capStringsFog = new String[]{"Fog.ALLOW_COLOR_READ.14", "Fog.ALLOW_COLOR_WRITE.15", "Fog.ALLOW_INFLUENCING_BOUNDS_READ.12", "Fog.ALLOW_INFLUENCING_BOUNDS_WRITE.13", "Fog.ALLOW_SCOPE_READ.18", "Fog.ALLOW_SCOPE_WRITE.19"};
    private static final String[] capStringsExpFog = new String[]{"ExponentialFog.ALLOW_DENSITY_READ.16", "ExponentialFog.ALLOW_DENSITY_WRITE.17"};
    private static final String[] capStringsLinFog = new String[]{"LinearFog.ALLOW_DISTANCE_READ.16", "LinearFog.ALLOW_DISTANCE_WRITE.17"};
    private static final String[] capStringsSound = new String[]{"Sound.ALLOW_CHANNELS_USED_READ.31", "Sound.ALLOW_CONT_PLAY_READ.20", "Sound.ALLOW_CONT_PLAY_WRITE.21", "Sound.ALLOW_DURATION_READ.28", "Sound.ALLOW_ENABLE_READ.22", "Sound.ALLOW_ENABLE_WRITE.23", "Sound.ALLOW_INITIAL_GAIN_READ.14", "Sound.ALLOW_INITIAL_GAIN_WRITE.15", "Sound.ALLOW_IS_PLAYING_READ.30", "Sound.ALLOW_IS_READY_READ.29", "Sound.ALLOW_LOOP_READ.16", "Sound.ALLOW_LOOP_WRITE.17", "Sound.ALLOW_MUTE_READ.40", "Sound.ALLOW_MUTE_WRITE.41", "Sound.ALLOW_PAUSE_READ.42", "Sound.ALLOW_PAUSE_WRITE.43", "Sound.ALLOW_PRIORITY_READ.26", "Sound.ALLOW_PRIORITY_WRITE.27", "Sound.ALLOW_RATE_SCALE_FACTOR_READ.44", "Sound.ALLOW_RATE_SCALE_FACTOR_WRITE.45", "Sound.ALLOW_RELEASE_READ.18", "Sound.ALLOW_RELEASE_WRITE.19", "Sound.ALLOW_SCHEDULING_BOUNDS_READ.24", "Sound.ALLOW_SCHEDULING_BOUNDS_WRITE.25", "Sound.ALLOW_SOUND_DATA_READ.12", "Sound.ALLOW_SOUND_DATA_WRITE.13"};
    private static final String[] capStringsPointSound = new String[]{"PointSound.ALLOW_DISTANCE_GAIN_READ.34", "PointSound.ALLOW_DISTANCE_GAIN_WRITE.35", "PointSound.ALLOW_POSITION_READ.32", "PointSound.ALLOW_POSITION_WRITE.33"};
    private static final String[] capStringsConeSound = new String[]{"ConeSound.ALLOW_ANGULAR_ATTENUATION_READ.38", "ConeSound.ALLOW_ANGULAR_ATTENUATION_WRITE.39", "ConeSound.ALLOW_DIRECTION_READ.36", "ConeSound.ALLOW_DIRECTION_WRITE.37"};
    private static final String[] capStringsSoundscape = new String[]{"Soundscape.ALLOW_APPLICATION_BOUNDS_READ.12", "Soundscape.ALLOW_APPLICATION_BOUNDS_WRITE.13", "Soundscape.ALLOW_ATTRIBUTES_READ.14", "Soundscape.ALLOW_ATTRIBUTES_WRITE.15"};
    private static final String[] capStringsGroup = new String[]{"Group.ALLOW_CHILDREN_EXTEND.14", "Group.ALLOW_CHILDREN_READ.12", "Group.ALLOW_CHILDREN_WRITE.13", "Group.ALLOW_COLLISION_BOUNDS_READ.15", "Group.ALLOW_COLLISION_BOUNDS_WRITE.16"};
    private static final String[] capStringsBranchGroup = new String[]{"BranchGroup.ALLOW_DETACH.17"};
    private static final String[] capStringsOrderedGroup = new String[]{"OrderedGroup.ALLOW_CHILD_INDEX_ORDER_READ.17", "OrderedGroup.ALLOW_CHILD_INDEX_ORDER_WRITE.18"};
    private static final String[] capStringsSharedGroup = new String[]{"SharedGroup.ALLOW_LINK_READ.17"};
    private static final String[] capStringsSwitch = new String[]{"Switch.ALLOW_SWITCH_READ.17", "Switch.ALLOW_SWITCH_WRITE.18"};
    private static final String[] capStringsTransformGroup = new String[]{"TransformGroup.ALLOW_TRANSFORM_READ.17", "TransformGroup.ALLOW_TRANSFORM_WRITE.18"};
    private static final String[] capStringsViewSpecGroup = new String[]{"ViewSpecificGroup.ALLOW_VIEW_READ.17", "ViewSpecificGroup.ALLOW_VIEW_WRITE.18"};
    private static final String[] capStringsColAttributes = new String[]{"ColoringAttributes.ALLOW_COLOR_READ.0", "ColoringAttributes.ALLOW_COLOR_WRITE.1", "ColoringAttributes.ALLOW_SHADE_MODEL_READ.2", "ColoringAttributes.ALLOW_SHADE_MODEL_WRITE.3"};
    private static final String[] capStringsMaterial = new String[]{"Material.ALLOW_COMPONENT_READ.0", "Material.ALLOW_COMPONENT_WRITE.1"};
    private static final String[] capStringsTransAttributes = new String[]{"TransparencyAttributes.ALLOW_BLEND_FUNCTION_READ.4", "TransparencyAttributes.ALLOW_BLEND_FUNCTION_WRITE.5", "TransparencyAttributes.ALLOW_MODE_READ.0", "TransparencyAttributes.ALLOW_MODE_WRITE.1", "TransparencyAttributes.ALLOW_VALUE_READ.2", "TransparencyAttributes.ALLOW_VALUE_WRITE.3"};
    private static final String[] capStringsPointAttributes = new String[]{"PointAttributes.ALLOW_ANTIALIASING_READ.2", "PointAttributes.ALLOW_ANTIALIASING_WRITE.3", "PointAttributes.ALLOW_SIZE_READ.0", "PointAttributes.ALLOW_SIZE_WRITE.1"};
    private static final String[] capStringsLineAttributes = new String[]{"LineAttributes.ALLOW_ANTIALIASING_READ.4", "LineAttributes.ALLOW_ANTIALIASING_WRITE.5", "LineAttributes.ALLOW_PATTERN_READ.2", "LineAttributes.ALLOW_PATTERN_WRITE.3", "LineAttributes.ALLOW_WIDTH_READ.0", "LineAttributes.ALLOW_WIDTH_WRITE.1"};
    private static final String[] capStringsPolyAttributes = new String[]{"PolygonAttributes.ALLOW_CULL_FACE_READ.0", "PolygonAttributes.ALLOW_CULL_FACE_WRITE.1", "PolygonAttributes.ALLOW_MODE_READ.2", "PolygonAttributes.ALLOW_MODE_WRITE.3", "PolygonAttributes.ALLOW_NORMAL_FLIP_READ.6", "PolygonAttributes.ALLOW_NORMAL_FLIP_WRITE.7", "PolygonAttributes.ALLOW_OFFSET_READ.4", "PolygonAttributes.ALLOW_OFFSET_WRITE.5"};
    private static final String[] capStringsRendAttributes = new String[]{"RenderingAttributes.ALLOW_ALPHA_TEST_FUNCTION_READ.2", "RenderingAttributes.ALLOW_ALPHA_TEST_FUNCTION_WRITE.3", "RenderingAttributes.ALLOW_ALPHA_TEST_VALUE_READ.0", "RenderingAttributes.ALLOW_ALPHA_TEST_VALUE_WRITE.1", "RenderingAttributes.ALLOW_DEPTH_ENABLE_READ.4", "RenderingAttributes.ALLOW_DEPTH_ENABLE_WRITE.11", "RenderingAttributes.ALLOW_DEPTH_TEST_FUNCTION_READ.12", "RenderingAttributes.ALLOW_DEPTH_TEST_FUNCTION_WRITE.13", "RenderingAttributes.ALLOW_IGNORE_VERTEX_COLORS_READ.9", "RenderingAttributes.ALLOW_IGNORE_VERTEX_COLORS_WRITE.10", "RenderingAttributes.ALLOW_RASTER_OP_READ.7", "RenderingAttributes.ALLOW_RASTER_OP_WRITE.8", "RenderingAttributes.ALLOW_STENCIL_ATTRIBUTES_READ.14", "RenderingAttributes.ALLOW_STENCIL_ATTRIBUTES_WRITE.15", "RenderingAttributes.ALLOW_VISIBLE_READ.5", "RenderingAttributes.ALLOW_VISIBLE_WRITE.6"};
    private static final String[] capStringsTexture = new String[]{"Texture.ALLOW_BOUNDARY_COLOR_READ.6", "Texture.ALLOW_BOUNDARY_MODE_READ.2", "Texture.ALLOW_ENABLE_READ.0", "Texture.ALLOW_ENABLE_WRITE.1", "Texture.ALLOW_FILTER_READ.3", "Texture.ALLOW_FORMAT_READ.9", "Texture.ALLOW_IMAGE_READ.4", "Texture.ALLOW_IMAGE_WRITE.7", "Texture.ALLOW_MIPMAP_MODE_READ.5", "Texture.ALLOW_SIZE_READ.8", "Texture.ALLOW_LOD_RANGE_READ.10", "Texture.ALLOW_LOD_RANGE_WRITE.11", "Texture.ALLOW_ANISOTROPIC_FILTER_READ.12", "Texture.ALLOW_SHARPEN_TEXTURE_READ.13", "Texture.ALLOW_FILTER4_READ.14"};
    private static final String[] capStringsTexture2D = new String[]{"Texture2D.ALLOW_DETAIL_TEXTURE_READ.15"};
    private static final String[] capStringsTexAttributes = new String[]{"TextureAttributes.ALLOW_BLEND_COLOR_READ.2", "TextureAttributes.ALLOW_BLEND_COLOR_WRITE.3", "TextureAttributes.ALLOW_COLOR_TABLE_READ.6", "TextureAttributes.ALLOW_COLOR_TABLE_WRITE.7", "TextureAttributes.ALLOW_COMBINE_READ.8", "TextureAttributes.ALLOW_COMBINE_WRITE.9", "TextureAttributes.ALLOW_MODE_READ.0", "TextureAttributes.ALLOW_MODE_WRITE.1", "TextureAttributes.ALLOW_TRANSFORM_READ.4", "TextureAttributes.ALLOW_TRANSFORM_WRITE.5"};
    private static final String[] capStringsTexCoordGen = new String[]{"TexCoordGeneration.ALLOW_ENABLE_READ.0", "TexCoordGeneration.ALLOW_ENABLE_WRITE.1", "TexCoordGeneration.ALLOW_FORMAT_READ.2", "TexCoordGeneration.ALLOW_MODE_READ.3", "TexCoordGeneration.ALLOW_PLANE_READ.4", "TexCoordGeneration.ALLOW_PLANE_WRITE.5"};
    private static final String[] capStringsTexUnitState = new String[]{"TextureUnitState.ALLOW_STATE_READ.0", "TextureUnitState.ALLOW_STATE_WRITE.1"};
    private static final String[] capStringsAppearance = new String[]{"Appearance.ALLOW_COLORING_ATTRIBUTES_READ.8", "Appearance.ALLOW_COLORING_ATTRIBUTES_WRITE.9", "Appearance.ALLOW_LINE_ATTRIBUTES_READ.16", "Appearance.ALLOW_LINE_ATTRIBUTES_WRITE.17", "Appearance.ALLOW_MATERIAL_READ.0", "Appearance.ALLOW_MATERIAL_WRITE.1", "Appearance.ALLOW_POINT_ATTRIBUTES_READ.18", "Appearance.ALLOW_POINT_ATTRIBUTES_WRITE.19", "Appearance.ALLOW_POLYGON_ATTRIBUTES_READ.14", "Appearance.ALLOW_POLYGON_ATTRIBUTES_WRITE.15", "Appearance.ALLOW_RENDERING_ATTRIBUTES_READ.12", "Appearance.ALLOW_RENDERING_ATTRIBUTES_WRITE.13", "Appearance.ALLOW_TEXGEN_READ.4", "Appearance.ALLOW_TEXGEN_WRITE.5", "Appearance.ALLOW_TEXTURE_READ.2", "Appearance.ALLOW_TEXTURE_WRITE.3", "Appearance.ALLOW_TEXTURE_ATTRIBUTES_READ.6", "Appearance.ALLOW_TEXTURE_ATTRIBUTES_WRITE.7", "Appearance.ALLOW_TEXTURE_UNIT_STATE_READ.20", "Appearance.ALLOW_TEXTURE_UNIT_STATE_WRITE.21", "Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_READ.10", "Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_WRITE.11"};
    private static final String[] capStringsShaderAppearance = new String[]{"ShaderAppearance.ALLOW_SHADER_ATTRIBUTE_SET_READ.24", "ShaderAppearance.ALLOW_SHADER_ATTRIBUTE_SET_WRITE.25", "ShaderAppearance.ALLOW_SHADER_PROGRAM_READ.22", "ShaderAppearance.ALLOW_SHADER_PROGRAM_WRITE.23"};
    private static final String[] capStringsShaderProgram = new String[]{"ShaderProgram.ALLOW_NAMES_READ.1", "ShaderProgram.ALLOW_SHADERS_READ.0"};
    private static final String[] capStringsShader = new String[0];
    private static final String[] capStringsShaderAttrSet = new String[]{"ShaderAttributeSet.ALLOW_ATTRIBUTES_READ.0", "ShaderAttributeSet.ALLOW_ATTRIBUTES_WRITE.1"};
    private static final String[] capStringsShaderAttrBinding = new String[0];
    private static final String[] capStringsShaderAttrObject = new String[]{"ShaderAttributeObject.ALLOW_VALUE_READ.0", "ShaderAttributeObject.ALLOW_VALUE_WRITE.1"};
    private static final String[] capStringsAlpha = new String[0];
    private static final String[] capStringsFont3D = new String[0];
    private static final String[] capStringsDepthComp = new String[]{"DepthComponent.ALLOW_DATA_READ.1", "DepthComponent.ALLOW_SIZE_READ.0"};
    private static final String[] capStringsImageComp = new String[]{"ImageComponent.ALLOW_FORMAT_READ.1", "ImageComponent.ALLOW_IMAGE_READ.2", "ImageComponent.ALLOW_IMAGE_WRITE.3", "ImageComponent.ALLOW_SIZE_READ.0"};
    private static final String[] capStringsMediaContainer = new String[]{"MediaContainer.ALLOW_CACHE_READ.0", "MediaContainer.ALLOW_CACHE_WRITE.1", "MediaContainer.ALLOW_URL_READ.2", "MediaContainer.ALLOW_URL_WRITE.3"};
    private static final String[] capStringsAuralAttrib = new String[]{"AuralAttributes.ALLOW_ATTRIBUTE_GAIN_READ.0", "AuralAttributes.ALLOW_ATTRIBUTE_GAIN_WRITE.1", "AuralAttributes.ALLOW_DECAY_FILTER_READ.22", "AuralAttributes.ALLOW_DECAY_FILTER_WRITE.23", "AuralAttributes.ALLOW_DECAY_TIME_READ.20", "AuralAttributes.ALLOW_DECAY_TIME_WRITE.21", "AuralAttributes.ALLOW_DENSITY_READ.26", "AuralAttributes.ALLOW_DENSITY_WRITE.27", "AuralAttributes.ALLOW_DIFFUSION_READ.24", "AuralAttributes.ALLOW_DIFFUSION_WRITE.25", "AuralAttributes.ALLOW_DISTANCE_FILTER_READ.10", "AuralAttributes.ALLOW_DISTANCE_FILTER_WRITE.11", "AuralAttributes.ALLOW_FREQUENCY_SCALE_FACTOR_READ.12", "AuralAttributes.ALLOW_FREQUENCY_SCALE_FACTOR_WRITE.13", "AuralAttributes.ALLOW_REFLECTION_COEFFICIENT_READ.4", "AuralAttributes.ALLOW_REFLECTION_COEFFICIENT_WRITE.5", "AuralAttributes.ALLOW_REFLECTION_DELAY_READ.16", "AuralAttributes.ALLOW_REFLECTION_DELAY_WRITE.17", "AuralAttributes.ALLOW_REVERB_COEFFICIENT_READ.18", "AuralAttributes.ALLOW_REVERB_COEFFICIENT_WRITE.19", "AuralAttributes.ALLOW_REVERB_DELAY_READ.6", "AuralAttributes.ALLOW_REVERB_DELAY_WRITE.7", "AuralAttributes.ALLOW_REVERB_ORDER_READ.8", "AuralAttributes.ALLOW_REVERB_ORDER_WRITE.9", "AuralAttributes.ALLOW_ROLLOFF_READ.2", "AuralAttributes.ALLOW_ROLLOFF_WRITE.3", "AuralAttributes.ALLOW_VELOCITY_SCALE_FACTOR_READ.14", "AuralAttributes.ALLOW_VELOCITY_SCALE_FACTOR_WRITE.15"};
    private static final String[] capStringsGeometry = new String[]{"Geometry.ALLOW_INTERSECT.18"};
    private static final String[] capStringsGeometryArray = new String[]{"GeometryArray.ALLOW_COLOR_READ.2", "GeometryArray.ALLOW_COLOR_WRITE.3", "GeometryArray.ALLOW_COORDINATE_READ.0", "GeometryArray.ALLOW_COORDINATE_WRITE.1", "GeometryArray.ALLOW_COUNT_READ.8", "GeometryArray.ALLOW_COUNT_WRITE.20", "GeometryArray.ALLOW_FORMAT_READ.17", "GeometryArray.ALLOW_NORMAL_READ.4", "GeometryArray.ALLOW_NORMAL_WRITE.5", "GeometryArray.ALLOW_REF_DATA_READ.21", "GeometryArray.ALLOW_REF_DATA_WRITE.19", "GeometryArray.ALLOW_TEXCOORD_READ.6", "GeometryArray.ALLOW_TEXCOORD_WRITE.7", "GeometryArray.ALLOW_VERTEX_ATTR_READ.22", "GeometryArray.ALLOW_VERTEX_ATTR_WRITE.23"};
    private static final String[] capStringsIndexedGeometryArray = new String[]{"IndexedGeometryArray.ALLOW_COLOR_INDEX_READ.11", "IndexedGeometryArray.ALLOW_COLOR_INDEX_WRITE.12", "IndexedGeometryArray.ALLOW_COORDINATE_INDEX_READ.9", "IndexedGeometryArray.ALLOW_COORDINATE_INDEX_WRITE.10", "IndexedGeometryArray.ALLOW_NORMAL_INDEX_READ.13", "IndexedGeometryArray.ALLOW_NORMAL_INDEX_WRITE.14", "IndexedGeometryArray.ALLOW_TEXCOORD_INDEX_READ.15", "IndexedGeometryArray.ALLOW_TEXCOORD_INDEX_WRITE.16", "IndexedGeometryArray.ALLOW_VERTEX_ATTR_INDEX_READ.24", "IndexedGeometryArray.ALLOW_VERTEX_ATTR_INDEX_WRITE.25"};
    private static final String[] capStringsCompGeometry = new String[]{"CompressedGeometry.ALLOW_COUNT_READ.0", "CompressedGeometry.ALLOW_GEOMETRY_READ.2", "CompressedGeometry.ALLOW_HEADER_READ.1", "CompressedGeometry.ALLOW_REF_DATA_READ.3"};
    private static final String[] capStringsRaster = new String[]{"Raster.ALLOW_CLIP_MODE_READ.11", "Raster.ALLOW_CLIP_MODE_WRITE.12", "Raster.ALLOW_DEPTH_COMPONENT_READ.6", "Raster.ALLOW_DEPTH_COMPONENT_WRITE.7", "Raster.ALLOW_IMAGE_READ.4", "Raster.ALLOW_IMAGE_WRITE.5", "Raster.ALLOW_OFFSET_READ.2", "Raster.ALLOW_OFFSET_WRITE.3", "Raster.ALLOW_POSITION_READ.0", "Raster.ALLOW_POSITION_WRITE.1", "Raster.ALLOW_SIZE_READ.8", "Raster.ALLOW_SIZE_WRITE.9", "Raster.ALLOW_TYPE_READ.10"};
    private static final String[] capStringsText3D = new String[]{"Text3D.ALLOW_ALIGNMENT_READ.6", "Text3D.ALLOW_ALIGNMENT_WRITE.7", "Text3D.ALLOW_BOUNDING_BOX_READ.12", "Text3D.ALLOW_CHARACTER_SPACING_READ.10", "Text3D.ALLOW_CHARACTER_SPACING_WRITE.11", "Text3D.ALLOW_FONT3D_READ.0", "Text3D.ALLOW_FONT3D_WRITE.1", "Text3D.ALLOW_PATH_READ.8", "Text3D.ALLOW_PATH_WRITE.9", "Text3D.ALLOW_POSITION_READ.4", "Text3D.ALLOW_POSITION_WRITE.5", "Text3D.ALLOW_STRING_READ.2", "Text3D.ALLOW_STRING_WRITE.3"};

    CapFrqBits() {
    }

    static String[] getCapStringsOfLeaf(CapSGOType leafType) {
        Vector<String[]> capStringsArrays = new Vector<String[]>(3);
        capStringsArrays.add(capStringsNode);
        int capCount = capStringsNode.length;
        switch (leafType) {
            case NODE: {
                break;
            }
            case LEAF: {
                break;
            }
            case MORPH: {
                capStringsArrays.add(capStringsMorph);
                capCount += capStringsMorph.length;
                break;
            }
            case SHAPE3D: {
                capStringsArrays.add(capStringsShape3D);
                capCount += capStringsShape3D.length;
                break;
            }
            case O_SHAPE3D: {
                capStringsArrays.add(capStringsShape3D);
                capStringsArrays.add(capStringsOrientShape3D);
                capCount += capStringsShape3D.length + capStringsOrientShape3D.length;
                break;
            }
            case LIGHT: 
            case LIGHTAMBIENT: {
                capStringsArrays.add(capStringsLight);
                capCount += capStringsLight.length;
                break;
            }
            case LIGHTDIRECT: {
                capStringsArrays.add(capStringsLight);
                capStringsArrays.add(capStringsDirect);
                capCount += capStringsLight.length + capStringsDirect.length;
                break;
            }
            case LIGHTPOINT: {
                capStringsArrays.add(capStringsLight);
                capStringsArrays.add(capStringsPoint);
                capCount += capStringsLight.length + capStringsPoint.length;
                break;
            }
            case LIGHTSPOT: {
                capStringsArrays.add(capStringsLight);
                capStringsArrays.add(capStringsPoint);
                capStringsArrays.add(capStringsSpot);
                capCount += capStringsLight.length + capStringsPoint.length + capStringsSpot.length;
                break;
            }
            case FOG: {
                capStringsArrays.add(capStringsFog);
                capCount += capStringsFog.length;
                break;
            }
            case FOGEXPO: {
                capStringsArrays.add(capStringsFog);
                capStringsArrays.add(capStringsExpFog);
                capCount += capStringsFog.length + capStringsExpFog.length;
                break;
            }
            case FOGLIN: {
                capStringsArrays.add(capStringsFog);
                capStringsArrays.add(capStringsLinFog);
                capCount += capStringsFog.length + capStringsLinFog.length;
                break;
            }
            case SOUND: 
            case SOUNDBACK: {
                capStringsArrays.add(capStringsSound);
                capCount += capStringsSound.length;
                break;
            }
            case SOUNDPOINT: {
                capStringsArrays.add(capStringsSound);
                capStringsArrays.add(capStringsPointSound);
                capCount += capStringsSound.length + capStringsPointSound.length;
                break;
            }
            case SOUNDCONE: {
                capStringsArrays.add(capStringsSound);
                capStringsArrays.add(capStringsPointSound);
                capStringsArrays.add(capStringsConeSound);
                capCount += capStringsSound.length + capStringsPointSound.length + capStringsConeSound.length;
                break;
            }
            case SOUNDSCAPE: {
                capStringsArrays.add(capStringsSoundscape);
                capCount += capStringsSoundscape.length;
                break;
            }
            case ALTAPPEARANCE: {
                capStringsArrays.add(capStringsAltAppearance);
                capCount += capStringsAltAppearance.length;
                break;
            }
            case BACKGROUND: {
                capStringsArrays.add(capStringsBackground);
                capCount += capStringsBackground.length;
                break;
            }
            case BOUNDINGLEAF: {
                capStringsArrays.add(capStringsBoundingLeaf);
                capCount += capStringsBoundingLeaf.length;
                break;
            }
            case CLIP: {
                capStringsArrays.add(capStringsClip);
                capCount += capStringsClip.length;
                break;
            }
            case MODELCLIP: {
                capStringsArrays.add(capStringsModelClip);
                capCount += capStringsModelClip.length;
                break;
            }
            case LINK: {
                capStringsArrays.add(capStringsLink);
                capCount += capStringsLink.length;
                break;
            }
            case VIEWPLATFORM: {
                capStringsArrays.add(capStringsViewPlatform);
                capCount += capStringsViewPlatform.length;
                break;
            }
        }
        String[] capStringsArray = new String[capCount];
        int k = 0;
        Iterator iterator = capStringsArrays.iterator();
        while (iterator.hasNext()) {
            String[] capStrings;
            String[] stringArray = capStrings = (String[])iterator.next();
            int n = capStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String capString = stringArray[n2];
                capStringsArray[k++] = capString;
                ++n2;
            }
        }
        return capStringsArray;
    }

    static String[] getCapStringsOfAppear(CapSGOType compType) {
        Vector<String[]> capStringsArrays = new Vector<String[]>(3);
        int capCount = 0;
        switch (compType) {
            case APPEARANCE: {
                capStringsArrays.add(capStringsAppearance);
                capCount += capStringsAppearance.length;
                break;
            }
            case APPEARANCE_SHADER: {
                capStringsArrays.add(capStringsAppearance);
                capStringsArrays.add(capStringsShaderAppearance);
                capCount += capStringsAppearance.length + capStringsShaderAppearance.length;
                break;
            }
            case ALPHA: {
                capStringsArrays.add(capStringsAlpha);
                capCount += capStringsAlpha.length;
                break;
            }
            case AURAL: {
                capStringsArrays.add(capStringsAuralAttrib);
                capCount += capStringsAuralAttrib.length;
                break;
            }
            case COLORING: {
                capStringsArrays.add(capStringsColAttributes);
                capCount += capStringsColAttributes.length;
                break;
            }
            case DEPTH: 
            case DEPTH_FLOAT: 
            case DEPTH_INT: 
            case DEPTH_NATIVE: {
                capStringsArrays.add(capStringsDepthComp);
                capCount += capStringsDepthComp.length;
                break;
            }
            case IMAGE: 
            case IMAGE2D: 
            case IMAGE3D: {
                capStringsArrays.add(capStringsImageComp);
                capCount += capStringsImageComp.length;
                break;
            }
            case LINE: {
                capStringsArrays.add(capStringsLineAttributes);
                capCount += capStringsLineAttributes.length;
                break;
            }
            case MATERIAL: {
                capStringsArrays.add(capStringsMaterial);
                capCount += capStringsMaterial.length;
                break;
            }
            case MEDIA: {
                capStringsArrays.add(capStringsMediaContainer);
                capCount += capStringsMediaContainer.length;
                break;
            }
            case POINT: {
                capStringsArrays.add(capStringsPointAttributes);
                capCount += capStringsPointAttributes.length;
                break;
            }
            case POLYGON: {
                capStringsArrays.add(capStringsPolyAttributes);
                capCount += capStringsPolyAttributes.length;
                break;
            }
            case RENDERING: {
                capStringsArrays.add(capStringsRendAttributes);
                capCount += capStringsRendAttributes.length;
                break;
            }
            case TEX_ATTRIB: {
                capStringsArrays.add(capStringsTexAttributes);
                capCount += capStringsTexAttributes.length;
                break;
            }
            case TEX_2D: {
                capStringsArrays.add(capStringsTexture);
                capStringsArrays.add(capStringsTexture2D);
                capCount += capStringsTexture.length + capStringsTexture2D.length;
                break;
            }
            case TEXTURE: 
            case TEX_3D: 
            case TEX_CM: {
                capStringsArrays.add(capStringsTexture);
                capCount += capStringsTexture.length;
                break;
            }
            case TEX_COORD: {
                capStringsArrays.add(capStringsTexCoordGen);
                capCount += capStringsTexCoordGen.length;
                break;
            }
            case TEX_UNIT: {
                capStringsArrays.add(capStringsTexUnitState);
                capCount += capStringsTexUnitState.length;
                break;
            }
            case TRANSPARENCY: {
                capStringsArrays.add(capStringsTransAttributes);
                capCount += capStringsTransAttributes.length;
                break;
            }
            case SHADERPROG: 
            case SHADERPROG_CG: 
            case SHADERPROG_GLSL: {
                capStringsArrays.add(capStringsShaderProgram);
                capCount += capStringsShaderProgram.length;
                break;
            }
            case SHADER_SOURCECODE: {
                capStringsArrays.add(capStringsShader);
                capCount += capStringsShader.length;
                break;
            }
            case SHADERATTRSET: {
                capStringsArrays.add(capStringsShaderAttrSet);
                capCount += capStringsShaderAttrSet.length;
                break;
            }
            case SHADERATTR_BINDING: {
                capStringsArrays.add(capStringsShaderAttrBinding);
                capCount += capStringsShaderAttrBinding.length;
                break;
            }
            case SHADERATTR_OBJECT: 
            case SHADERATTR_ARRAY: 
            case SHADERATTR_VALUE: {
                capStringsArrays.add(capStringsShaderAttrObject);
                capCount += capStringsShaderAttrObject.length;
            }
        }
        String[] capStringsArray = new String[capCount];
        int k = 0;
        Iterator iterator = capStringsArrays.iterator();
        while (iterator.hasNext()) {
            String[] capStrings;
            String[] stringArray = capStrings = (String[])iterator.next();
            int n = capStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String capString = stringArray[n2];
                capStringsArray[k++] = capString;
                ++n2;
            }
        }
        return capStringsArray;
    }

    static String[] getCapStringsOfGeom(CapSGOType compType) {
        Vector<String[]> capStringsArrays = new Vector<String[]>(3);
        int capCount = 0;
        switch (compType) {
            case GEOMETRY: {
                capStringsArrays.add(capStringsGeometry);
                capCount += capStringsGeometry.length;
                break;
            }
            case GEOMETRYARRAY: 
            case GEOMETRYSTRIPARRAY: 
            case POINTARRAY: 
            case LINEARRAY: 
            case TRIAARRAY: 
            case QUADARRAY: 
            case LINESTRIP: 
            case TRIASTRIP: 
            case TRIAFAN: {
                capStringsArrays.add(capStringsGeometry);
                capStringsArrays.add(capStringsGeometryArray);
                capCount += capStringsGeometry.length + capStringsGeometryArray.length;
                break;
            }
            case INDEXEDGEOMETRYARRAY: 
            case INDEXEDGEOMETRYSTRIPARRAY: 
            case POINTARRAY_I: 
            case LINEARRAY_I: 
            case TRIAARRAY_I: 
            case QUADARRAY_I: 
            case LINESTRIP_I: 
            case TRIASTRIP_I: 
            case TRIAFAN_I: {
                capStringsArrays.add(capStringsGeometry);
                capStringsArrays.add(capStringsGeometryArray);
                capStringsArrays.add(capStringsIndexedGeometryArray);
                capCount += capStringsGeometry.length + capStringsGeometryArray.length + capStringsIndexedGeometryArray.length;
                break;
            }
            case CG: {
                capStringsArrays.add(capStringsGeometry);
                capStringsArrays.add(capStringsCompGeometry);
                capCount += capStringsGeometry.length + capStringsCompGeometry.length;
                break;
            }
            case RASTER: {
                capStringsArrays.add(capStringsGeometry);
                capStringsArrays.add(capStringsRaster);
                capCount += capStringsGeometry.length + capStringsRaster.length;
                break;
            }
            case TEXT3D: {
                capStringsArrays.add(capStringsGeometry);
                capStringsArrays.add(capStringsText3D);
                capCount += capStringsGeometry.length + capStringsText3D.length;
                break;
            }
            case FONT3D: {
                capStringsArrays.add(capStringsFont3D);
                capCount += capStringsFont3D.length;
            }
        }
        String[] capStringsArray = new String[capCount];
        int k = 0;
        Iterator iterator = capStringsArrays.iterator();
        while (iterator.hasNext()) {
            String[] capStrings;
            String[] stringArray = capStrings = (String[])iterator.next();
            int n = capStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String capString = stringArray[n2];
                capStringsArray[k++] = capString;
                ++n2;
            }
        }
        return capStringsArray;
    }

    static String[] getCapStringsOfGroup(CapSGOType groupType) {
        Vector<String[]> capStringsArrays = new Vector<String[]>(3);
        capStringsArrays.add(capStringsNode);
        capStringsArrays.add(capStringsGroup);
        int capCount = capStringsNode.length + capStringsGroup.length;
        switch (groupType) {
            case BRANCHGROUP: {
                capStringsArrays.add(capStringsBranchGroup);
                capCount += capStringsBranchGroup.length;
                break;
            }
            case GROUP: {
                break;
            }
            case TRANSFORMGROUP: {
                capStringsArrays.add(capStringsTransformGroup);
                capCount += capStringsTransformGroup.length;
                break;
            }
            case ORDEREDGROUP: {
                capStringsArrays.add(capStringsOrderedGroup);
                capCount += capStringsOrderedGroup.length;
                break;
            }
            case DECALGROUP: {
                capStringsArrays.add(capStringsOrderedGroup);
                capCount += capStringsOrderedGroup.length;
                break;
            }
            case SHAREDGROUP: {
                capStringsArrays.add(capStringsSharedGroup);
                capCount += capStringsSharedGroup.length;
                break;
            }
            case SWITCH: {
                capStringsArrays.add(capStringsSwitch);
                capCount += capStringsSwitch.length;
                break;
            }
            case VIEWSPECGROUP: {
                capStringsArrays.add(capStringsViewSpecGroup);
                capCount += capStringsViewSpecGroup.length;
            }
        }
        String[] capStringsArray = new String[capCount];
        int k = 0;
        Iterator iterator = capStringsArrays.iterator();
        while (iterator.hasNext()) {
            String[] capStrings;
            String[] stringArray = capStrings = (String[])iterator.next();
            int n = capStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String capString = stringArray[n2];
                capStringsArray[k++] = capString;
                ++n2;
            }
        }
        return capStringsArray;
    }
}

