/*
 * Decompiled with CFR 0.152.
 */
package org.interactivemesh.jfx.sample3d.tuxcube;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.obj.ObjModelImporter;
import java.net.URL;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.RotateTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Point3D;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;

final class FXTuxCubeSubScene {
    private SubScene subScene = null;
    private Group viewingGroup = null;
    private Affine viewingRotate = new Affine();
    private Translate viewingTranslate = new Translate();
    private double startX = 0.0;
    private double startY = 0.0;
    private PerspectiveCamera perspectiveCamera = null;
    private AmbientLight ambLight = null;
    private PointLight pointLight = null;
    private Group tuxCubeRotGroup = null;
    private Group tuxCubeCenterGroup = null;
    private Rotate tuxCubeRotate = null;
    private Timeline tuxCubeRotTimeline = null;
    private RotateTransition[] tuxRotTransAll = null;
    private BoundingBox tuxCubeBinL = null;
    private double sceneDiameter = 0.0;
    private MeshView[] meshViews = null;
    private PhongMaterial eyesMat = null;
    private PhongMaterial feetMat = null;
    private PhongMaterial mouthMat = null;
    private PhongMaterial pupilsMat = null;
    private TriangleMesh bodyMesh = null;
    private TriangleMesh frontMesh = null;
    private TriangleMesh eyesMesh = null;
    private TriangleMesh feetMesh = null;
    private TriangleMesh mouthMesh = null;
    private TriangleMesh pupilsMesh = null;

    FXTuxCubeSubScene() {
        if (this.loadTuxModel()) {
            this.createBaseScene();
            this.createSubScene(800.0, 800.0, SceneAntialiasing.BALANCED);
        }
    }

    private boolean loadTuxModel() {
        Object object;
        ObjModelImporter objModelImporter = new ObjModelImporter();
        try {
            object = this.getClass().getResource("resources/TuxModel-NoTongue.obj");
            objModelImporter.read((URL)object);
        }
        catch (ImportException e) {
            e.printStackTrace();
            return false;
        }
        object = objModelImporter.getNamedMeshViews();
        Map map = objModelImporter.getNamedMaterials();
        objModelImporter.close();
        this.eyesMat = (PhongMaterial)map.get("TuxEyesAppear");
        this.eyesMesh = (TriangleMesh)((MeshView)object.get("TuxEyes")).getMesh();
        this.feetMat = (PhongMaterial)map.get("TuxFeetAppear");
        this.feetMesh = (TriangleMesh)((MeshView)object.get("TuxFeet")).getMesh();
        this.mouthMat = (PhongMaterial)map.get("TuxMouthAppear");
        this.mouthMesh = (TriangleMesh)((MeshView)object.get("TuxMouth")).getMesh();
        this.pupilsMat = (PhongMaterial)map.get("TuxPupilsAppear");
        this.pupilsMesh = (TriangleMesh)((MeshView)object.get("TuxPupils")).getMesh();
        this.bodyMesh = (TriangleMesh)((MeshView)object.get("TuxBody")).getMesh();
        this.frontMesh = (TriangleMesh)((MeshView)object.get("TuxFront")).getMesh();
        return true;
    }

    private void createBaseScene() {
        this.perspectiveCamera = new PerspectiveCamera(true);
        this.perspectiveCamera.setVerticalFieldOfView(false);
        this.perspectiveCamera.setFarClip(250.0);
        this.perspectiveCamera.setNearClip(0.1);
        this.perspectiveCamera.setFieldOfView(44.0);
        this.pointLight = new PointLight(Color.WHITE);
        this.pointLight.setTranslateZ(-20000.0);
        this.ambLight = new AmbientLight(Color.color((double)0.3, (double)0.3, (double)0.3));
        this.viewingGroup = new Group(new Node[]{this.perspectiveCamera, this.pointLight});
        this.viewingGroup.getTransforms().setAll((Object[])new Transform[]{this.viewingRotate, this.viewingTranslate});
        this.tuxCubeCenterGroup = new Group();
        this.tuxCubeRotGroup = new Group(new Node[]{this.tuxCubeCenterGroup});
        this.tuxCubeRotate = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
        KeyValue keyValue = new KeyValue((WritableValue)this.tuxCubeRotate.angleProperty(), (Object)0, Interpolator.LINEAR);
        KeyValue keyValue2 = new KeyValue((WritableValue)this.tuxCubeRotate.angleProperty(), (Object)360, Interpolator.LINEAR);
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{keyValue});
        KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)50000.0), new KeyValue[]{keyValue2});
        this.tuxCubeRotTimeline = new Timeline();
        this.tuxCubeRotTimeline.setCycleCount(-1);
        this.tuxCubeRotTimeline.getKeyFrames().setAll((Object[])new KeyFrame[]{keyFrame, keyFrame2});
        this.tuxCubeRotGroup.getTransforms().setAll((Object[])new Transform[]{this.tuxCubeRotate});
    }

    private void createSubScene(double d, double d2, SceneAntialiasing sceneAntialiasing) {
        Group group = new Group();
        this.subScene = new SubScene((Parent)group, d, d2, true, sceneAntialiasing);
        this.subScene.setFill((Paint)Color.TRANSPARENT);
        this.subScene.setCamera((Camera)this.perspectiveCamera);
        group.getChildren().addAll((Object[])new Node[]{this.tuxCubeRotGroup, this.viewingGroup, this.ambLight});
        final Rotate rotate = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
        final Rotate rotate2 = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
        this.subScene.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                    rotate.setAngle((FXTuxCubeSubScene.this.startY - mouseEvent.getSceneY()) / 10.0);
                    rotate2.setAngle((mouseEvent.getSceneX() - FXTuxCubeSubScene.this.startX) / 10.0);
                    FXTuxCubeSubScene.this.viewingRotate.append(rotate.createConcatenation((Transform)rotate2));
                } else if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                    FXTuxCubeSubScene.this.viewingTranslate.setX(FXTuxCubeSubScene.this.viewingTranslate.getX() + (FXTuxCubeSubScene.this.startX - mouseEvent.getSceneX()) / 100.0);
                    FXTuxCubeSubScene.this.viewingTranslate.setY(FXTuxCubeSubScene.this.viewingTranslate.getY() + (FXTuxCubeSubScene.this.startY - mouseEvent.getSceneY()) / 100.0);
                } else if (mouseEvent.getButton() == MouseButton.MIDDLE) {
                    FXTuxCubeSubScene.this.viewingTranslate.setZ(FXTuxCubeSubScene.this.viewingTranslate.getZ() + (mouseEvent.getSceneY() - FXTuxCubeSubScene.this.startY) / 40.0);
                }
                FXTuxCubeSubScene.this.startX = mouseEvent.getSceneX();
                FXTuxCubeSubScene.this.startY = mouseEvent.getSceneY();
            }
        });
        this.subScene.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent scrollEvent) {
                FXTuxCubeSubScene.this.viewingTranslate.setZ(FXTuxCubeSubScene.this.viewingTranslate.getZ() - scrollEvent.getDeltaY() / 40.0);
            }
        });
        this.subScene.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                FXTuxCubeSubScene.this.startX = mouseEvent.getSceneX();
                FXTuxCubeSubScene.this.startY = mouseEvent.getSceneY();
            }
        });
    }

    SubScene getSubScene() {
        return this.subScene;
    }

    SubScene exchangeSubScene(SceneAntialiasing sceneAntialiasing) {
        ((Group)this.subScene.getRoot()).getChildren().clear();
        this.subScene.setCamera(null);
        this.subScene.setOnMouseDragged(null);
        this.subScene.setOnScroll(null);
        this.subScene.setOnMousePressed(null);
        this.createSubScene(this.subScene.getWidth(), this.subScene.getHeight(), sceneAntialiasing);
        return this.subScene;
    }

    void createTuxCubeOfDim(int n, boolean bl, DrawMode drawMode) {
        this.tuxCubeCenterGroup.getChildren().clear();
        long l = 4L;
        Group group = null;
        Group group2 = null;
        Group group3 = null;
        PhongMaterial[] phongMaterialArray = this.createMaterials(n);
        int n2 = n * n * n;
        int n3 = 0;
        int n4 = 0;
        int n5 = phongMaterialArray.length - 1;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        this.tuxRotTransAll = new RotateTransition[n2];
        this.meshViews = new MeshView[n2 * 6];
        ObservableList observableList = this.tuxCubeCenterGroup.getChildren();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n; ++k) {
                    n4 = n3 * 6;
                    group = new Group();
                    group.setTranslateZ(-0.01396);
                    group.getChildren().addAll((Object[])new Node[]{this.createMeshView((Mesh)this.eyesMesh, (Material)this.eyesMat, this.meshViews, n4), this.createMeshView((Mesh)this.feetMesh, (Material)this.feetMat, this.meshViews, n4 + 1), this.createMeshView((Mesh)this.mouthMesh, (Material)this.mouthMat, this.meshViews, n4 + 2), this.createMeshView((Mesh)this.pupilsMesh, (Material)this.pupilsMat, this.meshViews, n4 + 3), this.createMeshView((Mesh)this.bodyMesh, (Material)phongMaterialArray[n5], this.meshViews, n4 + 4), this.createMeshView((Mesh)this.frontMesh, (Material)phongMaterialArray[n5--], this.meshViews, n4 + 5)});
                    group2 = new Group(new Node[]{group});
                    RotateTransition rotateTransition = new RotateTransition();
                    rotateTransition.setNode((Node)group2);
                    rotateTransition.setAxis(Rotate.Y_AXIS);
                    rotateTransition.setDelay(Duration.millis((double)l));
                    rotateTransition.setDuration(Duration.millis((double)(5000.0 - (double)(2 * n3) * (1000.0 / (double)n2))));
                    rotateTransition.setCycleCount(-1);
                    rotateTransition.setAutoReverse(false);
                    rotateTransition.setInterpolator(Interpolator.LINEAR);
                    rotateTransition.setByAngle(360.0);
                    this.tuxRotTransAll[n3] = rotateTransition;
                    group3 = new Group(new Node[]{group2});
                    group3.setTranslateX((double)f);
                    group3.setTranslateY((double)f2);
                    group3.setTranslateZ((double)f3);
                    observableList.add((Object)group3);
                    f += 2.0f;
                    l = 4L * (long)n3;
                    ++n3;
                }
                f = 0.0f;
                f2 += 2.0f;
            }
            f2 = 0.0f;
            f3 += 2.0f;
            n5 = phongMaterialArray.length - 1;
        }
        this.tuxCubeBinL = (BoundingBox)this.tuxCubeCenterGroup.getBoundsInLocal();
        this.tuxCubeCenterGroup.setTranslateX(-(this.tuxCubeBinL.getMinX() + this.tuxCubeBinL.getMaxX()) / 2.0);
        this.tuxCubeCenterGroup.setTranslateY(-(this.tuxCubeBinL.getMinY() + this.tuxCubeBinL.getMaxY()) / 2.0);
        this.tuxCubeCenterGroup.setTranslateZ(-(this.tuxCubeBinL.getMinZ() + this.tuxCubeBinL.getMaxZ()) / 2.0);
        this.sceneDiameter = Math.sqrt(Math.pow(this.tuxCubeBinL.getWidth(), 2.0) + Math.pow(this.tuxCubeBinL.getHeight(), 2.0) + Math.pow(this.tuxCubeBinL.getDepth(), 2.0));
        this.playPauseTuxRotation(bl);
        if (drawMode == DrawMode.LINE) {
            this.setDrawMode(drawMode);
        }
    }

    void setVantagePoint(VP vP) {
        Rotate rotate = null;
        double d = this.distToSceneCenter(this.sceneDiameter / 2.0);
        switch (vP) {
            case BOTTOM: {
                rotate = new Rotate(90.0, Rotate.X_AXIS);
                break;
            }
            case CORNER: {
                Rotate rotate2 = new Rotate(-45.0, Rotate.X_AXIS);
                Rotate rotate3 = new Rotate(-45.0, new Point3D(0.0, 1.0, 1.0).normalize());
                rotate = rotate2.createConcatenation((Transform)rotate3);
                break;
            }
            case FRONT: {
                rotate = new Rotate();
                break;
            }
            case TOP: {
                rotate = new Rotate(-90.0, Rotate.X_AXIS);
            }
        }
        this.viewingRotate.setToTransform((Transform)rotate);
        this.viewingTranslate.setX(0.0);
        this.viewingTranslate.setY(0.0);
        this.viewingTranslate.setZ(-d);
    }

    void playPauseTuxRotation(boolean bl) {
        if (bl) {
            for (RotateTransition rotateTransition : this.tuxRotTransAll) {
                rotateTransition.play();
            }
        } else {
            for (RotateTransition rotateTransition : this.tuxRotTransAll) {
                rotateTransition.pause();
            }
        }
    }

    void stopTuxRotation() {
        for (RotateTransition rotateTransition : this.tuxRotTransAll) {
            rotateTransition.stop();
            rotateTransition.getNode().setRotate(0.0);
        }
    }

    void stopCubeRotation() {
        this.tuxCubeRotTimeline.stop();
        this.tuxCubeRotate.setAngle(0.0);
    }

    void setRotationSpeed(float f) {
        if (f < 49.0f) {
            this.tuxCubeRotTimeline.play();
            this.tuxCubeRotTimeline.setRate((double)(1.0f * (49.0f - f)));
        } else if (f > 51.0f) {
            this.tuxCubeRotTimeline.play();
            this.tuxCubeRotTimeline.setRate((double)(-1.0f * (f - 51.0f)));
        } else {
            this.tuxCubeRotTimeline.pause();
        }
    }

    void setDrawMode(DrawMode drawMode) {
        for (MeshView meshView : this.meshViews) {
            meshView.setDrawMode(drawMode);
        }
    }

    void setProjectionMode(String string) {
        if (string.equalsIgnoreCase("Parallel")) {
            // empty if block
        }
    }

    private MeshView createMeshView(Mesh mesh, Material material, MeshView[] meshViewArray, int n) {
        MeshView meshView = new MeshView(mesh);
        meshView.setMaterial(material);
        meshViewArray[n] = meshView;
        return meshView;
    }

    private PhongMaterial[] createMaterials(int n) {
        PhongMaterial[] phongMaterialArray = new PhongMaterial[n * n];
        int n2 = 0;
        int n3 = 1;
        float f = 0.0f;
        float f2 = 1.0f / (float)(n * n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                phongMaterialArray[n2] = new PhongMaterial();
                java.awt.Color color = new java.awt.Color(java.awt.Color.HSBtoRGB(f, 0.85f, 0.7f));
                phongMaterialArray[n2].setDiffuseColor(Color.rgb((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
                phongMaterialArray[n2].setSpecularColor(Color.color((double)0.2, (double)0.2, (double)0.2));
                phongMaterialArray[n2].setSpecularPower(16.0);
                f += f2 * (float)n3;
                ++n2;
            }
            if ((n3 *= -1) < 0) {
                f += f2 * (float)(n - 1);
                continue;
            }
            f += f2 * (float)(n + 1);
        }
        return phongMaterialArray;
    }

    private double distToSceneCenter(double d) {
        double d2 = this.perspectiveCamera.getFieldOfView();
        double d3 = this.subScene.getWidth();
        double d4 = this.subScene.getHeight();
        double d5 = 1.0;
        if (d3 > d4) {
            d5 = d3 / d4;
        }
        double d6 = 1.0 * d5 * d / Math.tan(Math.toRadians(d2 / 2.0));
        return d6;
    }

    static enum VP {
        Select("Select"),
        BOTTOM("Bottom"),
        CORNER("Corner"),
        FRONT("Front"),
        TOP("Top");

        private String listName;

        private VP(String string2) {
            this.listName = string2;
        }

        String getListName() {
            return this.listName;
        }
    }
}

