/*
 * Decompiled with CFR 0.152.
 */
package org.interactivemesh.jfx.sample3d.tuxcubesv;

import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.interactivemesh.jfx.sample3d.tuxcubesv.FXTuxCubeSVSubScene;

final class AnotherView {
    private final Group root3D;
    private double sceneDiameter = 0.0;
    private final SnapshotParameters params;
    private final ImageView viewPane;
    private WritableImage wImage = null;
    private final Affine viewingRotate = new Affine();
    private final Translate viewingTranslate = new Translate();
    private double startX = 0.0;
    private double startY = 0.0;
    private final PerspectiveCamera perspectiveCamera;

    AnotherView(Group group) {
        this.root3D = group;
        this.perspectiveCamera = new PerspectiveCamera(true);
        this.perspectiveCamera.setVerticalFieldOfView(false);
        this.perspectiveCamera.setFarClip(250.0);
        this.perspectiveCamera.setNearClip(0.1);
        this.perspectiveCamera.setFieldOfView(44.0);
        this.perspectiveCamera.getTransforms().setAll((Object[])new Transform[]{this.viewingRotate, this.viewingTranslate});
        this.params = new SnapshotParameters();
        this.params.setCamera((Camera)this.perspectiveCamera);
        this.params.setDepthBuffer(true);
        this.viewPane = new ImageView();
        final Rotate rotate = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
        final Rotate rotate2 = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
        this.viewPane.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                    rotate.setAngle((AnotherView.this.startY - mouseEvent.getSceneY()) / 10.0);
                    rotate2.setAngle((mouseEvent.getSceneX() - AnotherView.this.startX) / 10.0);
                    AnotherView.this.viewingRotate.append(rotate.createConcatenation((Transform)rotate2));
                } else if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                    AnotherView.this.viewingTranslate.setX(AnotherView.this.viewingTranslate.getX() + (AnotherView.this.startX - mouseEvent.getSceneX()) / 100.0);
                    AnotherView.this.viewingTranslate.setY(AnotherView.this.viewingTranslate.getY() + (AnotherView.this.startY - mouseEvent.getSceneY()) / 100.0);
                } else if (mouseEvent.getButton() == MouseButton.MIDDLE) {
                    AnotherView.this.viewingTranslate.setZ(AnotherView.this.viewingTranslate.getZ() + (mouseEvent.getSceneY() - AnotherView.this.startY) / 40.0);
                }
                AnotherView.this.startX = mouseEvent.getSceneX();
                AnotherView.this.startY = mouseEvent.getSceneY();
            }
        });
        this.viewPane.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent scrollEvent) {
                AnotherView.this.viewingTranslate.setZ(AnotherView.this.viewingTranslate.getZ() - scrollEvent.getDeltaY() / 40.0);
            }
        });
        this.viewPane.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                AnotherView.this.startX = mouseEvent.getSceneX();
                AnotherView.this.startY = mouseEvent.getSceneY();
            }
        });
    }

    ImageView getViewPane() {
        return this.viewPane;
    }

    void drawView(double d, double d2) {
        this.params.setViewport(new Rectangle2D(0.0, 0.0, d, d2));
        if (this.wImage == null || this.wImage.getWidth() != d || this.wImage.getHeight() != d2) {
            this.wImage = this.root3D.snapshot(this.params, null);
        } else {
            this.root3D.snapshot(this.params, this.wImage);
        }
        this.viewPane.setImage((Image)this.wImage);
    }

    void setBackground(Paint paint) {
        this.params.setFill(paint);
    }

    void setSceneDiameter(double d) {
        this.sceneDiameter = d;
    }

    void setVantagePoint(FXTuxCubeSVSubScene.VP vP) {
        Rotate rotate = null;
        double d = this.distToSceneCenter(this.sceneDiameter / 2.0);
        switch (vP) {
            case BOTTOM: {
                rotate = new Rotate(90.0, Rotate.X_AXIS);
                break;
            }
            case CORNER: {
                Rotate rotate2 = new Rotate(-45.0, Rotate.X_AXIS);
                Rotate rotate3 = new Rotate(-45.0, new Point3D(0.0, 1.0, 1.0).normalize());
                rotate = rotate2.createConcatenation((Transform)rotate3);
                break;
            }
            case FRONT: {
                rotate = new Rotate();
                break;
            }
            case TOP: {
                rotate = new Rotate(-90.0, Rotate.X_AXIS);
            }
        }
        this.viewingRotate.setToTransform((Transform)rotate);
        this.viewingTranslate.setX(0.0);
        this.viewingTranslate.setY(0.0);
        this.viewingTranslate.setZ(-d);
    }

    private double distToSceneCenter(double d) {
        double d2 = this.perspectiveCamera.getFieldOfView();
        Bounds bounds = this.viewPane.getBoundsInLocal();
        double d3 = bounds.getWidth();
        double d4 = bounds.getHeight();
        double d5 = 1.0;
        if (d3 > d4) {
            d5 = d3 / d4;
        }
        double d6 = 1.0 * d5 * d / Math.tan(Math.toRadians(d2 / 2.0));
        return d6;
    }
}

