/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.image;

import com.interactivemesh.jfx.image.ImageFactoryImpl;
import com.interactivemesh.jfx.image.TifArrayStream;
import com.interactivemesh.jfx.image.TifBufferStream;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.net.URL;
import javafx.scene.image.WritableImage;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;

final class ImageFactoryJAIImpl
extends ImageFactoryImpl {
    private TifArrayStream tiffArrayStream = null;
    private TifBufferStream tiffBufferStream = null;

    ImageFactoryJAIImpl() {
    }

    @Override
    void close() {
        super.close();
        try {
            if (this.tiffArrayStream != null) {
                this.tiffArrayStream.close();
            }
            if (this.tiffBufferStream != null) {
                this.tiffBufferStream.close();
            }
            this.tiffArrayStream = null;
            this.tiffBufferStream = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    WritableImage readImage(String string, URL uRL) throws IOException {
        if (string.equalsIgnoreCase("tif") || string.equalsIgnoreCase("tiff")) {
            return this.readTifImage(uRL);
        }
        return super.readImage(string, uRL);
    }

    private WritableImage readTifImage(URL uRL) throws IOException {
        WritableImage writableImage = null;
        ImageFactoryImpl.ImageData imageData = this.setupImageBuffer(uRL);
        if (imageData == ImageFactoryImpl.ImageData.ARRAY) {
            if (this.tiffArrayStream == null) {
                this.tiffArrayStream = new TifArrayStream();
            }
            this.tiffArrayStream.setup(this.currImageArray, this.currImageArrayLimit);
            writableImage = this.createTiff(this.tiffArrayStream);
            this.tiffArrayStream.clear();
        } else if (imageData == ImageFactoryImpl.ImageData.BUFFER) {
            if (this.tiffBufferStream == null) {
                this.tiffBufferStream = new TifBufferStream();
            }
            this.tiffBufferStream.setup(this.currImageBuffer);
            writableImage = this.createTiff(this.tiffBufferStream);
            this.tiffBufferStream.clear();
        }
        return writableImage;
    }

    private WritableImage createTiff(SeekableStream seekableStream) throws IOException {
        Object var2_2 = null;
        RenderingHints renderingHints = null;
        TIFFDecodeParam tIFFDecodeParam = new TIFFDecodeParam();
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("TIFF", "rendered");
        parameterBlockJAI.setParameter("stream", (Object)seekableStream);
        parameterBlockJAI.setParameter("param", (Object)tIFFDecodeParam);
        parameterBlockJAI.setParameter("page", var2_2);
        RenderedOp renderedOp = JAI.create((String)"TIFF", (ParameterBlock)parameterBlockJAI, renderingHints);
        BufferedImage bufferedImage = renderedOp.getAsBufferedImage();
        return this.bImageToWImage(bufferedImage);
    }
}

