/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.image;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.IIOException;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

final class ImageIOInputStreamBuffer
implements ImageInputStream {
    private Stack<Long> markByteStack = null;
    private Stack<Integer> markBitStack = null;
    private boolean isClosed = false;
    private ByteBuffer buffer = null;
    private int bufferSize = -1;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private int bitOffset = 0;
    private long flushedPos = 0L;
    private boolean doPrint = false;

    ImageIOInputStreamBuffer() {
    }

    void setup(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        this.buffer = byteBuffer;
        byteBuffer.order(byteOrder);
        this.byteOrder = byteOrder;
        this.bufferSize = byteBuffer.remaining();
        this.markByteStack = new Stack();
        this.markBitStack = new Stack();
        this.isClosed = false;
        this.bitOffset = 0;
        this.flushedPos = 0L;
    }

    void clear() {
        this.buffer = null;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream setByteOrder byteOrder = " + byteOrder);
        }
        this.byteOrder = byteOrder;
        this.buffer.order(byteOrder);
    }

    @Override
    public ByteOrder getByteOrder() {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream getByteOrder() !");
        }
        return this.byteOrder;
    }

    @Override
    public int read() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream read() !");
        }
        this.bitOffset = 0;
        if (this.buffer.position() < this.buffer.limit()) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream read(byte[] b) !");
        }
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream read(byte[] b, int off, int len) len = " + n2);
        }
        if (byArray == null) {
            throw new NullPointerException("b == null");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("((off < 0) || (len < 0) || (off + len > b.length)) b.length/off/len=)" + byArray.length + "/" + n + "/" + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        this.bitOffset = 0;
        if (this.buffer.position() >= this.buffer.limit()) {
            return -1;
        }
        if (n2 > this.buffer.remaining()) {
            n2 = this.buffer.remaining();
        }
        this.buffer.get(byArray, n, n2);
        return n2;
    }

    @Override
    public void readBytes(IIOByteBuffer iIOByteBuffer, int n) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readBytes(IIOByteBuffer buf, int len) !");
        }
        this.bitOffset = 0;
        if (n < 0) {
            throw new IndexOutOfBoundsException("len < 0!");
        }
        if (iIOByteBuffer == null) {
            throw new NullPointerException("buf == null!");
        }
        byte[] byArray = new byte[n];
        n = this.read(byArray, 0, n);
        iIOByteBuffer.setData(byArray);
        iIOByteBuffer.setOffset(0);
        iIOByteBuffer.setLength(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        int n;
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readBoolean() !");
        }
        return (n = this.readUnsignedByte()) != 0;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readByte() !");
        }
        if (this.buffer.remaining() < 1) {
            throw new EOFException("(buffer.remaining() < 1)");
        }
        this.bitOffset = 0;
        return this.buffer.get();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readUnsignedByte() !");
        }
        if (this.buffer.remaining() < 1) {
            throw new EOFException("(buffer.remaining() < 1)");
        }
        this.bitOffset = 0;
        return this.buffer.get() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readShort() !");
        }
        if (this.buffer.remaining() < 2) {
            throw new EOFException("(buffer.remaining() < 2)");
        }
        this.bitOffset = 0;
        return this.buffer.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readUnsignedShort() !");
        }
        if (this.buffer.remaining() < 2) {
            throw new EOFException("(buffer.remaining() < 2)");
        }
        this.bitOffset = 0;
        return this.buffer.getShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readChar() !");
        }
        if (this.buffer.remaining() < 2) {
            throw new EOFException("(buffer.remaining() < 2)");
        }
        this.bitOffset = 0;
        return this.buffer.getChar();
    }

    @Override
    public int readInt() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readInt() !");
        }
        if (this.buffer.remaining() < 4) {
            throw new EOFException("(buffer.remaining() < 4)");
        }
        this.bitOffset = 0;
        return this.buffer.getInt();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readUnsignedInt() !");
        }
        if (this.buffer.remaining() < 4) {
            throw new EOFException("(buffer.remaining() < 4)");
        }
        this.bitOffset = 0;
        return (long)this.buffer.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readLong() !");
        }
        if (this.buffer.remaining() < 8) {
            throw new EOFException("(buffer.remaining() < 8)");
        }
        this.bitOffset = 0;
        return this.buffer.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readFloat() !");
        }
        if (this.buffer.remaining() < 4) {
            throw new EOFException("(buffer.remaining() < 4)");
        }
        this.bitOffset = 0;
        return this.buffer.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readDouble() !");
        }
        if (this.buffer.remaining() < 8) {
            throw new EOFException("(buffer.remaining() < 8)");
        }
        this.bitOffset = 0;
        return this.buffer.getDouble();
    }

    @Override
    public String readLine() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readLine() !");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    continue block4;
                }
                case 13: {
                    bl = true;
                    long l = this.getStreamPosition();
                    if (this.read() == 10) continue block4;
                    this.seek(l);
                    continue block4;
                }
            }
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Override
    public String readUTF() throws IOException {
        String string;
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readUTF() !");
        }
        this.bitOffset = 0;
        ByteOrder byteOrder = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            string = DataInputStream.readUTF(this);
        }
        catch (IOException e) {
            this.setByteOrder(byteOrder);
            throw e;
        }
        this.setByteOrder(byteOrder);
        return string;
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readFully(byte[] b, int off, int len) len = " + n2);
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        if (n2 > this.buffer.remaining()) {
            throw new EOFException("(len > buffer.remaining())");
        }
        this.bitOffset = 0;
        this.buffer.get(byArray, n, n2);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readFully(byte[] b) !");
        }
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(short[] sArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > sArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readFully(short[] s, int off, int len) len = " + n2);
        }
        if (n2 > this.buffer.remaining() / 2) {
            throw new EOFException("(len > buffer.remaining()/2)");
        }
        this.bitOffset = 0;
        for (int i = 0; i < n2; ++i) {
            sArray[n + i] = this.buffer.getShort();
        }
    }

    @Override
    public void readFully(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length!");
        }
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readFully(char[] c, int off, int len) len = " + n2);
        }
        if (n2 > this.buffer.remaining() / 2) {
            throw new EOFException("(len > buffer.remaining()/2)");
        }
        this.bitOffset = 0;
        for (int i = 0; i < n2; ++i) {
            cArray[n + i] = this.buffer.getChar();
        }
    }

    @Override
    public void readFully(int[] nArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > nArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readFully(int[] i, int off, int len) len = " + n2);
        }
        if (n2 > this.buffer.remaining() / 4) {
            throw new EOFException("(len > buffer.remaining()/4)");
        }
        this.bitOffset = 0;
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.buffer.getInt();
        }
    }

    @Override
    public void readFully(long[] lArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > lArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length!");
        }
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readFully(long[] l, int off, int len) len = " + n2);
        }
        if (n2 > this.buffer.remaining() / 8) {
            throw new EOFException("(len > buffer.remaining()/8)");
        }
        this.bitOffset = 0;
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.buffer.getLong();
        }
    }

    @Override
    public void readFully(float[] fArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > fArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length!");
        }
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readFully(float[] f, int off, int len) len = " + n2);
        }
        if (n2 > this.buffer.remaining() / 4) {
            throw new EOFException("(len > buffer.remaining()/4)");
        }
        this.bitOffset = 0;
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.buffer.getFloat();
        }
    }

    @Override
    public void readFully(double[] dArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > dArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length!");
        }
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readFully(double[] d, int off, int len) len = " + n2);
        }
        if (n2 > this.buffer.remaining() / 8) {
            throw new EOFException("(len > buffer.remaining()/8)");
        }
        this.bitOffset = 0;
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.buffer.getDouble();
        }
    }

    @Override
    public long getStreamPosition() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream getStreamPosition() = " + this.buffer.position());
        }
        return this.buffer.position();
    }

    @Override
    public int getBitOffset() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream getBitOffset() !");
        }
        return this.bitOffset;
    }

    @Override
    public void setBitOffset(int n) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream setBitOffset(int bitOffset) !");
        }
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("bitOffset must be betwwen 0 and 7!");
        }
        this.bitOffset = n;
    }

    @Override
    public int readBit() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readBit() !");
        }
        int n = this.bitOffset + 1 & 7;
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        if (n != 0) {
            this.seek(this.getStreamPosition() - 1L);
            n2 >>= 8 - n;
        }
        this.bitOffset = n;
        return n2 & 1;
    }

    @Override
    public long readBits(int n) throws IOException {
        int n2;
        if (this.doPrint) {
            System.out.println("ImageIOInputStream readBits(int numBits) !");
        }
        if (n < 0 || n > 64) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return 0L;
        }
        int n3 = this.bitOffset + n & 7;
        long l = 0L;
        for (n2 = n + this.bitOffset; n2 > 0; n2 -= 8) {
            int n4 = this.read();
            if (n4 == -1) {
                throw new EOFException();
            }
            l <<= 8;
            l |= (long)n4;
        }
        if (n3 != 0) {
            this.seek(this.getStreamPosition() - 1L);
        }
        this.bitOffset = n3;
        l >>>= -n2;
        return l &= -1L >>> 64 - n;
    }

    @Override
    public long length() {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream length() !");
        }
        return this.bufferSize;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream skipBytes(int n) !");
        }
        long l = this.getStreamPosition();
        this.seek(l + (long)n);
        return (int)(this.getStreamPosition() - l);
    }

    @Override
    public long skipBytes(long l) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream skipBytes(long n) !");
        }
        long l2 = this.getStreamPosition();
        this.seek(l2 + l);
        return this.getStreamPosition() - l2;
    }

    @Override
    public void seek(long l) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream seek(long pos) pos = " + l);
        }
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        int n = Math.min((int)l, this.buffer.limit());
        this.buffer.position(n);
        this.bitOffset = 0;
    }

    @Override
    public void mark() {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream mark() !");
        }
        try {
            this.markByteStack.push(new Long(this.getStreamPosition()));
            this.markBitStack.push(new Integer(this.getBitOffset()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream reset() !");
        }
        if (this.markByteStack.empty()) {
            return;
        }
        long l = this.markByteStack.pop();
        if (l < this.flushedPos) {
            throw new IIOException("Previous marked position has been discarded!");
        }
        this.seek(l);
        int n = this.markBitStack.pop();
        this.setBitOffset(n);
    }

    @Override
    public void flushBefore(long l) throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream flushBefore(long pos) pos = " + l);
        }
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        if (l > this.getStreamPosition()) {
            throw new IndexOutOfBoundsException("pos > getStreamPosition()!");
        }
        this.flushedPos = l;
    }

    @Override
    public void flush() throws IOException {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream flush() !");
        }
        this.flushBefore(this.getStreamPosition());
    }

    @Override
    public long getFlushedPosition() {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream getFlushedPosition() !");
        }
        return this.flushedPos;
    }

    @Override
    public boolean isCached() {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream isCached() !");
        }
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream isCachedMemory() !");
        }
        return true;
    }

    @Override
    public boolean isCachedFile() {
        if (this.doPrint) {
            System.out.println("ImageIOInputStream isCachedFile() !");
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.clear();
        if (this.doPrint) {
            System.out.println("ImageIOInputStream close() !");
        }
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

