/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.image;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;

final class TgaImageReader {
    private int lengthField6 = Integer.MIN_VALUE;
    private int colorMapType = Integer.MIN_VALUE;
    private int imageType = Integer.MIN_VALUE;
    private int firstEntryIndex = Integer.MIN_VALUE;
    private int colorMapLength = Integer.MIN_VALUE;
    private int colorMapEntrySize = Integer.MIN_VALUE;
    private int xOrigin = Integer.MIN_VALUE;
    private int yOrigin = Integer.MIN_VALUE;
    private int width = Integer.MIN_VALUE;
    private int height = Integer.MIN_VALUE;
    private int depth = Integer.MIN_VALUE;
    private int descriptor = Integer.MIN_VALUE;
    private int descNumAlphaBits = Integer.MIN_VALUE;
    private int descBit4 = Integer.MIN_VALUE;
    private int descBit5 = Integer.MIN_VALUE;
    private int descBit6 = Integer.MIN_VALUE;
    private int descBit7 = Integer.MIN_VALUE;
    String imageInfoString = null;

    TgaImageReader() {
    }

    private void readHeader(ByteBuffer byteBuffer) throws IOException {
        this.lengthField6 = byteBuffer.get() & 0xFF;
        this.colorMapType = byteBuffer.get() & 0xFF;
        this.imageType = byteBuffer.get() & 0xFF;
        this.firstEntryIndex = byteBuffer.getShort() & 0xFFFF;
        this.colorMapLength = byteBuffer.getShort() & 0xFFFF;
        this.colorMapEntrySize = byteBuffer.get() & 0xFF;
        this.xOrigin = byteBuffer.getShort() & 0xFFFF;
        this.yOrigin = byteBuffer.getShort() & 0xFFFF;
        this.width = byteBuffer.getShort() & 0xFFFF;
        this.height = byteBuffer.getShort() & 0xFFFF;
        this.depth = byteBuffer.get() & 0xFF;
        this.descriptor = byteBuffer.get() & 0xFF;
        this.descNumAlphaBits = this.descriptor & 0xF;
        this.descBit4 = this.descriptor & 0x10;
        this.descBit5 = this.descriptor & 0x20;
        this.descBit6 = this.descriptor & 0x40;
        this.descBit7 = this.descriptor & 0x80;
        this.imageInfoString = null;
        if (this.lengthField6 > 0) {
            int n = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + this.lengthField6);
            Charset charset = Charset.forName("ISO-8859-1");
            CharsetDecoder charsetDecoder = charset.newDecoder();
            CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
            charBuffer.clear();
            char[] cArray = null;
            if (charBuffer.isDirect()) {
                cArray = new char[charBuffer.limit()];
                charBuffer.get(cArray);
            } else {
                cArray = charBuffer.array();
            }
            this.imageInfoString = new String(cArray);
            byteBuffer.limit(n);
        }
    }

    private int readHeader(byte[] byArray, int n) throws IOException {
        int n2 = 0;
        this.lengthField6 = byArray[n2++] & 0xFF;
        this.colorMapType = byArray[n2++] & 0xFF;
        this.imageType = byArray[n2++] & 0xFF;
        this.firstEntryIndex = ((byArray[n2++] & 0xFF) << 0 | (byArray[n2++] & 0xFF) << 8) & 0xFFFF;
        this.colorMapLength = ((byArray[n2++] & 0xFF) << 0 | (byArray[n2++] & 0xFF) << 8) & 0xFFFF;
        this.colorMapEntrySize = byArray[n2++] & 0xFF;
        this.xOrigin = ((byArray[n2++] & 0xFF) << 0 | (byArray[n2++] & 0xFF) << 8) & 0xFFFF;
        this.yOrigin = ((byArray[n2++] & 0xFF) << 0 | (byArray[n2++] & 0xFF) << 8) & 0xFFFF;
        this.width = ((byArray[n2++] & 0xFF) << 0 | (byArray[n2++] & 0xFF) << 8) & 0xFFFF;
        this.height = ((byArray[n2++] & 0xFF) << 0 | (byArray[n2++] & 0xFF) << 8) & 0xFFFF;
        this.depth = byArray[n2++] & 0xFF;
        this.descriptor = byArray[n2++] & 0xFF;
        this.descNumAlphaBits = this.descriptor & 0xF;
        this.descBit4 = this.descriptor & 0x10;
        this.descBit5 = this.descriptor & 0x20;
        this.descBit6 = this.descriptor & 0x40;
        this.descBit7 = this.descriptor & 0x80;
        this.imageInfoString = null;
        if (this.lengthField6 > 0) {
            this.imageInfoString = new String(byArray, n2, n2 + this.lengthField6);
            n2 += this.lengthField6;
        }
        return n2;
    }

    private void clearHeader() {
        this.lengthField6 = Integer.MIN_VALUE;
        this.colorMapType = Integer.MIN_VALUE;
        this.imageType = Integer.MIN_VALUE;
        this.firstEntryIndex = Integer.MIN_VALUE;
        this.colorMapLength = Integer.MIN_VALUE;
        this.colorMapEntrySize = Integer.MIN_VALUE;
        this.xOrigin = Integer.MIN_VALUE;
        this.yOrigin = Integer.MIN_VALUE;
        this.width = Integer.MIN_VALUE;
        this.height = Integer.MIN_VALUE;
        this.depth = Integer.MIN_VALUE;
        this.descriptor = Integer.MIN_VALUE;
        this.descNumAlphaBits = Integer.MIN_VALUE;
        this.descBit4 = Integer.MIN_VALUE;
        this.descBit5 = Integer.MIN_VALUE;
        this.descBit6 = Integer.MIN_VALUE;
        this.descBit7 = Integer.MIN_VALUE;
        this.imageInfoString = null;
    }

    WritableImage readTgaImage(ByteBuffer byteBuffer) throws IOException {
        return this.getTgaImageFrom(byteBuffer);
    }

    WritableImage readTgaImage(byte[] byArray, int n) throws IOException {
        return this.getTgaImageFrom(byArray, n);
    }

    private WritableImage getTgaImageFrom(byte[] byArray, int n) throws IOException {
        int n2 = this.readHeader(byArray, n);
        int n3 = 0;
        if (this.colorMapType > 0) {
            n3 = this.colorMapEntrySize * this.colorMapLength;
            n2 += n3;
        }
        WritableImage writableImage = new WritableImage(this.width, this.height);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        PixelFormat pixelFormat = pixelWriter.getPixelFormat();
        PixelFormat.Type type = pixelFormat.getType();
        int n4 = this.width * this.height;
        if (this.imageType == 2) {
            if (this.depth == 24 || this.depth == 32 && this.descNumAlphaBits == 0) {
                if (type == PixelFormat.Type.BYTE_BGRA || type == PixelFormat.Type.BYTE_BGRA_PRE) {
                    int n5;
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder());
                    if (this.depth == 24) {
                        if (this.yOrigin == 0) {
                            n5 = 0;
                            for (int i = this.height - 1; i >= 0; --i) {
                                n5 = i * this.width;
                                byteBuffer.position(n5 * 4);
                                for (int j = 0; j < this.width; ++j) {
                                    byteBuffer.put(byArray[n2++]);
                                    byteBuffer.put(byArray[n2++]);
                                    byteBuffer.put(byArray[n2++]);
                                    byteBuffer.put((byte)127);
                                }
                            }
                        } else {
                            for (n5 = 0; n5 < n4; ++n5) {
                                byteBuffer.put(byArray[n2++]);
                                byteBuffer.put(byArray[n2++]);
                                byteBuffer.put(byArray[n2++]);
                                byteBuffer.put((byte)127);
                            }
                        }
                    } else if (this.yOrigin == 0) {
                        n5 = 0;
                        for (int i = this.height - 1; i >= 0; --i) {
                            n5 = i * this.width;
                            byteBuffer.position(n5 * 4);
                            for (int j = 0; j < this.width; ++j) {
                                byteBuffer.put(byArray[n2++]);
                                byteBuffer.put(byArray[n2++]);
                                byteBuffer.put(byArray[n2++]);
                                byteBuffer.put((byte)127);
                                ++n2;
                            }
                        }
                    } else {
                        for (n5 = 0; n5 < n4; ++n5) {
                            byteBuffer.put(byArray[n2++]);
                            byteBuffer.put(byArray[n2++]);
                            byteBuffer.put(byArray[n2++]);
                            byteBuffer.put((byte)127);
                            ++n2;
                        }
                    }
                    byteBuffer.position(0);
                    WritablePixelFormat writablePixelFormat = PixelFormat.getByteBgraPreInstance();
                    if (type == PixelFormat.Type.BYTE_BGRA) {
                        writablePixelFormat = PixelFormat.getByteBgraInstance();
                    }
                    pixelWriter.setPixels(0, 0, this.width, this.height, (PixelFormat)writablePixelFormat, (Buffer)byteBuffer, this.width * 4);
                } else {
                    int n6;
                    IntBuffer intBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
                    if (this.depth == 24) {
                        if (this.yOrigin == 0) {
                            n6 = 0;
                            for (int i = this.height - 1; i >= 0; --i) {
                                n6 = i * this.width;
                                for (int j = 0; j < this.width; ++j) {
                                    intBuffer.put(n6++, 0xFF000000 | byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16);
                                }
                            }
                        } else {
                            for (n6 = 0; n6 < n4; ++n6) {
                                intBuffer.put(0xFF000000 | byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16);
                            }
                        }
                    } else if (this.yOrigin == 0) {
                        n6 = 0;
                        for (int i = this.height - 1; i >= 0; --i) {
                            n6 = i * this.width;
                            for (int j = 0; j < this.width; ++j) {
                                intBuffer.put(n6++, 0xFF000000 | byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16);
                                ++n2;
                            }
                        }
                    } else {
                        for (n6 = 0; n6 < n4; ++n6) {
                            intBuffer.put(0xFF000000 | byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16);
                            ++n2;
                        }
                    }
                    intBuffer.position(0);
                    WritablePixelFormat writablePixelFormat = PixelFormat.getIntArgbPreInstance();
                    if (type == PixelFormat.Type.INT_ARGB) {
                        writablePixelFormat = PixelFormat.getIntArgbInstance();
                    }
                    pixelWriter.setPixels(0, 0, this.width, this.height, (PixelFormat)writablePixelFormat, (Buffer)intBuffer, this.width);
                }
            } else if (this.depth == 32 && this.descNumAlphaBits == 8) {
                if (type == PixelFormat.Type.BYTE_BGRA || type == PixelFormat.Type.BYTE_BGRA_PRE) {
                    int n7;
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder());
                    if (type == PixelFormat.Type.BYTE_BGRA) {
                        if (this.yOrigin == 0) {
                            n7 = 0;
                            for (int i = this.height - 1; i >= 0; --i) {
                                n7 = i * this.width;
                                byteBuffer.position(n7 * 4);
                                for (int j = 0; j < this.width; ++j) {
                                    byteBuffer.put(byArray[n2++]);
                                    byteBuffer.put(byArray[n2++]);
                                    byteBuffer.put(byArray[n2++]);
                                    byteBuffer.put(byArray[n2++]);
                                }
                            }
                        } else {
                            for (n7 = 0; n7 < n4; ++n7) {
                                byteBuffer.put(byArray[n2++]);
                                byteBuffer.put(byArray[n2++]);
                                byteBuffer.put(byArray[n2++]);
                                byteBuffer.put(byArray[n2++]);
                            }
                        }
                    } else if (this.yOrigin == 0) {
                        int n8 = 0;
                        for (int i = this.height - 1; i >= 0; --i) {
                            n8 = i * this.width;
                            byteBuffer.position(n8 * 4);
                            for (int j = 0; j < this.width; ++j) {
                                int n9 = byArray[n2++] & 0xFF;
                                int n10 = byArray[n2++] & 0xFF;
                                int n11 = byArray[n2++] & 0xFF;
                                if ((n7 = byArray[n2++] & 0xFF) == 255) {
                                    byteBuffer.put((byte)n9);
                                    byteBuffer.put((byte)n10);
                                    byteBuffer.put((byte)n11);
                                    byteBuffer.put((byte)n7);
                                    continue;
                                }
                                if (n7 == 0) {
                                    byteBuffer.put((byte)0);
                                    byteBuffer.put((byte)0);
                                    byteBuffer.put((byte)0);
                                    byteBuffer.put((byte)0);
                                    continue;
                                }
                                byteBuffer.put((byte)((n9 * n7 + 127) / 255));
                                byteBuffer.put((byte)((n10 * n7 + 127) / 255));
                                byteBuffer.put((byte)((n11 * n7 + 127) / 255));
                                byteBuffer.put((byte)n7);
                            }
                        }
                    } else {
                        for (int i = 0; i < n4; ++i) {
                            int n12 = byArray[n2++] & 0xFF;
                            int n13 = byArray[n2++] & 0xFF;
                            int n14 = byArray[n2++] & 0xFF;
                            if ((n7 = byArray[n2++] & 0xFF) == 255) {
                                byteBuffer.put((byte)n12);
                                byteBuffer.put((byte)n13);
                                byteBuffer.put((byte)n14);
                                byteBuffer.put((byte)n7);
                                continue;
                            }
                            if (n7 == 0) {
                                byteBuffer.put((byte)0);
                                byteBuffer.put((byte)0);
                                byteBuffer.put((byte)0);
                                byteBuffer.put((byte)0);
                                continue;
                            }
                            byteBuffer.put((byte)((n12 * n7 + 127) / 255));
                            byteBuffer.put((byte)((n13 * n7 + 127) / 255));
                            byteBuffer.put((byte)((n14 * n7 + 127) / 255));
                            byteBuffer.put((byte)n7);
                        }
                    }
                    byteBuffer.position(0);
                    WritablePixelFormat writablePixelFormat = PixelFormat.getByteBgraPreInstance();
                    if (type == PixelFormat.Type.BYTE_BGRA) {
                        writablePixelFormat = PixelFormat.getByteBgraInstance();
                    }
                    pixelWriter.setPixels(0, 0, this.width, this.height, (PixelFormat)writablePixelFormat, (Buffer)byteBuffer, this.width * 4);
                } else {
                    int n15;
                    IntBuffer intBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
                    if (type == PixelFormat.Type.INT_ARGB) {
                        if (this.yOrigin == 0) {
                            n15 = 0;
                            for (int i = this.height - 1; i >= 0; --i) {
                                n15 = i * this.width;
                                for (int j = 0; j < this.width; ++j) {
                                    intBuffer.put(n15++, byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24);
                                }
                            }
                        } else {
                            for (n15 = 0; n15 < n4; ++n15) {
                                intBuffer.put(byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24);
                            }
                        }
                    } else if (this.yOrigin == 0) {
                        int n16 = 0;
                        for (int i = this.height - 1; i >= 0; --i) {
                            n16 = i * this.width;
                            for (int j = 0; j < this.width; ++j) {
                                int n17 = byArray[n2++] & 0xFF;
                                int n18 = byArray[n2++] & 0xFF;
                                int n19 = byArray[n2++] & 0xFF;
                                if ((n15 = byArray[n2++] & 0xFF) == 255) {
                                    intBuffer.put(n16++, n17 & 0xFF | (n18 & 0xFF) << 8 | (n19 & 0xFF) << 16 | (n15 & 0xFF) << 24);
                                    continue;
                                }
                                if (n15 == 0) {
                                    intBuffer.put(n16++, 0);
                                    continue;
                                }
                                intBuffer.put(n16++, (n17 * n15 + 127) / 255 | (n18 * n15 + 127) / 255 << 8 | (n19 * n15 + 127) / 255 << 16 | (n15 & 0xFF) << 24);
                            }
                        }
                    } else {
                        for (int i = 0; i < n4; ++i) {
                            int n20 = byArray[n2++] & 0xFF;
                            int n21 = byArray[n2++] & 0xFF;
                            int n22 = byArray[n2++] & 0xFF;
                            if ((n15 = byArray[n2++] & 0xFF) == 255) {
                                intBuffer.put(n20 & 0xFF | (n21 & 0xFF) << 8 | (n22 & 0xFF) << 16 | (n15 & 0xFF) << 24);
                                continue;
                            }
                            if (n15 == 0) {
                                intBuffer.put(0);
                                continue;
                            }
                            intBuffer.put((n20 * n15 + 127) / 255 | (n21 * n15 + 127) / 255 << 8 | (n22 * n15 + 127) / 255 << 16 | (n15 & 0xFF) << 24);
                        }
                    }
                    intBuffer.position(0);
                    WritablePixelFormat writablePixelFormat = PixelFormat.getIntArgbPreInstance();
                    if (type == PixelFormat.Type.INT_ARGB) {
                        writablePixelFormat = PixelFormat.getIntArgbInstance();
                    }
                    pixelWriter.setPixels(0, 0, this.width, this.height, (PixelFormat)writablePixelFormat, (Buffer)intBuffer, this.width);
                }
            } else {
                System.out.println("TGA byte[] not read  depth / descNumAlphaBits = " + this.depth + " / " + this.descNumAlphaBits);
                writableImage = null;
            }
        } else if (this.imageType == 0) {
            writableImage = null;
        } else {
            System.out.println("TGA byte[] not read  imageType = " + this.imageType);
            writableImage = null;
        }
        this.clearHeader();
        return writableImage;
    }

    private WritableImage getTgaImageFrom(ByteBuffer byteBuffer) throws IOException {
        this.readHeader(byteBuffer);
        int n = 0;
        if (this.colorMapType > 0) {
            n = this.colorMapEntrySize * this.colorMapLength;
            byteBuffer.position(byteBuffer.position() + n);
        }
        WritableImage writableImage = new WritableImage(this.width, this.height);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        PixelFormat pixelFormat = pixelWriter.getPixelFormat();
        PixelFormat.Type type = pixelFormat.getType();
        int n2 = this.width * this.height;
        if (this.imageType == 2) {
            if (this.depth == 24 || this.depth == 32 && this.descNumAlphaBits == 0) {
                if (type == PixelFormat.Type.BYTE_BGRA || type == PixelFormat.Type.BYTE_BGRA_PRE) {
                    int n3;
                    ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder());
                    if (this.depth == 24) {
                        if (this.yOrigin == 0) {
                            n3 = 0;
                            for (int i = this.height - 1; i >= 0; --i) {
                                n3 = i * this.width;
                                byteBuffer2.position(n3 * 4);
                                for (int j = 0; j < this.width; ++j) {
                                    byteBuffer2.put(byteBuffer.get());
                                    byteBuffer2.put(byteBuffer.get());
                                    byteBuffer2.put(byteBuffer.get());
                                    byteBuffer2.put((byte)-1);
                                }
                            }
                        } else {
                            for (n3 = 0; n3 < n2; ++n3) {
                                byteBuffer2.put(byteBuffer.get());
                                byteBuffer2.put(byteBuffer.get());
                                byteBuffer2.put(byteBuffer.get());
                                byteBuffer2.put((byte)-1);
                            }
                        }
                    } else if (this.yOrigin == 0) {
                        n3 = 0;
                        for (int i = this.height - 1; i >= 0; --i) {
                            n3 = i * this.width;
                            byteBuffer2.position(n3 * 4);
                            for (int j = 0; j < this.width; ++j) {
                                byteBuffer2.put(byteBuffer.get());
                                byteBuffer2.put(byteBuffer.get());
                                byteBuffer2.put(byteBuffer.get());
                                byteBuffer2.put((byte)-1);
                                byteBuffer.get();
                            }
                        }
                    } else {
                        for (n3 = 0; n3 < n2; ++n3) {
                            byteBuffer2.put(byteBuffer.get());
                            byteBuffer2.put(byteBuffer.get());
                            byteBuffer2.put(byteBuffer.get());
                            byteBuffer2.put((byte)-1);
                            byteBuffer.get();
                        }
                    }
                    byteBuffer2.position(0);
                    WritablePixelFormat writablePixelFormat = PixelFormat.getByteBgraPreInstance();
                    if (type == PixelFormat.Type.BYTE_BGRA) {
                        writablePixelFormat = PixelFormat.getByteBgraInstance();
                    }
                    pixelWriter.setPixels(0, 0, this.width, this.height, (PixelFormat)writablePixelFormat, (Buffer)byteBuffer2, this.width * 4);
                } else {
                    int n4;
                    IntBuffer intBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
                    if (this.depth == 24) {
                        if (this.yOrigin == 0) {
                            n4 = 0;
                            for (int i = this.height - 1; i >= 0; --i) {
                                n4 = i * this.width;
                                for (int j = 0; j < this.width; ++j) {
                                    intBuffer.put(n4++, 0xFF000000 | byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16);
                                }
                            }
                        } else {
                            for (n4 = 0; n4 < n2; ++n4) {
                                intBuffer.put(0xFF000000 | byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16);
                            }
                        }
                    } else if (this.yOrigin == 0) {
                        n4 = 0;
                        for (int i = this.height - 1; i >= 0; --i) {
                            n4 = i * this.width;
                            for (int j = 0; j < this.width; ++j) {
                                intBuffer.put(n4++, 0xFF000000 | byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16);
                                byteBuffer.get();
                            }
                        }
                    } else {
                        for (n4 = 0; n4 < n2; ++n4) {
                            intBuffer.put(0xFF000000 | byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16);
                            byteBuffer.get();
                        }
                    }
                    intBuffer.position(0);
                    WritablePixelFormat writablePixelFormat = PixelFormat.getIntArgbPreInstance();
                    if (type == PixelFormat.Type.INT_ARGB) {
                        writablePixelFormat = PixelFormat.getIntArgbInstance();
                    }
                    pixelWriter.setPixels(0, 0, this.width, this.height, (PixelFormat)writablePixelFormat, (Buffer)intBuffer, this.width);
                }
            } else if (this.depth == 32 && this.descNumAlphaBits == 8) {
                if (type == PixelFormat.Type.BYTE_BGRA || type == PixelFormat.Type.BYTE_BGRA_PRE) {
                    int n5;
                    ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder());
                    if (type == PixelFormat.Type.BYTE_BGRA) {
                        if (this.yOrigin == 0) {
                            n5 = 0;
                            for (int i = this.height - 1; i >= 0; --i) {
                                n5 = i * this.width;
                                byteBuffer3.position(n5 * 4);
                                for (int j = 0; j < this.width; ++j) {
                                    byteBuffer3.put(byteBuffer.get());
                                    byteBuffer3.put(byteBuffer.get());
                                    byteBuffer3.put(byteBuffer.get());
                                    byteBuffer3.put(byteBuffer.get());
                                }
                            }
                        } else {
                            for (n5 = 0; n5 < n2; ++n5) {
                                byteBuffer3.put(byteBuffer.get());
                                byteBuffer3.put(byteBuffer.get());
                                byteBuffer3.put(byteBuffer.get());
                                byteBuffer3.put(byteBuffer.get());
                            }
                        }
                    } else if (this.yOrigin == 0) {
                        int n6 = 0;
                        for (int i = this.height - 1; i >= 0; --i) {
                            n6 = i * this.width;
                            byteBuffer3.position(n6 * 4);
                            for (int j = 0; j < this.width; ++j) {
                                int n7 = byteBuffer.get() & 0xFF;
                                int n8 = byteBuffer.get() & 0xFF;
                                int n9 = byteBuffer.get() & 0xFF;
                                n5 = byteBuffer.get() & 0xFF;
                                if (n5 == 255) {
                                    byteBuffer3.put((byte)n7);
                                    byteBuffer3.put((byte)n8);
                                    byteBuffer3.put((byte)n9);
                                    byteBuffer3.put((byte)n5);
                                    continue;
                                }
                                if (n5 == 0) {
                                    byteBuffer3.put((byte)0);
                                    byteBuffer3.put((byte)0);
                                    byteBuffer3.put((byte)0);
                                    byteBuffer3.put((byte)0);
                                    continue;
                                }
                                byteBuffer3.put((byte)((n7 * n5 + 127) / 255));
                                byteBuffer3.put((byte)((n8 * n5 + 127) / 255));
                                byteBuffer3.put((byte)((n9 * n5 + 127) / 255));
                                byteBuffer3.put((byte)n5);
                            }
                        }
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            int n10 = byteBuffer.get() & 0xFF;
                            int n11 = byteBuffer.get() & 0xFF;
                            int n12 = byteBuffer.get() & 0xFF;
                            n5 = byteBuffer.get() & 0xFF;
                            if (n5 == 255) {
                                byteBuffer3.put((byte)n10);
                                byteBuffer3.put((byte)n11);
                                byteBuffer3.put((byte)n12);
                                byteBuffer3.put((byte)n5);
                                continue;
                            }
                            if (n5 == 0) {
                                byteBuffer3.put((byte)0);
                                byteBuffer3.put((byte)0);
                                byteBuffer3.put((byte)0);
                                byteBuffer3.put((byte)0);
                                continue;
                            }
                            byteBuffer3.put((byte)((n10 * n5 + 127) / 255));
                            byteBuffer3.put((byte)((n11 * n5 + 127) / 255));
                            byteBuffer3.put((byte)((n12 * n5 + 127) / 255));
                            byteBuffer3.put((byte)n5);
                        }
                    }
                    byteBuffer3.position(0);
                    WritablePixelFormat writablePixelFormat = PixelFormat.getByteBgraPreInstance();
                    if (type == PixelFormat.Type.BYTE_BGRA) {
                        writablePixelFormat = PixelFormat.getByteBgraInstance();
                    }
                    pixelWriter.setPixels(0, 0, this.width, this.height, (PixelFormat)writablePixelFormat, (Buffer)byteBuffer3, this.width * 4);
                } else {
                    int n13;
                    IntBuffer intBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
                    if (type == PixelFormat.Type.INT_ARGB) {
                        if (this.yOrigin == 0) {
                            n13 = 0;
                            for (int i = this.height - 1; i >= 0; --i) {
                                n13 = i * this.width;
                                for (int j = 0; j < this.width; ++j) {
                                    intBuffer.put(n13++, byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 24);
                                }
                            }
                        } else {
                            for (n13 = 0; n13 < n2; ++n13) {
                                intBuffer.put(byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 24);
                            }
                        }
                    } else if (this.yOrigin == 0) {
                        int n14 = 0;
                        for (int i = this.height - 1; i >= 0; --i) {
                            n14 = i * this.width;
                            for (int j = 0; j < this.width; ++j) {
                                int n15 = byteBuffer.get() & 0xFF;
                                int n16 = byteBuffer.get() & 0xFF;
                                int n17 = byteBuffer.get() & 0xFF;
                                n13 = byteBuffer.get() & 0xFF;
                                if (n13 == 255) {
                                    intBuffer.put(n14++, n15 & 0xFF | (n16 & 0xFF) << 8 | (n17 & 0xFF) << 16 | (n13 & 0xFF) << 24);
                                    continue;
                                }
                                if (n13 == 0) {
                                    intBuffer.put(n14++, 0);
                                    continue;
                                }
                                intBuffer.put(n14++, (n15 * n13 + 127) / 255 | (n16 * n13 + 127) / 255 << 8 | (n17 * n13 + 127) / 255 << 16 | (n13 & 0xFF) << 24);
                            }
                        }
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            int n18 = byteBuffer.get() & 0xFF;
                            int n19 = byteBuffer.get() & 0xFF;
                            int n20 = byteBuffer.get() & 0xFF;
                            n13 = byteBuffer.get() & 0xFF;
                            if (n13 == 255) {
                                intBuffer.put(n18 & 0xFF | (n19 & 0xFF) << 8 | (n20 & 0xFF) << 16 | (n13 & 0xFF) << 24);
                                continue;
                            }
                            if (n13 == 0) {
                                intBuffer.put(0);
                                continue;
                            }
                            intBuffer.put((n18 * n13 + 127) / 255 | (n19 * n13 + 127) / 255 << 8 | (n20 * n13 + 127) / 255 << 16 | (n13 & 0xFF) << 24);
                        }
                    }
                    intBuffer.position(0);
                    WritablePixelFormat writablePixelFormat = PixelFormat.getIntArgbPreInstance();
                    if (type == PixelFormat.Type.INT_ARGB) {
                        writablePixelFormat = PixelFormat.getIntArgbInstance();
                    }
                    pixelWriter.setPixels(0, 0, this.width, this.height, (PixelFormat)writablePixelFormat, (Buffer)intBuffer, this.width);
                }
            } else {
                System.out.println("TGA ByteBuffer not read  depth / descNumAlphaBits = " + this.depth + " / " + this.descNumAlphaBits);
                writableImage = null;
            }
        } else if (this.imageType == 0) {
            writableImage = null;
        } else {
            System.out.println("TGA ByteBuffer not read  imageType = " + this.imageType);
            writableImage = null;
        }
        this.clearHeader();
        return writableImage;
    }
}

