/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.tds;

import com.interactivemesh.jfx.image.ImageFactory;
import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.tds.TdsImportOption;
import com.interactivemesh.jfx.importer.tds.TdsModelImporterImpl;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;

final class MMaterial {
    private HashMap<String, PhongMaterial> appearMap = null;
    private HashMap<String, PhongMaterial> namedSGOs = null;
    private final ArrayList<String> doubleSidedMaterials;
    private final ArrayList<String> lineDrawModeMaterials;
    private final IdentityHashMap<Image, FilePath> imagePaths;
    private ImageFactory imgFactory = null;
    private TdsModelImporterImpl.BaseURL baseUrl = null;
    private boolean asWritableImage = false;
    private TdsModelImporterImpl importerImpl = null;

    MMaterial(TdsModelImporterImpl tdsModelImporterImpl) {
        this.importerImpl = tdsModelImporterImpl;
        this.imgFactory = new ImageFactory();
        this.doubleSidedMaterials = new ArrayList();
        this.lineDrawModeMaterials = new ArrayList();
        this.imagePaths = new IdentityHashMap();
    }

    void close() {
        this.imgFactory.close();
        this.imgFactory = null;
    }

    void clear() {
        this.namedSGOs = null;
        this.appearMap = null;
        this.doubleSidedMaterials.clear();
        this.lineDrawModeMaterials.clear();
        this.imagePaths.clear();
    }

    IdentityHashMap<Image, FilePath> getImagePaths() {
        return this.imagePaths;
    }

    void setMaps(HashMap<String, PhongMaterial> hashMap, HashMap<String, PhongMaterial> hashMap2) {
        this.namedSGOs = hashMap;
        this.appearMap = hashMap2;
    }

    void setBaseUrl(TdsModelImporterImpl.BaseURL baseURL) {
        this.baseUrl = baseURL;
    }

    void setOptions(EnumSet<TdsImportOption> enumSet) {
        this.asWritableImage = enumSet.contains((Object)TdsImportOption.MAP_WRITABLEIMAGE);
    }

    boolean isDoubleSidedMaterial(String string) {
        return this.doubleSidedMaterials.contains(string);
    }

    boolean isLineDrawMode(String string) {
        return this.lineDrawModeMaterials.contains(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    void createAppearance(ByteBuffer byteBuffer, int n) {
        PhongMaterial phongMaterial = new PhongMaterial();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        float f = -1.0f;
        boolean bl10 = false;
        while (byteBuffer.position() < n) {
            float f2;
            float f3;
            int n2;
            int n3 = byteBuffer.getShort() & 0xFFFF;
            int n4 = byteBuffer.getInt();
            String string2 = Integer.toHexString(n3 & 0xFFFF);
            int n5 = byteBuffer.position() + n4 - 6;
            if (string2.equalsIgnoreCase("a000")) {
                string = this.importerImpl.getString(byteBuffer);
            } else if (string2.equalsIgnoreCase("a010")) {
                Color color = this.getColor(byteBuffer);
            } else if (string2.equalsIgnoreCase("a020")) {
                Color color = this.getColor(byteBuffer);
                phongMaterial.setDiffuseColor(color);
            } else if (string2.equalsIgnoreCase("a030")) {
                Color color = this.getColor(byteBuffer);
                phongMaterial.setSpecularColor(color);
            } else if (string2.equalsIgnoreCase("a040")) {
                int n6 = byteBuffer.getShort() & 0xFFFF;
                n2 = byteBuffer.getInt();
                f3 = this.getPercentage(n6, byteBuffer);
                f2 = 32.0f;
                f2 = Math.max(1.0f, 128.0f * f3);
                phongMaterial.setSpecularPower((double)f2);
            } else if (string2.equalsIgnoreCase("a041")) {
                int n7 = byteBuffer.getShort() & 0xFFFF;
                n2 = byteBuffer.getInt();
                f3 = this.getPercentage(n7, byteBuffer);
            } else if (string2.equalsIgnoreCase("a050")) {
                int n8 = byteBuffer.getShort() & 0xFFFF;
                n2 = byteBuffer.getInt();
                f3 = this.getPercentage(n8, byteBuffer);
                f2 = f3;
                if (!(f2 > 1.0E-5f)) {
                    // empty if block
                }
            } else if (string2.equalsIgnoreCase("a052")) {
                int n9 = byteBuffer.getShort() & 0xFFFF;
                n2 = byteBuffer.getInt();
                f3 = this.getPercentage(n9, byteBuffer);
            } else if (string2.equalsIgnoreCase("a053")) {
                int n10 = byteBuffer.getShort() & 0xFFFF;
                n2 = byteBuffer.getInt();
                f3 = this.getPercentage(n10, byteBuffer);
            } else if (string2.equalsIgnoreCase("a100")) {
                int n11 = byteBuffer.getShort() & 0xFFFF;
            } else if (string2.equalsIgnoreCase("a084")) {
                int n12 = byteBuffer.getShort() & 0xFFFF;
                n2 = byteBuffer.getInt();
                f3 = this.getPercentage(n12, byteBuffer);
            } else if (string2.equalsIgnoreCase("a240")) {
                bl = true;
            } else if (string2.equalsIgnoreCase("a250")) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase("a081")) {
                bl3 = true;
            } else if (string2.equalsIgnoreCase("a083")) {
                bl4 = true;
            } else if (string2.equalsIgnoreCase("a085")) {
                bl5 = true;
            } else if (string2.equalsIgnoreCase("a088")) {
                bl6 = true;
            } else if (string2.equalsIgnoreCase("a08a")) {
                bl7 = true;
            } else if (string2.equalsIgnoreCase("a08c")) {
                bl8 = true;
            } else if (string2.equalsIgnoreCase("a08e")) {
                bl9 = true;
            } else if (string2.equalsIgnoreCase("a087")) {
                f = byteBuffer.getFloat();
            } else if (string2.equalsIgnoreCase("a200")) {
                bl10 = true;
                this.createTexture(byteBuffer, phongMaterial, "diffuse", n5);
            } else if (string2.equalsIgnoreCase("A204")) {
                this.createTexture(byteBuffer, phongMaterial, "specular", n5);
            } else if (!string2.equalsIgnoreCase("A210") && !string2.equalsIgnoreCase("A220")) {
                if (string2.equalsIgnoreCase("A230")) {
                    this.createTexture(byteBuffer, phongMaterial, "bump", n5);
                } else if (!string2.equalsIgnoreCase("A33A") && !string2.equalsIgnoreCase("A33C") && string2.equalsIgnoreCase("A33D")) {
                    this.createTexture(byteBuffer, phongMaterial, "selfillu", n5);
                }
            }
            byteBuffer.position(n5);
        }
        this.appearMap.put(string, phongMaterial);
        this.namedSGOs.put(string, phongMaterial);
        if (bl3) {
            this.doubleSidedMaterials.add(string);
        }
        if (bl5) {
            if (f > 1.0f) {
                // empty if block
            }
            this.lineDrawModeMaterials.add(string);
        }
    }

    private void createTexture(ByteBuffer byteBuffer, PhongMaterial phongMaterial, String string, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = -1.0f;
        while (byteBuffer.position() < n) {
            int n2 = byteBuffer.getShort() & 0xFFFF;
            int n3 = byteBuffer.getInt();
            String string2 = Integer.toHexString(n2 & 0xFFFF);
            int n4 = byteBuffer.position() + n3 - 6;
            if (string2.equalsIgnoreCase("30")) {
                f6 = this.getPercentage(n2, byteBuffer);
            } else if (string2.equalsIgnoreCase("31")) {
                f6 = this.getPercentage(n2, byteBuffer);
            } else if (string2.equalsIgnoreCase("a300")) {
                String string3 = this.importerImpl.getString(byteBuffer);
                if (string3 != null && string3.length() > 0) {
                    Image image = this.readImage(string3, this.baseUrl);
                    if (string.equalsIgnoreCase("diffuse")) {
                        phongMaterial.setDiffuseMap(image);
                    } else if (string.equalsIgnoreCase("specular")) {
                        phongMaterial.setSpecularMap(image);
                    } else if (string.equalsIgnoreCase("bump")) {
                        phongMaterial.setBumpMap(image);
                    } else if (string.equalsIgnoreCase("selfillu")) {
                        phongMaterial.setSelfIlluminationMap(image);
                    }
                } else {
                    System.out.println("Map: Loading failed for mapFileName >" + string3 + "<!");
                }
            } else if (!string2.equalsIgnoreCase("a351") && !string2.equalsIgnoreCase("a353")) {
                if (string2.equalsIgnoreCase("a354")) {
                    bl2 = true;
                    f = byteBuffer.getFloat();
                } else if (string2.equalsIgnoreCase("a356")) {
                    bl2 = true;
                    f2 = byteBuffer.getFloat();
                } else if (string2.equalsIgnoreCase("a358")) {
                    bl3 = true;
                    f3 = byteBuffer.getFloat();
                } else if (string2.equalsIgnoreCase("a35a")) {
                    bl3 = true;
                    f4 = byteBuffer.getFloat();
                } else if (string2.equalsIgnoreCase("a35c")) {
                    bl4 = true;
                    f5 = (float)Math.toRadians(byteBuffer.getFloat());
                }
            }
            byteBuffer.position(n4);
        }
        if (!bl || bl2 || bl3 || bl4) {
            // empty if block
        }
    }

    private Image readImage(String string, TdsModelImporterImpl.BaseURL baseURL) {
        URL uRL = null;
        uRL = this.importerImpl.getUrlForAbsolutPath(string = string.replace('\\', '/'));
        if (uRL == null) {
            uRL = this.importerImpl.getUrlForRelativePath(baseURL, string);
        }
        if (uRL == null) {
            throw new ImportException("Can't create URL for image path = \n" + string);
        }
        String string2 = uRL.toExternalForm();
        int n = string2.lastIndexOf(46) + 1;
        String string3 = string2.substring(n);
        WritableImage writableImage = null;
        try {
            if (string3.equalsIgnoreCase("tga")) {
                writableImage = this.imgFactory.readImage(string3, uRL);
            } else if (string3.equalsIgnoreCase("tif") || string3.equalsIgnoreCase("tiff")) {
                writableImage = this.imgFactory.readImage(string3, uRL);
            } else {
                if (this.asWritableImage) {
                    writableImage = this.imgFactory.readImage(string3, uRL);
                }
                if (writableImage == null) {
                    writableImage = new Image(string2);
                }
            }
        }
        catch (IOException iOException) {
            throw new ImportException("Can't create image for URL = \n" + uRL.toString(), iOException);
        }
        if (writableImage != null) {
            this.imagePaths.put((Image)writableImage, new FilePath(string, uRL));
            return writableImage;
        }
        throw new ImportException("Can't create image for URL = \n" + uRL.toString());
    }

    private Color getColor(ByteBuffer byteBuffer) {
        float[] fArray = new float[3];
        int n = byteBuffer.getShort() & 0xFFFF;
        int n2 = byteBuffer.getInt();
        if (n == 16) {
            fArray[0] = byteBuffer.getFloat();
            fArray[1] = byteBuffer.getFloat();
            fArray[2] = byteBuffer.getFloat();
        } else if (n == 17) {
            int n3 = byteBuffer.get() & 0xFF;
            int n4 = byteBuffer.get() & 0xFF;
            int n5 = byteBuffer.get() & 0xFF;
            fArray[0] = (float)n3 / 255.0f;
            fArray[1] = (float)n4 / 255.0f;
            fArray[2] = (float)n5 / 255.0f;
        } else {
            String string = Integer.toHexString(n);
            throw new ImportException("Color type not supported (hex) : " + string + " !");
        }
        return new Color((double)fArray[0], (double)fArray[1], (double)fArray[2], 1.0);
    }

    private float getPercentage(int n, ByteBuffer byteBuffer) {
        if (n == 48) {
            int n2 = byteBuffer.getShort() & 0xFFFF;
            return (float)n2 / 100.0f;
        }
        if (n == 49) {
            float f = byteBuffer.getFloat();
            return f / 100.0f;
        }
        String string = Integer.toHexString(n);
        throw new ImportException("Percentage type not supported (hex) : " + string + " !");
    }
}

