/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.Controller;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import com.interactivemesh.jfx.importer.col.Geometry;
import com.interactivemesh.jfx.importer.col.InstanceBindMaterial;
import com.interactivemesh.jfx.importer.col.InstanceMaterial;
import com.interactivemesh.jfx.importer.col.Material;
import com.interactivemesh.jfx.importer.col.Param;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

final class InstanceController
extends InstanceBindMaterial {
    ArrayList<String> skeletonList = new ArrayList(2);
    private ArrayList<Param> paramList = null;
    private final HashMap<String, InstanceMaterial> instMaterialMap = new HashMap(4);
    private int numShape3Ds = 0;
    private int shape3dCounter = 0;

    InstanceController(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
        if (this.name != null && this.name.length() > 0) {
            this.name = elementBase.createUniqueName(this.name);
        }
    }

    @Override
    void addParam(Param param) {
        if (this.paramList == null) {
            this.paramList = new ArrayList(4);
        }
        this.paramList.add(param);
    }

    @Override
    InstanceMaterial createInstMaterial(String string, String string2, String string3, String string4) {
        InstanceMaterial instanceMaterial = new InstanceMaterial(string, string2, string3, string4);
        this.instMaterialMap.put(string4, instanceMaterial);
        return instanceMaterial;
    }

    ArrayList<MeshView> getInstanceShape3Ds() {
        Controller controller = null;
        if (this.url == null || (controller = this.cache.getController(this.url)) == null) {
            System.out.println("InstanceController controller url = null or cached controller = null = " + this.url + " / " + controller);
            return null;
        }
        Controller.Morph morph = controller.getMorph();
        if (morph != null) {
            Geometry geometry = null;
            if (morph.source == null || (geometry = this.cache.getGeometry(morph.source)) == null) {
                System.out.println("InstanceController morph.source = null or cached geometry = null = " + morph.source + " / " + geometry);
                return null;
            }
            if (geometry.getGeomType() != Geometry.GeomType.MESH) {
                System.out.println("InstanceController morph.source isn't a mesh = " + morph.source + " / " + (Object)((Object)geometry.getGeomType()));
                return null;
            }
            return this.createShape3Ds(geometry);
        }
        Controller.Skin skin = controller.getSkin();
        if (skin != null) {
            Geometry geometry = null;
            if (skin.source == null || (geometry = this.cache.getGeometry(skin.source)) == null) {
                System.out.println("InstanceController skin.source = null or cached geometry = null = " + skin.source + " / " + geometry);
                return null;
            }
            if (geometry.getGeomType() != Geometry.GeomType.MESH) {
                System.out.println("InstanceController skin.source isn't a mesh = " + skin.source + " / " + (Object)((Object)geometry.getGeomType()));
                return null;
            }
            return this.createShape3Ds(geometry);
        }
        return null;
    }

    private ArrayList<MeshView> createShape3Ds(Geometry geometry) {
        HashMap<String, ArrayList<TriangleMesh>> hashMap;
        String string;
        Object object;
        Object object2;
        Object object3;
        HashMap<String, PhongMaterial> hashMap2 = new HashMap<String, PhongMaterial>(2);
        HashMap<String, int[]> hashMap3 = new HashMap<String, int[]>(2);
        if (this.instMaterialMap.size() > 0) {
            object3 = this.instMaterialMap.entrySet();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                string = (String)object.getKey();
                hashMap = (InstanceMaterial)object.getValue();
                if (((InstanceMaterial)((Object)hashMap)).url != null) {
                    String string2 = ((InstanceMaterial)((Object)hashMap)).url;
                    Material material = this.cache.getMaterial(string2);
                    PhongMaterial phongMaterial = null;
                    int[] nArray = null;
                    if (material == null) {
                        phongMaterial = new PhongMaterial();
                        this.base.putNamedMaterial("PhongMaterial_" + Material.nextMatNameExt(), phongMaterial);
                    } else {
                        phongMaterial = material.getAppearance();
                        String[] stringArray = material.getTexCoordSemantics();
                        int n = 0;
                        if (stringArray != null && (n = stringArray.length) > 0) {
                            nArray = new int[n];
                            for (int i = 0; i < n; ++i) {
                                nArray[i] = stringArray[i] != null ? ((InstanceMaterial)((Object)hashMap)).getTexCoordSet(stringArray[i]) : -1;
                            }
                        }
                    }
                    hashMap2.put(string, phongMaterial);
                    hashMap3.put(string, nArray);
                    continue;
                }
                System.out.println("InstanceGeometry mat binding : instMat.url == null for instMat / geomMatSymbol = " + hashMap + " / " + string);
            }
        }
        object3 = geometry.getGeomType();
        object2 = this.name;
        if (object2 == null || ((String)object2).length() < 1) {
            object2 = geometry.getGeomInstanceName();
        }
        object = new ArrayList(1);
        if (object3 == Geometry.GeomType.MESH) {
            boolean bl;
            string = Integer.toString(this.hashCode());
            hashMap = geometry.getQuadTriaGeometries(string, hashMap3);
            boolean bl2 = bl = hashMap != null && !hashMap.isEmpty();
            if (bl) {
                this.numShape3Ds += hashMap.size();
            }
            if (bl) {
                this.fillShape3Ds(hashMap2, hashMap, (String)object2, string, (ArrayList<MeshView>)object);
            }
        } else {
            if (object3 == Geometry.GeomType.CONVEXMESH) {
                return null;
            }
            if (object3 == Geometry.GeomType.SPLINE) {
                return null;
            }
        }
        return object;
    }

    private void fillShape3Ds(HashMap<String, PhongMaterial> hashMap, HashMap<String, ArrayList<TriangleMesh>> hashMap2, String string, String string2, ArrayList<MeshView> arrayList) {
        Set<String> set = hashMap2.keySet();
        for (String string3 : set) {
            ArrayList<TriangleMesh> arrayList2 = hashMap2.get(string3);
            if (arrayList2.isEmpty()) continue;
            if (string3.equals(string2)) {
                this.fillDefaultAppearance(arrayList2, string, arrayList);
                continue;
            }
            PhongMaterial phongMaterial = hashMap.get(string3);
            if (phongMaterial != null) {
                for (TriangleMesh triangleMesh : arrayList2) {
                    MeshView meshView = new MeshView((Mesh)triangleMesh);
                    meshView.setMaterial((javafx.scene.paint.Material)phongMaterial);
                    this.setShape3DName(meshView, string);
                    arrayList.add(meshView);
                }
                continue;
            }
            this.fillDefaultAppearance(arrayList2, string, arrayList);
        }
    }

    private void fillDefaultAppearance(ArrayList<TriangleMesh> arrayList, String string, ArrayList<MeshView> arrayList2) {
        for (TriangleMesh triangleMesh : arrayList) {
            PhongMaterial phongMaterial = new PhongMaterial();
            this.base.putNamedMaterial("PhongMaterial_" + Material.nextMatNameExt(), phongMaterial);
            MeshView meshView = new MeshView((Mesh)triangleMesh);
            meshView.setMaterial((javafx.scene.paint.Material)phongMaterial);
            this.setShape3DName(meshView, string);
            arrayList2.add(meshView);
        }
    }

    private void setShape3DName(MeshView meshView, String string) {
        String string2 = null;
        if (this.numShape3Ds == 1) {
            string2 = string;
        } else {
            string2 = string + "-" + Integer.toString(this.shape3dCounter);
            ++this.shape3dCounter;
        }
        meshView.setId(string2);
        this.base.putNamedNode(string2, (Node)meshView);
    }
}

