/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractIdElement;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.Effect;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import com.interactivemesh.jfx.importer.col.SetParam;
import com.interactivemesh.jfx.importer.col.TechniqueHint;
import java.util.ArrayList;
import javafx.scene.paint.PhongMaterial;

final class Material
extends AbstractIdElement {
    String name = null;
    Asset asset = null;
    String instEffectSID = null;
    String instEffectName = null;
    String instEffectUrl = null;
    final ArrayList<TechniqueHint> instEffectTechHintList = new ArrayList(2);
    final ArrayList<SetParam> instEffectSetParamList = new ArrayList(6);
    private Effect effect = null;
    private PhongMaterial appearance = null;
    private static int matNameExt = 0;
    private String materialName = null;

    Material() {
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
        if (this.id != null) {
            elementCache.putMaterial(this.id, this);
        }
        if (this.asset != null) {
            this.asset.initialize(elementBase, elementCache);
        }
    }

    @Override
    void clear() {
        this.instEffectTechHintList.clear();
        this.instEffectSetParamList.clear();
        super.clear();
    }

    static int nextMatNameExt() {
        return ++matNameExt;
    }

    String[] getTexCoordSemantics() {
        if (this.effect != null) {
            return this.effect.getTexCoordSemantics();
        }
        return null;
    }

    boolean isDoubleSided() {
        if (this.effect != null) {
            return this.effect.isDoubleSided();
        }
        return false;
    }

    PhongMaterial getAppearance() {
        if (this.appearance == null) {
            this.materialName = this.name;
            if (this.materialName == null || this.materialName.length() < 1) {
                this.materialName = this.id;
            }
            this.materialName = this.base.createUniqueName(this.materialName);
            if (this.instEffectUrl == null || this.instEffectUrl.length() < 1) {
                System.out.println("Material : no instEffectUrl for id = " + this.id);
            } else {
                this.effect = this.cache.getEffect(this.instEffectUrl);
                if (this.effect == null) {
                    System.out.println("Material : no effect found for id / url = " + this.id + " / " + this.instEffectUrl);
                } else {
                    this.appearance = this.effect.createAppearance(this.instEffectTechHintList, this.instEffectSetParamList);
                    if (this.appearance == null) {
                        System.out.println("Material effect returned null for id / url = " + this.id + " / " + this.instEffectUrl);
                    }
                }
            }
            if (this.appearance == null) {
                this.appearance = new PhongMaterial();
                System.out.println("Material : default PhongMaterial created for id = " + this.id);
            }
            if (this.materialName == null) {
                this.materialName = "Material_" + ++matNameExt;
            }
            this.base.putNamedMaterial(this.materialName, this.appearance);
        }
        return this.appearance;
    }
}

