/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.col.InputS;
import com.interactivemesh.jfx.importer.col.InputU;
import com.interactivemesh.jfx.importer.col.LibGeometriesParser;
import com.interactivemesh.jfx.importer.col.Mesh;
import com.interactivemesh.jfx.importer.col.Polygons;
import com.interactivemesh.jfx.importer.col.Polylist;
import com.interactivemesh.jfx.importer.col.Primitive;
import com.interactivemesh.jfx.importer.col.Source;
import com.interactivemesh.jfx.importer.col.Triangles;
import com.interactivemesh.jfx.importer.col.Trifans;
import com.interactivemesh.jfx.importer.col.Tristrips;
import com.interactivemesh.jfx.importer.col.Vertices;

final class MeshParser
extends AbstractElementParserChar {
    private LibGeometriesParser libGeomsParser = null;
    private Mesh mesh = null;
    private boolean isVertices = false;
    private boolean isPrimitive = false;
    private Vertices currVertices = null;
    private Primitive currPrimitive = null;

    MeshParser(LibGeometriesParser libGeometriesParser) {
        super(libGeometriesParser.cfp);
        this.libGeomsParser = libGeometriesParser;
        this.charArray = new char[900000];
    }

    void setup(Mesh mesh) {
        this.mesh = mesh;
        this.arrPos = 0;
        this.isCharacter = false;
    }

    @Override
    void doClose() {
        this.libGeomsParser = null;
        this.charArray = null;
    }

    private void getCommonPrimAttr(boolean bl) {
        this.isPrimitive = true;
        String string = this.cfp.xR.getAttributeValue(null, "count");
        if (string != null) {
            this.currPrimitive.count = Integer.parseInt(string);
        }
        this.currPrimitive.name = this.cfp.xR.getAttributeValue(null, "name");
        this.currPrimitive.material = this.cfp.xR.getAttributeValue(null, "material");
        if (!bl) {
            this.mesh.primTriaQuadList.add(this.currPrimitive);
        }
    }

    @Override
    void startElement(String string) {
        if (this.isVertices) {
            if (string.equals("input")) {
                InputU inputU = new InputU();
                inputU.semantic = this.cfp.xR.getAttributeValue(null, "semantic");
                inputU.source = this.cfp.xR.getAttributeValue(null, "source");
                this.currVertices.inputList.add(inputU);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (this.isPrimitive) {
            if (string.equals("input")) {
                InputS inputS = new InputS();
                inputS.semantic = this.cfp.xR.getAttributeValue(null, "semantic");
                inputS.source = this.cfp.xR.getAttributeValue(null, "source");
                String string2 = this.cfp.xR.getAttributeValue(null, "offset");
                if (string2 != null) {
                    inputS.offset = Integer.parseInt(string2);
                }
                if ((string2 = this.cfp.xR.getAttributeValue(null, "")) != null) {
                    inputS.set = Integer.parseInt(string2);
                }
                this.currPrimitive.inputList.add(inputS);
                this.currPrimitive.vertexOffset = Math.max(this.currPrimitive.vertexOffset, inputS.offset + 1);
            } else if (string.equals("p")) {
                this.arrPos = 0;
                this.isCharacter = true;
            } else if (string.equals("vcount")) {
                this.arrPos = 0;
                this.isCharacter = true;
            } else if (string.equals("ph")) {
                this.cfp.setNullParser(this, string);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (string.equals("source")) {
            Source source = new Source();
            source.id = this.cfp.xR.getAttributeValue(null, "id");
            source.name = this.cfp.xR.getAttributeValue(null, "name");
            this.mesh.sourceVerticesElements.add(source);
            this.cfp.setSourceParser(this, source);
        } else if (string.equals("triangles")) {
            this.currPrimitive = new Triangles();
            this.getCommonPrimAttr(false);
        } else if (string.equals("tristrips")) {
            this.currPrimitive = new Tristrips();
            this.getCommonPrimAttr(false);
            ((Tristrips)this.currPrimitive).stripCounts = new int[this.currPrimitive.count];
        } else if (string.equals("polygons")) {
            this.currPrimitive = new Polygons();
            this.getCommonPrimAttr(false);
            ((Polygons)this.currPrimitive).vCounts = new int[this.currPrimitive.count];
        } else if (string.equals("polylist")) {
            this.currPrimitive = new Polylist();
            this.getCommonPrimAttr(false);
        } else if (string.equals("lines")) {
            this.cfp.setNullParser(this, string);
        } else if (string.equals("linestrips")) {
            this.cfp.setNullParser(this, string);
        } else if (string.equals("trifans")) {
            this.currPrimitive = new Trifans();
            this.getCommonPrimAttr(false);
            ((Trifans)this.currPrimitive).stripCounts = new int[this.currPrimitive.count];
        } else if (string.equals("vertices")) {
            this.isVertices = true;
            this.currVertices = new Vertices();
            this.currVertices.id = this.cfp.xR.getAttributeValue(null, "id");
            this.currVertices.name = this.cfp.xR.getAttributeValue(null, "name");
            this.mesh.sourceVerticesElements.add(this.currVertices);
        } else if (string.equals("extra")) {
            this.cfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (this.isVertices && string.equals("vertices")) {
            this.isVertices = false;
            this.currVertices = null;
        } else if (this.isPrimitive) {
            if (this.isCharacter) {
                this.isCharacter = false;
                if (string.equals("p")) {
                    this.currPrimitive.fillIndices(this.charArray, this.arrPos, this.cUtils());
                } else if (string.equals("vcount")) {
                    ((Polylist)this.currPrimitive).fillVcount(this.charArray, this.arrPos, this.cUtils());
                }
            } else {
                if (string.equals("triangles")) {
                    this.isPrimitive = false;
                } else if (string.equals("tristrips")) {
                    this.isPrimitive = false;
                } else if (string.equals("polygons")) {
                    this.isPrimitive = false;
                } else if (string.equals("polylist")) {
                    this.isPrimitive = false;
                } else if (string.equals("trifans")) {
                    this.isPrimitive = false;
                }
                if (!this.isPrimitive) {
                    this.currPrimitive = null;
                }
            }
        } else if (string.equals("mesh")) {
            this.isVertices = false;
            this.isPrimitive = false;
            this.currVertices = null;
            this.currPrimitive = null;
            this.mesh = null;
            this.cfp.setParser(this.libGeomsParser);
        }
    }
}

