/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.CVersion;
import com.interactivemesh.jfx.importer.col.InstanceCamera;
import com.interactivemesh.jfx.importer.col.InstanceController;
import com.interactivemesh.jfx.importer.col.InstanceGeometry;
import com.interactivemesh.jfx.importer.col.InstanceLight;
import com.interactivemesh.jfx.importer.col.InstanceNode;
import com.interactivemesh.jfx.importer.col.NodeC;
import com.interactivemesh.jfx.importer.col.TransformC;
import java.util.IdentityHashMap;

final class NodeCParser
extends AbstractElementParserChar {
    private AbstractElementParser parentParser = null;
    private boolean isInLibNodes = false;
    private NodeC currNode = null;
    private boolean isInstContrl = false;
    private InstanceController currInstContrl = null;
    private boolean isSkeleton = false;
    private boolean isInstGeometry = false;
    private InstanceGeometry currInstGeom = null;
    private boolean isTransform = false;
    private TransformC currTransform = null;
    private final IdentityHashMap<NodeC, NodeC> nodeParentMap = new IdentityHashMap();

    NodeCParser(AbstractElementParser abstractElementParser, boolean bl) {
        super(abstractElementParser.cfp);
        this.parentParser = abstractElementParser;
        this.isInLibNodes = bl;
        this.charArray = new char[200];
    }

    void setupForTopNode(NodeC nodeC) {
        this.currNode = nodeC;
        this.nodeParentMap.clear();
        this.nodeParentMap.put(nodeC, null);
        this.arrPos = 0;
        this.isCharacter = false;
    }

    void setupForChildNode(NodeC nodeC) {
        this.nodeParentMap.put(nodeC, this.currNode);
        this.currNode = nodeC;
        this.isCharacter = false;
    }

    @Override
    void doClose() {
        this.parentParser = null;
        this.charArray = null;
    }

    @Override
    void startElement(String string) {
        if (this.isInstContrl) {
            if (string.equals("skeleton")) {
                this.isSkeleton = true;
                this.arrPos = 0;
                this.isCharacter = true;
            } else if (string.equals("bind_material")) {
                this.cfp.setBindMaterialParser(this, this.currInstContrl);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (this.isInstGeometry) {
            if (string.equals("bind_material")) {
                this.cfp.setBindMaterialParser(this, this.currInstGeom);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else {
            if (string.equals("node")) {
                NodeC nodeC = new NodeC(false, this.isInLibNodes);
                nodeC.id = this.cfp.xR.getAttributeValue(null, "id");
                nodeC.name = this.cfp.xR.getAttributeValue(null, "name");
                nodeC.sid = this.cfp.xR.getAttributeValue(null, "sid");
                String string2 = this.cfp.xR.getAttributeValue(null, "type");
                if (string2 != null) {
                    nodeC.type = string2;
                }
                if ((string2 = this.cfp.xR.getAttributeValue(null, "layer")) != null) {
                    nodeC.layerList = this.cUtils().splitString(string2);
                }
                this.currNode.addNode(nodeC);
                this.setupForChildNode(nodeC);
            } else if (string.equals("instance_camera")) {
                this.currNode.addCamera(new InstanceCamera(this.cfp.xR.getAttributeValue(null, "sid"), this.cfp.xR.getAttributeValue(null, "name"), this.cfp.xR.getAttributeValue(null, "url")), this.cfp.base.isIgnoreCameras);
            } else if (string.equals("instance_controller")) {
                this.currInstContrl = new InstanceController(this.cfp.xR.getAttributeValue(null, "sid"), this.cfp.xR.getAttributeValue(null, "name"), this.cfp.xR.getAttributeValue(null, "url"));
                this.currNode.addController(this.currInstContrl);
                this.isInstContrl = true;
            } else if (string.equals("instance_geometry")) {
                this.currInstGeom = new InstanceGeometry(this.cfp.xR.getAttributeValue(null, "sid"), this.cfp.xR.getAttributeValue(null, "name"), this.cfp.xR.getAttributeValue(null, "url"));
                this.currNode.addGeometry(this.currInstGeom);
                this.isInstGeometry = true;
            } else if (string.equals("instance_light")) {
                if (this.cfp.scope.isLight) {
                    this.currNode.addLight(new InstanceLight(this.cfp.xR.getAttributeValue(null, "sid"), this.cfp.xR.getAttributeValue(null, "name"), this.cfp.xR.getAttributeValue(null, "url")));
                } else {
                    this.cfp.setNullParser(this, string);
                }
            } else if (string.equals("instance_node")) {
                if (this.cfp.currFileVersion == CVersion.ONE_FOUR_ONE) {
                    this.currNode.addInstNode(new InstanceNode(this.cfp.xR.getAttributeValue(null, "sid"), this.cfp.xR.getAttributeValue(null, "name"), this.cfp.xR.getAttributeValue(null, "url"), null));
                } else if (this.cfp.currFileVersion == CVersion.ONE_FIVE_ZERO) {
                    this.currNode.addInstNode(new InstanceNode(this.cfp.xR.getAttributeValue(null, "sid"), this.cfp.xR.getAttributeValue(null, "name"), this.cfp.xR.getAttributeValue(null, "url"), this.cfp.xR.getAttributeValue(null, "proxy")));
                }
            } else if (string.equals("lookat")) {
                this.isTransform = true;
                this.currTransform = new TransformC(TransformC.Type.LOOKAT, this.cfp.xR.getAttributeValue(null, "sid"));
            } else if (string.equals("matrix")) {
                this.isTransform = true;
                this.currTransform = new TransformC(TransformC.Type.MATRIX, this.cfp.xR.getAttributeValue(null, "sid"));
            } else if (string.equals("rotate")) {
                this.isTransform = true;
                this.currTransform = new TransformC(TransformC.Type.ROTATE, this.cfp.xR.getAttributeValue(null, "sid"));
            } else if (string.equals("scale")) {
                this.isTransform = true;
                this.currTransform = new TransformC(TransformC.Type.SCALE, this.cfp.xR.getAttributeValue(null, "sid"));
            } else if (string.equals("skew")) {
                this.isTransform = true;
                this.currTransform = new TransformC(TransformC.Type.SKEW, this.cfp.xR.getAttributeValue(null, "sid"));
            } else if (string.equals("translate")) {
                this.isTransform = true;
                this.currTransform = new TransformC(TransformC.Type.TRANSLATE, this.cfp.xR.getAttributeValue(null, "sid"));
            } else if (string.equals("asset")) {
                Asset asset;
                this.currNode.asset = asset = new Asset();
                this.cfp.setAssetParser(this, asset);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
            if (this.isTransform) {
                this.arrPos = 0;
                this.isCharacter = true;
                this.currNode.addTransform(this.currTransform);
            }
        }
    }

    @Override
    void endElement(String string) {
        if (this.isTransform) {
            String string2 = this.cUtils().trimString(this.charArray, this.arrPos);
            float[] fArray = new float[this.currTransform.valueLength()];
            this.cUtils().splitFloatInto(string2, fArray);
            this.currTransform.setValues(fArray);
            this.isTransform = false;
            this.currTransform = null;
            this.isCharacter = false;
        } else if (this.isSkeleton) {
            this.currInstContrl.skeletonList.add(this.cUtils().trimString(this.charArray, this.arrPos));
            this.isSkeleton = false;
            this.isCharacter = false;
        } else if (string.equals("instance_geometry")) {
            this.currInstGeom = null;
            this.isInstGeometry = false;
        } else if (string.equals("instance_controller")) {
            this.currInstContrl = null;
            this.isInstContrl = false;
        } else if (string.equals("node")) {
            NodeC nodeC = this.nodeParentMap.remove(this.currNode);
            if (nodeC != null) {
                this.currNode = nodeC;
            } else {
                this.cfp.setParser(this.parentParser);
                this.currNode = null;
            }
        }
    }
}

