/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractIdElement;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import com.interactivemesh.jfx.importer.col.Param;
import com.interactivemesh.jfx.importer.col.ValueArray;
import java.util.ArrayList;

final class Source
extends AbstractIdElement {
    String name = null;
    Asset asset = null;
    ValueArray valueArray = null;
    String accessorSource = null;
    int accessorCount = 0;
    int accessorOffset = 0;
    int accessorStride = 1;
    final ArrayList<Param> accessorParamList = new ArrayList();
    int numReferences = 0;

    Source() {
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
        if (this.id != null) {
            elementCache.putSource(this.id, this);
        }
        if (this.valueArray != null) {
            this.valueArray.initialize(elementBase, elementCache);
        }
        if (this.asset != null) {
            this.asset.initialize(elementBase, elementCache);
        }
    }

    @Override
    void clear() {
        this.valueArray = null;
        this.accessorParamList.clear();
        super.clear();
    }

    boolean isAccessor() {
        return this.accessorSource != null;
    }

    private ValueArray getValueArray() {
        if (this.accessorSource != null) {
            return this.cache.getValueArray(this.accessorSource);
        }
        return this.valueArray;
    }

    boolean[] getBoolArray() {
        if (this.accessorSource != null) {
            ValueArray valueArray = this.cache.getValueArray(this.accessorSource);
            boolean[] blArray = valueArray.getBoolArray();
            int n = this.accessorCount * this.accessorStride;
            if (this.accessorOffset > 0 || n != blArray.length) {
                boolean[] blArray2 = new boolean[n];
                System.arraycopy(blArray, this.accessorOffset, blArray2, 0, n);
                return blArray2;
            }
            return blArray;
        }
        if (this.valueArray != null) {
            return this.valueArray.getBoolArray();
        }
        System.out.println("Source Type.BOOL : accessorSource is null && valueArray is null !");
        return null;
    }

    float[] getFloatArray() {
        if (this.accessorSource != null) {
            ValueArray valueArray = this.cache.getValueArray(this.accessorSource);
            float[] fArray = valueArray.getFloatArray();
            int n = this.accessorCount * this.accessorStride;
            if (this.accessorOffset > 0 || n != fArray.length) {
                if (this.accessorOffset + n > fArray.length) {
                    System.out.println("Source Type.FLOAT inconsistent lengths ! id = " + this.id + "\n  accessorOffset=" + this.accessorOffset + " + accessorLength=" + n + " > arrayF.length=" + fArray.length);
                    return null;
                }
                float[] fArray2 = new float[n];
                System.arraycopy(fArray, this.accessorOffset, fArray2, 0, n);
                return fArray2;
            }
            return fArray;
        }
        if (this.valueArray != null) {
            return this.valueArray.getFloatArray();
        }
        System.out.println("Source Type.FLOAT : accessorSource is null && valueArray is null !");
        return null;
    }

    int[] getIntArray() {
        if (this.accessorSource != null) {
            ValueArray valueArray = this.cache.getValueArray(this.accessorSource);
            int[] nArray = valueArray.getIntArray();
            int n = this.accessorCount * this.accessorStride;
            if (this.accessorOffset > 0 || n != nArray.length) {
                int[] nArray2 = new int[n];
                System.arraycopy(nArray, this.accessorOffset, nArray2, 0, n);
                return nArray2;
            }
            return nArray;
        }
        if (this.valueArray != null) {
            return this.valueArray.getIntArray();
        }
        System.out.println("Source Type.INT : accessorSource is null && valueArray is null !");
        return null;
    }

    String[] getNameArray() {
        if (this.accessorSource != null) {
            ValueArray valueArray = this.cache.getValueArray(this.accessorSource);
            String[] stringArray = valueArray.getNameArray();
            int n = this.accessorCount * this.accessorStride;
            if (this.accessorOffset > 0 || n != stringArray.length) {
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, this.accessorOffset, stringArray2, 0, n);
                return stringArray2;
            }
            return stringArray;
        }
        if (this.valueArray != null) {
            return this.valueArray.getNameArray();
        }
        System.out.println("Source Type.NAME : accessorSource is null && valueArray is null !");
        return null;
    }

    String[] getIdRefArray() {
        if (this.accessorSource != null) {
            ValueArray valueArray = this.cache.getValueArray(this.accessorSource);
            String[] stringArray = valueArray.getIdRefArray();
            int n = this.accessorCount * this.accessorStride;
            if (this.accessorOffset > 0 || n != stringArray.length) {
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, this.accessorOffset, stringArray2, 0, n);
                return stringArray2;
            }
            return stringArray;
        }
        if (this.valueArray != null) {
            return this.valueArray.getIdRefArray();
        }
        System.out.println("Source Type.ID_REF : accessorSource is null && valueArray is null !");
        return null;
    }
}

