/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.x3d.AbstractSceneElement;
import com.interactivemesh.jfx.importer.x3d.ElementBase;
import com.interactivemesh.jfx.importer.x3d.ElementCache;
import com.interactivemesh.jfx.importer.x3d.ImageTextureNode;
import com.interactivemesh.jfx.importer.x3d.MaterialNode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;

final class AppearanceNode
extends AbstractSceneElement {
    MaterialNode materialNode = null;
    ImageTextureNode imgTexNode = null;
    private Material sharedMaterial = null;

    AppearanceNode(ElementBase elementBase, ElementCache elementCache) {
        super(elementBase, elementCache);
    }

    @Override
    void setDEF(String string) {
        if (string != null) {
            this.def = string;
            this.cache.putAppearanceNode(string, this);
        }
    }

    @Override
    void initialize() {
        if (this.materialNode != null) {
            this.materialNode.initialize();
        }
        if (this.imgTexNode != null) {
            this.imgTexNode.initialize();
        }
    }

    @Override
    void clear() {
        this.sharedMaterial = null;
        super.clear();
    }

    boolean hasImageTexture() {
        return this.imgTexNode != null;
    }

    Material getMaterial() {
        if (this.sharedMaterial != null && this.use != null) {
            return this.sharedMaterial;
        }
        PhongMaterial phongMaterial = new PhongMaterial();
        if (this.materialNode != null) {
            phongMaterial.setSpecularColor(this.materialNode.specularColor);
            Color color = this.materialNode.diffuseColor;
            Color color2 = this.materialNode.emissiveColor;
            Color color3 = Color.color((double)Math.min(1.0, color.getRed() + color2.getRed()), (double)Math.min(1.0, color.getGreen() + color2.getGreen()), (double)Math.min(1.0, color.getBlue() + color2.getBlue()));
            phongMaterial.setDiffuseColor(color3);
            float f = Math.max(1.0f, this.materialNode.shininess * 128.0f);
            phongMaterial.setSpecularPower((double)f);
        } else {
            phongMaterial.setDiffuseColor(Color.color((double)0.8, (double)0.8, (double)0.8));
        }
        if (this.imgTexNode != null) {
            phongMaterial.setDiffuseMap(this.imgTexNode.getImage());
        }
        if (this.use != null) {
            this.sharedMaterial = phongMaterial;
        }
        this.base.putNamedMaterial(this.def, phongMaterial);
        return phongMaterial;
    }
}

