/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.ModelImporter;
import com.interactivemesh.jfx.importer.Viewpoint;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.BaseURL;
import com.interactivemesh.jfx.importer.col.COLLADA;
import com.interactivemesh.jfx.importer.col.CUtils;
import com.interactivemesh.jfx.importer.col.CVersion;
import com.interactivemesh.jfx.importer.col.ColAsset;
import com.interactivemesh.jfx.importer.col.ColImportOption;
import com.interactivemesh.jfx.importer.col.ColladaFileParser;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import com.interactivemesh.jfx.importer.col.Geometry;
import com.interactivemesh.jfx.importer.col.LibGeometries;
import com.interactivemesh.jfx.importer.col.LibMaterials;
import com.interactivemesh.jfx.importer.col.Material;
import com.interactivemesh.jfx.importer.col.Scene;
import com.interactivemesh.jfx.importer.col.Scope;
import com.interactivemesh.jfx.importer.col.ZaeCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

final class CImporterImpl {
    private final CVersion cVersion;
    private URL baseUrlU = null;
    private String basePathU = null;
    private boolean isUserBase = false;
    private BaseURL baseUrlUser = null;
    private double creaseAngle = Math.toRadians(45.0);
    private final EnumSet<ColImportOption> c14Opts = EnumSet.of(ColImportOption.NONE);
    private boolean isClosed = false;
    private final ColladaFileParser colFileParser;
    private final ElementBase base;
    private final Scope scope;
    private final CUtils cUtils;
    private final HashMap<URL, ElementCache> referencedCachesMap;
    private final ModelImporter importer;
    private final String CxxImporter;
    private ColAsset cAsset = null;
    private ArrayList<Node> sceneNodeReturnList = null;
    private ArrayList<MeshView> shape3DReturnList = null;
    private ArrayList<PhongMaterial> appearReturnList = null;
    private ArrayList<TriangleMesh> geomReturnList = null;
    private ArrayList<FilePath> daeFileReturnList = null;

    CImporterImpl(ModelImporter modelImporter, Scope scope, CVersion cVersion) {
        this.importer = modelImporter;
        this.scope = scope;
        this.cVersion = cVersion;
        this.CxxImporter = "ColModelImporter";
        this.cUtils = new CUtils();
        this.base = new ElementBase(this.cUtils);
        this.colFileParser = new ColladaFileParser(this.base, scope, cVersion);
        this.referencedCachesMap = new HashMap();
    }

    ColAsset getAsset() {
        return this.cAsset;
    }

    double getCreaseAngle() {
        return Math.toDegrees(this.creaseAngle);
    }

    void setCreaseAngle(double d) {
        double d2 = Math.toRadians(d);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > Math.PI) {
            d2 = 3.1415927410125732;
        }
        this.creaseAngle = d2;
    }

    String getResourcePath() {
        return this.basePathU;
    }

    void setResourcePath(String string) {
        this.baseUrlU = null;
        this.basePathU = string;
        boolean bl = this.isUserBase = string != null && string.length() > 0;
        if (this.isUserBase) {
            URL uRL;
            string.trim();
            string = string.replace('\\', '/');
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if ((uRL = this.cUtils.getUrlForAbsolutPath(string)) == null) {
                throw new ImportException(this.CxxImporter + " setResourcePath : Can't create absolute URL from = " + string);
            }
            this.baseUrlUser = new BaseURL();
            this.baseUrlUser.protocol = uRL.getProtocol();
            this.baseUrlUser.host = uRL.getHost();
            this.baseUrlUser.port = uRL.getPort();
            this.baseUrlUser.path = uRL.getPath();
        } else {
            this.baseUrlUser = null;
        }
    }

    URL getResourceUrl() {
        return this.baseUrlU;
    }

    void setResourceUrl(URL uRL) {
        this.basePathU = null;
        this.baseUrlU = uRL;
        boolean bl = this.isUserBase = uRL != null;
        if (this.isUserBase) {
            this.baseUrlUser = new BaseURL();
            this.baseUrlUser.protocol = uRL.getProtocol();
            this.baseUrlUser.host = uRL.getHost();
            this.baseUrlUser.port = uRL.getPort();
            this.baseUrlUser.path = uRL.getPath();
            if (!this.baseUrlUser.path.endsWith("/")) {
                this.baseUrlUser.path = this.baseUrlUser.path + "/";
            }
        } else {
            this.baseUrlUser = null;
        }
    }

    EnumSet<ColImportOption> getOptions() {
        return this.c14Opts.clone();
    }

    void setOptions(ColImportOption ... colImportOptionArray) {
        if (colImportOptionArray == null || colImportOptionArray.length < 1) {
            throw new IllegalArgumentException("options is null || options' length < 1");
        }
        if (colImportOptionArray.length > 1) {
            for (ColImportOption colImportOption : colImportOptionArray) {
                if (colImportOption != ColImportOption.NONE) continue;
                throw new IllegalArgumentException("options include C14ImportOption.NONE");
            }
        }
        this.c14Opts.clear();
        for (ColImportOption colImportOption : colImportOptionArray) {
            this.c14Opts.add(colImportOption);
        }
    }

    void setOptions(EnumSet<ColImportOption> enumSet) {
        if (enumSet == null || enumSet.isEmpty()) {
            throw new IllegalArgumentException("options is null || options is empty");
        }
        if (enumSet.size() > 1) {
            for (ColImportOption colImportOption : enumSet) {
                if (colImportOption != ColImportOption.NONE) continue;
                throw new IllegalArgumentException("options include C14ImportOption.NONE");
            }
        }
        this.c14Opts.clear();
        this.c14Opts.addAll(enumSet);
    }

    private BaseURL createBaseURL(URL uRL) {
        BaseURL baseURL = new BaseURL();
        baseURL.protocol = uRL.getProtocol();
        baseURL.host = uRL.getHost();
        baseURL.port = uRL.getPort();
        baseURL.path = uRL.getPath();
        int n = baseURL.path.lastIndexOf(47);
        baseURL.path = n >= 0 ? baseURL.path.substring(0, n + 1) : Character.toString('/');
        return baseURL;
    }

    void read(File file) throws ImportException {
        this.checkIsClosed();
        if (file == null) {
            throw new ImportException(this.CxxImporter + " read(File file) : file is null !");
        }
        if (!file.exists()) {
            throw new ImportException(this.CxxImporter + " read(File file) : file doesn't exist !");
        }
        if (file.isDirectory()) {
            throw new ImportException(this.CxxImporter + " read(File file) : file is directory !");
        }
        if (!file.canRead()) {
            throw new ImportException(this.CxxImporter + " read(File file) : file can't be read !");
        }
        URL uRL = null;
        try {
            uRL = file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException(this.CxxImporter + " read(File file)", malformedURLException);
        }
        BaseURL baseURL = this.createBaseURL(uRL);
        String string = file.getName();
        if (string.endsWith(".zae") || string.endsWith(".ZAE")) {
            this.importZae(string.startsWith("jar:"), uRL, baseURL);
        } else {
            try {
                this.importFile(new FileInputStream(file), uRL, baseURL, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ImportException(this.CxxImporter + " read(File file)", fileNotFoundException);
            }
        }
    }

    void read(String string) throws ImportException {
        Object object;
        this.checkIsClosed();
        if (string == null || string.length() < 1) {
            throw new ImportException(this.CxxImporter + " read(String fileName) : fileName is null !");
        }
        string = string.replace('\\', '/');
        URL uRL = null;
        try {
            uRL = this.cUtils.getUrlForAbsolutPath(string);
            if (uRL == null && ((String)(object = System.getProperty("user.dir"))).length() > 0) {
                if (((String)(object = ((String)object).replace('\\', '/'))).charAt(0) != '/') {
                    object = '/' + (String)object;
                }
                if (((String)object).charAt(((String)object).length() - 1) != '/') {
                    object = (String)object + '/';
                }
                uRL = new URL("file", null, this.cUtils.normalizePath((String)object, string));
            }
        }
        catch (SecurityException securityException) {
            throw new ImportException(this.CxxImporter + " read(String fileName)", securityException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException(this.CxxImporter + " read(String fileName)", malformedURLException);
        }
        if (uRL == null) {
            throw new ImportException(this.CxxImporter + " read(String fileName) : Can' create URL f0r = \n" + string);
        }
        object = this.createBaseURL(uRL);
        if (string.endsWith(".zae") || string.endsWith(".ZAE")) {
            this.importZae(string.startsWith("jar:"), uRL, (BaseURL)object);
        } else {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                this.importFile(uRLConnection.getInputStream(), uRL, (BaseURL)object, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ImportException(this.CxxImporter + " read(String fileName)", fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ImportException(this.CxxImporter + " read(String fileName)", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new ImportException(this.CxxImporter + " read(String fileName)", iOException);
            }
        }
    }

    void read(URL uRL) throws ImportException {
        this.checkIsClosed();
        if (uRL == null) {
            throw new ImportException(this.CxxImporter + " read(URL url) : url is null !");
        }
        BaseURL baseURL = this.createBaseURL(uRL);
        String string = uRL.toExternalForm();
        if (string.endsWith(".zae") || string.endsWith(".ZAE")) {
            this.importZae(string.startsWith("jar:"), uRL, baseURL);
        } else {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                this.importFile(uRLConnection.getInputStream(), uRL, baseURL, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ImportException(this.CxxImporter + " read(URL url)", fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ImportException(this.CxxImporter + " read(URL url)", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new ImportException(this.CxxImporter + " read(URL url)", iOException);
            }
        }
    }

    private void importZae(boolean bl, URL uRL, BaseURL baseURL) {
        block21: {
            try {
                Object object;
                ZipEntry zipEntry;
                String string = null;
                boolean bl2 = false;
                if (bl) {
                    Closeable closeable;
                    Object object2;
                    ZaeCache zaeCache = new ZaeCache(true);
                    HashMap<String, byte[]> hashMap = zaeCache.getZaeEntryArrayMap();
                    URLConnection uRLConnection = uRL.openConnection();
                    InputStream inputStream = uRLConnection.getInputStream();
                    ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                    ZipEntry zipEntry2 = zipInputStream.getNextEntry();
                    while (zipEntry2 != null) {
                        object2 = zipEntry2.getName();
                        if (((String)object2).indexOf("manifest") >= 0 || ((String)object2).indexOf("MANIFEST") >= 0) {
                            bl2 = true;
                            string = zaeCache.getZaeRoot(zipInputStream);
                        } else {
                            closeable = new ByteArrayOutputStream();
                            byte[] byArray = new byte[65536];
                            int n = 0;
                            while ((n = zipInputStream.read(byArray)) > 0) {
                                ((ByteArrayOutputStream)closeable).write(byArray, 0, n);
                            }
                            byte[] byArray2 = ((ByteArrayOutputStream)closeable).toByteArray();
                            hashMap.put((String)object2, byArray2);
                        }
                        zipEntry2 = zipInputStream.getNextEntry();
                    }
                    zipInputStream.close();
                    zaeCache.closeZaeRootReader();
                    if (string != null) {
                        zaeCache.setRoot(string);
                        object2 = hashMap.get(string);
                        closeable = new ByteArrayInputStream((byte[])object2);
                        this.importFile((InputStream)closeable, uRL, baseURL, zaeCache);
                        break block21;
                    }
                    if (!bl2) {
                        throw new ImportException(this.CxxImporter + " read(URL url) - zae as jar-entry - no manifest.xml found !");
                    }
                    throw new ImportException(this.CxxImporter + " read(URL url) - zae as jar-entry - can't determine 'dae_root' !");
                }
                ZaeCache zaeCache = new ZaeCache(false);
                HashMap<String, ZipEntry> hashMap = zaeCache.getZaeEntryMap();
                URI uRI = uRL.toURI();
                ZipFile zipFile = new ZipFile(new File(uRI));
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                if (enumeration == null) {
                    throw new ImportException(this.CxxImporter + " read(URL url) : zipFile.entries() is null !");
                }
                if (!enumeration.hasMoreElements()) {
                    throw new ImportException(this.CxxImporter + " read(URL url) : zipFile.entries() has no elements !");
                }
                zaeCache.setZaeFile(zipFile);
                while (enumeration.hasMoreElements()) {
                    zipEntry = enumeration.nextElement();
                    object = zipEntry.getName();
                    if (((String)object).indexOf("manifest") >= 0 || ((String)object).indexOf("MANIFEST") >= 0) {
                        bl2 = true;
                        InputStream inputStream = zipFile.getInputStream(zipEntry);
                        string = zaeCache.getZaeRoot(inputStream);
                        zaeCache.closeZaeRootReader();
                        continue;
                    }
                    hashMap.put((String)object, zipEntry);
                }
                if (string != null) {
                    zaeCache.setRoot(string);
                    zipEntry = hashMap.get(string);
                    if (zipEntry != null) {
                        object = zipFile.getInputStream(zipEntry);
                        if (object != null) {
                            this.importFile((InputStream)object, uRL, baseURL, zaeCache);
                        } else {
                            System.out.println("daeRootStream = null !!!!!!!!!!!!!!");
                        }
                    } else {
                        System.out.println("daeRoot entry = null !!!!!!!!!!!!!!");
                    }
                    break block21;
                }
                if (!bl2) {
                    throw new ImportException(this.CxxImporter + " read(URL url) - zae - no manifest.xml found !");
                }
                throw new ImportException(this.CxxImporter + " read(URL url) - zae - can't determine 'dae_root' !");
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ImportException(this.CxxImporter + " read(URL url) : " + uRISyntaxException.getMessage(), uRISyntaxException);
            }
            catch (ZipException zipException) {
                throw new ImportException(this.CxxImporter + " read(URL url) : " + zipException.getMessage(), zipException);
            }
            catch (IOException iOException) {
                throw new ImportException(this.CxxImporter + " read(URL url) : " + iOException.getMessage(), iOException);
            }
        }
    }

    Node[] getImportedNodes() {
        Node[] nodeArray = null;
        int n = 0;
        if (this.sceneNodeReturnList != null && (n = this.sceneNodeReturnList.size()) > 0) {
            nodeArray = new Node[n];
            for (int i = 0; i < n; ++i) {
                nodeArray[i] = this.sceneNodeReturnList.get(i);
            }
        }
        return nodeArray;
    }

    Map<String, Node> getNamedNodes() {
        return this.base.getNamedNodes();
    }

    Map<String, PhongMaterial> getNamedMaterials() {
        return this.base.getNamedMaterials();
    }

    IdentityHashMap<Image, FilePath> getImagePaths() {
        IdentityHashMap<Image, FilePath> identityHashMap = new IdentityHashMap<Image, FilePath>();
        Set<Map.Entry<URL, ElementCache>> set = this.referencedCachesMap.entrySet();
        for (Map.Entry<URL, ElementCache> entry : set) {
            IdentityHashMap<Image, FilePath> identityHashMap2 = entry.getValue().getImagePaths();
            identityHashMap.putAll(identityHashMap2);
        }
        return identityHashMap;
    }

    FilePath[] getIncludedColladaPaths() {
        if (this.daeFileReturnList != null && !this.daeFileReturnList.isEmpty()) {
            FilePath[] filePathArray = new FilePath[this.daeFileReturnList.size()];
            this.daeFileReturnList.toArray(filePathArray);
            return filePathArray;
        }
        return null;
    }

    Viewpoint[] getViewpoints() {
        return this.base.getViewpoints();
    }

    Node[] getCamLights() {
        return this.base.getCamLights();
    }

    void clear() {
        this.scope.isLight = true;
        this.base.clear();
        this.colFileParser.clear();
        this.cAsset = null;
        Collection<ElementCache> collection = this.referencedCachesMap.values();
        for (ElementCache elementCache : collection) {
            elementCache.clear();
        }
        this.referencedCachesMap.clear();
        if (this.sceneNodeReturnList != null) {
            this.sceneNodeReturnList.clear();
            this.sceneNodeReturnList = null;
        }
        if (this.shape3DReturnList != null) {
            this.shape3DReturnList.clear();
            this.shape3DReturnList = null;
        }
        if (this.appearReturnList != null) {
            this.appearReturnList.clear();
            this.appearReturnList = null;
        }
        if (this.geomReturnList != null) {
            this.geomReturnList.clear();
            this.geomReturnList = null;
        }
        if (this.daeFileReturnList != null) {
            this.daeFileReturnList.clear();
            this.daeFileReturnList = null;
        }
    }

    void close() {
        this.isClosed = true;
        this.clear();
        this.base.close();
        this.colFileParser.close();
    }

    private void clearForNextImport() {
        this.clear();
    }

    private void checkIsClosed() {
        if (this.isClosed) {
            throw new ImportException(this.CxxImporter + " is closed! Can't be used anymore!");
        }
    }

    private void importFile(InputStream inputStream, URL uRL, BaseURL baseURL, ZaeCache zaeCache) {
        Object object;
        HashMap<String, ArrayList<TriangleMesh>> hashMap;
        Object object3;
        this.clearForNextImport();
        if (this.c14Opts != null && !this.c14Opts.isEmpty()) {
            this.base.isGenerateNormals = this.c14Opts.contains((Object)ColImportOption.GENERATE_NORMALS);
            this.base.isReverse = this.c14Opts.contains((Object)ColImportOption.REVERSE_GEOMETRY);
            this.base.isReverseTransparence = this.c14Opts.contains((Object)ColImportOption.REVERSE_TRANSPARENCY);
            this.base.isWritableImage = this.c14Opts.contains((Object)ColImportOption.MAP_WRITABLEIMAGE);
            this.base.isIgnoreCameras = this.c14Opts.contains((Object)ColImportOption.IGNORE_CAMERAS);
            this.scope.isLight = !this.c14Opts.contains((Object)ColImportOption.IGNORE_LIGHTS);
        }
        this.base.zaeCache = zaeCache;
        this.base.creaseAngle = this.creaseAngle;
        ElementCache elementCache = new ElementCache(this, zaeCache != null);
        if (zaeCache != null) {
            this.referencedCachesMap.put(zaeCache.getRootUrl(), elementCache);
            elementCache.setZaeEntryBase(zaeCache.getRootEntryBase());
        } else {
            this.referencedCachesMap.put(uRL, elementCache);
        }
        if (this.isUserBase) {
            elementCache.setBaseURL(this.baseUrlUser);
        } else {
            elementCache.setBaseURL(baseURL);
        }
        COLLADA cOLLADA = this.colFileParser.parse(inputStream);
        cOLLADA.initialize(this.base, elementCache);
        this.cAsset = new ColAsset();
        this.cAsset.version = cOLLADA.getVersion();
        Asset asset = cOLLADA.asset;
        ArrayList<Asset.Contributor> arrayList = asset.contributorList;
        if (arrayList != null) {
            object3 = new ArrayList();
            for (Asset.Contributor object22 : arrayList) {
                hashMap = new ColAsset.Contributor();
                ((ColAsset.Contributor)((Object)hashMap)).author = object22.author;
                ((ColAsset.Contributor)((Object)hashMap)).atool = object22.atool;
                ((ColAsset.Contributor)((Object)hashMap)).comments = object22.comments;
                ((ColAsset.Contributor)((Object)hashMap)).copyright = object22.copyright;
                ((ColAsset.Contributor)((Object)hashMap)).source = object22.source;
                ((ColAsset.Contributor)((Object)hashMap)).authorMail = object22.authorMail;
                ((ColAsset.Contributor)((Object)hashMap)).authorWeb = object22.authorWeb;
                ((ArrayList)object3).add(hashMap);
            }
            this.cAsset.contributorList = object3;
        }
        if ((object3 = asset.geoLocation) != null) {
            object = new ColAsset.GeographicLocation();
            ((ColAsset.GeographicLocation)object).altitudeMode = ((Asset.GeographicLocation)object3).altitudeMode;
            ((ColAsset.GeographicLocation)object).altitudeValue = ((Asset.GeographicLocation)object3).altitudeValue;
            ((ColAsset.GeographicLocation)object).latitude = ((Asset.GeographicLocation)object3).latitude;
            ((ColAsset.GeographicLocation)object).longitude = ((Asset.GeographicLocation)object3).longitude;
            this.cAsset.geoLocation = object;
        }
        this.cAsset.creString = asset.created;
        this.cAsset.modString = asset.modified;
        this.cAsset.keywords = asset.keywords;
        this.cAsset.revision = asset.revision;
        this.cAsset.subject = asset.subject;
        this.cAsset.title = asset.title;
        this.cAsset.upAxis = asset.upAxis;
        this.cAsset.unitName = asset.unitName;
        this.cAsset.unitMeter = asset.unitMeter;
        this.base.upAxis = asset.upAxis;
        if (this.scope == Scope.APPEARANCE) {
            object = cOLLADA.initAppearance(this.base, elementCache);
            if (object != null && !((ArrayList)object).isEmpty()) {
                this.appearReturnList = new ArrayList();
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    hashMap = (LibMaterials)iterator.next();
                    ArrayList<Material> arrayList2 = ((LibMaterials)((Object)hashMap)).getMaterials();
                    if (arrayList2 == null || arrayList2.isEmpty()) continue;
                    for (Material material : arrayList2) {
                        PhongMaterial phongMaterial = material.getAppearance();
                        if (phongMaterial == null) continue;
                        this.appearReturnList.add(phongMaterial);
                    }
                }
                if (this.appearReturnList.isEmpty()) {
                    this.appearReturnList = null;
                }
            }
        } else if (this.scope == Scope.GEOMETRY) {
            object = cOLLADA.initGeometry(this.base, elementCache);
            if (object != null && !((ArrayList)object).isEmpty()) {
                this.geomReturnList = new ArrayList();
                String string = Integer.toString(this.hashCode());
                hashMap = null;
                Collection<ArrayList<TriangleMesh>> collection = null;
                Iterator<ArrayList<TriangleMesh>> iterator = null;
                Iterator iterator2 = ((ArrayList)object).iterator();
                while (iterator2.hasNext()) {
                    LibGeometries libGeometries = (LibGeometries)iterator2.next();
                    ArrayList<Geometry> arrayList3 = libGeometries.getGeometryMeshes();
                    if (arrayList3 == null || arrayList3.isEmpty()) continue;
                    for (Geometry geometry : arrayList3) {
                        hashMap = geometry.getQuadTriaGeometries(string, null);
                        if (hashMap == null) continue;
                        collection = hashMap.values();
                        iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            this.geomReturnList.addAll((Collection<TriangleMesh>)iterator.next());
                        }
                    }
                }
                if (this.geomReturnList.isEmpty()) {
                    this.geomReturnList = null;
                }
            }
        } else if (this.scope == Scope.MODEL) {
            object = cOLLADA.initModel(this.base, elementCache);
            if (object != null) {
                this.sceneNodeReturnList = ((Scene)object).createSceneTopJ3DNodes(this.cAsset.upAxis);
            } else {
                System.out.println(this.CxxImporter + " : No COLLADA Scene !!");
            }
        } else {
            System.out.println(this.CxxImporter + " : check scope = " + (Object)((Object)this.scope));
        }
        cOLLADA.clear();
        this.importer.onFileImported();
    }

    ElementCache getReferencedCache(BaseURL baseURL, String string, String string2, boolean bl) {
        ElementCache elementCache;
        boolean bl2;
        String string3 = null;
        URL uRL = null;
        uRL = this.cUtils.getUrlForAbsolutPath(string);
        boolean bl3 = bl2 = uRL != null;
        if (!bl2) {
            if (bl) {
                string3 = this.base.zaeCache.normalizeZaeEntry(string2, string);
                uRL = this.base.zaeCache.getUrlFor(string3);
                if (uRL == null) {
                    throw new ImportException("Can't create URL for zae/dae-path = " + string3);
                }
            } else {
                uRL = this.cUtils.getUrlForRelativePath(baseURL, string);
                if (uRL == null) {
                    throw new ImportException("Can't create URL for dae-path = " + string);
                }
            }
        }
        if ((elementCache = this.referencedCachesMap.get(uRL)) == null) {
            if (this.daeFileReturnList == null) {
                this.daeFileReturnList = new ArrayList();
            }
            elementCache = this.readReferencedFile(bl2, uRL, string3, bl);
            if (bl) {
                this.daeFileReturnList.add(new FilePath(string, null));
            } else {
                this.daeFileReturnList.add(new FilePath(string, uRL));
            }
        }
        return elementCache;
    }

    private ElementCache readReferencedFile(boolean bl, URL uRL, String string, boolean bl2) {
        Object object;
        COLLADA cOLLADA = null;
        ElementCache elementCache = new ElementCache(this, bl2);
        if (bl2 && !bl) {
            object = this.base.zaeCache.getInputStreamForEntry(string);
            cOLLADA = this.colFileParser.parse((InputStream)object);
            elementCache.setZaeEntryBase(this.base.zaeCache.getEntryBaseFor(string));
        } else {
            try {
                object = uRL.openStream();
                cOLLADA = this.colFileParser.parse((InputStream)object);
            }
            catch (IOException iOException) {
                throw new ImportException("Can't open stream for referenced COLLADA file: \n  url = " + uRL.toExternalForm() + "\n  " + iOException.getMessage(), iOException);
            }
        }
        this.referencedCachesMap.put(uRL, elementCache);
        if (!bl2) {
            if (this.isUserBase) {
                elementCache.setBaseURL(this.baseUrlUser);
            } else {
                object = new BaseURL();
                ((BaseURL)object).protocol = uRL.getProtocol();
                ((BaseURL)object).host = uRL.getHost();
                ((BaseURL)object).port = uRL.getPort();
                ((BaseURL)object).path = uRL.getPath();
                int n = ((BaseURL)object).path.lastIndexOf(47);
                ((BaseURL)object).path = n >= 0 ? ((BaseURL)object).path.substring(0, n + 1) : Character.toString('/');
                elementCache.setBaseURL((BaseURL)object);
            }
        }
        cOLLADA.initialize(this.base, elementCache);
        if (this.scope == Scope.APPEARANCE) {
            cOLLADA.initAppearance(this.base, elementCache);
        } else if (this.scope == Scope.GEOMETRY) {
            cOLLADA.initGeometry(this.base, elementCache);
        } else if (this.scope != Scope.SHAPE3D) {
            if (this.scope == Scope.MODEL) {
                cOLLADA.initModel(this.base, elementCache);
            } else if (this.scope == Scope.SCENE) {
                // empty if block
            }
        }
        return elementCache;
    }
}

