/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.col.ColladaFileParser;
import com.interactivemesh.jfx.importer.col.Surface;

final class SurfaceParser
extends AbstractElementParserChar {
    private AbstractElementParser parentParser = null;
    private Surface surface = null;
    private Surface.InitFrom currInitFrom = null;
    private boolean isFormatHint = false;

    SurfaceParser(ColladaFileParser colladaFileParser) {
        super(colladaFileParser);
        this.charArray = new char[200];
        this.isCharacter = true;
    }

    void setup(AbstractElementParser abstractElementParser, Surface surface) {
        this.parentParser = abstractElementParser;
        this.surface = surface;
        this.arrPos = 0;
    }

    @Override
    void doClose() {
        this.charArray = null;
    }

    @Override
    void startElement(String string) {
        this.arrPos = 0;
        if (string.startsWith("init_")) {
            this.surface.initElement = string;
            if (string.equals("init_from")) {
                this.currInitFrom = new Surface.InitFrom();
                this.surface.setInitFromAttributes(this.currInitFrom, this.cfp.xR);
                this.surface.initFrom = this.currInitFrom;
            } else if (string.equals("init_as_null")) {
                this.surface.isInitAsNull = true;
            }
        } else if (string.equals("format_hint")) {
            this.isFormatHint = true;
        } else if (this.isFormatHint) {
            if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (string.equals("extra")) {
            this.cfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals("init_from")) {
            this.currInitFrom.ref = this.cUtils().trimString(this.charArray, this.arrPos);
            this.currInitFrom = null;
        } else if (string.equals("format")) {
            this.surface.format = this.cUtils().trimString(this.charArray, this.arrPos);
        } else if (string.equals("size")) {
            this.cUtils().splitIntegerInto(this.charArray, this.arrPos, this.surface.size);
        } else if (string.equals("viewport_ratio")) {
            String string2 = this.cUtils().trimString(this.charArray, this.arrPos);
            this.cUtils().splitFloatInto(string2, this.surface.viewportRation);
        } else if (string.equals("mip_levels")) {
            String string3 = this.cUtils().trimString(this.charArray, this.arrPos);
            this.surface.mipLevels = Integer.parseInt(string3);
        } else if (string.equals("mipmap_generate")) {
            String string4 = this.cUtils().trimString(this.charArray, this.arrPos);
            this.surface.mipmapGenerate = string4.equalsIgnoreCase("true");
        } else if (this.isFormatHint) {
            if (string.equals("channels")) {
                this.surface.fhChannels = this.cUtils().trimString(this.charArray, this.arrPos);
            } else if (string.equals("range")) {
                this.surface.fhRange = this.cUtils().trimString(this.charArray, this.arrPos);
            } else if (string.equals("precision")) {
                this.surface.fhRange = this.cUtils().trimString(this.charArray, this.arrPos);
            } else if (string.equals("option")) {
                this.surface.fhRange = this.cUtils().trimString(this.charArray, this.arrPos);
            } else if (string.equals("format_hint")) {
                this.isFormatHint = false;
            }
        } else if (string.equals("surface")) {
            this.cfp.setParser(this.parentParser);
            this.parentParser = null;
            this.surface = null;
        }
    }
}

