/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.Shape3DParser;
import javafx.scene.Node;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.TriangleMesh;

final class MeshViewParser
extends Shape3DParser {
    private final MeshParser meshParser = new MeshParser(this);
    private MeshView currMeshView = null;

    MeshViewParser(FxFileParser fxFileParser) {
        super(fxFileParser);
    }

    void setup(AbstractElementParser abstractElementParser, MeshView meshView) {
        this.parentParser = abstractElementParser;
        this.currMeshView = meshView;
        this.setupShape3D();
        int n = this.fxfp.xR.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = this.fxfp.xR.getAttributeValue(i);
            if (string == null || string.length() <= 0) {
                throw new ImportException("MeshViewParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
            }
            String string2 = this.fxfp.xR.getAttributeLocalName(i);
            this.processShape3DAttributes(string2, string, i);
        }
    }

    @Override
    String getIdDefault() {
        return "MeshView";
    }

    @Override
    void close() {
        super.close();
    }

    @Override
    void startElement(String string) {
        if (string.equals("transforms")) {
            this.fxfp.setTransformsParser(this, (Node)this.currMeshView);
        } else if (string.equals("material")) {
            this.setMaterialParser(this, (Shape3D)this.currMeshView);
        } else if (string.equals("mesh")) {
            this.fxfp.setParser(this.meshParser);
        } else {
            this.isCharacter = false;
            this.isPrimitive = false;
            if (!this.processShape3DStartElement(string)) {
                if (this.processPrimitiveStartElement(string)) {
                    this.isPrimitive = true;
                } else {
                    this.fxfp.setNullParser(this, string);
                }
            }
            if (this.isCharacter) {
                this.arrPos = 0;
            }
        }
    }

    @Override
    void endElement(String string) {
        if (!string.equals(this.primTagName)) {
            if (this.isCharacter || this.isPrimitive) {
                String string2 = this.getCharOrPrimString();
                if (string2 != null) {
                    this.processShape3DEndElement(string, string2);
                }
            } else if (string.equals("MeshView")) {
                this.setShape3DProperties((Shape3D)this.currMeshView);
                this.fxfp.setParser(this.parentParser);
                this.parentParser = null;
                this.currMeshView = null;
            }
        }
    }

    private final class MeshParser
    extends AbstractElementParser {
        private final AbstractElementParser parentParser;

        private MeshParser(AbstractElementParser abstractElementParser) {
            super(abstractElementParser.fxfp);
            this.parentParser = abstractElementParser;
        }

        @Override
        void close() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        void startElement(String string) {
            if (string.equals("TriangleMesh")) {
                TriangleMesh triangleMesh = new TriangleMesh();
                MeshViewParser.this.currMeshView.setMesh((Mesh)triangleMesh);
                this.fxfp.setTriangleMeshParser(this, triangleMesh);
                return;
            } else if (string.equals("reference")) {
                if (!this.fxfp.xR.getPrefix().equals("fx")) throw new ImportException("MeshParser : mesh reference element doesn't have prefix 'fx:' !");
                String string2 = this.fxfp.xR.getAttributeValue(null, "source");
                if (string2 == null || string2.length() <= 0) throw new ImportException("MeshParser : source attribute of mesh reference not found !");
                TriangleMesh triangleMesh = this.fxfp.currCache.getTriangleMesh(string2);
                if (triangleMesh == null) throw new ImportException("MeshParser : no mesh referernce found for source = >" + string2 + "< !");
                MeshViewParser.this.currMeshView.setMesh((Mesh)triangleMesh);
                return;
            } else {
                this.fxfp.setNullParser(this, string);
            }
        }

        @Override
        void endElement(String string) {
            if (string.equals("mesh")) {
                this.fxfp.setParser(this.parentParser);
            }
        }
    }
}

