/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.x3d.AbstractElementParser;
import com.interactivemesh.jfx.importer.x3d.GeometryNode;
import com.interactivemesh.jfx.importer.x3d.XFileParser;

final class GeometryNodeParser
extends AbstractElementParser {
    private AbstractElementParser parentParser = null;
    private GeometryNode currGeomNode = null;
    private String returnTag = null;
    private boolean isVertexData = false;

    GeometryNodeParser(XFileParser xFileParser) {
        super(xFileParser);
    }

    void setup(GeometryNode geometryNode, AbstractElementParser abstractElementParser, String string) {
        this.currGeomNode = geometryNode;
        this.parentParser = abstractElementParser;
        this.returnTag = string;
    }

    @Override
    void close() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void startElement(String string) {
        if (this.isVertexData) {
            this.xfp.setNullParser(this, string);
            return;
        } else {
            String string2 = this.xfp.xR.getAttributeValue(null, "DEF");
            String string3 = this.xfp.xR.getAttributeValue(null, "USE");
            this.isVertexData = false;
            if (string.equals("Coordinate")) {
                if (string3 != null) {
                    GeometryNode geometryNode = this.currGeomNode.cache.getVertexData(string3);
                    if (geometryNode == null) throw new ImportException("GeometryNodeParser : shared " + string + " node not found for USE = " + string3);
                    geometryNode.coordUsed = string3;
                    this.currGeomNode.useCoordinate = string3;
                    return;
                } else {
                    this.isVertexData = true;
                    this.currGeomNode.coordinate = this.xfp.xR.getAttributeValue(null, "point");
                    if (string2 == null) return;
                    this.currGeomNode.cache.putVertexData(string2, this.currGeomNode);
                }
                return;
            } else if (string.equals("Normal")) {
                if (string3 != null) {
                    GeometryNode geometryNode = this.currGeomNode.cache.getVertexData(string3);
                    if (geometryNode == null) throw new ImportException("GeometryNodeParser : shared " + string + " node not found for USE = " + string3);
                    geometryNode.normalUsed = string3;
                    this.currGeomNode.useNormal = string3;
                    return;
                } else {
                    this.isVertexData = true;
                    this.currGeomNode.normal = this.xfp.xR.getAttributeValue(null, "vector");
                    if (string2 == null) return;
                    this.currGeomNode.cache.putVertexData(string2, this.currGeomNode);
                }
                return;
            } else if (string.equals("TextureCoordinate")) {
                if (string3 != null) {
                    GeometryNode geometryNode = this.currGeomNode.cache.getVertexData(string3);
                    if (geometryNode == null) throw new ImportException("GeometryNodeParser : shared " + string + " node not found for USE = " + string3);
                    geometryNode.texCoordUsed = string3;
                    this.currGeomNode.useTexCoordinate = string3;
                    return;
                } else {
                    this.isVertexData = true;
                    this.currGeomNode.texCoordinate = this.xfp.xR.getAttributeValue(null, "point");
                    if (string2 == null) return;
                    this.currGeomNode.cache.putVertexData(string2, this.currGeomNode);
                }
                return;
            } else if (string.equals("CoordinateDouble")) {
                if (string3 != null) {
                    GeometryNode geometryNode = this.currGeomNode.cache.getVertexData(string3);
                    if (geometryNode == null) throw new ImportException("GeometryNodeParser : shared " + string + " node not found for USE = " + string3);
                    geometryNode.coordUsed = string3;
                    this.currGeomNode.useCoordinateD = string3;
                    return;
                } else {
                    this.isVertexData = true;
                    this.currGeomNode.coordinateD = this.xfp.xR.getAttributeValue(null, "point");
                    if (string2 == null) return;
                    this.currGeomNode.cache.putVertexData(string2, this.currGeomNode);
                }
                return;
            } else if (string.startsWith("Metadata")) {
                this.currGeomNode.setMetaData(this.xfp.setMetaParser(this, string, string2, string3, this.currGeomNode.cache));
                return;
            } else {
                this.xfp.setNullParser(this, string);
            }
        }
    }

    @Override
    void endElement(String string) {
        if (this.isVertexData) {
            this.isVertexData = false;
            return;
        }
        if (string.equals(this.returnTag)) {
            this.xfp.setParser(this.parentParser);
            this.parentParser = null;
            this.currGeomNode = null;
            this.returnTag = null;
        }
    }
}

