/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.modelbrowser;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.modelbrowser.FxmlExporter;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableIntegerArray;
import javafx.collections.ObservableList;
import javafx.geometry.Point3D;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.ObservableFaceArray;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Shear;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

final class FxmlModelExporter
extends FxmlExporter {
    private final IdentityHashMap<Image, Integer> imNumMap = new IdentityHashMap();
    private final IdentityHashMap<PhongMaterial, Integer> pmNumMap = new IdentityHashMap();
    private final IdentityHashMap<TriangleMesh, Integer> tmNumMap = new IdentityHashMap();
    private final IdentityHashMap<Image, String> sharedImMap = new IdentityHashMap();
    private final IdentityHashMap<PhongMaterial, String> sharedPmMap = new IdentityHashMap();
    private final IdentityHashMap<TriangleMesh, String> sharedTmMap = new IdentityHashMap();
    private boolean isReference = false;
    private int imRef = 0;
    private int pmRef = 0;
    private int tmRef = 0;
    private Map<Image, FilePath> currImagePathMap = null;
    private int coordScale = -6;
    private int texScale = -1;
    private boolean isDropZeros = true;
    private static final String B = " ";
    private static final String C = ",";
    private static final String BC = ", ";
    private String space = " ";

    FxmlModelExporter(File file) {
        super(file);
    }

    @Override
    void close() {
        this.imNumMap.clear();
        this.pmNumMap.clear();
        this.tmNumMap.clear();
        this.sharedImMap.clear();
        this.sharedPmMap.clear();
        this.sharedTmMap.clear();
        super.close();
    }

    void export(Node[] nodeArray, Map<Image, FilePath> map) throws IOException {
        Object object;
        this.currImagePathMap = map;
        boolean bl = nodeArray.length > 1;
        for (Node nodeArray2 : nodeArray) {
            this.searchTypesInTransform(nodeArray2);
            if (nodeArray2 instanceof Group) {
                this.findReusedAttributes((Group)nodeArray2);
                continue;
            }
            if (nodeArray2 instanceof MeshView) {
                this.findReusedAttributes((MeshView)nodeArray2);
                continue;
            }
            if (nodeArray2 instanceof LightBase) {
                if (nodeArray2 instanceof AmbientLight) {
                    this.isAmbLight = true;
                    continue;
                }
                if (!(nodeArray2 instanceof PointLight)) continue;
                this.isPointLight = true;
                continue;
            }
            if (!(nodeArray2 instanceof Camera)) continue;
            if (nodeArray2 instanceof ParallelCamera) {
                this.isParCam = true;
            }
            if (!(nodeArray2 instanceof PerspectiveCamera)) continue;
            this.isPerCam = true;
        }
        if (this.pmNumMap.size() > 0) {
            object = this.pmNumMap.values();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                if (n <= 1) continue;
                this.isReference = true;
                break;
            }
        }
        if (!this.isReference && this.imNumMap.size() > 0) {
            object = this.imNumMap.values();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                if (n <= 1) continue;
                this.isReference = true;
                break;
            }
        }
        if (!this.isReference && this.tmNumMap.size() > 0) {
            object = this.tmNumMap.values();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                if (n <= 1) continue;
                this.isReference = true;
                break;
            }
        }
        this.isGroup = this.isGroup || bl;
        this.writeXML();
        this.writeComments();
        this.writeModelImports();
        int n = 0;
        if (bl) {
            String string = "AddedRootGroup_" + System.currentTimeMillis();
            if (this.isReference) {
                this.fxWriter.write("<Group id=\"" + string + "\" xmlns:fx=\"http://javafx.com/fxml\">\n");
            } else {
                this.fxWriter.write("<Group id=\"" + string + "\">\n");
            }
            this.fxWriter.write(this.getTabs(1) + "<children>\n");
            n = 2;
        }
        String string = this.getTabs(n);
        String string2 = this.getTabs(n + 1);
        for (Node node : nodeArray) {
            if (node instanceof Group) {
                String string3 = node.getId();
                ObservableList observableList = ((Group)node).getChildren();
                StringBuilder stringBuilder = new StringBuilder("<Group");
                if (string3 != null && string3.length() > 0) {
                    stringBuilder.append(" id=\"" + string3 + "\"");
                }
                if (this.isReference && !bl) {
                    stringBuilder.append(" xmlns:fx=\"http://javafx.com/fxml\"");
                }
                stringBuilder.append(">\n");
                this.fxWriter.write(string + stringBuilder.toString());
                this.writeTransforms(n + 1, node);
                if (observableList.size() > 0) {
                    this.fxWriter.write(string2 + "<children>\n");
                    for (Node node2 : observableList) {
                        if (node2 instanceof Group) {
                            this.writeGroup(n + 2, (Group)node2);
                            continue;
                        }
                        this.writeLeaf(n + 2, node2);
                    }
                    this.fxWriter.write(string2 + "</children>\n");
                }
                this.fxWriter.write(string + "</Group>\n");
                continue;
            }
            this.writeLeaf(n, node);
        }
        if (bl) {
            this.fxWriter.write(this.getTabs(1) + "</children>\n");
            this.fxWriter.write("</Group>\n");
        }
        this.close();
    }

    private void findReusedAttributes(Group group) {
        this.isGroup = true;
        ObservableList observableList = group.getChildren();
        if (observableList.size() > 0) {
            for (Node node : observableList) {
                this.searchTypesInTransform(node);
                if (node instanceof Group) {
                    this.findReusedAttributes((Group)node);
                    continue;
                }
                if (node instanceof MeshView) {
                    this.findReusedAttributes((MeshView)node);
                    continue;
                }
                if (node instanceof LightBase) {
                    if (node instanceof AmbientLight) {
                        this.isAmbLight = true;
                        continue;
                    }
                    if (!(node instanceof PointLight)) continue;
                    this.isPointLight = true;
                    continue;
                }
                if (!(node instanceof Camera)) continue;
                if (node instanceof ParallelCamera) {
                    this.isParCam = true;
                }
                if (!(node instanceof PerspectiveCamera)) continue;
                this.isPerCam = true;
            }
        }
    }

    private void findReusedAttributes(MeshView meshView) {
        Integer n;
        PhongMaterial phongMaterial;
        this.isMeshView = true;
        if (meshView.getMaterial() != null) {
            this.isPhongMat = true;
            phongMaterial = (PhongMaterial)meshView.getMaterial();
            n = this.pmNumMap.get(phongMaterial);
            if (n == null) {
                this.pmNumMap.put(phongMaterial, 1);
                if (phongMaterial.getDiffuseColor() != null) {
                    this.isColor = true;
                }
                if (phongMaterial.getSpecularColor() != null) {
                    this.isColor = true;
                }
                this.findReusedAttributes(phongMaterial.getBumpMap());
                this.findReusedAttributes(phongMaterial.getDiffuseMap());
                this.findReusedAttributes(phongMaterial.getSelfIlluminationMap());
                this.findReusedAttributes(phongMaterial.getSpecularMap());
            } else {
                this.pmNumMap.put(phongMaterial, n + 1);
            }
        }
        if (meshView.getMesh() != null) {
            this.isTriaMesh = true;
            phongMaterial = (TriangleMesh)meshView.getMesh();
            n = this.tmNumMap.get(phongMaterial);
            if (n == null) {
                this.tmNumMap.put((TriangleMesh)phongMaterial, 1);
            } else {
                this.tmNumMap.put((TriangleMesh)phongMaterial, n + 1);
            }
        }
    }

    private void findReusedAttributes(Image image) {
        if (image == null) {
            return;
        }
        this.isImage = true;
        Integer n = this.imNumMap.get(image);
        if (n == null) {
            this.imNumMap.put(image, 1);
        } else {
            this.imNumMap.put(image, n + 1);
        }
    }

    private void searchTypesInTransform(Node node) {
        ObservableList observableList = node.getTransforms();
        for (Transform transform : observableList) {
            if (transform instanceof Affine) {
                this.isAffine = true;
                continue;
            }
            if (transform instanceof Rotate) {
                this.isRotate = true;
                continue;
            }
            if (transform instanceof Translate) {
                this.isTranslate = true;
                continue;
            }
            if (transform instanceof Scale) {
                this.isScale = true;
                continue;
            }
            if (!(transform instanceof Shear)) continue;
        }
    }

    private void writeGroup(int n, Group group) throws IOException {
        String string = this.getTabs(n);
        String string2 = this.getTabs(n + 1);
        String string3 = group.getId();
        boolean bl = group.isVisible();
        ObservableList observableList = group.getChildren();
        StringBuilder stringBuilder = new StringBuilder(string + "<Group");
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append(" id=\"" + string3 + "\"");
        }
        if (!bl) {
            stringBuilder.append(" visible=\"false\"");
        }
        stringBuilder.append(">\n");
        this.fxWriter.write(stringBuilder.toString());
        this.writeTransforms(n + 1, (Node)group);
        if (observableList.size() > 0) {
            this.fxWriter.write(string2 + "<children>\n");
            for (Node node : observableList) {
                if (node instanceof Group) {
                    this.writeGroup(n + 2, (Group)node);
                    continue;
                }
                this.writeLeaf(n + 2, node);
            }
            this.fxWriter.write(string2 + "</children>\n");
        }
        this.fxWriter.write(string + "</Group>\n");
    }

    private void writeLeaf(int n, Node node) throws IOException {
        if (node instanceof MeshView) {
            this.writeMeshView(n, (MeshView)node);
        } else if (node instanceof LightBase) {
            this.writeLight(n, (LightBase)node);
        } else if (node instanceof Camera) {
            this.writeCamera(n, (Camera)node);
        }
    }

    private void writeLight(int n, LightBase lightBase) throws IOException {
        boolean bl;
        String string = this.getTabs(n);
        String string2 = this.getTabs(n + 1);
        String string3 = this.getTabs(n + 2);
        StringBuilder stringBuilder = new StringBuilder(200);
        String string4 = null;
        if (lightBase instanceof AmbientLight) {
            string4 = "AmbientLight";
        } else if (lightBase instanceof PointLight) {
            string4 = "PointLight";
        }
        stringBuilder.append("<" + string4 + "");
        String string5 = lightBase.getId();
        if (string5 != null && string5.length() > 0) {
            stringBuilder.append(" id=\"" + string5 + "\"");
        }
        if (!(bl = lightBase.isVisible())) {
            stringBuilder.append(" visible=\"false\"");
        }
        if (lightBase.isLightOn()) {
            stringBuilder.append(" lightOn=\"true\"");
        } else {
            stringBuilder.append(" lightOn=\"false\"");
        }
        stringBuilder.append(">\n");
        this.fxWriter.write(string + stringBuilder.toString());
        this.writeTransforms(n + 1, (Node)lightBase);
        Color color = lightBase.getColor();
        if (color != null) {
            this.fxWriter.write(string2 + "<color>\n");
            this.fxWriter.write(string3 + "<Color red=\"" + (float)color.getRed() + "\" green=\"" + (float)color.getGreen() + "\" blue=\"" + (float)color.getBlue() + "\"/>\n");
            this.fxWriter.write(string2 + "</color>\n");
        }
        this.fxWriter.write(string + "</" + string4 + ">\n");
    }

    private void writeCamera(int n, Camera camera) throws IOException {
        boolean bl;
        String string = this.getTabs(n);
        StringBuilder stringBuilder = new StringBuilder(200);
        String string2 = null;
        if (camera instanceof ParallelCamera) {
            string2 = "ParallelCamera";
        } else if (camera instanceof PerspectiveCamera) {
            string2 = "PerspectiveCamera";
        }
        stringBuilder.append("<" + string2 + "");
        String string3 = camera.getId();
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append(" id=\"" + string3 + "\"");
        }
        if (!(bl = camera.isVisible())) {
            stringBuilder.append(" visible=\"false\"");
        }
        stringBuilder.append(" farClip=\"" + (float)camera.getFarClip() + "\" nearClip=\"" + (float)camera.getNearClip() + "\"");
        if (camera instanceof PerspectiveCamera) {
            String string4 = "true";
            if (!((PerspectiveCamera)camera).isVerticalFieldOfView()) {
                string4 = "false";
            }
            stringBuilder.append(" fieldOfView=\"" + (float)((PerspectiveCamera)camera).getFieldOfView() + "\" verticalFieldOfView=\"" + string4 + "\"");
        }
        stringBuilder.append(">\n");
        this.fxWriter.write(string + stringBuilder.toString());
        this.writeTransforms(n + 1, (Node)camera);
        this.fxWriter.write(string + "</" + string2 + ">\n");
    }

    private void writeMeshView(int n, MeshView meshView) throws IOException {
        Integer n2;
        PhongMaterial phongMaterial;
        String string = this.getTabs(n);
        String string2 = this.getTabs(n + 1);
        String string3 = this.getTabs(n + 2);
        String string4 = meshView.getId();
        boolean bl = meshView.isVisible();
        CullFace cullFace = meshView.getCullFace();
        DrawMode drawMode = meshView.getDrawMode();
        StringBuilder stringBuilder = new StringBuilder("<MeshView");
        if (string4 != null && string4.length() > 0) {
            stringBuilder.append(" id=\"" + string4 + "\"");
        }
        if (!bl) {
            stringBuilder.append(" visible=\"false\"");
        }
        stringBuilder.append(" cullFace=\"" + cullFace.name() + "\" drawMode=\"" + drawMode.name() + "\">\n");
        this.fxWriter.write(string + stringBuilder.toString());
        this.writeTransforms(n + 1, (Node)meshView);
        if (meshView.getMaterial() != null) {
            this.fxWriter.write(string2 + "<material>\n");
            phongMaterial = (PhongMaterial)meshView.getMaterial();
            n2 = this.pmNumMap.get(phongMaterial);
            float f = (float)phongMaterial.getSpecularPower();
            if (n2 != null && n2 > 1) {
                String string5 = this.sharedPmMap.get(phongMaterial);
                if (string5 == null) {
                    ++this.pmRef;
                    string5 = "PmFxId_" + this.pmRef;
                    this.sharedPmMap.put(phongMaterial, string5);
                    if ((double)f != 1.0) {
                        this.fxWriter.write(string3 + "<PhongMaterial fx:id=\"" + string5 + "\" specularPower=\"" + f + "\">\n");
                    } else {
                        this.fxWriter.write(string3 + "<PhongMaterial fx:id=\"" + string5 + "\">\n");
                    }
                    this.writePmColorsAndMaps(n + 3, phongMaterial);
                    this.fxWriter.write(string3 + "</PhongMaterial>\n");
                } else {
                    this.fxWriter.write(string3 + "<fx:reference source=\"" + string5 + "\"/>\n");
                }
            } else {
                if ((double)f != 1.0) {
                    this.fxWriter.write(string3 + "<PhongMaterial specularPower=\"" + f + "\">\n");
                } else {
                    this.fxWriter.write(string3 + "<PhongMaterial>\n");
                }
                this.writePmColorsAndMaps(n + 3, phongMaterial);
                this.fxWriter.write(string3 + "</PhongMaterial>\n");
            }
            this.fxWriter.write(string2 + "</material>\n");
        }
        if (meshView.getMesh() != null) {
            this.fxWriter.write(string2 + "<mesh>\n");
            phongMaterial = (TriangleMesh)meshView.getMesh();
            n2 = this.tmNumMap.get(phongMaterial);
            if (n2 != null && n2 > 1) {
                String string6 = this.sharedTmMap.get(phongMaterial);
                if (string6 == null) {
                    ++this.tmRef;
                    string6 = "TmFxId_" + this.tmRef;
                    this.sharedTmMap.put((TriangleMesh)phongMaterial, string6);
                    this.fxWriter.write(string3 + "<TriangleMesh fx:id=\"" + string6 + "\">\n");
                    this.writeTriangleMeshArrays(n + 3, (TriangleMesh)phongMaterial);
                    this.fxWriter.write(string3 + "</TriangleMesh>\n");
                } else {
                    this.fxWriter.write(string3 + "<fx:reference source=\"" + string6 + "\"/>\n");
                }
            } else {
                this.fxWriter.write(string3 + "<TriangleMesh>\n");
                this.writeTriangleMeshArrays(n + 3, (TriangleMesh)phongMaterial);
                this.fxWriter.write(string3 + "</TriangleMesh>\n");
            }
            this.fxWriter.write(string2 + "</mesh>\n");
        }
        this.fxWriter.write(string + "</MeshView>\n");
    }

    private void writePmColorsAndMaps(int n, PhongMaterial phongMaterial) throws IOException {
        Color color;
        String string = this.getTabs(n);
        String string2 = this.getTabs(n + 1);
        String string3 = this.getTabs(n + 2);
        Image image = phongMaterial.getBumpMap();
        if (image != null) {
            this.writeMap(n, "bumpMap", image);
        }
        if ((color = phongMaterial.getDiffuseColor()) != null) {
            this.fxWriter.write(string + "<diffuseColor>\n");
            this.fxWriter.write(string2 + "<Color red=\"" + (float)color.getRed() + "\" green=\"" + (float)color.getGreen() + "\" blue=\"" + (float)color.getBlue() + "\" opacity=\"" + (float)color.getOpacity() + "\"/>\n");
            this.fxWriter.write(string + "</diffuseColor>\n");
        }
        if ((image = phongMaterial.getDiffuseMap()) != null) {
            this.writeMap(n, "diffuseMap", image);
        }
        if ((image = phongMaterial.getSelfIlluminationMap()) != null) {
            this.writeMap(n, "selfIlluminationMap", image);
        }
        if ((color = phongMaterial.getSpecularColor()) != null) {
            this.fxWriter.write(string + "<specularColor>\n");
            this.fxWriter.write(string2 + "<Color red=\"" + (float)color.getRed() + "\" green=\"" + (float)color.getGreen() + "\" blue=\"" + (float)color.getBlue() + "\" opacity=\"" + (float)color.getOpacity() + "\"/>\n");
            this.fxWriter.write(string + "</specularColor>\n");
        }
        if ((image = phongMaterial.getSpecularMap()) != null) {
            this.writeMap(n, "specularMap", image);
        }
    }

    private void writeMap(int n, String string, Image image) throws IOException {
        String string2 = this.getTabs(n);
        String string3 = this.getTabs(n + 1);
        this.fxWriter.write(string2 + "<" + string + ">\n");
        Integer n2 = this.imNumMap.get(image);
        if (n2 != null && n2 > 1) {
            String string4 = this.sharedImMap.get(image);
            if (string4 == null) {
                ++this.imRef;
                string4 = "ImFxId_" + this.imRef;
                this.sharedImMap.put(image, string4);
                if (this.currImagePathMap != null) {
                    FilePath filePath = this.currImagePathMap.get(image);
                    this.fxWriter.write(string3 + "<Image fx:id=\"" + string4 + "\" url=\"@" + filePath.getImportedPath() + "\"/>\n");
                } else {
                    this.fxWriter.write(string3 + "<Image fx:id=\"" + string4 + "\" url=\"@" + "TODO" + "\"/>\n");
                }
            } else {
                this.fxWriter.write(string3 + "<fx:reference source=\"" + string4 + "\"/>\n");
            }
        } else if (this.currImagePathMap != null) {
            FilePath filePath = this.currImagePathMap.get(image);
            this.fxWriter.write(string3 + "<Image url=\"@" + filePath.getImportedPath() + "\"/>\n");
        } else {
            this.fxWriter.write(string3 + "<Image url=\"@" + "TODO" + "\"/>\n");
        }
        this.fxWriter.write(string2 + "</" + string + ">\n");
    }

    private void writeTriangleMeshArrays(int n, TriangleMesh triangleMesh) throws IOException {
        int n2;
        int n3;
        String string = this.getTabs(n);
        ObservableFloatArray observableFloatArray = triangleMesh.getPoints();
        int n4 = observableFloatArray.size() / 3;
        int n5 = 0;
        StringBuilder stringBuilder = new StringBuilder(n4 * 3 * 9);
        stringBuilder.append("<points>");
        if (this.coordScale > 0) {
            stringBuilder.append(this.getBigDecimal(observableFloatArray.get(0), this.coordScale));
            stringBuilder.append(this.space);
            stringBuilder.append(this.getBigDecimal(observableFloatArray.get(1), this.coordScale));
            stringBuilder.append(this.space);
            stringBuilder.append(this.getBigDecimal(observableFloatArray.get(2), this.coordScale));
            n5 = 3;
            for (n3 = 1; n3 < n4; ++n3) {
                stringBuilder.append(this.space);
                stringBuilder.append(this.getBigDecimal(observableFloatArray.get(n5++), this.coordScale));
                stringBuilder.append(this.space);
                stringBuilder.append(this.getBigDecimal(observableFloatArray.get(n5++), this.coordScale));
                stringBuilder.append(this.space);
                stringBuilder.append(this.getBigDecimal(observableFloatArray.get(n5++), this.coordScale));
            }
        } else {
            stringBuilder.append(Float.toString(observableFloatArray.get(0)));
            stringBuilder.append(this.space);
            stringBuilder.append(Float.toString(observableFloatArray.get(1)));
            stringBuilder.append(this.space);
            stringBuilder.append(Float.toString(observableFloatArray.get(2)));
            n5 = 3;
            for (n3 = 1; n3 < n4; ++n3) {
                stringBuilder.append(this.space);
                stringBuilder.append(Float.toString(observableFloatArray.get(n5++)));
                stringBuilder.append(this.space);
                stringBuilder.append(Float.toString(observableFloatArray.get(n5++)));
                stringBuilder.append(this.space);
                stringBuilder.append(Float.toString(observableFloatArray.get(n5++)));
            }
        }
        stringBuilder.append("</points>\n");
        this.fxWriter.write(string + stringBuilder.toString());
        ObservableFloatArray observableFloatArray2 = triangleMesh.getTexCoords();
        int n6 = observableFloatArray2.size() / 2;
        n5 = 2;
        stringBuilder = new StringBuilder(n6 * 2 * 9);
        stringBuilder.append("<texCoords>");
        if (this.texScale > 0) {
            stringBuilder.append(this.getBigDecimal(observableFloatArray2.get(0), this.texScale));
            stringBuilder.append(this.space);
            stringBuilder.append(this.getBigDecimal(observableFloatArray2.get(1), this.texScale));
            for (n2 = 1; n2 < n6; ++n2) {
                stringBuilder.append(this.space);
                stringBuilder.append(this.getBigDecimal(observableFloatArray2.get(n5++), this.texScale));
                stringBuilder.append(this.space);
                stringBuilder.append(this.getBigDecimal(observableFloatArray2.get(n5++), this.texScale));
            }
        } else {
            stringBuilder.append(Float.toString(observableFloatArray2.get(0)));
            stringBuilder.append(this.space);
            stringBuilder.append(Float.toString(observableFloatArray2.get(1)));
            for (n2 = 1; n2 < n6; ++n2) {
                stringBuilder.append(this.space);
                stringBuilder.append(Float.toString(observableFloatArray2.get(n5++)));
                stringBuilder.append(this.space);
                stringBuilder.append(Float.toString(observableFloatArray2.get(n5++)));
            }
        }
        stringBuilder.append("</texCoords>\n");
        this.fxWriter.write(string + stringBuilder.toString());
        ObservableFaceArray observableFaceArray = triangleMesh.getFaces();
        int n7 = observableFaceArray.size();
        stringBuilder = new StringBuilder(n7 * 6);
        stringBuilder.append("<faces>");
        stringBuilder.append(Integer.toString(observableFaceArray.get(0)));
        for (int i = 1; i < n7; ++i) {
            stringBuilder.append(this.space + Integer.toString(observableFaceArray.get(i)));
        }
        stringBuilder.append("</faces>\n");
        this.fxWriter.write(string + stringBuilder.toString());
        ObservableIntegerArray observableIntegerArray = triangleMesh.getFaceSmoothingGroups();
        n7 = observableIntegerArray.size();
        stringBuilder = new StringBuilder(n7 * 6);
        stringBuilder.append("<faceSmoothingGroups>");
        stringBuilder.append(Integer.toString(observableIntegerArray.get(0)));
        for (int i = 1; i < n7; ++i) {
            stringBuilder.append(this.space + Integer.toString(observableIntegerArray.get(i)));
        }
        stringBuilder.append("</faceSmoothingGroups>\n");
        this.fxWriter.write(string + stringBuilder.toString());
    }

    private String getBigDecimal(float f, int n) {
        if (this.isDropZeros) {
            String string = new BigDecimal(f).setScale(n, RoundingMode.HALF_UP).toPlainString();
            int n2 = string.indexOf(46);
            int n3 = n2;
            for (int i = string.length() - 1; i > n3; --i) {
                if (string.charAt(i) != '0') {
                    string = string.substring(0, i + 1);
                    break;
                }
                if (i != n2 + 1) continue;
                string = string.substring(0, i + 1);
                break;
            }
            return string;
        }
        return new BigDecimal(f).setScale(n, RoundingMode.HALF_UP).toString();
    }

    private void writeTransforms(int n, Node node) throws IOException {
        ObservableList observableList = node.getTransforms();
        if (observableList.size() < 1) {
            return;
        }
        String string = this.getTabs(n);
        String string2 = this.getTabs(n + 1);
        String string3 = this.getTabs(n + 2);
        String string4 = this.getTabs(n + 3);
        this.fxWriter.write(string + "<transforms>\n");
        for (Transform transform : observableList) {
            Affine affine;
            if (transform instanceof Affine) {
                affine = (Affine)transform;
                this.fxWriter.write(string2 + "<Affine mxx=\"" + (float)affine.getMxx() + "\" mxy=\"" + (float)affine.getMxy() + "\" mxz=\"" + (float)affine.getMxz() + "\" tx=\"" + (float)affine.getTx() + "\" " + "myx=\"" + (float)affine.getMyx() + "\" myy=\"" + (float)affine.getMyy() + "\" myz=\"" + (float)affine.getMyz() + "\" ty=\"" + (float)affine.getTy() + "\" " + "mzx=\"" + (float)affine.getMzx() + "\" mzy=\"" + (float)affine.getMzy() + "\" mzz=\"" + (float)affine.getMzz() + "\" tz=\"" + (float)affine.getTz() + "\"/>\n");
                continue;
            }
            if (transform instanceof Rotate) {
                affine = (Rotate)transform;
                Point3D point3D = affine.getAxis();
                this.fxWriter.write(string2 + "<Rotate angle=\"" + (float)affine.getAngle() + "\" pivotX=\"" + (float)affine.getPivotX() + "\" pivotY=\"" + (float)affine.getPivotY() + "\" pivotZ=\"" + (float)affine.getPivotZ() + "\">\n");
                this.fxWriter.write(string3 + "<axis>\n");
                this.fxWriter.write(string4 + "<Point3D x=\"" + (float)point3D.getX() + "\" y=\"" + (float)point3D.getY() + "\" z=\"" + (float)point3D.getZ() + "\"/>\n");
                this.fxWriter.write(string3 + "</axis>\n");
                this.fxWriter.write(string2 + "</Rotate>\n");
                continue;
            }
            if (transform instanceof Translate) {
                affine = (Translate)transform;
                this.fxWriter.write(string2 + "<Translate x=\"" + (float)affine.getX() + "\" y=\"" + (float)affine.getY() + "\" z=\"" + (float)affine.getZ() + "\"/>\n");
                continue;
            }
            if (transform instanceof Scale) {
                affine = (Scale)transform;
                this.fxWriter.write(string2 + "<Scale x=\"" + (float)affine.getX() + "\" y=\"" + (float)affine.getY() + "\" z=\"" + (float)affine.getZ() + "\" pivotX=\"" + (float)affine.getPivotX() + "\" pivotY=\"" + (float)affine.getPivotY() + "\" pivotZ=\"" + (float)affine.getPivotZ() + "\"/>\n");
                continue;
            }
            if (!(transform instanceof Shear)) continue;
            affine = (Shear)transform;
        }
        this.fxWriter.write(string + "</transforms>\n");
    }
}

