/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.modelbrowser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;

final class SystemProperties {
    private HashMap<String, ImageIOReader> readerClasses = new HashMap();
    private final String[] IOFormatNames = new String[]{"tga", "targa", "raw", "tif", "jpeg", "JFIF", "WBMP", "jpeg-ls", "jpeg-lossless", "PNM", "JPG", "wbmp", "PNG", "JPEG", "jpeg 2000", "tiff", "BMP", "JPEG2000", "RAW", "JPEG-LOSSLESS", "jpeg2000", "GIF", "TIF", "TIFF", "bmp", "jpg", "pnm", "png", "jfif", "gif", "JPEG-LS", "JPEG 2000"};

    SystemProperties() {
    }

    StringBuilder getSystemProps() {
        Object object;
        Object object2;
        String string = this.getPropValue("path.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n--- Operating System ------------------------------\n\n");
        stringBuilder.append(this.getSystemProp("os.name"));
        stringBuilder.append(this.getSystemProp("os.arch"));
        stringBuilder.append(this.getSystemProp("os.version"));
        stringBuilder.append("\n--- User ------------------------------------------\n\n");
        stringBuilder.append(this.getSystemProp("user.name"));
        stringBuilder.append(this.getSystemProp("user.language"));
        stringBuilder.append(this.getSystemProp("user.timezone"));
        stringBuilder.append(this.getSystemProp("user.home"));
        stringBuilder.append(this.getSystemProp("user.dir"));
        stringBuilder.append("\n--- Java System -----------------------------------\n\n");
        stringBuilder.append(this.getSystemProp("java.version"));
        stringBuilder.append(this.getSystemProp("java.runtime.version"));
        stringBuilder.append(this.getSystemProp("java.home"));
        String string2 = this.getPropValue("java.ext.dirs");
        if (!(string.startsWith("n.a.") || string.startsWith("Exception") || string2.startsWith("n.a.") || string2.startsWith("Exception"))) {
            object2 = string2.split(string);
            if (object2 != null) {
                stringBuilder.append("java.ext.dirs =\n");
                for (Object object3 : object2) {
                    stringBuilder.append("  - " + (String)object3 + "\n");
                }
            }
        } else {
            stringBuilder.append(this.getSystemProp("java.ext.dirs"));
        }
        stringBuilder.append(this.getSystemProp("java.io.tmpdir"));
        stringBuilder.append(this.getSystemProp("java.class.version"));
        object2 = this.getPropValue("java.class.path");
        if (!(string.startsWith("n.a.") || string.startsWith("Exception") || ((String)object2).startsWith("n.a.") || ((String)object2).startsWith("Exception"))) {
            object = ((String)object2).split(string);
            if (object != null) {
                stringBuilder.append("java.class.path =\n");
                for (Object object4 : object) {
                    stringBuilder.append("  - " + (String)object4 + "\n");
                }
            }
        } else {
            stringBuilder.append(this.getSystemProp("java.class.path"));
        }
        stringBuilder.append(this.getSystemProp("java.awt.graphicsenv"));
        stringBuilder.append(this.getSystemProp("java.vendor"));
        stringBuilder.append(this.getSystemProp("java.specification.version"));
        stringBuilder.append(this.getSystemProp("java.specification.vendor"));
        stringBuilder.append(this.getSystemProp("java.specification.name"));
        stringBuilder.append(this.getSystemProp("java.vm.version"));
        stringBuilder.append(this.getSystemProp("java.vm.vendor"));
        stringBuilder.append(this.getSystemProp("java.vm.name"));
        stringBuilder.append(this.getSystemProp("java.vm.info"));
        stringBuilder.append(this.getSystemProp("java.vm.specification.version"));
        stringBuilder.append(this.getSystemProp("java.vm.specification.vendor"));
        stringBuilder.append(this.getSystemProp("java.vm.specification.name"));
        object = this.getPropValue("java.library.path");
        if (!(string.startsWith("n.a.") || string.startsWith("Exception") || ((String)object).startsWith("n.a.") || ((String)object).startsWith("Exception"))) {
            String[] stringArray = ((String)object).split(string);
            if (stringArray != null) {
                stringBuilder.append("java.library.path =\n");
                for (String object5 : stringArray) {
                    stringBuilder.append("  - " + object5 + "\n");
                }
            }
        } else {
            stringBuilder.append(this.getSystemProp("java.library.path"));
        }
        stringBuilder.append("\n--- JavaFX ----------------------------------------\n\n");
        stringBuilder.append(this.getSystemProp("javafx.version"));
        stringBuilder.append(this.getSystemProp("javafx.runtime.version"));
        stringBuilder.append(this.getSystemProp("javafx.animation.fullspeed"));
        stringBuilder.append(this.getSystemProp("prism.dirtyopts"));
        stringBuilder.append(this.getSystemProp("prism.verbose"));
        stringBuilder.append(this.getSystemProp("quantum.multithreaded"));
        WritableImage writableImage = new WritableImage(10, 10);
        stringBuilder.append("\n");
        stringBuilder.append("PixelWriter's PixelFormat = " + writableImage.getPixelWriter().getPixelFormat().getType());
        stringBuilder.append("\n");
        stringBuilder.append("\n--- Java Image I/O Readers ------------------------\n\n");
        ImageIO.scanForPlugins();
        String[] stringArray = ImageIO.getReaderFormatNames();
        if (stringArray != null && stringArray.length > 0) {
            this.searchReaderClasses(stringArray);
        }
        if (this.IOFormatNames != null && this.IOFormatNames.length > 0) {
            this.searchReaderClasses(this.IOFormatNames);
        }
        if (!this.readerClasses.isEmpty()) {
            Set<String> set = this.readerClasses.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                ImageIOReader imageIOReader = this.readerClasses.get(iterator.next());
                stringBuilder.append("class = " + imageIOReader.pluginClassName + "\n");
                stringBuilder.append("  suffixes = " + imageIOReader.fileSuffixes + " /  format names = " + imageIOReader.formatNames + "\n");
                stringBuilder.append("  vendor = " + imageIOReader.vendorName + " / version = " + imageIOReader.version + "\n");
            }
        }
        stringBuilder.append("\n---------------------------------------------------\n");
        return stringBuilder;
    }

    private String getSystemProp(String string) {
        return string + " = " + this.getPropValue(string) + "\n";
    }

    private String getPropValue(String string) {
        String string2;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = "Exception = " + securityException.getMessage();
        }
        catch (NullPointerException nullPointerException) {
            string2 = "Exception = " + nullPointerException.getMessage();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = "Exception = " + illegalArgumentException.getMessage();
        }
        catch (Exception exception) {
            string2 = "Exception = " + exception.getMessage();
        }
        if (string2 == null) {
            string2 = "n.a.";
        }
        return string2;
    }

    private void searchReaderClasses(String[] stringArray) {
        ImageReaderSpi imageReaderSpi = null;
        for (String string : stringArray) {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
            while (iterator.hasNext()) {
                ImageIOReader imageIOReader;
                String string2;
                ImageReader imageReader = iterator.next();
                imageReaderSpi = imageReader.getOriginatingProvider();
                if (imageReaderSpi != null) {
                    string2 = imageReaderSpi.getPluginClassName();
                    if (this.readerClasses.containsKey(string2)) continue;
                    imageIOReader = new ImageIOReader();
                    imageIOReader.pluginClassName = string2;
                    imageIOReader.vendorName = imageReaderSpi.getVendorName();
                    imageIOReader.version = imageReaderSpi.getVersion();
                    String[] stringArray2 = imageReaderSpi.getFileSuffixes();
                    if (stringArray2 != null && stringArray2.length > 0) {
                        imageIOReader.fileSuffixes = "";
                        for (String string3 : stringArray2) {
                            imageIOReader.fileSuffixes = imageIOReader.fileSuffixes + string3 + " ";
                        }
                    }
                    if ((stringArray2 = imageReaderSpi.getFormatNames()) != null && stringArray2.length > 0) {
                        imageIOReader.formatNames = "";
                        for (String string3 : stringArray2) {
                            imageIOReader.formatNames = imageIOReader.formatNames + string3 + " ";
                        }
                    }
                    this.readerClasses.put(string2, imageIOReader);
                    continue;
                }
                string2 = imageReader.getClass().getName();
                if (this.readerClasses.containsKey(string2)) continue;
                imageIOReader = new ImageIOReader();
                imageIOReader.pluginClassName = string2;
                try {
                    imageIOReader.formatNames = imageReader.getFormatName();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.readerClasses.put(string2, imageIOReader);
            }
        }
    }

    private static final class ImageIOReader {
        String pluginClassName = null;
        String vendorName = "NA";
        String version = "NA";
        String fileSuffixes = "NA";
        String formatNames = "NA";

        private ImageIOReader() {
        }
    }
}

