package com.interactivemesh.j3d.sourcecode.boundingline;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;

import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Locale;
import javax.media.j3d.Material;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;

import javax.swing.JFrame;
import javax.swing.JPanel;

import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseWheelZoom;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;

/**
 * @author Copyright (c) 2007 August Lammersdorf, www.InteractiveMesh.com
 * @since March 31, 2007
 * @version 1.0
 *
 * Please create your own implementation.
 * You are allowed to copy all lines you like of this source code, 
 * but you may not modify, compile, or distribute this 'CharBoundingLine'. 
 * 
 * 
 */
public final class CharBoundingLine {
	
	static {
		System.out.println("CharBoundingLine: Copyright (c) 2007 August Lammersdorf, www.InteractiveMesh.com.");
	}

	private	Canvas3D 		canvas3D 	=	null;
	private Locale 			locale 		= 	null;
	
	private BranchGroup 	sceneBranch = 	null;
	private BranchGroup 	viewBranch 	= 	null;
	private BranchGroup 	enviBranch 	= 	null;
	
	private TransformGroup 	characterTG = 	null;
	
	public static void main(String[] args) {
		new CharBoundingLine();
	}

	public CharBoundingLine() {
		createUniverse();
		addShape();
		setLive();
		showCanvas3D();
	}
	
	private void addShape() {
		
		// Line color
		Color3f lineColor = new Color3f(1.0f, 0.0f, 0.0f);
		
		//
	    // Character geometry
    	//
        Font font = new Font("Dialog", Font.PLAIN, 1);
        Font3D font3D = new Font3D(font, 0.001, new FontExtrusion());

        // Unicode code point of desired character
        char[] chars = Character.toChars(174);

        // Used as source for the needed geometries
        TriangleArray charTriangleArray = (TriangleArray)font3D.getGlyphGeometry(chars[0]);
        int vertexCount = charTriangleArray.getVertexCount();
        
        float[] coords = new float[vertexCount * 3];
        float[] normals = new float[vertexCount * 3];
        charTriangleArray.getCoordinates(0, coords);
        charTriangleArray.getNormals(0, normals);
    	
    	// Geometry of front shape
        TriangleArray geometryFront = new TriangleArray(
        	vertexCount, 
            GeometryArray.COORDINATES | GeometryArray.NORMALS | GeometryArray.BY_REFERENCE);
        geometryFront.setCoordRefFloat(coords);
        geometryFront.setNormalRefFloat(normals);

		// Shared geometry of middle and back shape
        TriangleArray geometryMidBack = new TriangleArray(
        	vertexCount,
        	GeometryArray.COORDINATES | GeometryArray.BY_REFERENCE);
        geometryMidBack.setCoordRefFloat(coords);
        
        //
		// Back Appearance: ColoringAttributes, LineAttributes, PolygonAttributes, RenderingAttributes
        //
		Appearance appearBack = new Appearance();
		
		ColoringAttributes colAttrB = new ColoringAttributes();
		colAttrB.setColor(lineColor);
		
		LineAttributes lineAttrB = new LineAttributes();
		lineAttrB.setLineAntialiasingEnable(true);
		lineAttrB.setLineWidth(4); 
		
		PolygonAttributes polyAttrB = new PolygonAttributes();
		polyAttrB.setPolygonMode(PolygonAttributes.POLYGON_LINE);
		polyAttrB.setCullFace(PolygonAttributes.CULL_FRONT);
		
		RenderingAttributes rendAttrB = new RenderingAttributes();
		rendAttrB.setDepthTestFunction(RenderingAttributes.NOT_EQUAL);
		
		appearBack.setColoringAttributes(colAttrB);
		appearBack.setPolygonAttributes(polyAttrB);
		appearBack.setLineAttributes(lineAttrB);
		appearBack.setRenderingAttributes(rendAttrB);

        //
		// Middle Appearance: ColoringAttributes, RenderingAttributes
        //
		Appearance appearMiddle = new Appearance();
		
		ColoringAttributes colAttrM = new ColoringAttributes();
		colAttrM.setColor(lineColor); 
		
		RenderingAttributes rendAttrM = new RenderingAttributes();
		rendAttrM.setDepthTestFunction(RenderingAttributes.NOT_EQUAL);
		
		appearMiddle.setColoringAttributes(colAttrM);
		appearMiddle.setRenderingAttributes(rendAttrM);

		//
		// Front Appearance: Material
		//
		Appearance appearFront = new Appearance();
		
		Material matF = new Material();
		matF.setDiffuseColor(1.0f, 1.0f, 0.0f);
		matF.setSpecularColor(0.0f, 0.0f, 0.0f);

		appearFront.setMaterial(matF);

        //
		// Shapes
		//
		Shape3D shapeBack = new Shape3D(geometryMidBack, appearBack);		
		Shape3D shapeMiddle = new Shape3D(geometryMidBack, appearMiddle);
		Shape3D shapeFront = new Shape3D(geometryFront, appearFront);		
		
		OrderedGroup orderedGroup = new OrderedGroup();
		orderedGroup.addChild(shapeBack);
		orderedGroup.addChild(shapeMiddle);
		orderedGroup.addChild(shapeFront);

		characterTG.addChild(orderedGroup);
	}
	
    // Set live
	private void setLive() {
		sceneBranch.compile();
		viewBranch.compile();
		enviBranch.compile();
        locale.addBranchGraph(sceneBranch);
        locale.addBranchGraph(viewBranch);
        locale.addBranchGraph(enviBranch);
	}
	
    private void createUniverse() {		
        // Bounds
    	BoundingSphere globalBounds = new BoundingSphere();
        globalBounds.setRadius(Double.MAX_VALUE);		
        //
        // Viewing
        //
        View view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        view.setBackClipDistance(5.0);
        view.setFrontClipDistance(0.005);
        
        GraphicsConfigTemplate3D gCT = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(gCT);
        
        try {
        	canvas3D = new Canvas3D(gcfg);
        }
        catch (NullPointerException e) {
            System.out.println("CharBoundingLine: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.out.println("CharBoundingLine: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }               
        // 
    	view.addCanvas3D(canvas3D);
        //
        // SuperStructure
        //
        VirtualUniverse vu = new VirtualUniverse();
        locale = new Locale(vu);        
        //
        // BranchGraphs
        //		
        sceneBranch = new BranchGroup();
        viewBranch = new BranchGroup();
        enviBranch = new BranchGroup();
        
        // ViewBranch
        
        TransformGroup viewTG = new TransformGroup();
        viewTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        Transform3D viewTransform = new Transform3D();
        viewTransform.setTranslation(new Vector3f(0.0f, 0.0f, 1.5f));
        viewTG.setTransform(viewTransform);
                
        ViewPlatform vp = new ViewPlatform();
        view.attachViewPlatform(vp);
        
        DirectionalLight headLight = new DirectionalLight();
        headLight.setInfluencingBounds(globalBounds);

        viewTG.addChild(vp);
        viewTG.addChild(headLight);
        viewBranch.addChild(viewTG);
        
        // EnviBranch
        
        Background bg = new Background();
        bg.setApplicationBounds(globalBounds);
        bg.setColor(0.9f, 0.9f, 0.9f);
        
        enviBranch.addChild(bg);

        // SceneBranch
        
        TransformGroup navigationTG = new TransformGroup();
        navigationTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        Transform3D mTransform = new Transform3D();
        // Rotate a little bit
        mTransform.setEuler(new Vector3d(0.0, -0.4, 0.0));
        navigationTG.setTransform(mTransform);
        sceneBranch.addChild(navigationTG);
        
        characterTG = new TransformGroup();        
        // Center of character 174
        Transform3D charTransform = new Transform3D();
        charTransform.setTranslation(new Vector3f(-0.3671875f, -0.359375f, -0.1f));
        characterTG.setTransform(charTransform);

        navigationTG.addChild(characterTG);
        
        // MouseRotate
        MouseRotate mouseRotate = new MouseRotate(canvas3D, navigationTG);
        mouseRotate.setSchedulingBounds(globalBounds);
        sceneBranch.addChild(mouseRotate);
        // MouseTranslate 
        MouseTranslate mouseTrans = new MouseTranslate(canvas3D, navigationTG);
        mouseTrans.setSchedulingBounds(globalBounds);
        sceneBranch.addChild(mouseTrans);
        // MouseWheelZoom 
        MouseWheelZoom mouseWZoom = new MouseWheelZoom(canvas3D, navigationTG);
        mouseWZoom.setSchedulingBounds(globalBounds);
        sceneBranch.addChild(mouseWZoom);
        // MouseZoom
        MouseZoom mouseZoom = new MouseZoom(canvas3D, navigationTG);
        mouseZoom.setSchedulingBounds(globalBounds);
        sceneBranch.addChild(mouseZoom);
    }
    
	private void showCanvas3D() {
		
		JPanel jPanel = new JPanel(new BorderLayout());
		jPanel.setPreferredSize(new Dimension(500, 500));
		jPanel.add(canvas3D);
		
		JFrame jFrame = new JFrame();
		jFrame.setTitle("InteractiveMesh : CharBoundingLine");
		jFrame.setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		jFrame.add(jPanel);
		jFrame.pack();
		
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension jframeDim = jFrame.getSize();
        jFrame.setLocation((screenDim.width - jframeDim.width)/2, (screenDim.height - jframeDim.height)/2);

		jFrame.setVisible(true);
	}	
}
