/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdesktop.j3d.loaders.vrml97.VrmlScene;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.Scene;
import vrml.InvalidVRMLSyntaxException;

public class VrmlLoader
extends LoaderBase {
    Loader loader = new Loader(null, 0);

    public VrmlLoader(int flags) {
        super(flags);
    }

    public VrmlLoader() {
        this(0);
    }

    public com.sun.j3d.loaders.Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        Scene scene;
        try {
            this.loader.setWorldURL(this.baseUrl, null);
        }
        catch (MalformedURLException e) {
            FileNotFoundException f = new FileNotFoundException("BaseUrl: " + this.baseUrl);
            f.initCause(e);
            throw f;
        }
        try {
            scene = this.loader.load(reader);
        }
        catch (InvalidVRMLSyntaxException e) {
            e.printStackTrace();
            ParsingErrorException p = new ParsingErrorException();
            p.initCause((Throwable)e);
            throw p;
        }
        return new VrmlScene(scene);
    }

    public com.sun.j3d.loaders.Scene load(String pathname) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        URL url = null;
        try {
            url = this.pathToURL(pathname);
        }
        catch (MalformedURLException e) {
            FileNotFoundException f = new FileNotFoundException("Loading: " + pathname);
            f.initCause(e);
            throw f;
        }
        try {
            this.loader.setWorldURL(this.pathToURL(this.basePath), url);
        }
        catch (MalformedURLException e) {
            FileNotFoundException f = new FileNotFoundException("BasePath: " + this.basePath);
            f.initCause(e);
            throw f;
        }
        return this.doLoad(url);
    }

    public com.sun.j3d.loaders.Scene load(URL url) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        try {
            this.loader.setWorldURL(this.baseUrl, url);
        }
        catch (MalformedURLException e) {
            FileNotFoundException f = new FileNotFoundException("BaseUrl: " + this.baseUrl);
            f.initCause(e);
            throw f;
        }
        return this.doLoad(url);
    }

    private com.sun.j3d.loaders.Scene doLoad(URL url) throws ParsingErrorException, FileNotFoundException {
        Scene scene;
        try {
            scene = this.loader.load(url);
        }
        catch (IOException e) {
            FileNotFoundException f = new FileNotFoundException(url.toString());
            f.initCause(e);
            throw f;
        }
        catch (InvalidVRMLSyntaxException e) {
            ParsingErrorException p = new ParsingErrorException(url.toString());
            p.initCause((Throwable)e);
            throw p;
        }
        return new VrmlScene(scene);
    }

    private URL pathToURL(String path) throws MalformedURLException {
        URL retval = null;
        if (path == null) {
            return null;
        }
        if (!path.startsWith(File.separator) && path.indexOf(58) != 1) {
            path = String.valueOf(System.getProperties().getProperty("user.dir")) + '/' + path;
        }
        path = path.replace(File.separatorChar, '/');
        retval = new URL("file:" + path);
        return retval;
    }
}

