/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import org.jdesktop.j3d.loaders.vrml97.impl.BaseNode;
import org.jdesktop.j3d.loaders.vrml97.impl.ConstField;
import org.jdesktop.j3d.loaders.vrml97.impl.ConstMFNode;
import org.jdesktop.j3d.loaders.vrml97.impl.ConstSFNode;
import org.jdesktop.j3d.loaders.vrml97.impl.Field;
import org.jdesktop.j3d.loaders.vrml97.impl.MField;
import org.jdesktop.j3d.loaders.vrml97.impl.SFNode;

public class MFNode
extends MField {
    BaseNode[] nodes;

    public MFNode() {
        this.nodes = new BaseNode[0];
    }

    public MFNode(BaseNode[] values) {
        this.nodes = new BaseNode[values.length];
        System.arraycopy(values, 0, this.nodes, 0, values.length);
    }

    public void getValue(BaseNode[] values) {
        System.arraycopy(this.nodes, 0, values, 0, this.nodes.length);
    }

    public BaseNode[] getValue() {
        return this.nodes;
    }

    public void setValue(BaseNode[] values) {
        this.nodes = new BaseNode[values.length];
        System.arraycopy(values, 0, this.nodes, 0, values.length);
        this.route();
    }

    public void setValue(int size, BaseNode[] value) {
        this.setValue(value);
    }

    public void setValue(MFNode node) {
        this.setValue(node.nodes);
    }

    public void setValue(ConstMFNode constNode) {
        this.setValue((MFNode)constNode.ownerField);
    }

    public BaseNode get1Value(int index) {
        return this.nodes[index];
    }

    public void set1Value(int index, BaseNode f) {
        this.nodes[index] = f;
        this.route();
    }

    public void set1Value(int index, ConstSFNode csfn) {
        this.set1Value(index, (SFNode)csfn.ownerField);
    }

    public void set1Value(int index, SFNode sfnod) {
        this.set1Value(index, sfnod.node);
    }

    public void addValue(BaseNode f) {
        BaseNode[] temp = new BaseNode[this.nodes.length + 1];
        int i = 0;
        while (i < temp.length - 1) {
            temp[i] = this.nodes[i];
            ++i;
        }
        temp[temp.length - 1] = f;
        this.nodes = temp;
        this.route();
    }

    public void addValue(ConstSFNode constsfnod) {
        this.addValue((SFNode)constsfnod.ownerField);
    }

    public void addValue(SFNode sfnod) {
        this.addValue(sfnod.node);
    }

    public void insertValue(int index, BaseNode f) {
        BaseNode[] temp = new BaseNode[this.nodes.length + 1];
        int i = 0;
        while (i < index) {
            temp[i] = this.nodes[i];
            ++i;
        }
        temp[index] = f;
        i = index + 1;
        while (i < temp.length + 1) {
            temp[i] = this.nodes[i - 1];
            ++i;
        }
        this.nodes = temp;
        this.route();
    }

    public void insertValue(int index, ConstSFNode constsfnod) {
        this.insertValue(index, (SFNode)constsfnod.ownerField);
    }

    public void insertValue(int index, SFNode constsfnod) {
        this.insertValue(index, constsfnod.node);
    }

    public synchronized void update(Field field) {
        this.setValue((MFNode)field);
    }

    public synchronized Object clone() {
        MFNode ref = new MFNode(this.nodes);
        int i = 0;
        while (i < ref.nodes.length) {
            if (this.nodes[i] != null) {
                BaseNode cloneNode;
                ref.nodes[i] = cloneNode = (BaseNode)this.nodes[i].clone();
                if (this.nodes[i].loader.debug) {
                    System.out.println("MFNode.clone(): child " + i + " = " + cloneNode.toStringId() + " = " + cloneNode);
                }
                this.nodes[i].loader.registerClone(this.nodes[i], cloneNode);
                this.nodes[i].loader.cleanUp();
            }
            ++i;
        }
        return ref;
    }

    public synchronized ConstField constify() {
        if (this.constField == null) {
            this.constField = new ConstMFNode(this);
        }
        return this.constField;
    }

    public int getSize() {
        return this.nodes.length;
    }

    public void clear() {
        this.nodes = null;
    }

    public void delete(int n) {
    }

    public vrml.Field wrap() {
        return new vrml.field.MFNode(this);
    }

    public String toString() {
        String retval = "[\n";
        int i = 0;
        while (i < this.nodes.length) {
            retval = String.valueOf(retval) + this.nodes[i] + "\n";
            ++i;
        }
        retval = String.valueOf(retval) + "]\n";
        return retval;
    }
}

