/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.gui;

import com.interactivemesh.j3d.community.gui.FXCanvas3DRepainter;
import com.sun.j3d.exp.swing.impl.AutoOffScreenCanvas3D;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class FXCanvas3DDB
extends JPanel
implements AncestorListener {
    private static double METERS_PER_PIXEL = 2.8222222222222223E-4;
    private GraphicsConfiguration graphicsConfig = null;
    private OffscreenCanvas3D canvas = null;
    private long wakeupEventMasks = 0L;
    private BufferedImage paintImage = null;
    private int[] paintIntBuffer = null;
    private int[] renderIntBuffer = null;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private ReentrantLock imageAccessLock = null;
    private Condition imageCopyCondition = null;
    private Condition imageResizeCondition = null;
    private volatile boolean isImageCopied = false;
    private volatile boolean isRendererLocked = false;
    private FXCanvas3DRepainter repainter = null;

    public FXCanvas3DDB() {
        this(null, null);
    }

    public FXCanvas3DDB(GraphicsDevice device) {
        this(null, device);
    }

    public FXCanvas3DDB(GraphicsConfigTemplate3D template) {
        this(template, null);
    }

    public FXCanvas3DDB(GraphicsConfigTemplate3D template, GraphicsDevice device) {
        if (template == null) {
            template = new GraphicsConfigTemplate3D();
        }
        template.setStereo(3);
        template.setDoubleBuffer(3);
        this.graphicsConfig = device == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template) : device.getBestConfiguration((GraphicsConfigTemplate)template);
        this.addAncestorListener(this);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.enableEvents(1L);
        this.imageAccessLock = new ReentrantLock();
        this.imageCopyCondition = this.imageAccessLock.newCondition();
        this.imageResizeCondition = this.imageAccessLock.newCondition();
    }

    public void setRepainter(FXCanvas3DRepainter painter) {
        this.repainter = painter;
    }

    public void copyOffScreenBuffer() {
        if (this.paintImage != null) {
            boolean isLocked = false;
            try {
                try {
                    isLocked = this.imageAccessLock.tryLock(50L, TimeUnit.MILLISECONDS);
                    System.arraycopy(this.renderIntBuffer, 0, this.paintIntBuffer, 0, this.renderIntBuffer.length);
                    this.isImageCopied = true;
                    if (isLocked) {
                        this.imageCopyCondition.signal();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (isLocked) {
                        this.imageAccessLock.unlock();
                    }
                }
            }
            finally {
                if (isLocked) {
                    this.imageAccessLock.unlock();
                }
            }
        }
    }

    public void ancestorAdded(AncestorEvent event) {
        Dimension sz = this.getSize();
        if (sz.width < 1) {
            sz.width = 100;
        }
        if (sz.height < 1) {
            sz.height = 100;
        }
        this.createCanvas(sz.width, sz.height);
        this.canvas.addNotifyFlag = true;
        this.canvas.addNotify();
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.canvas.removeNotify();
    }

    public Canvas3D getOffscreenCanvas3D() {
        if (this.canvas == null) {
            this.createCanvas(this.getWidth(), this.getHeight());
        }
        return this.canvas;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.createCanvas(width, height);
    }

    private void createCanvas(int width, int height) {
        if (this.getParent() == null) {
            return;
        }
        final int w = Math.max(1, width);
        final int h = Math.max(1, height);
        if (this.canvas == null) {
            this.canvas = new OffscreenCanvas3D(this.graphicsConfig);
        } else if (this.canvas.getWidth() == w && this.canvas.getHeight() == h) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.canvas.createOffScreenBuffer(this.graphicsConfig.getBounds(), w, h);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FXCanvas3DDB.this.canvas.createOffScreenBuffer(FXCanvas3DDB.this.graphicsConfig.getBounds(), w, h);
                }
            });
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.paintImage == null || !this.canvas.isRendererRunning()) {
            return;
        }
        g.drawImage(this.paintImage, 0, this.imageHeight, this.imageWidth, 0, 0, 0, this.imageWidth, this.imageHeight, null);
    }

    public void enableWakeupOnAWTEvents(long eventMasks) {
        if ((eventMasks & 1L) != 0L) {
            this.wakeupEventMasks |= 1L;
        }
        if ((eventMasks & 4L) != 0L) {
            this.wakeupEventMasks |= 4L;
        }
        if ((eventMasks & 8L) != 0L) {
            this.wakeupEventMasks |= 8L;
        }
        if ((eventMasks & 0x10L) != 0L) {
            this.wakeupEventMasks |= 0x10L;
        }
        if ((eventMasks & 0x20L) != 0L) {
            this.wakeupEventMasks |= 0x20L;
        }
        if ((eventMasks & 0x20000L) != 0L) {
            this.wakeupEventMasks |= 0x20000L;
        }
        this.enableEvents(this.wakeupEventMasks);
    }

    public void disableWakeupOnAWTEvents(long eventMasks) {
        this.wakeupEventMasks &= eventMasks ^ 0xFFFFFFFFFFFFFFFFL;
        this.disableEvents(eventMasks);
    }

    protected void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        if ((this.wakeupEventMasks & 1L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processComponentEvent(e);
            e.setSource(src);
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if ((this.wakeupEventMasks & 4L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processFocusEvent(e);
            e.setSource(src);
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if ((this.wakeupEventMasks & 8L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processKeyEvent(e);
            e.setSource(src);
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if ((this.wakeupEventMasks & 0x10L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processMouseEvent(e);
            e.setSource(src);
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if ((this.wakeupEventMasks & 0x20L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processMouseMotionEvent(e);
            e.setSource(src);
        }
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
        if ((this.wakeupEventMasks & 0x20000L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processMouseWheelEvent(e);
            e.setSource(src);
        }
    }

    private final class OffscreenCanvas3D
    extends Canvas3D
    implements AutoOffScreenCanvas3D {
        private BufferedImage renderImage;
        private boolean isWatingForResizing;
        private boolean addNotifyFlag;
        private Runnable repaintCall;
        private static final int LIMIT = 200000000;

        private OffscreenCanvas3D(GraphicsConfiguration graphicsConfiguration) {
            super(graphicsConfiguration, true);
            this.renderImage = null;
            this.isWatingForResizing = false;
            this.addNotifyFlag = false;
            this.repaintCall = null;
            this.repaintCall = new RepaintCall();
        }

        private void createOffScreenBuffer(Rectangle screenRect, int width, int height) {
            this.stopRenderer();
            int screenWidth = (int)screenRect.getWidth();
            int screenHeight = (int)screenRect.getHeight();
            Screen3D screen3D = this.getScreen3D();
            screen3D.setSize(screenWidth, screenHeight);
            screen3D.setPhysicalScreenWidth((double)screenWidth * METERS_PER_PIXEL);
            screen3D.setPhysicalScreenHeight((double)screenHeight * METERS_PER_PIXEL);
            if (this.renderImage != null) {
                this.renderImage.flush();
            }
            if (FXCanvas3DDB.this.paintImage != null) {
                FXCanvas3DDB.this.paintImage.flush();
            }
            this.renderImage = new BufferedImage(width, height, 2);
            ImageComponent2D image = new ImageComponent2D(2, this.renderImage, true, true);
            image.setCapability(2);
            image.setCapability(3);
            FXCanvas3DDB.this.paintImage = new BufferedImage(width, height, 2);
            FXCanvas3DDB.this.paintIntBuffer = ((DataBufferInt)FXCanvas3DDB.this.paintImage.getRaster().getDataBuffer()).getData();
            FXCanvas3DDB.this.renderIntBuffer = ((DataBufferInt)this.renderImage.getRaster().getDataBuffer()).getData();
            FXCanvas3DDB.this.imageWidth = width;
            FXCanvas3DDB.this.imageHeight = height;
            try {
                FXCanvas3DDB.this.imageAccessLock.lock();
                this.isWatingForResizing = true;
                while (FXCanvas3DDB.this.isRendererLocked) {
                    FXCanvas3DDB.this.isImageCopied = true;
                    FXCanvas3DDB.this.imageCopyCondition.signal();
                    try {
                        FXCanvas3DDB.this.imageResizeCondition.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.isWatingForResizing = false;
                this.waitForOffScreenRendering();
                try {
                    this.setOffScreenBuffer(image);
                }
                catch (RestrictedAccessException e) {
                    this.createOffScreenBuffer(screenRect, width, height);
                    System.out.println("Repeat : createOffScreenBuffer(screenRect, width, height) !!");
                }
            }
            finally {
                FXCanvas3DDB.this.imageAccessLock.unlock();
            }
            this.startRenderer();
        }

        public void addNotify() {
            if (!this.addNotifyFlag) {
                throw new UnsupportedOperationException("User must not call this method !!");
            }
            this.addNotifyFlag = false;
            super.addNotify();
        }

        public Container getParent() {
            return FXCanvas3DDB.this.getParent();
        }

        public void postSwap() {
            if (this.isRendererRunning()) {
                try {
                    FXCanvas3DDB.this.imageAccessLock.lock();
                    FXCanvas3DDB.this.isImageCopied = false;
                    SwingUtilities.invokeLater(this.repaintCall);
                    while (!FXCanvas3DDB.this.isImageCopied) {
                        FXCanvas3DDB.this.isRendererLocked = true;
                        try {
                            FXCanvas3DDB.this.imageCopyCondition.awaitNanos(200000000L);
                            FXCanvas3DDB.this.isImageCopied = true;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    FXCanvas3DDB.this.isRendererLocked = false;
                    if (this.isWatingForResizing) {
                        FXCanvas3DDB.this.imageResizeCondition.signal();
                    }
                }
                finally {
                    FXCanvas3DDB.this.imageAccessLock.unlock();
                }
            }
        }

        protected void processComponentEvent(ComponentEvent e) {
            super.processComponentEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
        }

        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            super.processMouseWheelEvent(e);
        }

        private final class RepaintCall
        implements Runnable {
            private RepaintCall() {
            }

            public void run() {
                if (FXCanvas3DDB.this.repainter != null) {
                    FXCanvas3DDB.this.repainter.repaintFXCanvas3D();
                }
            }
        }
    }
}

