package com.interactivemesh.j3d.community.gui;

/*
 * 
 * License notice see "com.interactivemesh.j3d.community.gui.FXCanvas3DImage.java"
 *
 */
/**
 * The corresponding JavaFX SwingComponent class has to implement this interface 
 * to enable the FXCanvas3DImage object to initialize its repainting and 
 * to inform about its resizing. Both methods are called on the event-dispatching thread.
 * 
 * @see FXCanvas3DImage
 */
public interface FXCanvas3DImageRepainter { 

    /** 
     * Called by the FXCanvas3DImage object from the postSwap-method to initialize its repainting.
     * <p>
     * The repaint request is handled by a FX.deferAction() 
     * - an equivalent to SwingUtilities.invokeLater() - 
     * and will be executed on the EDT. 
     * </p>
     */
    public void repaintFXCanvas3DImage();       
    
    /**
     * Called by the FXCanvas3DImage object when it was resized.
     * 
     */
    public void onFXCanvas3DImageResized();  
}
