/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.gui;

import com.interactivemesh.j3d.community.gui.FXCanvas3DMV;
import com.interactivemesh.j3d.community.gui.FXCanvas3DMVRepainter;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.swing.SwingUtilities;

public class FXCanvas3DMVControl {
    private FXCanvas3DMV[] fxCanvas3DMVs = null;
    private int fxCanvas3DLength = 0;
    private int fxCancvas3DMVCount = 0;
    private int fxCanvas3DMVDone = 0;
    private boolean[] canvasToRender = null;
    private ReentrantLock imageAccessLock = new ReentrantLock();
    private Condition imageCopyCondition = this.imageAccessLock.newCondition();
    private Condition imageResizeCondition = this.imageAccessLock.newCondition();
    private volatile boolean isImageCopied = false;
    private volatile boolean isRendererLocked = false;
    private volatile boolean isResizing = false;
    private long swapTimeCurr = 0L;
    private long swapTimeLast = 0L;
    private FXCanvas3DMVRepainter repainter = null;
    private Runnable repaintCall = new RepaintCall();
    private static final int LIMIT_WAIT = 200000000;
    private static final int LIMIT_SWAP = 400000000;

    public FXCanvas3DMVControl(FXCanvas3DMV[] fxCanvas3Ds) {
        this.fxCanvas3DLength = fxCanvas3Ds.length;
        this.fxCanvas3DMVs = new FXCanvas3DMV[this.fxCanvas3DLength];
        this.canvasToRender = new boolean[this.fxCanvas3DLength];
        int i = 0;
        while (i < this.fxCanvas3DLength) {
            this.fxCanvas3DMVs[i] = fxCanvas3Ds[i];
            this.fxCanvas3DMVs[i].setFXCanvas3DMVControl(this, i);
            ++i;
        }
    }

    public void setRepainter(FXCanvas3DMVRepainter painter) {
        this.repainter = painter;
    }

    void createOffScreenCanvas(int index, int width, int height) {
        try {
            this.imageAccessLock.lock();
            while (this.isRendererLocked) {
                this.isImageCopied = true;
                this.imageCopyCondition.signal();
                try {
                    this.imageResizeCondition.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.isResizing = true;
            this.fxCanvas3DMVs[index].startStopRenderer(false);
            this.fxCanvas3DMVs[index].createOffScreenCanvas(width, height);
            this.fxCanvas3DMVs[index].startStopRenderer(true);
        }
        finally {
            this.isResizing = false;
            this.imageAccessLock.unlock();
        }
    }

    public void setFXCanvas3DMVSize(int width, int height) {
        try {
            FXCanvas3DMV c3dmv;
            this.imageAccessLock.lock();
            while (this.isRendererLocked) {
                this.isImageCopied = true;
                this.imageCopyCondition.signal();
                try {
                    this.imageResizeCondition.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.isResizing = true;
            FXCanvas3DMV[] fXCanvas3DMVArray = this.fxCanvas3DMVs;
            int n = this.fxCanvas3DMVs.length;
            int n2 = 0;
            while (n2 < n) {
                c3dmv = fXCanvas3DMVArray[n2];
                c3dmv.startStopRenderer(false);
                ++n2;
            }
            fXCanvas3DMVArray = this.fxCanvas3DMVs;
            n = this.fxCanvas3DMVs.length;
            n2 = 0;
            while (n2 < n) {
                c3dmv = fXCanvas3DMVArray[n2];
                c3dmv.createOffScreenCanvas(width, height);
                ++n2;
            }
            fXCanvas3DMVArray = this.fxCanvas3DMVs;
            n = this.fxCanvas3DMVs.length;
            n2 = 0;
            while (n2 < n) {
                c3dmv = fXCanvas3DMVArray[n2];
                c3dmv.startStopRenderer(true);
                ++n2;
            }
        }
        finally {
            this.isResizing = false;
            this.imageAccessLock.unlock();
        }
    }

    public void copyBuffersAndRepaint() {
        int i;
        try {
            this.imageAccessLock.lock();
            i = 0;
            while (i < this.fxCanvas3DLength) {
                if (this.canvasToRender[i]) {
                    this.fxCanvas3DMVs[i].copyOffScreenBuffer();
                }
                ++i;
            }
            this.isImageCopied = true;
            this.imageCopyCondition.signal();
        }
        finally {
            this.imageAccessLock.unlock();
        }
        i = 0;
        while (i < this.fxCanvas3DLength) {
            if (this.canvasToRender[i]) {
                this.fxCanvas3DMVs[i].repaint();
            }
            ++i;
        }
    }

    void postSwapFXCanvas3DMV(int canvasIndex) {
        if (this.isResizing) {
            return;
        }
        this.swapTimeCurr = System.nanoTime();
        if (this.swapTimeCurr - this.swapTimeLast > 400000000L) {
            this.fxCanvas3DMVDone = 0;
        }
        this.swapTimeLast = this.swapTimeCurr;
        if (this.fxCanvas3DMVDone == 0) {
            this.fxCancvas3DMVCount = 0;
            Canvas3D canvas3D = null;
            FXCanvas3DMV canvas3DMV = null;
            int i = 0;
            while (i < this.fxCanvas3DLength) {
                if (i == canvasIndex) {
                    this.canvasToRender[i] = true;
                    ++this.fxCancvas3DMVCount;
                } else {
                    canvas3DMV = this.fxCanvas3DMVs[i];
                    int index = canvas3DMV.getFXCanvas3DMVIndex();
                    this.canvasToRender[index] = false;
                    if (canvas3DMV.isCanvas3DCreated()) {
                        ViewPlatform vp;
                        canvas3D = canvas3DMV.getOffscreenCanvas3D();
                        View view = canvas3D.getView();
                        if (canvas3D.isRendererRunning() && view != null && (vp = view.getViewPlatform()) != null && vp.isLive() && canvas3DMV.isShowing()) {
                            this.canvasToRender[index] = true;
                            ++this.fxCancvas3DMVCount;
                        }
                    }
                }
                ++i;
            }
        }
        ++this.fxCanvas3DMVDone;
        if (this.fxCanvas3DMVDone < this.fxCancvas3DMVCount) {
            return;
        }
        this.fxCanvas3DMVDone = 0;
        try {
            this.imageAccessLock.lock();
            this.isImageCopied = false;
            this.isRendererLocked = true;
            SwingUtilities.invokeLater(this.repaintCall);
            while (!this.isImageCopied) {
                try {
                    this.imageCopyCondition.awaitNanos(200000000L);
                    this.isImageCopied = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.isRendererLocked = false;
            this.imageResizeCondition.signal();
        }
        finally {
            this.imageAccessLock.unlock();
        }
    }

    private final class RepaintCall
    implements Runnable {
        private RepaintCall() {
        }

        public void run() {
            if (FXCanvas3DMVControl.this.repainter != null) {
                FXCanvas3DMVControl.this.repainter.repaintFXCanvas3DMV();
            }
        }
    }
}

