package com.interactivemesh.j3d.community.gui;

/*
 * LICENSE
 * 
 * FXCanvas3DMV API 1.1
 * 
 * This API is a derived work of the Java 3D utility class "com.sun.j3d.exp.swing.JCanvas3D.java"
 * 
 * and includes the files
 * 
 * - "com.interactivemesh.j3d.community.gui.FXCanvas3DMV.java"
 * - "com.interactivemesh.j3d.community.gui.FXCanvas3DMVControl.java" 
 * - "com.interactivemesh.j3d.community.gui.FXCanvas3DMVRepainter.java" 
 * 
 * 
 * Redistribution and use are permitted according to the following license notice.
 * 
 * Version: 1.1
 * Date: 2009/11/10
 * 
 * Author:
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 * 
*/
/*
 * $RCSfile: com.sun.j3d.exp.swing.JCanvas3D.java,v $
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistribution of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF
 * USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR
 * ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
 *
 * $Revision: 1.10 $
 * $Date: 2007/04/11 02:08:56 $
 * $State: Exp $
 * 
 *  @author: Frederic 'pepe' Barachant
 *
 */

/**
 * A JavaFX class has to implement this interface to enable a
 * FXCanvas3DMVControl object to repaint its FXCanvas3DMV objects.
 * 
 * @see FXCanvas3DMV
 * @see FXCanvas3DMVControl
 */
public interface FXCanvas3DMVRepainter { 

    /**
     * Called by a FXCanvas3DMVControl object to repaint its FXCanvas3DMV objects.
     * <p>
     * The repaint request is handled by a FX.deferAction() 
     * - an equivalent to SwingUtilities.invokeLater() -  and will be executed on the EDT. 
     * 
     * The assigned function calls 'copyBuffersAndRepaint()' on the FXCanvas3DMVControl 
     * object for image data copying while the Java 3D renderer thread is waiting 
     * and for repainting of each FXCanvas3DMV panel.
     * </p>
     */
    public void repaintFXCanvas3DMV();   
}
