/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.gui;

import com.interactivemesh.j3d.community.gui.FXCanvas3DRepainter;
import com.sun.j3d.exp.swing.impl.AutoOffScreenCanvas3D;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class FXCanvas3DSB
extends JPanel
implements AncestorListener {
    private static double METERS_PER_PIXEL = 2.8222222222222223E-4;
    private GraphicsConfiguration graphicsConfig = null;
    private OffscreenCanvas3D canvas = null;
    private long wakeupEventMasks = 0L;
    private BufferedImage paintImage = null;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private ReentrantLock imageAccessLock = null;
    private Condition imagePaintCondition = null;
    private volatile boolean isImageDrawn = false;
    private boolean isSwapStarted = false;
    private FXCanvas3DRepainter repainter = null;

    public FXCanvas3DSB() {
        this(null, null);
    }

    public FXCanvas3DSB(GraphicsDevice device) {
        this(null, device);
    }

    public FXCanvas3DSB(GraphicsConfigTemplate3D template) {
        this(template, null);
    }

    public FXCanvas3DSB(GraphicsConfigTemplate3D template, GraphicsDevice device) {
        if (template == null) {
            template = new GraphicsConfigTemplate3D();
        }
        template.setStereo(3);
        template.setDoubleBuffer(3);
        this.graphicsConfig = device == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template) : device.getBestConfiguration((GraphicsConfigTemplate)template);
        this.addAncestorListener(this);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.imageAccessLock = new ReentrantLock();
        this.imagePaintCondition = this.imageAccessLock.newCondition();
    }

    public void setRepainter(FXCanvas3DRepainter painter) {
        this.repainter = painter;
    }

    public void ancestorAdded(AncestorEvent event) {
        Dimension sz = this.getSize();
        if (sz.width < 1) {
            sz.width = 100;
        }
        if (sz.height < 1) {
            sz.height = 100;
        }
        this.createCanvas(sz.width, sz.height);
        this.canvas.addNotifyFlag = true;
        this.canvas.addNotify();
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.canvas.removeNotify();
    }

    public Canvas3D getOffscreenCanvas3D() {
        if (this.canvas == null) {
            this.createCanvas(this.getWidth(), this.getHeight());
        }
        return this.canvas;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.createCanvas(width, height);
    }

    private void createCanvas(int width, int height) {
        if (this.getParent() == null) {
            return;
        }
        final int w = Math.max(1, width);
        final int h = Math.max(1, height);
        if (this.canvas == null) {
            this.canvas = new OffscreenCanvas3D(this.graphicsConfig);
        } else if (this.canvas.getWidth() == w && this.canvas.getHeight() == h) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.canvas.createOffScreenBuffer(this.graphicsConfig.getBounds(), w, h);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FXCanvas3DSB.this.canvas.createOffScreenBuffer(FXCanvas3DSB.this.graphicsConfig.getBounds(), w, h);
                }
            });
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.paintImage == null || !this.canvas.isRendererRunning()) {
            return;
        }
        boolean isLocked = false;
        try {
            try {
                isLocked = this.imageAccessLock.tryLock(50L, TimeUnit.MILLISECONDS);
                g.drawImage(this.paintImage, 0, this.imageHeight, this.imageWidth, 0, 0, 0, this.imageWidth, this.imageHeight, null);
                this.isImageDrawn = true;
                if (isLocked) {
                    this.imagePaintCondition.signal();
                }
            }
            catch (InterruptedException interruptedException) {
                if (isLocked) {
                    this.imageAccessLock.unlock();
                }
            }
        }
        finally {
            if (isLocked) {
                this.imageAccessLock.unlock();
            }
        }
    }

    public void enableWakeupOnAWTEvents(long eventMasks) {
        if ((eventMasks & 1L) != 0L) {
            this.wakeupEventMasks |= 1L;
        }
        if ((eventMasks & 4L) != 0L) {
            this.wakeupEventMasks |= 4L;
        }
        if ((eventMasks & 8L) != 0L) {
            this.wakeupEventMasks |= 8L;
        }
        if ((eventMasks & 0x10L) != 0L) {
            this.wakeupEventMasks |= 0x10L;
        }
        if ((eventMasks & 0x20L) != 0L) {
            this.wakeupEventMasks |= 0x20L;
        }
        if ((eventMasks & 0x20000L) != 0L) {
            this.wakeupEventMasks |= 0x20000L;
        }
        this.enableEvents(this.wakeupEventMasks);
    }

    public void disableWakeupOnAWTEvents(long eventMasks) {
        this.wakeupEventMasks &= eventMasks ^ 0xFFFFFFFFFFFFFFFFL;
        this.disableEvents(eventMasks);
    }

    protected void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        if ((this.wakeupEventMasks & 1L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processComponentEvent(e);
            e.setSource(src);
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if ((this.wakeupEventMasks & 4L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processFocusEvent(e);
            e.setSource(src);
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if ((this.wakeupEventMasks & 8L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processKeyEvent(e);
            e.setSource(src);
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if ((this.wakeupEventMasks & 0x10L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processMouseEvent(e);
            e.setSource(src);
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if ((this.wakeupEventMasks & 0x20L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processMouseMotionEvent(e);
            e.setSource(src);
        }
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
        if ((this.wakeupEventMasks & 0x20000L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvas);
            this.canvas.processMouseWheelEvent(e);
            e.setSource(src);
        }
    }

    private final class OffscreenCanvas3D
    extends Canvas3D
    implements AutoOffScreenCanvas3D {
        private Condition imageResizeCondition;
        private volatile boolean isRendererLocked;
        private volatile boolean isWatingForResizing;
        private boolean addNotifyFlag;
        private Runnable repaintCall;
        private static final int LIMIT = 200000000;

        private OffscreenCanvas3D(GraphicsConfiguration graphicsConfiguration) {
            super(graphicsConfiguration, true);
            this.imageResizeCondition = null;
            this.isRendererLocked = false;
            this.isWatingForResizing = false;
            this.addNotifyFlag = false;
            this.repaintCall = null;
            this.repaintCall = new RepaintCall();
            this.imageResizeCondition = FXCanvas3DSB.this.imageAccessLock.newCondition();
        }

        private void createOffScreenBuffer(Rectangle screenRect, int width, int height) {
            try {
                FXCanvas3DSB.this.imageAccessLock.lock();
                this.stopRenderer();
                this.isWatingForResizing = true;
                while (this.isRendererLocked) {
                    FXCanvas3DSB.this.isImageDrawn = true;
                    FXCanvas3DSB.this.imagePaintCondition.signal();
                    try {
                        this.imageResizeCondition.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.isWatingForResizing = false;
                this.waitForOffScreenRendering();
                int screenWidth = (int)screenRect.getWidth();
                int screenHeight = (int)screenRect.getHeight();
                Screen3D screen3D = this.getScreen3D();
                screen3D.setSize(screenWidth, screenHeight);
                screen3D.setPhysicalScreenWidth((double)screenWidth * METERS_PER_PIXEL);
                screen3D.setPhysicalScreenHeight((double)screenHeight * METERS_PER_PIXEL);
                if (FXCanvas3DSB.this.paintImage != null) {
                    FXCanvas3DSB.this.paintImage.flush();
                }
                FXCanvas3DSB.this.paintImage = new BufferedImage(width, height, 2);
                ImageComponent2D image = new ImageComponent2D(2, FXCanvas3DSB.this.paintImage, true, true);
                image.setCapability(2);
                image.setCapability(3);
                FXCanvas3DSB.this.imageWidth = width;
                FXCanvas3DSB.this.imageHeight = height;
                try {
                    this.setOffScreenBuffer(image);
                }
                catch (RestrictedAccessException e) {
                    this.createOffScreenBuffer(screenRect, width, height);
                    System.out.println("Repeat : createOffScreenBuffer(screenRect, width, height) !!");
                }
            }
            finally {
                FXCanvas3DSB.this.imageAccessLock.unlock();
            }
            this.startRenderer();
        }

        public void addNotify() {
            if (!this.addNotifyFlag) {
                throw new UnsupportedOperationException("User must not call this method !!");
            }
            this.addNotifyFlag = false;
            super.addNotify();
        }

        public Container getParent() {
            return FXCanvas3DSB.this.getParent();
        }

        public void preRender() {
            if (FXCanvas3DSB.this.isSwapStarted) {
                FXCanvas3DSB.this.isSwapStarted = false;
                try {
                    FXCanvas3DSB.this.imageAccessLock.unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }

        public void postRender() {
            if (this.isRendererRunning()) {
                FXCanvas3DSB.this.imageAccessLock.lock();
                FXCanvas3DSB.this.isSwapStarted = true;
            }
        }

        public void postSwap() {
            if (FXCanvas3DSB.this.isSwapStarted) {
                FXCanvas3DSB.this.isImageDrawn = false;
                SwingUtilities.invokeLater(this.repaintCall);
                while (!FXCanvas3DSB.this.isImageDrawn) {
                    this.isRendererLocked = true;
                    try {
                        FXCanvas3DSB.this.imagePaintCondition.awaitNanos(200000000L);
                        FXCanvas3DSB.this.isImageDrawn = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.isRendererLocked = false;
                    if (!this.isWatingForResizing) continue;
                    this.imageResizeCondition.signal();
                }
                FXCanvas3DSB.this.isSwapStarted = false;
                try {
                    FXCanvas3DSB.this.imageAccessLock.unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }

        protected void processComponentEvent(ComponentEvent e) {
            super.processComponentEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
        }

        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            super.processMouseWheelEvent(e);
        }

        private final class RepaintCall
        implements Runnable {
            private RepaintCall() {
            }

            public void run() {
                if (FXCanvas3DSB.this.repainter != null) {
                    FXCanvas3DSB.this.repainter.repaintFXCanvas3D();
                }
            }
        }
    }
}

