
package com.interactivemesh.j3d.testspace.jfx.charcubesb;

import javafx.async.JavaTaskBase;
import javafx.async.RunnableFuture;

/**
 * CharacterCubeUniverseFX.fx
 *
 * Version: 5.1
 * Date: 2010/09/19
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'CharacterCubeUniverseFX.fx'.
 *
 */

package class CharacterCubeUniverseFX extends JavaTaskBase, ScriptUpdater {

    var universe: CharacterCubeUniverse;

    package var transValue: Integer on replace {
        universe.setCubeTransparency(transValue);
    }

    package var rotationValue: Integer on replace {
        universe.setRotationSpeed(rotationValue);
    }

    package var minFrameCycleTime: Integer on replace {
        universe.setMinFrameCycleTime(minFrameCycleTime);
    }


    // Implemented in Main, called here from 'onDone'
    package var initUniverse: function(universe: CharacterCubeUniverse): Void;
    
    //
    // Script update
    //
    package var updateUnicodeCodePoint: function(codepoint: Integer): Void;
    // Interface ScriptUpdater
    override function setUnicodeCodePoint(codepoint: Integer): Void {
        updateUnicodeCodePoint(codepoint);
    }
    //
    // Universe update
    //
    package function setProjectionMode(mode: String) {
        universe.setProjectionMode(mode);
    }

    package function setVantagePoint(name: String) {
        universe.setVantagePoint(name);
    }

    package function resetRotation() {
        universe.resetRotation();
    }

    package function closeUniverse() {
        universe.closeUniverse();
    }

    //
    // Implementation of JavaTaskBase
    //
    // Create RunnableFuture: CharacterCubeUniverse
    // Called in function 'start()'
    protected override function create(): RunnableFuture {
        universe = new CharacterCubeUniverse();
        return universe;
    }
    // Called from CharacterCubeMain.fx
    // Initializes the 3D scene : calls run() on RunnableFuture 'universe'
    protected override function start(): Void {
        // Nothing to do
        super.start();
    }
    // Callback: Finish init
    override var onDone = function(): Void {
        universe.setScriptUpdater(this);
        initUniverse(universe);
    };
}