/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.utils.geometry;

import com.interactivemesh.j3d.community.utils.geometry.AWTShapeExtrusion;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTShapeExtruder {
    private double creaseAngle = 0.767944871;
    private double tessellationTolerance = 0.01;
    private AWTShapeExtrusion shapeExtrusion = null;
    private boolean isIdentityTransform = true;
    private boolean isScaleTranslation = false;
    private Transform3D coordTransform = new Transform3D();
    private Transform3D normalTransform = new Transform3D();
    private static final float EPS = 1.0E-6f;

    public AWTShapeExtruder() {
        this(0.01, null);
    }

    public AWTShapeExtruder(AWTShapeExtrusion extrudePath) {
        this(0.01, extrudePath);
    }

    public AWTShapeExtruder(double tessellationTolerance, AWTShapeExtrusion extrudePath) {
        this.tessellationTolerance = tessellationTolerance;
        this.shapeExtrusion = extrudePath;
    }

    public AWTShapeExtruder(double tessellationTolerance, AWTShapeExtrusion extrudePath, double creaseAngle) {
        this.tessellationTolerance = tessellationTolerance;
        this.shapeExtrusion = extrudePath;
        this.setCreaseAngle(creaseAngle);
    }

    public AWTShapeExtrusion getShapeExtrusion() {
        return this.shapeExtrusion;
    }

    public void setShapeExtrusion(AWTShapeExtrusion extrudePath) {
        this.shapeExtrusion = extrudePath;
    }

    public double getTessellationTolerance() {
        return this.tessellationTolerance;
    }

    public void setTessellationTolerance(double tessellationTolerance) {
        this.tessellationTolerance = tessellationTolerance;
    }

    public double getCreaseAngle() {
        return this.creaseAngle;
    }

    public void setCreaseAngle(double creaseAngle) {
        this.creaseAngle = Math.max(0.0, Math.min(Math.PI, creaseAngle));
    }

    public void getGeometryTransform(Transform3D transform) {
        if (transform == null) {
            throw new NullPointerException("transform is null");
        }
        transform.set(this.coordTransform);
    }

    public void setGeometryTransform(Transform3D transform) {
        if (transform == null) {
            throw new NullPointerException("transform is null");
        }
        this.isIdentityTransform = (transform.getType() & 2) != 0;
        if (this.isIdentityTransform) {
            this.coordTransform.setIdentity();
            this.normalTransform.setIdentity();
            return;
        }
        Transform3D invertTransposeT3D = new Transform3D(transform);
        if ((transform.getType() & 0x10) == 0) {
            try {
                invertTransposeT3D.invert();
                invertTransposeT3D.transpose();
            }
            catch (SingularMatrixException e) {
                throw new IllegalArgumentException("transform is not invertable", e);
            }
        }
        float[] mat = new float[16];
        transform.get(mat);
        this.isScaleTranslation = mat[1] == 0.0f && mat[2] == 0.0f && mat[4] == 0.0f && mat[6] == 0.0f && mat[8] == 0.0f && mat[9] == 0.0f && mat[12] == 0.0f && mat[13] == 0.0f && mat[14] == 0.0f && mat[15] == 1.0f;
        this.coordTransform.set(transform);
        this.normalTransform.set(invertTransposeT3D);
    }

    public GeometryArray getGeometry(Shape shape, AffineTransform trans) {
        PathIterator pIt = shape.getPathIterator(trans, this.tessellationTolerance);
        GeometryArray geomArray = this.createGeometry(pIt, false, true);
        return geomArray;
    }

    public GeometryArray getOutlineGeometry(Shape shape, AffineTransform trans) {
        PathIterator pIt = shape.getPathIterator(trans, this.tessellationTolerance);
        LineStripArray geomArray = this.createLineStripGeometry(pIt, true, false, true);
        return geomArray;
    }

    public GeometryArray getGeometry(char[] chars, Font font, boolean flip) {
        Shape shape = AWTShapeExtruder.createAWTShape(chars, font, flip);
        PathIterator pIt = shape.getPathIterator(null, this.tessellationTolerance);
        GeometryArray geomArray = this.createGeometry(pIt, false, true);
        return geomArray;
    }

    public static Shape createAWTShape(char[] chars, Font font, boolean flip) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        GlyphVector gv = font.createGlyphVector(frc, chars);
        Shape shape = gv.getOutline();
        if (!flip) {
            return shape;
        }
        AffineTransform trans = new AffineTransform();
        trans.setToScale(1.0, -1.0);
        return trans.createTransformedShape(shape);
    }

    void transformCoords(float[] coords) {
        if (!this.isIdentityTransform) {
            this.transformGeometry(this.coordTransform, coords, false);
        }
    }

    void transformNormals(float[] coords) {
        if (!this.isIdentityTransform) {
            this.transformGeometry(this.normalTransform, coords, true);
        }
    }

    void transformBounds(BoundingBox bounds, float[] coords) {
        if (this.isIdentityTransform) {
            return;
        }
        if (this.isScaleTranslation) {
            this.transformAxisAligned(bounds);
        } else {
            ArrayList<float[]> coordsList = new ArrayList<float[]>(1);
            coordsList.add(coords);
            this.transformBounds(bounds, coordsList);
        }
    }

    void transformBounds(BoundingBox bounds, ArrayList<float[]> coordsList) {
        if (this.isIdentityTransform) {
            return;
        }
        if (this.isScaleTranslation) {
            this.transformAxisAligned(bounds);
        } else {
            float[] coords0 = coordsList.get(0);
            float lx = coords0[0];
            float ly = coords0[1];
            float lz = coords0[2];
            float ux = lx;
            float uy = ly;
            float uz = lz;
            for (float[] coords : coordsList) {
                if (coords == null) continue;
                int i = 0;
                int l = coords.length;
                while (i < l) {
                    float x = coords[i];
                    if (x < lx) {
                        lx = x;
                    } else if (x > ux) {
                        ux = x;
                    }
                    float y = coords[i + 1];
                    if (y < ly) {
                        ly = y;
                    } else if (y > uy) {
                        uy = y;
                    }
                    float z = coords[i + 2];
                    if (z < lz) {
                        lz = z;
                    } else if (z > uz) {
                        uz = z;
                    }
                    i += 3;
                }
            }
            bounds.setLower(new Point3d((double)lx, (double)ly, (double)lz));
            bounds.setUpper(new Point3d((double)ux, (double)uy, (double)uz));
        }
    }

    private void transformAxisAligned(BoundingBox bounds) {
        Point3d p3d = new Point3d();
        bounds.getLower(p3d);
        this.coordTransform.transform(p3d);
        bounds.setLower(p3d);
        bounds.getUpper(p3d);
        this.coordTransform.transform(p3d);
        bounds.setUpper(p3d);
    }

    private void transformGeometry(Transform3D transform, float[] triple, boolean isNormal) {
        int length = triple.length;
        if (length < 3 || length % 3 != 0) {
            throw new IllegalArgumentException("length < 3 || length%3 != 0");
        }
        int tripleCt = length / 3;
        float[] mat = new float[16];
        transform.get(mat);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        int k = 0;
        if (isNormal) {
            float xt = 0.0f;
            float yt = 0.0f;
            float zt = 0.0f;
            int i = 0;
            while (i < tripleCt) {
                float nLength;
                x = triple[k++];
                yt = mat[4] * x + mat[5] * y + mat[6] * z;
                zt = mat[8] * x + mat[9] * y + mat[10] * z;
                nLength = (nLength = (float)Math.sqrt((xt = mat[0] * x + mat[1] * (y = triple[k++]) + mat[2] * (z = triple[k++])) * xt + yt * yt + zt * zt)) != 0.0f ? 1.0f / nLength : 1.0f;
                k -= 3;
                triple[k++] = xt * nLength;
                triple[k++] = yt * nLength;
                triple[k++] = zt * nLength;
                ++i;
            }
        } else {
            int i = 0;
            while (i < tripleCt) {
                x = triple[k++];
                y = triple[k++];
                z = triple[k++];
                k -= 3;
                triple[k++] = mat[0] * x + mat[1] * y + mat[2] * z + mat[3];
                triple[k++] = mat[4] * x + mat[5] * y + mat[6] * z + mat[7];
                triple[k++] = mat[8] * x + mat[9] * y + mat[10] * z + mat[11];
                ++i;
            }
        }
    }

    private void transformCoords(Transform3D transform, ArrayList<? extends Tuple3f> triple) {
        float[] mat = new float[16];
        transform.get(mat);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        Tuple3f t3f = null;
        int i = 0;
        int ct = triple.size();
        while (i < ct) {
            t3f = triple.get(i);
            x = t3f.x;
            y = t3f.y;
            z = t3f.z;
            t3f.x = mat[0] * x + mat[1] * y + mat[2] * z + mat[3];
            t3f.y = mat[4] * x + mat[5] * y + mat[6] * z + mat[7];
            t3f.z = mat[8] * x + mat[9] * y + mat[10] * z + mat[11];
            ++i;
        }
    }

    LineStripArray createLineStripGeometry(PathIterator pIt, boolean inclNormals, boolean byReference, boolean geomTransform) {
        int flag = -1;
        int numPoints = 0;
        int num = 0;
        ArrayList<Point3f> coordsList = new ArrayList<Point3f>(50);
        float[] tmpCoords = new float[6];
        float lastX = 0.0f;
        float lastY = 0.0f;
        float firstPntx = Float.MAX_VALUE;
        float firstPnty = Float.MAX_VALUE;
        ArrayList<Integer> contours = new ArrayList<Integer>(10);
        Point3f vertex = null;
        while (!pIt.isDone()) {
            int lastIndex;
            Point3f lastVertex;
            int lastIndVert;
            vertex = new Point3f();
            flag = pIt.currentSegment(tmpCoords);
            if (flag == 4) {
                if (num > 0) {
                    if (num > 2) {
                        lastIndVert = coordsList.size() - 1;
                        lastVertex = (Point3f)coordsList.get(lastIndVert);
                        if (firstPntx != lastVertex.x || firstPnty != lastVertex.y) {
                            coordsList.add(new Point3f(firstPntx, firstPnty, 0.0f));
                            ++num;
                            ++numPoints;
                        }
                    }
                    if (num > 0) {
                        if (num < 3) {
                            lastIndex = coordsList.size() - 1;
                            coordsList.remove(lastIndex);
                            if (num == 2) {
                                coordsList.remove(lastIndex - 1);
                            }
                            numPoints -= num;
                        } else {
                            contours.add(num);
                        }
                        num = 0;
                    }
                }
            } else if (flag == 0) {
                vertex.x = tmpCoords[0];
                vertex.y = tmpCoords[1];
                lastX = vertex.x;
                lastY = vertex.y;
                if (lastX == firstPntx && lastY == firstPnty) {
                    pIt.next();
                    continue;
                }
                if (num > 0) {
                    if (num > 2) {
                        lastIndVert = coordsList.size() - 1;
                        lastVertex = (Point3f)coordsList.get(lastIndVert);
                        if (firstPntx != lastVertex.x || firstPnty != lastVertex.y) {
                            coordsList.add(new Point3f(firstPntx, firstPnty, 0.0f));
                            ++num;
                            ++numPoints;
                        }
                    }
                    if (num > 0) {
                        if (num < 3) {
                            lastIndex = coordsList.size() - 1;
                            coordsList.remove(lastIndex);
                            if (num == 2) {
                                coordsList.remove(lastIndex - 1);
                            }
                            numPoints -= num;
                        } else {
                            contours.add(num);
                        }
                        num = 0;
                    }
                }
                firstPntx = lastX;
                firstPnty = lastY;
                coordsList.add(vertex);
                ++num;
                ++numPoints;
            } else if (flag == 1) {
                vertex.x = tmpCoords[0];
                vertex.y = tmpCoords[1];
                if (vertex.x == lastX && vertex.y == lastY) {
                    pIt.next();
                    continue;
                }
                lastX = vertex.x;
                lastY = vertex.y;
                coordsList.add(vertex);
                ++num;
                ++numPoints;
            }
            pIt.next();
        }
        if (numPoints == 0) {
            return null;
        }
        int stripCt = contours.size();
        int vertexCt = 0;
        int[] stripVertexCounts = new int[stripCt];
        int i = 0;
        while (i < stripCt) {
            stripVertexCounts[i] = (Integer)contours.get(i);
            vertexCt += stripVertexCounts[i];
            ++i;
        }
        int vertexFormat = 1;
        if (inclNormals) {
            vertexFormat |= 2;
        }
        if (byReference) {
            vertexFormat |= 0x80;
        }
        LineStripArray lineStripArray = new LineStripArray(vertexCt, vertexFormat, stripVertexCounts);
        if (byReference) {
            int k = 0;
            float[] coords = new float[vertexCt * 3];
            int i2 = 0;
            while (i2 < vertexCt) {
                vertex = (Point3f)coordsList.get(i2);
                coords[k++] = vertex.x;
                coords[k++] = vertex.y;
                ++k;
                ++i2;
            }
            if (geomTransform && !this.isIdentityTransform) {
                this.transformGeometry(this.coordTransform, coords, false);
            }
            lineStripArray.setCoordRefFloat(coords);
            if (inclNormals) {
                k = 0;
                float[] normals = new float[vertexCt * 3];
                if (geomTransform && !this.isIdentityTransform) {
                    float[] normalArr = new float[]{0.0f, 0.0f, 1.0f};
                    this.transformGeometry(this.normalTransform, normalArr, true);
                    int i3 = 0;
                    while (i3 < vertexCt) {
                        normals[k++] = normalArr[0];
                        normals[k++] = normalArr[1];
                        normals[k++] = normalArr[2];
                        ++i3;
                    }
                } else {
                    int i4 = 0;
                    while (i4 < vertexCt) {
                        k += 2;
                        normals[k++] = 1.0f;
                        ++i4;
                    }
                }
                lineStripArray.setNormalRefFloat(normals);
            }
        } else if (inclNormals) {
            Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
            if (geomTransform && !this.isIdentityTransform) {
                this.transformCoords(this.coordTransform, coordsList);
                float[] normalArr = new float[]{0.0f, 0.0f, 1.0f};
                this.transformGeometry(this.normalTransform, normalArr, true);
                normal.set(normalArr);
            }
            int i5 = 0;
            while (i5 < vertexCt) {
                lineStripArray.setCoordinate(i5, (Point3f)coordsList.get(i5));
                lineStripArray.setNormal(i5, normal);
                ++i5;
            }
        } else {
            if (geomTransform && !this.isIdentityTransform) {
                this.transformCoords(this.coordTransform, coordsList);
            }
            int i6 = 0;
            while (i6 < vertexCt) {
                lineStripArray.setCoordinate(i6, (Point3f)coordsList.get(i6));
                ++i6;
            }
        }
        coordsList = null;
        contours = null;
        return lineStripArray;
    }

    GeometryArray createGeometry(PathIterator pIt, boolean byReference, boolean geomTransform) {
        boolean isFrontBackAndFlat;
        int k;
        int j;
        int flag = -1;
        int numPoints = 0;
        int num = 0;
        ArrayList<Point3f> coordsList = new ArrayList<Point3f>();
        float[] tmpCoords = new float[6];
        float lastX = 0.0f;
        float lastY = 0.0f;
        float firstPntx = Float.MAX_VALUE;
        float firstPnty = Float.MAX_VALUE;
        GeometryInfo gi = null;
        ArrayList<Integer> contours = new ArrayList<Integer>(10);
        float maxY = -3.4028235E38f;
        int maxYIndex = 0;
        int beginIdx = 0;
        int endIdx = 0;
        int start = 0;
        int[] lastMaxYIndices = new int[3];
        boolean setMaxY = false;
        Point3f vertex = null;
        while (!pIt.isDone()) {
            int lastIndex;
            vertex = new Point3f();
            flag = pIt.currentSegment(tmpCoords);
            if (flag == 4) {
                if (num > 0) {
                    if (num > 2) {
                        int lastIndVert = coordsList.size() - 1;
                        Point3f lastVertex = (Point3f)coordsList.get(lastIndVert);
                        if (firstPntx == lastVertex.x && firstPnty == lastVertex.y) {
                            coordsList.remove(lastIndVert);
                            --num;
                            --numPoints;
                        }
                    }
                    if (num > 0) {
                        if (num < 3) {
                            lastIndex = coordsList.size() - 1;
                            coordsList.remove(lastIndex);
                            if (num == 2) {
                                coordsList.remove(lastIndex - 1);
                            }
                            numPoints -= num;
                            num = 0;
                            if (setMaxY) {
                                maxYIndex = lastMaxYIndices[0];
                                beginIdx = lastMaxYIndices[1];
                                endIdx = lastMaxYIndices[2];
                            }
                        } else {
                            if (setMaxY) {
                                beginIdx = start;
                                endIdx = numPoints - 1;
                                lastMaxYIndices[0] = maxYIndex;
                                lastMaxYIndices[1] = beginIdx;
                                lastMaxYIndices[2] = endIdx;
                            }
                            contours.add(num);
                            num = 0;
                        }
                    }
                }
            } else if (flag == 0) {
                vertex.x = tmpCoords[0];
                vertex.y = tmpCoords[1];
                lastX = vertex.x;
                lastY = vertex.y;
                if (lastX == firstPntx && lastY == firstPnty) {
                    pIt.next();
                    continue;
                }
                if (num > 0) {
                    if (firstPntx == tmpCoords[0] && firstPnty == tmpCoords[1]) {
                        coordsList.remove(coordsList.get(coordsList.size() - 1));
                        --num;
                        --numPoints;
                    }
                    if (num > 0) {
                        if (num < 3) {
                            lastIndex = coordsList.size() - 1;
                            coordsList.remove(lastIndex);
                            if (num == 2) {
                                coordsList.remove(lastIndex - 1);
                            }
                            num = 0;
                            numPoints -= num;
                            if (setMaxY) {
                                maxYIndex = lastMaxYIndices[0];
                                beginIdx = lastMaxYIndices[1];
                                endIdx = lastMaxYIndices[2];
                            }
                        } else {
                            if (setMaxY) {
                                beginIdx = start;
                                endIdx = numPoints - 1;
                                lastMaxYIndices[0] = maxYIndex;
                                lastMaxYIndices[1] = beginIdx;
                                lastMaxYIndices[2] = endIdx;
                            }
                            contours.add(num);
                            num = 0;
                        }
                    }
                }
                firstPntx = lastX;
                firstPnty = lastY;
                start = numPoints;
                setMaxY = false;
                if (vertex.y > maxY) {
                    maxY = vertex.y;
                    maxYIndex = numPoints;
                    setMaxY = true;
                }
                coordsList.add(vertex);
                ++num;
                ++numPoints;
            } else if (flag == 1) {
                vertex.x = tmpCoords[0];
                vertex.y = tmpCoords[1];
                if (vertex.x == lastX && vertex.y == lastY) {
                    pIt.next();
                    continue;
                }
                if (vertex.y > maxY) {
                    maxY = vertex.y;
                    maxYIndex = numPoints;
                    setMaxY = true;
                }
                lastX = vertex.x;
                lastY = vertex.y;
                coordsList.add(vertex);
                ++num;
                ++numPoints;
            } else {
                System.out.println("AWTShapeExtruder flag = pIt.currentSegment = " + flag);
            }
            pIt.next();
        }
        if (numPoints == 0) {
            return null;
        }
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        Point3f p3 = new Point3f();
        boolean flip_side_orient = true;
        Point3f[] vertices = new Point3f[coordsList.size()];
        coordsList.toArray(vertices);
        if (endIdx - beginIdx > 0) {
            if (maxYIndex == beginIdx) {
                p1.set((Tuple3f)vertices[endIdx]);
            } else {
                p1.set((Tuple3f)vertices[maxYIndex - 1]);
            }
            p2.set((Tuple3f)vertices[maxYIndex]);
            if (maxYIndex == endIdx) {
                p3.set((Tuple3f)vertices[beginIdx]);
            } else {
                p3.set((Tuple3f)vertices[maxYIndex + 1]);
            }
            flip_side_orient = p3.x != p2.x ? (p1.x != p2.x ? (Math.abs((p2.y - p1.y) / (p2.x - p1.x)) > Math.abs((p3.y - p2.y) / (p3.x - p2.x)) ? p3.x > p2.x : p2.x > p1.x) : p3.x > p2.x) : p2.x > p1.x;
        }
        int startIdx = 0;
        IslandsNode islandsTree = new IslandsNode(-1, -1);
        int i = 0;
        while (i < contours.size()) {
            endIdx = startIdx + (Integer)contours.get(i);
            islandsTree.insert(new IslandsNode(startIdx, endIdx), vertices);
            startIdx = endIdx;
            ++i;
        }
        coordsList = null;
        contours = null;
        ArrayList islandsList = new ArrayList();
        islandsTree.collectOddLevelNode(islandsList, 0);
        IslandsNode[] nodes = new IslandsNode[islandsList.size()];
        islandsList.toArray(nodes);
        int numIslands = islandsList.size();
        int[][] islandCounts = new int[numIslands][];
        Point3f[][] outVerts = new Point3f[numIslands][];
        i = 0;
        while (i < numIslands) {
            IslandsNode node = nodes[i];
            int nchild = node.numChild();
            islandCounts[i] = new int[nchild + 1];
            islandCounts[i][0] = node.numVertices();
            int sum = 0;
            sum += islandCounts[i][0];
            j = 0;
            while (j < nchild) {
                islandCounts[i][j + 1] = node.getChild(j).numVertices();
                sum += islandCounts[i][j + 1];
                ++j;
            }
            outVerts[i] = new Point3f[sum];
            startIdx = 0;
            k = node.startIdx;
            while (k < node.endIdx) {
                outVerts[i][startIdx++] = vertices[k];
                ++k;
            }
            j = 0;
            while (j < nchild) {
                endIdx = node.getChild(j).endIdx;
                k = node.getChild(j).startIdx;
                while (k < endIdx) {
                    outVerts[i][startIdx++] = vertices[k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        islandsTree = null;
        islandsList = null;
        vertices = null;
        int[] contourCounts = new int[1];
        int currCoordIndex = 0;
        int vertOffset = 0;
        ArrayList<Point3f[]> triaData = new ArrayList<Point3f[]>();
        numPoints = 0;
        i = 0;
        while (i < numIslands) {
            contourCounts[0] = islandCounts[i].length;
            numPoints += outVerts[i].length;
            gi = new GeometryInfo(5);
            gi.setCoordinates(outVerts[i]);
            gi.setStripCounts(islandCounts[i]);
            gi.setContourCounts(contourCounts);
            GeometryArray ga = gi.getGeometryArray(false, false, false);
            Point3f[] triaPoints = this.removeDegeneratedTrias(ga);
            vertOffset += triaPoints.length;
            triaData.add(triaPoints);
            ++i;
        }
        boolean bl = isFrontBackAndFlat = this.shapeExtrusion != null && this.shapeExtrusion.getDepth() == 0.0f;
        int vertCnt = this.shapeExtrusion == null ? vertOffset : (isFrontBackAndFlat ? vertOffset * 2 : (this.shapeExtrusion.getExtrusionShape() == null ? vertOffset * 2 + numPoints * 6 : vertOffset * 2 + numPoints * 6 * (this.shapeExtrusion.getExtrusion().length - 1)));
        int vertexFormat = 3;
        if (byReference) {
            vertexFormat |= 0x80;
        }
        TriangleArray triAry = new TriangleArray(vertCnt, vertexFormat);
        float[] coords = new float[vertCnt * 3];
        float[] normals = new float[vertCnt * 3];
        boolean[] flip_orient = new boolean[numIslands];
        Point3f q1 = new Point3f();
        Point3f q2 = new Point3f();
        Point3f q3 = new Point3f();
        Vector3f nF = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f nB = new Vector3f(0.0f, 0.0f, -1.0f);
        if (geomTransform && !this.isIdentityTransform) {
            float[] normalArrF = new float[]{0.0f, 0.0f, 1.0f};
            this.transformNormals(normalArrF);
            nF.set(normalArrF);
            nB.set(-nF.x, -nF.y, -nF.z);
        }
        Vector3f nz = new Vector3f();
        j = 0;
        while (j < numIslands) {
            Point3f[] triaPoints = (Point3f[])triaData.get(j);
            vertOffset = triaPoints.length;
            boolean findOrient = false;
            i = 0;
            while (i < vertOffset) {
                block115: {
                    block114: {
                        block117: {
                            block116: {
                                p1.set((Tuple3f)triaPoints[i]);
                                p2.set((Tuple3f)triaPoints[i + 1]);
                                p3.set((Tuple3f)triaPoints[i + 2]);
                                if (findOrient) break block114;
                                if (!this.getNormal(p1, p2, p3, nz)) break block115;
                                if (!(nz.z >= 1.0E-6f)) break block116;
                                flip_orient[j] = false;
                                break block117;
                            }
                            if (!(nz.z <= -1.0E-6f)) break block115;
                            flip_orient[j] = true;
                        }
                        findOrient = true;
                    }
                    if (flip_orient[j]) {
                        q1.x = p2.x;
                        q1.y = p2.y;
                        q1.z = p2.z;
                        p2.x = p3.x;
                        p2.y = p3.y;
                        p2.z = p3.z;
                        p3.x = q1.x;
                        p3.y = q1.y;
                        p3.z = q1.z;
                    }
                    int index = currCoordIndex * 3;
                    if (this.shapeExtrusion != null) {
                        coords[index] = p1.x;
                        normals[index++] = nB.x;
                        coords[index] = p1.y;
                        normals[index++] = nB.y;
                        coords[index] = p1.z;
                        normals[index++] = nB.z;
                        coords[index] = p3.x;
                        normals[index++] = nB.x;
                        coords[index] = p3.y;
                        normals[index++] = nB.y;
                        coords[index] = p3.z;
                        normals[index++] = nB.z;
                        coords[index] = p2.x;
                        normals[index++] = nB.x;
                        coords[index] = p2.y;
                        normals[index++] = nB.y;
                        coords[index] = p2.z;
                        normals[index++] = nB.z;
                        q1.x = p1.x;
                        q1.y = p1.y;
                        q1.z = p1.z + this.shapeExtrusion.getDepth();
                        q2.x = p2.x;
                        q2.y = p2.y;
                        q2.z = p2.z + this.shapeExtrusion.getDepth();
                        q3.x = p3.x;
                        q3.y = p3.y;
                        q3.z = p3.z + this.shapeExtrusion.getDepth();
                        index = (currCoordIndex + vertOffset) * 3;
                        coords[index] = q1.x;
                        normals[index++] = nF.x;
                        coords[index] = q1.y;
                        normals[index++] = nF.y;
                        coords[index] = q1.z;
                        normals[index++] = nF.z;
                        coords[index] = q2.x;
                        normals[index++] = nF.x;
                        coords[index] = q2.y;
                        normals[index++] = nF.y;
                        coords[index] = q2.z;
                        normals[index++] = nF.z;
                        coords[index] = q3.x;
                        normals[index++] = nF.x;
                        coords[index] = q3.y;
                        normals[index++] = nF.y;
                        coords[index] = q3.z;
                        normals[index++] = nF.z;
                    } else {
                        coords[index] = p1.x;
                        normals[index++] = nF.x;
                        coords[index] = p1.y;
                        normals[index++] = nF.y;
                        coords[index] = p1.z;
                        normals[index++] = nF.z;
                        coords[index] = p2.x;
                        normals[index++] = nF.x;
                        coords[index] = p2.y;
                        normals[index++] = nF.y;
                        coords[index] = p2.z;
                        normals[index++] = nF.z;
                        coords[index] = p3.x;
                        normals[index++] = nF.x;
                        coords[index] = p3.y;
                        normals[index++] = nF.y;
                        coords[index] = p3.z;
                        normals[index++] = nF.z;
                    }
                }
                i += 3;
                currCoordIndex += 3;
            }
            if (this.shapeExtrusion != null) {
                currCoordIndex += vertOffset;
            }
            ++j;
        }
        if (this.shapeExtrusion != null && !isFrontBackAndFlat) {
            Vector3f goodNormal = new Vector3f();
            int index = currCoordIndex * 3;
            if (this.shapeExtrusion.getExtrusionShape() == null) {
                Vector3f n1 = new Vector3f();
                Vector3f n2 = new Vector3f();
                Vector3f pn1 = null;
                Vector3f pn2 = null;
                Vector3f n3 = new Vector3f();
                Vector3f n4 = new Vector3f();
                Vector3f p1Normal = new Vector3f();
                Vector3f p2Normal = new Vector3f();
                Vector3f q1Normal = new Vector3f();
                Vector3f q2Normal = new Vector3f();
                i = 0;
                while (i < numIslands) {
                    j = 0;
                    k = 0;
                    num = 0;
                    while (j < islandCounts[i].length) {
                        p1.x = outVerts[i][(num += islandCounts[i][j]) - 1].x;
                        p1.y = outVerts[i][num - 1].y;
                        p1.z = 0.0f;
                        q1.x = p1.x;
                        q1.y = p1.y;
                        q1.z = p1.z + this.shapeExtrusion.getDepth();
                        p2.z = 0.0f;
                        q2.z = p2.z + this.shapeExtrusion.getDepth();
                        int m = 0;
                        while (m < num) {
                            p2.x = outVerts[i][m].x;
                            p2.y = outVerts[i][m].y;
                            q2.x = p2.x;
                            q2.y = p2.y;
                            if (this.getNormal(p1, q1, p2, n1)) {
                                if (!flip_side_orient) {
                                    n1.negate();
                                }
                                goodNormal.set((Tuple3f)n1);
                                break;
                            }
                            ++m;
                        }
                        while (k < num) {
                            boolean smooth;
                            float cosine;
                            p2.x = outVerts[i][k].x;
                            p2.y = outVerts[i][k].y;
                            p2.z = 0.0f;
                            q2.x = p2.x;
                            q2.y = p2.y;
                            q2.z = p2.z + this.shapeExtrusion.getDepth();
                            if (!this.getNormal(p1, q1, p2, n1)) {
                                n1.set((Tuple3f)goodNormal);
                            } else {
                                if (!flip_side_orient) {
                                    n1.negate();
                                }
                                goodNormal.set((Tuple3f)n1);
                            }
                            if (!this.getNormal(p2, q1, q2, n2)) {
                                n2.set((Tuple3f)goodNormal);
                            } else {
                                if (!flip_side_orient) {
                                    n2.negate();
                                }
                                goodNormal.set((Tuple3f)n2);
                            }
                            if (pn1 != null) {
                                cosine = n1.dot(pn2);
                                boolean bl2 = smooth = (double)cosine > this.creaseAngle;
                                if (smooth) {
                                    p1Normal.x = pn1.x + pn2.x + n1.x;
                                    p1Normal.y = pn1.y + pn2.y + n1.y;
                                    p1Normal.z = pn1.z + pn2.z + n1.z;
                                    this.normalize(p1Normal);
                                    q1Normal.x = pn2.x + n1.x + n2.x;
                                    q1Normal.y = pn2.y + n1.y + n2.y;
                                    q1Normal.z = pn2.z + n1.z + n2.z;
                                    this.normalize(q1Normal);
                                } else {
                                    p1Normal.x = n1.x;
                                    p1Normal.y = n1.y;
                                    p1Normal.z = n1.z;
                                    q1Normal.x = n1.x + n2.x;
                                    q1Normal.y = n1.y + n2.y;
                                    q1Normal.z = n1.z + n2.z;
                                    this.normalize(q1Normal);
                                }
                            } else {
                                pn1 = new Vector3f();
                                pn2 = new Vector3f();
                                p1Normal.x = n1.x;
                                p1Normal.y = n1.y;
                                p1Normal.z = n1.z;
                                q1Normal.x = n1.x + n2.x;
                                q1Normal.y = n1.y + n2.y;
                                q1Normal.z = n1.z + n2.z;
                                this.normalize(q1Normal);
                            }
                            if (k + 1 < num) {
                                p3.x = outVerts[i][k + 1].x;
                                p3.y = outVerts[i][k + 1].y;
                                p3.z = 0.0f;
                                q3.x = p3.x;
                                q3.y = p3.y;
                                q3.z = p3.z + this.shapeExtrusion.getDepth();
                                if (!this.getNormal(p2, q2, p3, n3)) {
                                    n3.set((Tuple3f)goodNormal);
                                } else {
                                    if (!flip_side_orient) {
                                        n3.negate();
                                    }
                                    goodNormal.set((Tuple3f)n3);
                                }
                                if (!this.getNormal(p3, q2, q3, n4)) {
                                    n4.set((Tuple3f)goodNormal);
                                } else {
                                    if (!flip_side_orient) {
                                        n4.negate();
                                    }
                                    goodNormal.set((Tuple3f)n4);
                                }
                                cosine = n2.dot(n3);
                                boolean bl3 = smooth = (double)cosine > this.creaseAngle;
                                if (smooth) {
                                    p2Normal.x = n1.x + n2.x + n3.x;
                                    p2Normal.y = n1.y + n2.y + n3.y;
                                    p2Normal.z = n1.z + n2.z + n3.z;
                                    this.normalize(p2Normal);
                                    q2Normal.x = n2.x + n3.x + n4.x;
                                    q2Normal.y = n2.y + n3.y + n4.y;
                                    q2Normal.z = n2.z + n3.z + n4.z;
                                    this.normalize(q2Normal);
                                } else {
                                    p2Normal.x = n1.x + n2.x;
                                    p2Normal.y = n1.y + n2.y;
                                    p2Normal.z = n1.z + n2.z;
                                    this.normalize(p2Normal);
                                    q2Normal.x = n2.x;
                                    q2Normal.y = n2.y;
                                    q2Normal.z = n2.z;
                                }
                            } else {
                                p2Normal.x = n1.x + n2.x;
                                p2Normal.y = n1.y + n2.y;
                                p2Normal.z = n1.z + n2.z;
                                this.normalize(p2Normal);
                                q2Normal.x = n2.x;
                                q2Normal.y = n2.y;
                                q2Normal.z = n2.z;
                            }
                            if (flip_side_orient) {
                                coords[index] = p1.x;
                                normals[index++] = p1Normal.x;
                                coords[index] = p1.y;
                                normals[index++] = p1Normal.y;
                                coords[index] = p1.z;
                                normals[index++] = p1Normal.z;
                                coords[index] = q1.x;
                                normals[index++] = q1Normal.x;
                                coords[index] = q1.y;
                                normals[index++] = q1Normal.y;
                                coords[index] = q1.z;
                                normals[index++] = q1Normal.z;
                                coords[index] = p2.x;
                                normals[index++] = p2Normal.x;
                                coords[index] = p2.y;
                                normals[index++] = p2Normal.y;
                                coords[index] = p2.z;
                                normals[index++] = p2Normal.z;
                                coords[index] = p2.x;
                                normals[index++] = p2Normal.x;
                                coords[index] = p2.y;
                                normals[index++] = p2Normal.y;
                                coords[index] = p2.z;
                                normals[index++] = p2Normal.z;
                                coords[index] = q1.x;
                                normals[index++] = q1Normal.x;
                                coords[index] = q1.y;
                                normals[index++] = q1Normal.y;
                                coords[index] = q1.z;
                                normals[index++] = q1Normal.z;
                            } else {
                                coords[index] = q1.x;
                                normals[index++] = q1Normal.x;
                                coords[index] = q1.y;
                                normals[index++] = q1Normal.y;
                                coords[index] = q1.z;
                                normals[index++] = q1Normal.z;
                                coords[index] = p1.x;
                                normals[index++] = p1Normal.x;
                                coords[index] = p1.y;
                                normals[index++] = p1Normal.y;
                                coords[index] = p1.z;
                                normals[index++] = p1Normal.z;
                                coords[index] = p2.x;
                                normals[index++] = p2Normal.x;
                                coords[index] = p2.y;
                                normals[index++] = p2Normal.y;
                                coords[index] = p2.z;
                                normals[index++] = p2Normal.z;
                                coords[index] = q1.x;
                                normals[index++] = q1Normal.x;
                                coords[index] = q1.y;
                                normals[index++] = q1Normal.y;
                                coords[index] = q1.z;
                                normals[index++] = q1Normal.z;
                                coords[index] = p2.x;
                                normals[index++] = p2Normal.x;
                                coords[index] = p2.y;
                                normals[index++] = p2Normal.y;
                                coords[index] = p2.z;
                                normals[index++] = p2Normal.z;
                            }
                            coords[index] = q2.x;
                            normals[index++] = q2Normal.x;
                            coords[index] = q2.y;
                            normals[index++] = q2Normal.y;
                            coords[index] = q2.z;
                            normals[index++] = q2Normal.z;
                            pn1.x = n1.x;
                            pn1.y = n1.y;
                            pn1.z = n1.z;
                            pn2.x = n2.x;
                            pn2.y = n2.y;
                            pn2.z = n2.z;
                            p1.x = p2.x;
                            p1.y = p2.y;
                            p1.z = p2.z;
                            q1.x = q2.x;
                            q1.y = q2.y;
                            q1.z = q2.z;
                            ++k;
                        }
                        pn1 = null;
                        pn2 = null;
                        ++j;
                    }
                    ++i;
                }
                if (geomTransform && !this.isIdentityTransform) {
                    this.transformCoords(coords);
                    this.transformNormals(normals);
                }
                if (byReference) {
                    triAry.setCoordRefFloat(coords);
                    triAry.setNormalRefFloat(normals);
                } else {
                    triAry.setCoordinates(0, coords);
                    triAry.setNormals(0, normals);
                }
            } else {
                int offset = 0;
                Point3f P2 = new Point3f();
                Point3f Q2 = new Point3f();
                Point3f P1 = new Point3f();
                Vector3f nn1 = new Vector3f();
                Vector3f nn2 = new Vector3f();
                Vector3f nn3 = new Vector3f();
                Vector3f nna = new Vector3f();
                Vector3f nnb = new Vector3f();
                Point2f[] extrPnts = this.shapeExtrusion.getExtrusion();
                int extrPntsLength = extrPnts.length;
                i = 0;
                while (i < numIslands) {
                    j = 0;
                    k = 0;
                    num = 0;
                    offset = 0;
                    while (j < islandCounts[i].length) {
                        boolean isFirst = true;
                        boolean isLast = false;
                        float cosFirst = 0.0f;
                        float cosa = 0.0f;
                        float cosb = 0.0f;
                        p1.x = outVerts[i][(num += islandCounts[i][j]) - 1].x;
                        p1.y = outVerts[i][num - 1].y;
                        p1.z = 0.0f;
                        q1.x = p1.x;
                        q1.y = p1.y;
                        q1.z = p1.z + this.shapeExtrusion.getDepth();
                        p3.z = 0.0f;
                        int m = num - 2;
                        while (m >= 0) {
                            p3.x = outVerts[i][m].x;
                            p3.y = outVerts[i][m].y;
                            if (this.getNormal(p3, q1, p1, nn1)) {
                                if (!flip_side_orient) {
                                    nn1.negate();
                                }
                                goodNormal.set((Tuple3f)nn1);
                                break;
                            }
                            --m;
                        }
                        while (k < num) {
                            isLast = k == num - 1;
                            p2.x = outVerts[i][k].x;
                            p2.y = outVerts[i][k].y;
                            p2.z = 0.0f;
                            q2.x = p2.x;
                            q2.y = p2.y;
                            q2.z = p2.z + this.shapeExtrusion.getDepth();
                            this.getNormal(p1, q1, p2, nn2);
                            if (!flip_side_orient) {
                                nn2.negate();
                            }
                            p3.x = outVerts[i][k + 1 == num ? offset : k + 1].x;
                            p3.y = outVerts[i][k + 1 == num ? offset : k + 1].y;
                            p3.z = 0.0f;
                            if (!this.getNormal(p3, p2, q2, nn3)) {
                                nn3.set((Tuple3f)goodNormal);
                            } else {
                                if (!flip_side_orient) {
                                    nn3.negate();
                                }
                                goodNormal.set((Tuple3f)nn3);
                            }
                            nna.x = nn1.x + nn2.x;
                            nna.y = nn1.y + nn2.y;
                            nna.z = nn1.z + nn2.z;
                            this.normalize(nna);
                            nnb.x = nn3.x + nn2.x;
                            nnb.y = nn3.y + nn2.y;
                            nnb.z = nn3.z + nn2.z;
                            this.normalize(nnb);
                            P1.x = p1.x;
                            P1.y = p1.y;
                            P1.z = p1.z;
                            P2.x = p2.x;
                            P2.y = p2.y;
                            P2.z = p2.z;
                            Q2.x = q2.x;
                            Q2.y = q2.y;
                            Q2.z = q2.z;
                            if (isFirst) {
                                cosFirst = cosa = nna.dot(nn1);
                                isFirst = false;
                            } else {
                                cosa = cosb;
                            }
                            cosb = isLast ? cosFirst : nnb.dot(nn3);
                            m = 1;
                            while (m < extrPntsLength) {
                                if (this.shapeExtrusion.isT3DStyleExtrusion()) {
                                    q1.x = P1.x + nna.x * extrPnts[m].y;
                                    q1.y = P1.y + nna.y * extrPnts[m].y;
                                    q2.x = P2.x + nnb.x * extrPnts[m].y;
                                    q2.y = P2.y + nnb.y * extrPnts[m].y;
                                } else {
                                    q1.x = P1.x + nna.x * extrPnts[m].y / cosa;
                                    q1.y = P1.y + nna.y * extrPnts[m].y / cosa;
                                    q2.x = P2.x + nnb.x * extrPnts[m].y / cosb;
                                    q2.y = P2.y + nnb.y * extrPnts[m].y / cosb;
                                }
                                q1.z = q2.z = extrPnts[m].x;
                                if (flip_side_orient) {
                                    coords[index++] = p1.x;
                                    coords[index++] = p1.y;
                                    coords[index++] = p1.z;
                                    coords[index++] = q1.x;
                                    coords[index++] = q1.y;
                                    coords[index++] = q1.z;
                                } else {
                                    coords[index++] = q1.x;
                                    coords[index++] = q1.y;
                                    coords[index++] = q1.z;
                                    coords[index++] = p1.x;
                                    coords[index++] = p1.y;
                                    coords[index++] = p1.z;
                                }
                                coords[index++] = p2.x;
                                coords[index++] = p2.y;
                                coords[index++] = p2.z;
                                if (flip_side_orient) {
                                    coords[index++] = p2.x;
                                    coords[index++] = p2.y;
                                    coords[index++] = p2.z;
                                    coords[index++] = q1.x;
                                    coords[index++] = q1.y;
                                    coords[index++] = q1.z;
                                } else {
                                    coords[index++] = q1.x;
                                    coords[index++] = q1.y;
                                    coords[index++] = q1.z;
                                    coords[index++] = p2.x;
                                    coords[index++] = p2.y;
                                    coords[index++] = p2.z;
                                }
                                coords[index++] = q2.x;
                                coords[index++] = q2.y;
                                coords[index++] = q2.z;
                                p1.x = q1.x;
                                p1.y = q1.y;
                                p1.z = q1.z;
                                p2.x = q2.x;
                                p2.y = q2.y;
                                p2.z = q2.z;
                                ++m;
                            }
                            p1.x = P2.x;
                            p1.y = P2.y;
                            p1.z = P2.z;
                            q1.x = Q2.x;
                            q1.y = Q2.y;
                            q1.z = Q2.z;
                            nn1.x = nn2.x;
                            nn1.y = nn2.y;
                            nn1.z = nn2.z;
                            ++k;
                        }
                        offset = num;
                        ++j;
                    }
                    ++i;
                }
                if (geomTransform && !this.isIdentityTransform) {
                    this.transformCoords(coords);
                }
                GeometryInfo giShape = new GeometryInfo(1);
                giShape.setCoordinates(coords);
                NormalGenerator ngShape = new NormalGenerator(this.creaseAngle);
                ngShape.generateNormals(giShape);
                triAry = byReference ? giShape.getGeometryArray(true, false, false) : giShape.getGeometryArray();
            }
        } else {
            if (geomTransform && !this.isIdentityTransform) {
                this.transformCoords(coords);
            }
            if (byReference) {
                triAry.setCoordRefFloat(coords);
                triAry.setNormalRefFloat(normals);
            } else {
                triAry.setCoordinates(0, coords);
                triAry.setNormals(0, normals);
            }
        }
        return triAry;
    }

    private boolean getNormal(Point3f p1, Point3f p2, Point3f p3, Vector3f normal) {
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        v1.sub((Tuple3f)p2, (Tuple3f)p1);
        v2.sub((Tuple3f)p3, (Tuple3f)p1);
        normal.cross(v1, v2);
        float length = normal.length();
        if (length > 0.0f) {
            length = 1.0f / length;
            normal.x *= length;
            normal.y *= length;
            normal.z *= length;
            return true;
        }
        return false;
    }

    private boolean normalize(Vector3f v) {
        float len = v.length();
        if (len > 0.0f) {
            len = 1.0f / len;
            v.x *= len;
            v.y *= len;
            v.z *= len;
            return true;
        }
        return false;
    }

    private Point3f[] removeDegeneratedTrias(GeometryArray ga) {
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        Vector3f n = new Vector3f();
        int length = ga.getVertexCount();
        Point3f[] points = new Point3f[length];
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        Point3f p3 = new Point3f();
        int k = 0;
        int i = 0;
        while (i < length) {
            ga.getCoordinate(i, p1);
            ga.getCoordinate(i + 1, p2);
            ga.getCoordinate(i + 2, p3);
            v1.sub((Tuple3f)p2, (Tuple3f)p1);
            v2.sub((Tuple3f)p3, (Tuple3f)p1);
            n.cross(v1, v2);
            if (n.length() > 0.0f) {
                points[k++] = new Point3f(p1);
                points[k++] = new Point3f(p2);
                points[k++] = new Point3f(p3);
            }
            i += 3;
        }
        if (k == length) {
            return points;
        }
        Point3f[] pointArray = new Point3f[k];
        int i2 = 0;
        while (i2 < k) {
            pointArray[i2] = points[i2];
            ++i2;
        }
        return pointArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IslandsNode {
        private ArrayList<IslandsNode> islandsList = null;
        private int startIdx;
        private int endIdx;

        IslandsNode(int startIdx, int endIdx) {
            this.startIdx = startIdx;
            this.endIdx = endIdx;
            this.islandsList = null;
        }

        void addChild(IslandsNode node) {
            if (this.islandsList == null) {
                this.islandsList = new ArrayList(5);
            }
            this.islandsList.add(node);
        }

        void removeChild(IslandsNode node) {
            this.islandsList.remove(this.islandsList.indexOf(node));
        }

        IslandsNode getChild(int idx) {
            return this.islandsList.get(idx);
        }

        int numChild() {
            return this.islandsList == null ? 0 : this.islandsList.size();
        }

        int numVertices() {
            return this.endIdx - this.startIdx;
        }

        void insert(IslandsNode newNode, Point3f[] vertices) {
            boolean createNewLevel = false;
            if (this.islandsList != null) {
                int i = this.numChild() - 1;
                while (i >= 0) {
                    IslandsNode childNode = this.getChild(i);
                    int status = this.check2Contours(newNode.startIdx, newNode.endIdx, childNode.startIdx, childNode.endIdx, vertices);
                    switch (status) {
                        case 2: {
                            childNode.insert(newNode, vertices);
                            return;
                        }
                        case 3: {
                            newNode.addChild(childNode);
                            createNewLevel = true;
                        }
                    }
                    --i;
                }
            }
            if (createNewLevel) {
                int i = newNode.numChild() - 1;
                while (i >= 0) {
                    this.removeChild(newNode.getChild(i));
                    --i;
                }
            }
            this.addChild(newNode);
        }

        private void collectOddLevelNode(ArrayList<IslandsNode> list, int level) {
            if (level % 2 == 1) {
                list.add(this);
            }
            if (this.islandsList != null) {
                ++level;
                int i = this.numChild() - 1;
                while (i >= 0) {
                    this.getChild(i).collectOddLevelNode(list, level);
                    --i;
                }
            }
        }

        private int check2Contours(int begin1, int end1, int begin2, int end2, Point3f[] vertices) {
            boolean inside2 = this.pointInPolygon2D(vertices[begin1].x, vertices[begin1].y, begin2, end2, vertices);
            int i = begin1 + 1;
            while (i < end1) {
                if (this.pointInPolygon2D(vertices[i].x, vertices[i].y, begin2, end2, vertices) != inside2) {
                    return 1;
                }
                ++i;
            }
            boolean inside1 = this.pointInPolygon2D(vertices[begin2].x, vertices[begin2].y, begin1, end1, vertices);
            i = begin2 + 1;
            while (i < end2) {
                if (this.pointInPolygon2D(vertices[i].x, vertices[i].y, begin1, end1, vertices) != inside1) {
                    return 1;
                }
                ++i;
            }
            if (!inside2) {
                if (!inside1) {
                    return 0;
                }
                return 3;
            }
            return 2;
        }

        private boolean pointInPolygon2D(float x, float y, int begIdx, int endIdx, Point3f[] verts) {
            float xi;
            int num_intersections = 0;
            int i = begIdx;
            while (i < endIdx - 1) {
                if (!(verts[i].y >= y && verts[i + 1].y >= y || verts[i].y < y && verts[i + 1].y < y || !(x < (xi = verts[i].x + (verts[i].x - verts[i + 1].x) * (y - verts[i].y) / (verts[i].y - verts[i + 1].y))))) {
                    ++num_intersections;
                }
                ++i;
            }
            if (!(verts[i].y >= y && verts[begIdx].y >= y || verts[i].y < y && verts[begIdx].y < y || !(x < (xi = verts[i].x + (verts[i].x - verts[begIdx].x) * (y - verts[i].y) / (verts[i].y - verts[begIdx].y))))) {
                ++num_intersections;
            }
            return num_intersections % 2 != 0;
        }
    }
}

