
package com.interactivemesh.j3d.testspace.jfx.hellocube;

import javax.swing.JPanel;

import javafx.ext.swing.SwingComponent;

// FXCanvas3D API 3.0
//import com.interactivemesh.j3d.community.gui.FXCanvas3DDB; // Alternative
import com.interactivemesh.j3d.community.gui.FXCanvas3DSB;
import com.interactivemesh.j3d.community.gui.FXCanvas3DRepainter;

/**
 * FXCancas3DComp.fx
 * 
 * Version: 2.0
 * Date: 2010/05/14
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'FXCancas3DComp.fx'.
 *
 */

// SwingComponent of lightweight 3D canvas

package class FXCanvas3DComp extends SwingComponent, FXCanvas3DRepainter {

    // Parent of FXCanvas3D
    var container: JPanel;

    // FXCanvas3D instance
    var fxCanvas3D: FXCanvas3DSB;


    // Create SwingComponent - called at construction time
    override protected function createJComponent(): JPanel {
        container = new JPanel();
    }

    // Called from HelloCubeMain
    package function initFXCanvas3D(universe: HelloCubeUniverse) {
        // Create FXCanvas3D instance
        fxCanvas3D = universe.createFXCanvas3D(this, container);
    }

    // Interface FXCanvas3DRepainter

    // Called from FXCanvas3D
    override function repaintFXCanvas3D() {
        /*
         JavaFX API :
         A deferAction represents an action that should be executed
         at a later time of the system's choosing.
         In systems based on event dispatch, such as Swing, execution of a
         deferAction generally means putting it on the event queue for later processing.
        */
        FX.deferAction(
            function(): Void {

                // Now we are in the JavaFX painting loop and on the EDT

                // !!!!!!!!!!!!!!!!  In case of FXCanvas3DDB  !!!!!!!!!!!!
                // Copy renderImage into paintImage and notify J3D-Renderer thread
                //fxCanvas3D.copyOffScreenBuffer();

                // Repaint FXCanvas3DDB / FXCanvas3DSB

                // Call doesn't wait, paintComponent() will be called in the next loop !?
                fxCanvas3D.repaint();
            }
        );
    }
}
