package com.interactivemesh.j3d.testspace.jfx.hellocube;

import com.javafx.preview.control.MenuItem;
import com.javafx.preview.control.PopupMenu;

import javafx.stage.Stage;

import javafx.scene.Group;
import javafx.scene.Scene;

import javafx.scene.input.MouseButton;
import javafx.scene.layout.LayoutInfo;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;

import javafx.util.Math;

/**
 * HelloCubeMain.fx
 *
 * Version: 2.0
 * Date: 2010/05/14
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'HelloCubeMain.fx'.
 *
 */

// TODO : How to check for application versus applet ??
// API : getArgument("javafx.applet") will return null if not running as an applet
// API : This is an experimental facility, that may be changed in future versions.
var isApplication: Boolean = (FX.getArgument("javafx.applet") == null);

var stage: Stage;

var border: Number = 50;

// FXCanvas3D
def fxCanvas3DComp = FXCanvas3DComp {
    // Resizing, min size 10x10
    layoutInfo: LayoutInfo {
        width: bind Math.max(10, stage.scene.width - 2 * border);
        height: bind Math.max(10, stage.scene.height - 2 * border);
    }
}

// HelloCubeUniverse
def universeFX = HelloCubeUniverseFX {
    // Callback of AsyncOperation
    initUniverse: function(universe: HelloCubeUniverse): Void {
        // Finish FXCanvas3DComp
        fxCanvas3DComp.initFXCanvas3D(universe);
        // Show frame
        stage.visible = true;

        // Print properties
        printSystemProps();
        universe.printJava3DProps();
    }
}

def popupMenu = PopupMenu {
    items: [
        MenuItem {
            text: "Exit application"
            action: function() { stage.close() }
        }
    ]
}

stage = Stage {

    title: "InteractiveMesh : Java 3D meets JavaFX  ""\"Hello Cube\""

    resizable: true
    visible: false // !!
    
    onClose: function() {
        universeFX.closeUniverse();
    }

    scene: Scene {

        width: 960
        height: 600

        fill: Color.color(0.0, 0.4, 0.8);

        var popupPanel: Rectangle;

        content: [
            // Context menu
            popupMenu,

            // Background node for popup menu
            popupPanel = Rectangle {
                width: bind stage.scene.width
                height: bind stage.scene.height
                fill: Color.color(0.0, 0.4, 0.8)
                onMousePressed: function (event) {
                    if (popupMenu.showing)
                        popupMenu.hide();
                }
                onMouseClicked: function(event) {
                    if (isApplication and event.button == MouseButton.SECONDARY) {
                        popupMenu.show(popupPanel, event.screenX+5, event.screenY);
                    }
                }
            },

            // 3D
            Group {
                layoutX: border
                layoutY: border
                content: [
                    // Lightweight canvas of Java 3D scene
                    fxCanvas3DComp
                ]
            }
        ]
    }
}

//
// Start
//
// Execute JavaTaskBase
universeFX.start();


// System properties
function printSystemProps() {
    FX.println("");
    FX.println("------------------------------------------------------------------------");
    FX.println("SYSTEM  PROPERTIES");
    FX.println("------------------------------------------------------------------------");
    FX.println("OS      Name     =  {FX.getProperty("javafx.os.name")}");
    FX.println("OS      Arch     =  {FX.getProperty("javafx.os.arch")}");
    FX.println("OS      Version  =  {FX.getProperty("javafx.os.version")}");
    FX.println("------------------------------------------------------------------------");
    FX.println("JavaFX  Version  =  {FX.getProperty("javafx.version")}");
    FX.println("Java    Version  =  {FX.getProperty("javafx.java.version")}");
    FX.println("Java    Vender   =  {FX.getProperty("javafx.java.vendor")}");
    FX.println("------------------------------------------------------------------------");
}

