/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.gui;

import com.interactivemesh.j3d.community.gui.FXCanvas3DRepainter;
import com.sun.j3d.exp.swing.impl.AutoOffScreenCanvas3D;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class FXCanvas3DAnaglyph
extends JPanel
implements AncestorListener {
    private static double METERS_PER_PIXEL = 2.8222222222222223E-4;
    private GraphicsConfiguration graphicsConfig = null;
    private InternalCanvas3D canvasLeft = null;
    private InternalCanvas3D canvasRight = null;
    private long wakeupEventMasks = 0L;
    private BufferedImage paintImage = null;
    private int[] paintIntBuffer = null;
    private int[] renderIntBufferLeft = null;
    private int[] renderIntBufferRight = null;
    private volatile int imageWidth = 0;
    private volatile int imageHeight = 0;
    private long swapTimeLast = 0L;
    private long swapTimeCurr = 0L;
    private boolean isEyeSwapedLeft = false;
    private boolean isEyeSwapedRight = false;
    private ReentrantLock imageAccessLock = null;
    private Condition imageCopyCondition = null;
    private Condition imageResizeCondition = null;
    private boolean isImageCopied = false;
    private boolean isRendererLocked = false;
    private FXCanvas3DRepainter repainter = null;
    private Runnable repaintCall = null;
    private static final int LIMIT_WAIT = 200000000;
    private static final int LIMIT_SWAP = 400000000;

    public FXCanvas3DAnaglyph() {
        this(null, null);
    }

    public FXCanvas3DAnaglyph(GraphicsDevice device) {
        this(null, device);
    }

    public FXCanvas3DAnaglyph(GraphicsConfigTemplate3D template) {
        this(template, null);
    }

    public FXCanvas3DAnaglyph(GraphicsConfigTemplate3D template, GraphicsDevice device) {
        if (template == null) {
            template = new GraphicsConfigTemplate3D();
        }
        template.setStereo(3);
        template.setDoubleBuffer(3);
        this.graphicsConfig = device == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template) : device.getBestConfiguration((GraphicsConfigTemplate)template);
        this.addAncestorListener(this);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.imageAccessLock = new ReentrantLock();
        this.imageCopyCondition = this.imageAccessLock.newCondition();
        this.imageResizeCondition = this.imageAccessLock.newCondition();
        this.repaintCall = new RepaintCall();
    }

    public void setRepainter(FXCanvas3DRepainter painter) {
        this.repainter = painter;
    }

    public void copyOffScreenBuffer() {
        if (this.paintImage != null) {
            try {
                this.imageAccessLock.lock();
                int argb = 0;
                int gLeft = 0;
                int bLeft = 0;
                int rPaint = 0;
                int i = 0;
                int j = 0;
                while (j < this.imageHeight) {
                    int k = 0;
                    while (k < this.imageWidth) {
                        argb = this.renderIntBufferLeft[i];
                        gLeft = argb >> 8 & 0xFF;
                        bLeft = argb & 0xFF;
                        rPaint = (int)(0.7 * (double)gLeft + 0.3 * (double)bLeft);
                        argb = this.renderIntBufferRight[i];
                        this.paintIntBuffer[i] = argb & 0xFF00FFFF | rPaint << 16;
                        ++i;
                        ++k;
                    }
                    ++j;
                }
                this.isImageCopied = true;
                this.imageCopyCondition.signal();
            }
            finally {
                this.imageAccessLock.unlock();
            }
        }
    }

    private void postSwapDone(int eye) {
        this.swapTimeCurr = System.nanoTime();
        if (this.swapTimeCurr - this.swapTimeLast > 400000000L) {
            this.isEyeSwapedLeft = false;
            this.isEyeSwapedRight = false;
        }
        this.swapTimeLast = this.swapTimeCurr;
        if (eye == 0) {
            if (this.isEyeSwapedLeft) {
                return;
            }
            this.isEyeSwapedLeft = true;
        }
        if (eye == 1) {
            if (this.isEyeSwapedRight) {
                return;
            }
            this.isEyeSwapedRight = true;
        }
        if (!this.isEyeSwapedLeft || !this.isEyeSwapedRight) {
            return;
        }
        if (!this.imageAccessLock.tryLock()) {
            this.isEyeSwapedLeft = false;
            this.isEyeSwapedRight = false;
            return;
        }
        try {
            this.isImageCopied = false;
            SwingUtilities.invokeLater(this.repaintCall);
            while (!this.isImageCopied) {
                this.isRendererLocked = true;
                try {
                    this.imageCopyCondition.awaitNanos(200000000L);
                    this.isImageCopied = true;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.isRendererLocked = false;
            this.imageResizeCondition.signal();
        }
        finally {
            this.isEyeSwapedLeft = false;
            this.isEyeSwapedRight = false;
            this.imageAccessLock.unlock();
        }
    }

    public void ancestorAdded(AncestorEvent event) {
        Dimension sz = this.getSize();
        if (sz.width < 1) {
            sz.width = 100;
        }
        if (sz.height < 1) {
            sz.height = 100;
        }
        this.createCanvas(sz.width, sz.height);
        this.canvasLeft.addNotifyFlag = true;
        this.canvasLeft.addNotify();
        this.canvasRight.addNotifyFlag = true;
        this.canvasRight.addNotify();
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.canvasLeft.removeNotify();
        this.canvasRight.removeNotify();
    }

    public Canvas3D getOffscreenCanvas3DLeft() {
        if (this.canvasLeft == null) {
            this.createCanvas(this.getWidth(), this.getHeight());
        }
        return this.canvasLeft;
    }

    public Canvas3D getOffscreenCanvas3DRight() {
        if (this.canvasRight == null) {
            this.createCanvas(this.getWidth(), this.getHeight());
        }
        return this.canvasRight;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.createCanvas(width, height);
    }

    private void createCanvas(int width, int height) {
        if (this.getParent() == null) {
            return;
        }
        final int w = Math.max(1, width);
        final int h = Math.max(1, height);
        if (this.canvasLeft == null) {
            this.canvasLeft = new InternalCanvas3D(this.graphicsConfig, 0);
            this.canvasRight = new InternalCanvas3D(this.graphicsConfig, 1);
        } else if (this.canvasLeft.getWidth() == w && this.canvasLeft.getHeight() == h) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.createOffScreenBuffers(this.graphicsConfig.getBounds(), w, h);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FXCanvas3DAnaglyph.this.createOffScreenBuffers(FXCanvas3DAnaglyph.this.graphicsConfig.getBounds(), w, h);
                }
            });
        }
    }

    private void createOffScreenBuffers(Rectangle screenRect, int width, int height) {
        try {
            this.imageAccessLock.lock();
            while (this.isRendererLocked) {
                this.isImageCopied = true;
                this.imageCopyCondition.signal();
                try {
                    this.imageResizeCondition.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.canvasLeft.createOffScreenBuffers(this.graphicsConfig.getBounds(), width, height);
            this.canvasRight.createOffScreenBuffers(this.graphicsConfig.getBounds(), width, height);
        }
        finally {
            this.imageAccessLock.unlock();
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.paintImage != null && this.canvasLeft.isRendererRunning() && this.canvasRight.isRendererRunning()) {
            g.drawImage(this.paintImage, 0, this.imageHeight, this.imageWidth, 0, 0, 0, this.imageWidth, this.imageHeight, null);
        }
    }

    public void enableWakeupOnAWTEvents(long eventMasks) {
        if ((eventMasks & 1L) != 0L) {
            this.wakeupEventMasks |= 1L;
        }
        if ((eventMasks & 4L) != 0L) {
            this.wakeupEventMasks |= 4L;
        }
        if ((eventMasks & 8L) != 0L) {
            this.wakeupEventMasks |= 8L;
        }
        if ((eventMasks & 0x10L) != 0L) {
            this.wakeupEventMasks |= 0x10L;
        }
        if ((eventMasks & 0x20L) != 0L) {
            this.wakeupEventMasks |= 0x20L;
        }
        if ((eventMasks & 0x20000L) != 0L) {
            this.wakeupEventMasks |= 0x20000L;
        }
        this.enableEvents(this.wakeupEventMasks);
    }

    public void disableWakeupOnAWTEvents(long eventMasks) {
        this.wakeupEventMasks &= eventMasks ^ 0xFFFFFFFFFFFFFFFFL;
        this.disableEvents(eventMasks);
    }

    protected void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        if ((this.wakeupEventMasks & 1L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvasLeft);
            this.canvasLeft.processComponentEvent(e);
            e.setSource(src);
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if ((this.wakeupEventMasks & 4L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvasLeft);
            this.canvasLeft.processFocusEvent(e);
            e.setSource(src);
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if ((this.wakeupEventMasks & 8L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvasLeft);
            this.canvasLeft.processKeyEvent(e);
            e.setSource(src);
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if ((this.wakeupEventMasks & 0x10L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvasLeft);
            this.canvasLeft.processMouseEvent(e);
            e.setSource(src);
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if ((this.wakeupEventMasks & 0x20L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvasLeft);
            this.canvasLeft.processMouseMotionEvent(e);
            e.setSource(src);
        }
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
        if ((this.wakeupEventMasks & 0x20000L) != 0L) {
            Object src = e.getSource();
            e.setSource((Object)this.canvasLeft);
            this.canvasLeft.processMouseWheelEvent(e);
            e.setSource(src);
        }
    }

    private final class InternalCanvas3D
    extends Canvas3D
    implements AutoOffScreenCanvas3D {
        private BufferedImage renderImage;
        private int eye;
        private boolean addNotifyFlag;

        private InternalCanvas3D(GraphicsConfiguration graphicsConfiguration, int eye) {
            super(graphicsConfiguration, true);
            this.renderImage = null;
            this.eye = -1;
            this.addNotifyFlag = false;
            this.eye = eye;
            this.setMonoscopicViewPolicy(eye);
        }

        private void createOffScreenBuffers(Rectangle screenRect, int width, int height) {
            this.stopRenderer();
            int screenWidth = (int)screenRect.getWidth();
            int screenHeight = (int)screenRect.getHeight();
            Screen3D screen3D = this.getScreen3D();
            screen3D.setSize(screenWidth, screenHeight);
            screen3D.setPhysicalScreenWidth((double)screenWidth * METERS_PER_PIXEL);
            screen3D.setPhysicalScreenHeight((double)screenHeight * METERS_PER_PIXEL);
            if (this.renderImage != null) {
                this.renderImage.flush();
            }
            if (this.eye == 0 && FXCanvas3DAnaglyph.this.paintImage != null) {
                FXCanvas3DAnaglyph.this.paintImage.flush();
            }
            this.renderImage = new BufferedImage(width, height, 2);
            ImageComponent2D image = new ImageComponent2D(2, this.renderImage, true, true);
            image.setCapability(2);
            image.setCapability(3);
            if (this.eye == 0) {
                FXCanvas3DAnaglyph.this.paintImage = new BufferedImage(width, height, 2);
                FXCanvas3DAnaglyph.this.paintIntBuffer = ((DataBufferInt)FXCanvas3DAnaglyph.this.paintImage.getRaster().getDataBuffer()).getData();
                FXCanvas3DAnaglyph.this.renderIntBufferLeft = ((DataBufferInt)this.renderImage.getRaster().getDataBuffer()).getData();
                FXCanvas3DAnaglyph.this.imageWidth = width;
                FXCanvas3DAnaglyph.this.imageHeight = height;
            } else {
                FXCanvas3DAnaglyph.this.renderIntBufferRight = ((DataBufferInt)this.renderImage.getRaster().getDataBuffer()).getData();
            }
            this.waitForOffScreenRendering();
            try {
                this.setOffScreenBuffer(image);
            }
            catch (RestrictedAccessException e) {
                this.createOffScreenBuffers(screenRect, width, height);
                System.out.println("Repeat : createOffScreenBuffer(screenRect, width, height) !!");
            }
            this.startRenderer();
        }

        public void addNotify() {
            if (!this.addNotifyFlag) {
                throw new UnsupportedOperationException("User must not call this method !!");
            }
            this.addNotifyFlag = false;
            super.addNotify();
        }

        public Container getParent() {
            return FXCanvas3DAnaglyph.this.getParent();
        }

        public void postSwap() {
            FXCanvas3DAnaglyph.this.postSwapDone(this.eye);
        }

        protected void processComponentEvent(ComponentEvent e) {
            super.processComponentEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
        }

        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            super.processMouseWheelEvent(e);
        }
    }

    private final class RepaintCall
    implements Runnable {
        private RepaintCall() {
        }

        public void run() {
            if (FXCanvas3DAnaglyph.this.repainter != null) {
                FXCanvas3DAnaglyph.this.repainter.repaintFXCanvas3D();
            }
        }
    }
}

