/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.gui;

import com.sun.j3d.exp.swing.impl.AutoOffScreenCanvas3D;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class JCanvas3DYUp
extends JPanel
implements AncestorListener {
    public static final int RESIZE_IMMEDIATELY = 0;
    public static final int RESIZE_DELAYED = 1;
    private static double METERS_PER_PIXEL = 2.8222222222222223E-4;
    private GraphicsConfigTemplate3D template;
    private GraphicsConfiguration graphicsConfig;
    private InternalCanvas3D canvas;
    private boolean hasBeenAdded = false;
    int resizeMode;
    int resizeValidationDelay;
    private GraphicsDevice device;

    public JCanvas3DYUp() {
        this(null, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public JCanvas3DYUp(GraphicsDevice device) {
        this(null, device);
    }

    public JCanvas3DYUp(GraphicsConfigTemplate3D template) {
        this(template, GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    public JCanvas3DYUp(GraphicsConfigTemplate3D template, GraphicsDevice device) {
        this.device = device;
        this.template = new GraphicsConfigTemplate3D();
        if (template != null) {
            this.template.setRedSize(template.getRedSize());
            this.template.setGreenSize(template.getGreenSize());
            this.template.setBlueSize(template.getBlueSize());
            this.template.setDepthSize(template.getDepthSize());
            this.template.setSceneAntialiasing(template.getSceneAntialiasing());
            this.template.setStencilSize(template.getStencilSize());
        }
        this.template.setStereo(3);
        this.template.setDoubleBuffer(3);
        this.graphicsConfig = this.device.getBestConfiguration((GraphicsConfigTemplate)this.template);
        this.addAncestorListener(this);
        this.setDoubleBuffered(false);
        this.setResizeMode(0);
        this.setResizeValidationDelay(100);
        this.setFocusable(true);
    }

    public void ancestorAdded(AncestorEvent event) {
        Dimension sz = this.getSize();
        if (sz.width == 0) {
            sz.width = 100;
        }
        if (sz.height == 0) {
            sz.height = 100;
        }
        this.createCanvas(sz.width, sz.height);
        this.canvas.addNotifyFlag = true;
        this.canvas.addNotify();
        this.hasBeenAdded = true;
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
        this.hasBeenAdded = false;
        this.canvas.removeNotify();
    }

    private void computePhysicalDimensions() {
        Rectangle screenRect = this.graphicsConfig.getBounds();
        int screenWidth = (int)screenRect.getWidth();
        int screenHeight = (int)screenRect.getHeight();
        this.canvas.getScreen3D().setSize(screenWidth, screenHeight);
        this.canvas.getScreen3D().setPhysicalScreenWidth((double)screenWidth * METERS_PER_PIXEL);
        this.canvas.getScreen3D().setPhysicalScreenHeight((double)screenHeight * METERS_PER_PIXEL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void createCanvas(int width, int height) {
        if (this.getParent() == null) {
            return;
        }
        if (this.canvas != null) {
            if (width == this.canvas.getWidth() && height == this.canvas.getHeight()) return;
            if (this.canvas.getOffScreenBuffer() != null && this.canvas.getOffScreenBuffer().getImage() != null) {
                this.canvas.getOffScreenBuffer().getImage().flush();
            }
        } else {
            this.canvas = new InternalCanvas3D(this.graphicsConfig, this);
        }
        this.createOffScreenBuffer(width, height);
    }

    private void createOffScreenBuffer(int width, int height) {
        this.computePhysicalDimensions();
        BufferedImage bImage = new BufferedImage(width, height, 2);
        ImageComponent2D image = new ImageComponent2D(2, bImage, true, true);
        image.setCapability(2);
        image.setCapability(3);
        this.canvas.stopRenderer();
        this.canvas.waitForOffScreenRendering();
        this.canvas.setOffScreenBuffer(image);
        this.canvas.startRenderer();
    }

    public Canvas3D getOffscreenCanvas3D() {
        if (this.canvas == null) {
            this.createCanvas(this.getWidth(), this.getHeight());
        }
        return this.canvas;
    }

    public int getResizeMode() {
        return this.resizeMode;
    }

    public int getResizeValidationDelay() {
        return this.resizeValidationDelay;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hasBeenAdded) {
            if (!this.canvas.canvasCrashed && this.canvas.isRendererRunning()) {
                this.canvas.waitForSwap();
            }
            if (this.canvas.bi != null) {
                g.drawImage(this.canvas.bi, 0, this.getHeight(), this.getWidth(), 0, 0, 0, this.getWidth(), this.getHeight(), null);
            }
        }
    }

    protected void processComponentKeyEvent(KeyEvent e) {
        super.processComponentKeyEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processComponentEvent(e);
        e.setSource(src);
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processFocusEvent(e);
        e.setSource(src);
    }

    protected void processInputMethodEvent(InputMethodEvent e) {
        super.processInputMethodEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processInputMethodEvent(e);
        e.setSource(src);
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processKeyEvent(e);
        e.setSource(src);
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseEvent(e);
        e.setSource(src);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseMotionEvent(e);
        e.setSource(src);
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        super.processMouseWheelEvent(e);
        Object src = e.getSource();
        e.setSource((Object)this.canvas);
        this.canvas.processMouseWheelEvent(e);
        e.setSource(src);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.canvas == null || this.canvas.getOffScreenBuffer() == null || this.getResizeMode() == 0) {
            this.createCanvas(width, height);
        } else if (1 == this.getResizeMode() && this.canvas.getParent() != null && this.canvas.getParent().isVisible()) {
            if (this.canvas.resizeThread == null || !this.canvas.resizeThread.isAlive()) {
                this.canvas.resizeThread = new ResizeThread(width, height, this.getResizeValidationDelay(), this);
                this.canvas.resizeThread.start();
            } else {
                this.canvas.resizeThread.setWidth(width);
                this.canvas.resizeThread.setHeight(height);
            }
        }
    }

    public void setResizeMode(int resizeMode) {
        this.resizeMode = resizeMode;
    }

    public void setResizeValidationDelay(int resizeValidationDelay) {
        this.resizeValidationDelay = resizeValidationDelay;
    }

    static class InternalCanvas3D
    extends Canvas3D
    implements AutoOffScreenCanvas3D {
        private static final int MAX_WAIT_LOOPS = 5;
        private static final long MAX_WAIT_TIME = 100L;
        BufferedImage bi = null;
        JCanvas3DYUp lwCanvas;
        ResizeThread resizeThread;
        boolean addNotifyFlag;
        protected boolean canvasCrashed;
        boolean imageReadyBis;
        boolean waitingForSwap;

        public InternalCanvas3D(GraphicsConfiguration graphicsConfiguration, JCanvas3DYUp lwCanvas) {
            super(graphicsConfiguration, true);
            this.lwCanvas = lwCanvas;
            this.imageReadyBis = false;
            this.waitingForSwap = false;
            this.addNotifyFlag = false;
        }

        public void addNotify() {
            if (!this.addNotifyFlag) {
                throw new UnsupportedOperationException("CHANGE ME");
            }
            this.addNotifyFlag = false;
            super.addNotify();
        }

        public Container getParent() {
            if (this.lwCanvas == null) {
                return null;
            }
            return this.lwCanvas.getParent();
        }

        public void postRender() {
            this.imageReadyBis = false;
        }

        public synchronized void postSwap() {
            if (this.isRendererRunning()) {
                this.bi = this.getOffScreenBuffer().getImage();
                this.imageReadyBis = true;
                if (!this.waitingForSwap) {
                    this.lwCanvas.repaint();
                } else {
                    ((Object)((Object)this)).notify();
                }
            }
        }

        protected void processComponentEvent(ComponentEvent e) {
            super.processComponentEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
        }

        protected void processInputMethodEvent(InputMethodEvent e) {
            super.processInputMethodEvent(e);
        }

        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            super.processMouseWheelEvent(e);
        }

        synchronized void waitForSwap() {
            int counter = 5;
            while (!this.imageReadyBis) {
                try {
                    this.waitingForSwap = true;
                    ((Object)((Object)this)).wait(100L);
                    this.waitingForSwap = false;
                    if (this.imageReadyBis || --counter > 0) continue;
                    System.err.println("CANVAS CRASHED!!!");
                    this.canvasCrashed = true;
                    return;
                }
                catch (InterruptedException ex) {
                    System.err.println(ex);
                }
            }
        }
    }

    static class ResizeSwingRunnable
    implements Runnable {
        JCanvas3DYUp canvas;
        int height;
        int width;

        private ResizeSwingRunnable() {
        }

        public ResizeSwingRunnable(JCanvas3DYUp canvas, int width, int height) {
            this.canvas = canvas;
            this.width = width;
            this.height = height;
        }

        public void run() {
            this.canvas.createCanvas(this.width, this.height);
        }
    }

    static class ResizeThread
    extends Thread {
        JCanvas3DYUp canvas;
        boolean sizeChanged;
        int delay;
        int height;
        int width;

        private ResizeThread() {
        }

        public ResizeThread(int width, int height, int delay, JCanvas3DYUp canvas) {
            this.width = width;
            this.height = height;
            this.delay = delay;
            this.sizeChanged = true;
            this.canvas = canvas;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block5: while (true) {
                    if (!this.sizeChanged) {
                        return;
                    }
                    while (true) {
                        if (!this.sizeChanged) {
                            try {
                                EventQueue.invokeAndWait(new ResizeSwingRunnable(this.canvas, this.width, this.height));
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                // empty catch block
                            }
                            continue block5;
                        }
                        this.sizeChanged = false;
                        Thread.sleep(this.delay);
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setHeight(int height) {
            if (!this.isAlive()) {
                throw new RuntimeException("Resizing order arrived to a dead resizing thread. Spawn a new one.");
            }
            this.height = height;
            this.sizeChanged = true;
        }

        public void setWidth(int width) {
            if (!this.isAlive()) {
                throw new RuntimeException("Resizing order arrived to a dead resizing thread. Spawn a new one.");
            }
            this.width = width;
            this.sizeChanged = true;
        }
    }
}

