/*
 * Decompiled with CFR 0.152.
 */
package org.interactivemesh.pivot.wtk.j3d;

import com.sun.j3d.exp.swing.impl.AutoOffScreenCanvas3D;
import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.skin.ComponentSkin;

public class PCanvas3D
extends Component {
    private static double METERS_PER_PIXEL = 2.8222222222222223E-4;
    private GraphicsConfiguration graphicsConfig = null;
    private OffscreenCanvas3D canvas = null;
    private Container awtParent = null;
    private long wakeupEventMasks = 0L;
    private boolean isTransOffScreen = false;
    private BufferedImage paintImage = null;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private ReentrantLock imageAccessLock = null;
    private Condition imagePaintCondition = null;
    private volatile boolean isImageDrawn = false;

    public PCanvas3D() {
        this(null, null);
    }

    public PCanvas3D(GraphicsDevice device) {
        this(null, device);
    }

    public PCanvas3D(GraphicsConfigTemplate3D template) {
        this(template, null);
    }

    public PCanvas3D(GraphicsConfigTemplate3D template, GraphicsDevice device) {
        if (template == null) {
            template = new GraphicsConfigTemplate3D();
        }
        template.setStereo(3);
        template.setDoubleBuffer(3);
        this.graphicsConfig = device == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)template) : device.getBestConfiguration((GraphicsConfigTemplate)template);
        this.imageAccessLock = new ReentrantLock();
        this.imagePaintCondition = this.imageAccessLock.newCondition();
        PCanvas3DSkin skin = new PCanvas3DSkin();
        this.setSkin((Skin)skin);
        try {
            this.isTransOffScreen = Boolean.parseBoolean(System.getProperty("j3d.transparentOffScreen"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void setApplicationDisplay(Display display) {
        ApplicationContext.DisplayHost displayHost = display.getDisplayHost();
        this.awtParent = displayHost.getParent();
        if (this.awtParent instanceof Frame) {
            displayHost.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent event) {
                    long flags = event.getChangeFlags();
                    if ((flags & 1L) != 0L) {
                        Container parent = event.getChangedParent();
                        if (PCanvas3D.this.awtParent == parent) {
                            PCanvas3D.this.canvas.removeNotify();
                            PCanvas3D.this.awtParent = null;
                        } else {
                            PCanvas3D.this.awtParent = parent;
                            if (PCanvas3D.this.canvas != null) {
                                PCanvas3D.this.canvas.addNotifyFlag = true;
                                PCanvas3D.this.canvas.addNotify();
                            }
                        }
                    }
                }
            });
        }
    }

    public void enableWakeupOnAWTEvents(long eventMasks) {
        if ((eventMasks & 1L) != 0L) {
            this.wakeupEventMasks |= 1L;
        }
        if ((eventMasks & 4L) != 0L) {
            this.wakeupEventMasks |= 4L;
        }
        if ((eventMasks & 8L) != 0L) {
            this.wakeupEventMasks |= 8L;
        }
        if ((eventMasks & 0x10L) != 0L) {
            this.wakeupEventMasks |= 0x10L;
        }
        if ((eventMasks & 0x20L) != 0L) {
            this.wakeupEventMasks |= 0x20L;
        }
        if ((eventMasks & 0x20000L) != 0L) {
            this.wakeupEventMasks |= 0x20000L;
        }
    }

    public void disableWakeupOnAWTEvents(long eventMasks) {
        this.wakeupEventMasks &= eventMasks ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public Canvas3D getOffscreenCanvas3D() {
        if (this.canvas == null) {
            this.createOffscreenCanvas3D(this.getWidth(), this.getHeight());
        }
        return this.canvas;
    }

    private void createOffscreenCanvas3D(int width, int height) {
        final int w = Math.max(1, width);
        final int h = Math.max(1, height);
        if (this.canvas == null) {
            this.canvas = new OffscreenCanvas3D(this.graphicsConfig);
        } else if (this.canvas.getWidth() == w && this.canvas.getHeight() == h) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.canvas.createOffScreenBuffer(this.graphicsConfig.getBounds(), w, h);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PCanvas3D.this.canvas.createOffScreenBuffer(PCanvas3D.this.graphicsConfig.getBounds(), w, h);
                }
            });
        }
    }

    private final class OffscreenCanvas3D
    extends Canvas3D
    implements AutoOffScreenCanvas3D {
        private Condition imageResizeCondition;
        private boolean isRendererLocked;
        private boolean isWatingForResizing;
        private boolean isSwapStarted;
        private boolean addNotifyFlag;
        private Runnable repaintCall;
        private static final int LIMIT = 200000000;

        private OffscreenCanvas3D(GraphicsConfiguration graphicsConfiguration) {
            super(graphicsConfiguration, true);
            this.imageResizeCondition = null;
            this.isRendererLocked = false;
            this.isWatingForResizing = false;
            this.isSwapStarted = false;
            this.addNotifyFlag = false;
            this.repaintCall = null;
            this.repaintCall = new RepaintCall();
            this.imageResizeCondition = PCanvas3D.this.imageAccessLock.newCondition();
        }

        private void createOffScreenBuffer(Rectangle screenRect, int width, int height) {
            try {
                PCanvas3D.this.imageAccessLock.lock();
                this.stopRenderer();
                this.isWatingForResizing = true;
                while (this.isRendererLocked) {
                    PCanvas3D.this.isImageDrawn = true;
                    PCanvas3D.this.imagePaintCondition.signal();
                    try {
                        this.imageResizeCondition.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.isWatingForResizing = false;
                this.waitForOffScreenRendering();
                int screenWidth = (int)screenRect.getWidth();
                int screenHeight = (int)screenRect.getHeight();
                Screen3D screen3D = this.getScreen3D();
                screen3D.setSize(screenWidth, screenHeight);
                screen3D.setPhysicalScreenWidth((double)screenWidth * METERS_PER_PIXEL);
                screen3D.setPhysicalScreenHeight((double)screenHeight * METERS_PER_PIXEL);
                if (PCanvas3D.this.paintImage != null) {
                    PCanvas3D.this.paintImage.flush();
                }
                PCanvas3D.this.paintImage = new BufferedImage(width, height, 2);
                ImageComponent2D image = new ImageComponent2D(2, PCanvas3D.this.paintImage, true, true);
                image.setCapability(3);
                PCanvas3D.this.imageWidth = width;
                PCanvas3D.this.imageHeight = height;
                try {
                    this.setOffScreenBuffer(image);
                }
                catch (RestrictedAccessException e) {
                    this.createOffScreenBuffer(screenRect, width, height);
                    System.out.println("Repeat : createOffScreenBuffer(screenRect, width, height) !!");
                }
            }
            finally {
                PCanvas3D.this.imageAccessLock.unlock();
            }
            this.startRenderer();
        }

        public void addNotify() {
            if (!this.addNotifyFlag) {
                throw new UnsupportedOperationException("User must not call this method !!");
            }
            this.addNotifyFlag = false;
            super.addNotify();
        }

        public Container getParent() {
            return PCanvas3D.this.awtParent;
        }

        public void preRender() {
            if (this.isSwapStarted) {
                this.isSwapStarted = false;
                try {
                    PCanvas3D.this.imageAccessLock.unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }

        public void postRender() {
            if (this.isRendererRunning()) {
                PCanvas3D.this.imageAccessLock.lock();
                this.isSwapStarted = true;
            }
        }

        public void postSwap() {
            if (this.isSwapStarted) {
                PCanvas3D.this.isImageDrawn = false;
                EventQueue.invokeLater(this.repaintCall);
                while (!PCanvas3D.this.isImageDrawn) {
                    this.isRendererLocked = true;
                    try {
                        PCanvas3D.this.imagePaintCondition.awaitNanos(200000000L);
                        PCanvas3D.this.isImageDrawn = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.isRendererLocked = false;
                    if (!this.isWatingForResizing) continue;
                    this.imageResizeCondition.signal();
                }
                this.isSwapStarted = false;
                try {
                    PCanvas3D.this.imageAccessLock.unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }

        protected void processComponentEvent(ComponentEvent e) {
            super.processComponentEvent(e);
        }

        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
        }

        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            super.processMouseWheelEvent(e);
        }

        private final class RepaintCall
        implements Runnable {
            private RepaintCall() {
            }

            @Override
            public void run() {
                PCanvas3D.this.repaint();
            }
        }
    }

    public final class PCanvas3DSkin
    extends ComponentSkin {
        private Color backgroundColor = null;

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            this.repaintComponent();
        }

        public int getPreferredWidth(int width) {
            return this.getWidth();
        }

        public int getPreferredHeight(int height) {
            return this.getHeight();
        }

        public void layout() {
        }

        public boolean isFocusable() {
            return true;
        }

        public boolean isOpaque() {
            boolean opaque = false;
            if (this.backgroundColor != null && this.backgroundColor.getTransparency() == 1 || !PCanvas3D.this.isTransOffScreen) {
                opaque = true;
            }
            return opaque;
        }

        public void setSize(int width, int height) {
            super.setSize(width, height);
            PCanvas3D.this.createOffscreenCanvas3D(width, height);
        }

        public void paint(Graphics2D g) {
            Rectangle clip = g.getClipBounds();
            if (this.backgroundColor != null) {
                g.setPaint(this.backgroundColor);
                g.fillRect(0, 0, clip.width, clip.height);
            }
            if (PCanvas3D.this.paintImage == null || !PCanvas3D.this.canvas.isRendererRunning()) {
                return;
            }
            boolean isLocked = false;
            try {
                try {
                    isLocked = PCanvas3D.this.imageAccessLock.tryLock(50L, TimeUnit.MILLISECONDS);
                    if (clip.width != PCanvas3D.this.imageWidth || clip.height != PCanvas3D.this.imageHeight) {
                        g.drawImage(PCanvas3D.this.paintImage, clip.x, clip.y + clip.height, clip.x + clip.width, clip.y, clip.x, PCanvas3D.this.imageHeight - (clip.y + clip.height), clip.x + clip.width, PCanvas3D.this.imageHeight - clip.y, null);
                    } else {
                        g.drawImage(PCanvas3D.this.paintImage, 0, PCanvas3D.this.imageHeight, PCanvas3D.this.imageWidth, 0, 0, 0, PCanvas3D.this.imageWidth, PCanvas3D.this.imageHeight, null);
                    }
                    PCanvas3D.this.isImageDrawn = true;
                    if (isLocked) {
                        PCanvas3D.this.imagePaintCondition.signal();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (isLocked) {
                        PCanvas3D.this.imageAccessLock.unlock();
                    }
                }
            }
            finally {
                if (isLocked) {
                    PCanvas3D.this.imageAccessLock.unlock();
                }
            }
        }

        public boolean keyTyped(Component component, char character) {
            boolean consumed = super.keyTyped(component, character);
            if ((PCanvas3D.this.wakeupEventMasks & 8L) != 0L && PCanvas3D.this.canvas != null) {
                KeyEvent event = new KeyEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 400, System.currentTimeMillis(), this.getModifiersEx(), 0, character);
                PCanvas3D.this.canvas.processKeyEvent(event);
                consumed = true;
            }
            return consumed;
        }

        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            boolean consumed = super.keyPressed(component, keyCode, keyLocation);
            if ((PCanvas3D.this.wakeupEventMasks & 8L) != 0L && PCanvas3D.this.canvas != null) {
                KeyEvent event = new KeyEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 401, System.currentTimeMillis(), this.getModifiersEx(), keyCode, '\uffff', this.getKeyLoc(keyLocation));
                PCanvas3D.this.canvas.processKeyEvent(event);
                consumed = true;
            }
            return consumed;
        }

        public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            boolean consumed = super.keyReleased(component, keyCode, keyLocation);
            if ((PCanvas3D.this.wakeupEventMasks & 8L) != 0L && PCanvas3D.this.canvas != null) {
                KeyEvent event = new KeyEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 402, System.currentTimeMillis(), this.getModifiersEx(), keyCode, '\uffff', this.getKeyLoc(keyLocation));
                PCanvas3D.this.canvas.processKeyEvent(event);
                consumed = true;
            }
            return consumed;
        }

        public boolean mouseMove(Component component, int x, int y) {
            boolean consumed = super.mouseMove(component, x, y);
            if ((PCanvas3D.this.wakeupEventMasks & 0x20L) != 0L && PCanvas3D.this.canvas != null) {
                int id = 503;
                if (Mouse.isPressed((Mouse.Button)Mouse.Button.LEFT) || Mouse.isPressed((Mouse.Button)Mouse.Button.RIGHT) || Mouse.isPressed((Mouse.Button)Mouse.Button.MIDDLE)) {
                    id = 506;
                }
                MouseEvent mouseEvent = new MouseEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), id, System.currentTimeMillis(), this.getModifiersEx(), x, y, 1, false, this.getButtons());
                PCanvas3D.this.canvas.processMouseMotionEvent(mouseEvent);
                consumed = true;
            }
            return consumed;
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            if ((PCanvas3D.this.wakeupEventMasks & 0x10L) != 0L && PCanvas3D.this.canvas != null) {
                MouseEvent mouseEvent = new MouseEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 504, System.currentTimeMillis(), this.getModifiersEx(), 0, 0, 1, false, this.getButtons());
                PCanvas3D.this.canvas.processMouseEvent(mouseEvent);
            }
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            if ((PCanvas3D.this.wakeupEventMasks & 0x10L) != 0L && PCanvas3D.this.canvas != null) {
                MouseEvent mouseEvent = new MouseEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 505, System.currentTimeMillis(), this.getModifiersEx(), 0, 0, 1, false, this.getButtons());
                PCanvas3D.this.canvas.processMouseEvent(mouseEvent);
            }
        }

        public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseDown(component, button, x, y);
            PCanvas3D.this.requestFocus();
            if ((PCanvas3D.this.wakeupEventMasks & 0x10L) != 0L && PCanvas3D.this.canvas != null) {
                MouseEvent mouseEvent = new MouseEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 501, System.currentTimeMillis(), this.getModifiersEx(), x, y, 1, false, this.getButtons());
                PCanvas3D.this.canvas.processMouseEvent(mouseEvent);
                consumed = true;
            }
            return consumed;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseUp(component, button, x, y);
            if ((PCanvas3D.this.wakeupEventMasks & 0x10L) != 0L && PCanvas3D.this.canvas != null) {
                MouseEvent mouseEvent = new MouseEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 502, System.currentTimeMillis(), this.getModifiersEx(), x, y, 1, false, this.getButtons());
                PCanvas3D.this.canvas.processMouseEvent(mouseEvent);
                consumed = true;
            }
            return consumed;
        }

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            boolean consumed = super.mouseClick(component, button, x, y, count);
            if ((PCanvas3D.this.wakeupEventMasks & 0x10L) != 0L && PCanvas3D.this.canvas != null) {
                MouseEvent mouseEvent = new MouseEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 500, System.currentTimeMillis(), this.getModifiersEx(), x, y, count, false, this.getButtons());
                PCanvas3D.this.canvas.processMouseEvent(mouseEvent);
                consumed = true;
            }
            return consumed;
        }

        public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            boolean consumed = false;
            if ((PCanvas3D.this.wakeupEventMasks & 0x20000L) != 0L && PCanvas3D.this.canvas != null) {
                int type = 0;
                if (scrollType == Mouse.ScrollType.BLOCK) {
                    type = 1;
                }
                MouseWheelEvent mouseEvent = new MouseWheelEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 507, System.currentTimeMillis(), this.getModifiersEx(), x, y, 1, false, type, scrollAmount, wheelRotation);
                PCanvas3D.this.canvas.processMouseWheelEvent(mouseEvent);
                consumed = true;
            } else {
                consumed = super.mouseWheel(component, scrollType, scrollAmount, wheelRotation, x, y);
            }
            return consumed;
        }

        public void parentChanged(Component component, org.apache.pivot.wtk.Container previousParent) {
            org.apache.pivot.wtk.Container currParent = component.getParent();
            if (currParent == null) {
                if (PCanvas3D.this.canvas != null) {
                    PCanvas3D.this.canvas.removeNotify();
                }
            } else if (previousParent == null) {
                PCanvas3D.this.createOffscreenCanvas3D(currParent.getWidth(), currParent.getHeight());
                if (PCanvas3D.this.canvas != null) {
                    PCanvas3D.this.canvas.addNotifyFlag = true;
                    PCanvas3D.this.canvas.addNotify();
                }
            }
        }

        public void visibleChanged(Component component) {
            if ((PCanvas3D.this.wakeupEventMasks & 1L) != 0L && PCanvas3D.this.canvas != null) {
                int id = 102;
                if (!component.isVisible()) {
                    id = 103;
                }
                PCanvas3D.this.canvas.processComponentEvent(new ComponentEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), id));
            }
        }

        public void locationChanged(Component component, int previousX, int previousY) {
            if ((PCanvas3D.this.wakeupEventMasks & 1L) != 0L && PCanvas3D.this.canvas != null) {
                PCanvas3D.this.canvas.processComponentEvent(new ComponentEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 100));
            }
        }

        public void sizeChanged(Component component, int previousWidth, int previousHeight) {
            if ((PCanvas3D.this.wakeupEventMasks & 1L) != 0L && PCanvas3D.this.canvas != null) {
                PCanvas3D.this.canvas.processComponentEvent(new ComponentEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), 101));
            }
        }

        public void enabledChanged(Component component) {
        }

        public void focusedChanged(Component component, Component obverseComponent) {
            super.focusedChanged(component, obverseComponent);
            if ((PCanvas3D.this.wakeupEventMasks & 4L) != 0L && PCanvas3D.this.canvas != null) {
                int id = 1004;
                if (!component.isFocused()) {
                    id = 1005;
                }
                PCanvas3D.this.canvas.processFocusEvent(new FocusEvent((java.awt.Component)((Object)PCanvas3D.this.canvas), id));
            }
        }

        private int getKeyLoc(Keyboard.KeyLocation loc) {
            if (loc == Keyboard.KeyLocation.STANDARD) {
                return 1;
            }
            if (loc == Keyboard.KeyLocation.LEFT) {
                return 2;
            }
            if (loc == Keyboard.KeyLocation.RIGHT) {
                return 3;
            }
            if (loc == Keyboard.KeyLocation.KEYPAD) {
                return 4;
            }
            return 0;
        }

        private int getModifiersEx() {
            int modifiersEx = 0;
            if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.ALT)) {
                modifiersEx |= 0x200;
            }
            if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.CTRL)) {
                modifiersEx |= 0x80;
            }
            if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.META)) {
                modifiersEx |= 0x100;
            }
            if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                modifiersEx |= 0x40;
            }
            return modifiersEx;
        }

        private int getButtons() {
            int buttons = 0;
            if (Mouse.isPressed((Mouse.Button)Mouse.Button.LEFT)) {
                buttons |= 1;
            }
            if (Mouse.isPressed((Mouse.Button)Mouse.Button.MIDDLE)) {
                buttons |= 2;
            }
            if (Mouse.isPressed((Mouse.Button)Mouse.Button.RIGHT)) {
                buttons |= 3;
            }
            return buttons;
        }
    }
}

