/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Rectangle;
import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bounds
implements Serializable {
    private static final long serialVersionUID = -2473226417628417475L;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public static final String X_KEY = "x";
    public static final String Y_KEY = "y";
    public static final String WIDTH_KEY = "width";
    public static final String HEIGHT_KEY = "height";

    public Bounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Bounds(Point origin, Dimensions size) {
        if (origin == null) {
            throw new IllegalArgumentException("origin is null.");
        }
        if (size == null) {
            throw new IllegalArgumentException("size is null.");
        }
        this.x = origin.x;
        this.y = origin.y;
        this.width = size.width;
        this.height = size.height;
    }

    public Bounds(Bounds bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds is null.");
        }
        this.x = bounds.x;
        this.y = bounds.y;
        this.width = bounds.width;
        this.height = bounds.height;
    }

    public Bounds(Dictionary<String, ?> bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds is null.");
        }
        this.x = bounds.containsKey((Object)X_KEY) ? (Integer)bounds.get((Object)X_KEY) : 0;
        this.y = bounds.containsKey((Object)Y_KEY) ? (Integer)bounds.get((Object)Y_KEY) : 0;
        this.width = bounds.containsKey((Object)WIDTH_KEY) ? (Integer)bounds.get((Object)WIDTH_KEY) : 0;
        this.height = bounds.containsKey((Object)HEIGHT_KEY) ? (Integer)bounds.get((Object)HEIGHT_KEY) : 0;
    }

    public Bounds(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException("rectangle is null.");
        }
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Dimensions getSize() {
        return new Dimensions(this.width, this.height);
    }

    public Bounds union(int x, int y, int width, int height) {
        int x1 = Math.min(this.x, x);
        int y1 = Math.min(this.y, y);
        int x2 = Math.max(this.x + this.width, x + width);
        int y2 = Math.max(this.y + this.height, y + height);
        return new Bounds(x1, y1, x2 - x1, y2 - y1);
    }

    public Bounds union(Bounds bounds) {
        return this.union(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Bounds intersect(int x, int y, int width, int height) {
        int x1 = Math.max(this.x, x);
        int y1 = Math.max(this.y, y);
        int x2 = Math.min(this.x + this.width, x + width);
        int y2 = Math.min(this.y + this.height, y + height);
        return new Bounds(x1, y1, x2 - x1, y2 - y1);
    }

    public Bounds intersect(Bounds bounds) {
        return this.intersect(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Bounds translate(int dx, int dy) {
        return new Bounds(this.x + dx, this.y + dy, this.width, this.height);
    }

    public Bounds translate(Point offset) {
        return this.translate(offset.x, offset.y);
    }

    public boolean contains(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("point is null");
        }
        return this.contains(point.x, point.y);
    }

    public boolean contains(int x, int y) {
        return x >= this.x && y >= this.y && x < this.x + this.width && y < this.y + this.height;
    }

    public boolean contains(Bounds bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds is null");
        }
        return this.contains(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public boolean contains(int x, int y, int width, int height) {
        return !this.isEmpty() && x >= this.x && y >= this.y && x + width <= this.x + this.width && y + height <= this.y + this.height;
    }

    public boolean intersects(Bounds bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException("bounds is null");
        }
        return this.intersects(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public boolean intersects(int x, int y, int width, int height) {
        return !this.isEmpty() && x + width > this.x && y + height > this.y && x < this.x + this.width && y < this.y + this.height;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof Bounds) {
            Bounds bounds = (Bounds)object;
            equals = this.x == bounds.x && this.y == bounds.y && this.width == bounds.width && this.height == bounds.height;
        }
        return equals;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.x + "," + this.y + ";" + this.width + X_KEY + this.height + "]";
    }

    public static Bounds decode(String value) {
        Bounds bounds;
        if (value == null) {
            throw new IllegalArgumentException();
        }
        try {
            bounds = new Bounds((Dictionary<String, ?>)JSONSerializer.parseMap((String)value));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
        return bounds;
    }
}

