/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuBarListener;
import org.apache.pivot.wtk.content.MenuBarItemDataRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="items")
public class MenuBar
extends Container {
    private ArrayList<Item> items = new ArrayList();
    private ItemSequence itemSequence = new ItemSequence();
    private Item activeItem = null;
    private MenuBarListenerList menuBarListeners = new MenuBarListenerList();

    public MenuBar() {
        this.installSkin(MenuBar.class);
    }

    public ItemSequence getItems() {
        return this.itemSequence;
    }

    public Item getActiveItem() {
        return this.activeItem;
    }

    private void setActiveItem(Item activeItem) {
        Item previousActiveItem = this.activeItem;
        if (previousActiveItem != activeItem) {
            this.activeItem = activeItem;
            this.menuBarListeners.activeItemChanged(this, previousActiveItem);
        }
    }

    public void activateNextItem() {
        int n = this.items.getLength();
        int index = this.activeItem == null ? 0 : this.items.indexOf((Object)this.activeItem) + 1;
        while (index < n) {
            Item item;
            if (!(item = (Item)this.items.get(index++)).isEnabled()) continue;
            item.setActive(true);
            break;
        }
    }

    public void activatePreviousItem() {
        int n = this.items.getLength();
        int index = this.activeItem == null ? n - 1 : this.items.indexOf((Object)this.activeItem) - 1;
        while (index >= 0) {
            Item item;
            if (!(item = (Item)this.items.get(index--)).isEnabled()) continue;
            item.setActive(true);
            break;
        }
    }

    public ListenerList<MenuBarListener> getMenuBarListeners() {
        return this.menuBarListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MenuBarListenerList
    extends ListenerList<MenuBarListener>
    implements MenuBarListener {
        private MenuBarListenerList() {
        }

        @Override
        public void itemInserted(MenuBar menuBar, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuBarListener listener = (MenuBarListener)i$.next();
                listener.itemInserted(menuBar, index);
            }
        }

        @Override
        public void itemsRemoved(MenuBar menuBar, int index, Sequence<Item> removed) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuBarListener listener = (MenuBarListener)i$.next();
                listener.itemsRemoved(menuBar, index, removed);
            }
        }

        @Override
        public void activeItemChanged(MenuBar menuBar, Item previousActiveItem) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuBarListener listener = (MenuBarListener)i$.next();
                listener.activeItemChanged(menuBar, previousActiveItem);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ItemSequence
    implements Sequence<Item>,
    Iterable<Item> {
        public int add(Item item) {
            int index = this.getLength();
            this.insert(item, index);
            return index;
        }

        public void insert(Item item, int index) {
            MenuBar.this.add(item);
            MenuBar.this.items.insert((Object)item, index);
            MenuBar.this.menuBarListeners.itemInserted(MenuBar.this, index);
        }

        public Item update(int index, Item item) {
            throw new UnsupportedOperationException();
        }

        public int remove(Item item) {
            int index = MenuBar.this.items.indexOf((Object)item);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Item> remove(int index, int count) {
            Sequence removed = MenuBar.this.items.remove(index, count);
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                Item item = (Item)removed.get(i);
                item.setActive(false);
                MenuBar.this.remove(item);
            }
            MenuBar.this.menuBarListeners.itemsRemoved(MenuBar.this, index, (Sequence<Item>)removed);
            return removed;
        }

        public Item get(int index) {
            return (Item)MenuBar.this.items.get(index);
        }

        public int indexOf(Item item) {
            return MenuBar.this.items.indexOf((Object)item);
        }

        public int getLength() {
            return MenuBar.this.items.getLength();
        }

        @Override
        public Iterator<Item> iterator() {
            return new ImmutableIterator((Iterator)MenuBar.this.items.iterator());
        }
    }

    public static interface ItemListener {
        public void menuChanged(Item var1, Menu var2);

        public void activeChanged(Item var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @DefaultProperty(value="menu")
    public static class Item
    extends Button {
        private Menu menu = null;
        private boolean active = false;
        private ItemListenerList itemListeners = new ItemListenerList();
        private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new MenuBarItemDataRenderer();

        public Item() {
            this(null);
        }

        public Item(Object buttonData) {
            super(buttonData);
            this.setDataRenderer(DEFAULT_DATA_RENDERER);
            this.installSkin(Item.class);
        }

        @Override
        protected void setParent(Container parent) {
            if (!(parent instanceof MenuBar)) {
                throw new IllegalArgumentException("Parent must be an instance of " + MenuBar.class.getName());
            }
            this.setActive(false);
            super.setParent(parent);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (!enabled) {
                this.setActive(false);
            }
        }

        public Menu getMenu() {
            return this.menu;
        }

        public void setMenu(Menu menu) {
            if (menu != null && menu.getItem() != null) {
                throw new IllegalArgumentException("menu already belongs to an item.");
            }
            Menu previousMenu = this.menu;
            if (previousMenu != menu) {
                this.menu = menu;
                this.itemListeners.menuChanged(this, previousMenu);
            }
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            if (active && (this.getParent() == null || !this.isEnabled())) {
                throw new IllegalStateException();
            }
            if (this.active != active) {
                this.active = active;
                MenuBar menuBar = (MenuBar)this.getParent();
                Item activeItem = menuBar.getActiveItem();
                if (active) {
                    menuBar.setActiveItem(this);
                    if (activeItem != null) {
                        activeItem.setActive(false);
                    }
                } else if (activeItem == this) {
                    menuBar.setActiveItem(null);
                }
                this.itemListeners.activeChanged(this);
            }
        }

        @Override
        public void setToggleButton(boolean toggleButton) {
            throw new UnsupportedOperationException("Menu bar items cannot be toggle buttons.");
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && this.menu != null;
        }

        public ListenerList<ItemListener> getItemListeners() {
            return this.itemListeners;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ItemListenerList
        extends ListenerList<ItemListener>
        implements ItemListener {
            private ItemListenerList() {
            }

            @Override
            public void menuChanged(Item item, Menu previousMenu) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    ItemListener listener = (ItemListener)i$.next();
                    listener.menuChanged(item, previousMenu);
                }
            }

            @Override
            public void activeChanged(Item item) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    ItemListener listener = (ItemListener)i$.next();
                    listener.activeChanged(item);
                }
            }
        }
    }
}

