/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.RollupListener;
import org.apache.pivot.wtk.RollupStateListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="content")
public class Rollup
extends Container {
    private Component heading = null;
    private Component content = null;
    private boolean expanded = true;
    private boolean collapsible = true;
    private RollupListenerList rollupListeners = new RollupListenerList();
    private RollupStateListenerList rollupStateListeners = new RollupStateListenerList();

    public Rollup() {
        this(false, null);
    }

    public Rollup(boolean expanded) {
        this(expanded, null);
    }

    public Rollup(Component content) {
        this(false, content);
    }

    public Rollup(boolean expanded, Component content) {
        this.expanded = expanded;
        this.installSkin(Rollup.class);
        if (content != null) {
            this.setContent(content);
        }
    }

    public Component getHeading() {
        return this.heading;
    }

    public void setHeading(Component heading) {
        Component previousHeading = this.heading;
        if (heading != previousHeading) {
            this.heading = null;
            if (previousHeading != null) {
                this.remove(previousHeading);
            }
            if (heading != null) {
                this.add(heading);
            }
            this.heading = heading;
            this.rollupListeners.headingChanged(this, previousHeading);
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        Component previousContent = this.content;
        if (content != previousContent) {
            this.content = null;
            if (previousContent != null) {
                this.remove(previousContent);
            }
            if (content != null) {
                this.add(content);
            }
            this.content = content;
            this.rollupListeners.contentChanged(this, previousContent);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (expanded != this.expanded) {
            Vote vote = this.rollupStateListeners.previewExpandedChange(this);
            if (vote == Vote.APPROVE) {
                this.expanded = expanded;
                this.rollupStateListeners.expandedChanged(this);
            } else {
                this.rollupStateListeners.expandedChangeVetoed(this, vote);
            }
        }
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        if (this.collapsible != collapsible) {
            this.collapsible = collapsible;
            this.rollupListeners.collapsibleChanged(this);
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            if (component != this.heading && component != this.content) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(index, count);
    }

    public ListenerList<RollupListener> getRollupListeners() {
        return this.rollupListeners;
    }

    public ListenerList<RollupStateListener> getRollupStateListeners() {
        return this.rollupStateListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RollupStateListenerList
    extends ListenerList<RollupStateListener>
    implements RollupStateListener {
        private RollupStateListenerList() {
        }

        @Override
        public Vote previewExpandedChange(Rollup rollup) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                RollupStateListener listener = (RollupStateListener)i$.next();
                vote = vote.tally(listener.previewExpandedChange(rollup));
            }
            return vote;
        }

        @Override
        public void expandedChangeVetoed(Rollup rollup, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                RollupStateListener listener = (RollupStateListener)i$.next();
                listener.expandedChangeVetoed(rollup, reason);
            }
        }

        @Override
        public void expandedChanged(Rollup rollup) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                RollupStateListener listener = (RollupStateListener)i$.next();
                listener.expandedChanged(rollup);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RollupListenerList
    extends ListenerList<RollupListener>
    implements RollupListener {
        private RollupListenerList() {
        }

        @Override
        public void headingChanged(Rollup rollup, Component previousHeading) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                RollupListener listener = (RollupListener)i$.next();
                listener.headingChanged(rollup, previousHeading);
            }
        }

        @Override
        public void contentChanged(Rollup rollup, Component previousContent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                RollupListener listener = (RollupListener)i$.next();
                listener.contentChanged(rollup, previousContent);
            }
        }

        @Override
        public void collapsibleChanged(Rollup rollup) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                RollupListener listener = (RollupListener)i$.next();
                listener.collapsibleChanged(rollup);
            }
        }
    }
}

