/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ScrollPaneListener;
import org.apache.pivot.wtk.Viewport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollPane
extends Viewport {
    private ScrollBarPolicy horizontalScrollBarPolicy;
    private ScrollBarPolicy verticalScrollBarPolicy;
    private Component rowHeader;
    private Component columnHeader;
    private Component corner;
    private ScrollPaneListenerList scrollPaneListeners = new ScrollPaneListenerList();

    public ScrollPane() {
        this(ScrollBarPolicy.AUTO, ScrollBarPolicy.AUTO);
    }

    public ScrollPane(ScrollBarPolicy horizontalScrollBarPolicy, ScrollBarPolicy verticalScrollBarPolicy) {
        if (horizontalScrollBarPolicy == null) {
            throw new IllegalArgumentException("horizontalScrollBarPolicy is null");
        }
        if (verticalScrollBarPolicy == null) {
            throw new IllegalArgumentException("verticalScrollBarPolicy is null");
        }
        this.horizontalScrollBarPolicy = horizontalScrollBarPolicy;
        this.verticalScrollBarPolicy = verticalScrollBarPolicy;
        this.installSkin(ScrollPane.class);
    }

    public ScrollBarPolicy getHorizontalScrollBarPolicy() {
        return this.horizontalScrollBarPolicy;
    }

    public void setHorizontalScrollBarPolicy(ScrollBarPolicy horizontalScrollBarPolicy) {
        if (horizontalScrollBarPolicy == null) {
            throw new IllegalArgumentException("horizontalScrollBarPolicy is null");
        }
        ScrollBarPolicy previousHorizontalScrollBarPolicy = this.horizontalScrollBarPolicy;
        if (horizontalScrollBarPolicy != previousHorizontalScrollBarPolicy) {
            this.horizontalScrollBarPolicy = horizontalScrollBarPolicy;
            this.scrollPaneListeners.horizontalScrollBarPolicyChanged(this, previousHorizontalScrollBarPolicy);
        }
    }

    public ScrollBarPolicy getVerticalScrollBarPolicy() {
        return this.verticalScrollBarPolicy;
    }

    public void setVerticalScrollBarPolicy(ScrollBarPolicy verticalScrollBarPolicy) {
        if (verticalScrollBarPolicy == null) {
            throw new IllegalArgumentException("verticalScrollBarPolicy is null");
        }
        ScrollBarPolicy previousVerticalScrollBarPolicy = this.verticalScrollBarPolicy;
        if (verticalScrollBarPolicy != previousVerticalScrollBarPolicy) {
            this.verticalScrollBarPolicy = verticalScrollBarPolicy;
            this.scrollPaneListeners.verticalScrollBarPolicyChanged(this, previousVerticalScrollBarPolicy);
        }
    }

    public Component getRowHeader() {
        return this.rowHeader;
    }

    public void setRowHeader(Component rowHeader) {
        Component previousRowHeader = this.rowHeader;
        if (rowHeader != previousRowHeader) {
            if (previousRowHeader != null) {
                this.remove(previousRowHeader);
            }
            this.rowHeader = null;
            if (rowHeader != null) {
                if (rowHeader.getParent() != null) {
                    throw new IllegalArgumentException("Component already has a parent.");
                }
                int insertionIndex = 0;
                if (this.getView() != null) {
                    ++insertionIndex;
                }
                this.insert(rowHeader, insertionIndex);
            }
            this.rowHeader = rowHeader;
            this.scrollPaneListeners.rowHeaderChanged(this, previousRowHeader);
        }
    }

    public Component getColumnHeader() {
        return this.columnHeader;
    }

    public void setColumnHeader(Component columnHeader) {
        Component previousColumnHeader = this.columnHeader;
        if (columnHeader != previousColumnHeader) {
            if (previousColumnHeader != null) {
                this.remove(previousColumnHeader);
            }
            this.columnHeader = null;
            if (columnHeader != null) {
                int insertionIndex = 0;
                if (this.getView() != null) {
                    ++insertionIndex;
                }
                this.insert(columnHeader, insertionIndex);
            }
            this.columnHeader = columnHeader;
            this.scrollPaneListeners.columnHeaderChanged(this, previousColumnHeader);
        }
    }

    public Component getCorner() {
        return this.corner;
    }

    public void setCorner(Component corner) {
        Component previousCorner = this.corner;
        if (corner != this.corner) {
            if (previousCorner != null) {
                this.remove(previousCorner);
            }
            this.corner = null;
            if (corner != null) {
                int insertionIndex = 0;
                if (this.getView() != null) {
                    ++insertionIndex;
                }
                if (this.rowHeader != null) {
                    ++insertionIndex;
                }
                if (this.columnHeader != null) {
                    ++insertionIndex;
                }
                this.insert(corner, insertionIndex);
            }
            this.corner = corner;
            this.scrollPaneListeners.cornerChanged(this, previousCorner);
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            if (component != this.rowHeader && component != this.columnHeader && component != this.corner) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(index, count);
    }

    public ListenerList<ScrollPaneListener> getScrollPaneListeners() {
        return this.scrollPaneListeners;
    }

    public static class Corner
    extends Component {
        private Placement placement;

        public Corner(Placement placement) {
            if (placement == null) {
                throw new IllegalArgumentException("Placement is null.");
            }
            this.placement = placement;
            this.installSkin(Corner.class);
        }

        public Placement getPlacement() {
            return this.placement;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Placement {
            TOP_LEFT,
            BOTTOM_LEFT,
            BOTTOM_RIGHT,
            TOP_RIGHT;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScrollPaneListenerList
    extends ListenerList<ScrollPaneListener>
    implements ScrollPaneListener {
        private ScrollPaneListenerList() {
        }

        @Override
        public void horizontalScrollBarPolicyChanged(ScrollPane scrollPane, ScrollBarPolicy previousHorizontalScrollBarPolicy) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ScrollPaneListener listener = (ScrollPaneListener)i$.next();
                listener.horizontalScrollBarPolicyChanged(scrollPane, previousHorizontalScrollBarPolicy);
            }
        }

        @Override
        public void verticalScrollBarPolicyChanged(ScrollPane scrollPane, ScrollBarPolicy previousVerticalScrollBarPolicy) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ScrollPaneListener listener = (ScrollPaneListener)i$.next();
                listener.verticalScrollBarPolicyChanged(scrollPane, previousVerticalScrollBarPolicy);
            }
        }

        @Override
        public void rowHeaderChanged(ScrollPane scrollPane, Component previousRowHeader) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ScrollPaneListener listener = (ScrollPaneListener)i$.next();
                listener.rowHeaderChanged(scrollPane, previousRowHeader);
            }
        }

        @Override
        public void columnHeaderChanged(ScrollPane scrollPane, Component previousColumnHeader) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ScrollPaneListener listener = (ScrollPaneListener)i$.next();
                listener.columnHeaderChanged(scrollPane, previousColumnHeader);
            }
        }

        @Override
        public void cornerChanged(ScrollPane scrollPane, Component previousCorner) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ScrollPaneListener listener = (ScrollPaneListener)i$.next();
                listener.cornerChanged(scrollPane, previousCorner);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScrollBarPolicy {
        AUTO,
        NEVER,
        ALWAYS,
        FILL,
        FILL_TO_CAPACITY;

    }
}

