/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.SliderListener;
import org.apache.pivot.wtk.SliderValueListener;
import org.apache.pivot.wtk.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slider
extends Container {
    private int start = 0;
    private int end = 100;
    private int value = 0;
    private Orientation orientation = null;
    private SliderListenerList sliderListeners = new SliderListenerList();
    private SliderValueListenerList sliderValueListeners = new SliderValueListenerList();
    public static final int DEFAULT_START = 0;
    public static final int DEFAULT_END = 100;
    public static final int DEFAULT_VALUE = 0;

    public Slider() {
        this(Orientation.HORIZONTAL);
    }

    public Slider(Orientation orientation) {
        this.orientation = orientation;
        this.installSkin(Slider.class);
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.setRange(start, this.end);
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.setRange(this.start, end);
    }

    public void setRange(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("start " + start + " is greater than maximum " + end + ".");
        }
        int previousStart = this.start;
        int previousEnd = this.end;
        int previousValue = this.value;
        if (start != previousStart || end != previousEnd) {
            this.start = start;
            if (this.value < start) {
                this.value = start;
            }
            this.end = end;
            if (this.value > end) {
                this.value = end;
            }
            this.sliderListeners.rangeChanged(this, previousStart, previousEnd);
            if (previousValue < start || previousValue > end) {
                this.sliderValueListeners.valueChanged(this, previousValue);
            }
        }
    }

    public final void setRange(Span range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(range.start, range.end);
    }

    public final void setRange(Dictionary<String, ?> range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(new Span(range));
    }

    public final void setRange(String range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(Span.decode(range));
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        if (value < this.start) {
            throw new IllegalArgumentException("value " + value + " is less than minimum " + this.start + ".");
        }
        if (value > this.end) {
            throw new IllegalArgumentException("value " + value + " is greater than maximum " + this.end + ".");
        }
        int previousValue = this.value;
        if (value != previousValue) {
            this.value = value;
            this.sliderValueListeners.valueChanged(this, previousValue);
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null.");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.sliderListeners.orientationChanged(this);
        }
    }

    public ListenerList<SliderListener> getSliderListeners() {
        return this.sliderListeners;
    }

    public ListenerList<SliderValueListener> getSliderValueListeners() {
        return this.sliderValueListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SliderValueListenerList
    extends ListenerList<SliderValueListener>
    implements SliderValueListener {
        private SliderValueListenerList() {
        }

        @Override
        public void valueChanged(Slider slider, int previousValue) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SliderValueListener listener = (SliderValueListener)i$.next();
                listener.valueChanged(slider, previousValue);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SliderListenerList
    extends ListenerList<SliderListener>
    implements SliderListener {
        private SliderListenerList() {
        }

        @Override
        public void orientationChanged(Slider slider) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SliderListener listener = (SliderListener)i$.next();
                listener.orientationChanged(slider);
            }
        }

        @Override
        public void rangeChanged(Slider slider, int previousStart, int previousEnd) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SliderListener listener = (SliderListener)i$.next();
                listener.rangeChanged(slider, previousStart, previousEnd);
            }
        }
    }
}

