/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.SplitPaneListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitPane
extends Container {
    private Component topLeft = null;
    private Component bottomRight = null;
    private Orientation orientation = null;
    private Region primaryRegion = Region.TOP_LEFT;
    private ResizeMode resizeMode = ResizeMode.SPLIT_RATIO;
    private float splitRatio = 0.5f;
    private boolean locked = false;
    private SplitPaneListenerList splitPaneListeners = new SplitPaneListenerList();

    public SplitPane() {
        this(Orientation.HORIZONTAL);
    }

    public SplitPane(Orientation orientation) {
        this(orientation, null, null);
    }

    public SplitPane(Orientation orientation, Component topLeft, Component bottomRight) {
        this.orientation = orientation;
        this.installSkin(SplitPane.class);
        this.setTopLeft(topLeft);
        this.setBottomRight(bottomRight);
    }

    public Component getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(Component topLeft) {
        Component previousTopLeft = this.topLeft;
        if (topLeft != previousTopLeft) {
            this.topLeft = topLeft;
            if (previousTopLeft != null) {
                this.remove(previousTopLeft);
            }
            if (topLeft != null) {
                if (topLeft.getParent() != null) {
                    throw new IllegalArgumentException("Component already has a parent.");
                }
                this.add(topLeft);
            }
            this.splitPaneListeners.topLeftChanged(this, previousTopLeft);
        }
    }

    public Component getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(Component bottomRight) {
        Component previousBottomRight = this.bottomRight;
        if (bottomRight != previousBottomRight) {
            this.bottomRight = bottomRight;
            if (previousBottomRight != null) {
                this.remove(previousBottomRight);
            }
            if (bottomRight != null) {
                if (bottomRight.getParent() != null) {
                    throw new IllegalArgumentException("Component already has a parent.");
                }
                this.add(bottomRight);
            }
            this.splitPaneListeners.bottomRightChanged(this, previousBottomRight);
        }
    }

    public Component getTop() {
        return this.orientation == Orientation.HORIZONTAL ? null : this.getTopLeft();
    }

    public void setTop(Component component) {
        this.setTopLeft(component);
    }

    public Component getBottom() {
        return this.orientation == Orientation.HORIZONTAL ? null : this.getBottomRight();
    }

    public void setBottom(Component component) {
        this.setBottomRight(component);
    }

    public Component getLeft() {
        return this.orientation == Orientation.VERTICAL ? null : this.getTopLeft();
    }

    public void setLeft(Component component) {
        this.setTopLeft(component);
    }

    public Component getRight() {
        return this.orientation == Orientation.VERTICAL ? null : this.getBottomRight();
    }

    public void setRight(Component component) {
        this.setBottomRight(component);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null.");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.splitPaneListeners.orientationChanged(this);
        }
    }

    public Region getPrimaryRegion() {
        return this.primaryRegion;
    }

    public void setPrimaryRegion(Region primaryRegion) {
        if (primaryRegion == null) {
            throw new IllegalArgumentException("primaryRegion is null.");
        }
        if (this.primaryRegion != primaryRegion) {
            this.primaryRegion = primaryRegion;
            this.splitPaneListeners.primaryRegionChanged(this);
        }
    }

    public float getSplitRatio() {
        return this.splitRatio;
    }

    public void setSplitRatio(float splitRatio) {
        if (splitRatio < 0.0f || splitRatio > 1.0f) {
            throw new IllegalArgumentException("splitRatio must be between 0 and 1.");
        }
        float previousSplitRatio = this.splitRatio;
        if (previousSplitRatio != splitRatio) {
            this.splitRatio = splitRatio;
            this.splitPaneListeners.splitRatioChanged(this, previousSplitRatio);
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        if (this.locked != locked) {
            this.locked = locked;
            this.splitPaneListeners.lockedChanged(this);
        }
    }

    public ResizeMode getResizeMode() {
        return this.resizeMode;
    }

    public void setResizeMode(ResizeMode resizeMode) {
        if (resizeMode == null) {
            throw new IllegalArgumentException("resizeMode is null.");
        }
        ResizeMode previousResizeMode = this.resizeMode;
        if (previousResizeMode != resizeMode) {
            this.resizeMode = resizeMode;
            this.splitPaneListeners.resizeModeChanged(this, previousResizeMode);
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            if (component != this.topLeft && component != this.bottomRight) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(index, count);
    }

    public ListenerList<SplitPaneListener> getSplitPaneListeners() {
        return this.splitPaneListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SplitPaneListenerList
    extends ListenerList<SplitPaneListener>
    implements SplitPaneListener {
        private SplitPaneListenerList() {
        }

        @Override
        public void topLeftChanged(SplitPane splitPane, Component previousTopLeft) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SplitPaneListener listener = (SplitPaneListener)i$.next();
                listener.topLeftChanged(splitPane, previousTopLeft);
            }
        }

        @Override
        public void bottomRightChanged(SplitPane splitPane, Component previousBottomRight) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SplitPaneListener listener = (SplitPaneListener)i$.next();
                listener.bottomRightChanged(splitPane, previousBottomRight);
            }
        }

        @Override
        public void orientationChanged(SplitPane splitPane) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SplitPaneListener listener = (SplitPaneListener)i$.next();
                listener.orientationChanged(splitPane);
            }
        }

        @Override
        public void primaryRegionChanged(SplitPane splitPane) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SplitPaneListener listener = (SplitPaneListener)i$.next();
                listener.primaryRegionChanged(splitPane);
            }
        }

        @Override
        public void splitRatioChanged(SplitPane splitPane, float previousSplitRatio) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SplitPaneListener listener = (SplitPaneListener)i$.next();
                listener.splitRatioChanged(splitPane, previousSplitRatio);
            }
        }

        @Override
        public void lockedChanged(SplitPane splitPane) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SplitPaneListener listener = (SplitPaneListener)i$.next();
                listener.lockedChanged(splitPane);
            }
        }

        @Override
        public void resizeModeChanged(SplitPane splitPane, ResizeMode previousResizeMode) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SplitPaneListener listener = (SplitPaneListener)i$.next();
                listener.resizeModeChanged(splitPane, previousResizeMode);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResizeMode {
        SPLIT_RATIO,
        PRIMARY_REGION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Region {
        TOP_LEFT,
        BOTTOM_RIGHT;

    }
}

