/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.effects.Decorator;

public class DropShadowDecorator
implements Decorator {
    private int blurRadius;
    private int xOffset;
    private int yOffset;
    private Color shadowColor = Color.BLACK;
    private float shadowOpacity = 0.25f;
    private BufferedImage shadowImage = null;
    public static final float DEFAULT_SHADOW_OPACITY = 0.25f;

    public DropShadowDecorator() {
        this(5, 5, 5);
    }

    public DropShadowDecorator(int blurRadius, int xOffset, int yOffset) {
        this.blurRadius = blurRadius;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
    }

    public final void setShadowColor(String shadowColor) {
        if (shadowColor == null) {
            throw new IllegalArgumentException("shadowColor is null.");
        }
        this.setShadowColor(GraphicsUtilities.decodeColor(shadowColor));
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public void setShadowOpacity(float shadowOpacity) {
        this.shadowOpacity = shadowOpacity;
    }

    public int getBlurRadius() {
        return this.blurRadius;
    }

    public void setBlurRadius(int blurRadius) {
        this.blurRadius = blurRadius;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public Graphics2D prepare(Component component, Graphics2D graphics) {
        int width = component.getWidth();
        int height = component.getHeight();
        if (width > 0 && height > 0) {
            if (this.shadowImage == null || this.shadowImage.getWidth() != width + 2 * this.blurRadius || this.shadowImage.getHeight() != height + 2 * this.blurRadius) {
                BufferedImage rectangleImage = new BufferedImage(width, height, 2);
                Graphics2D rectangleImageGraphics = rectangleImage.createGraphics();
                rectangleImageGraphics.setColor(Color.BLACK);
                rectangleImageGraphics.fillRect(0, 0, width, height);
                rectangleImageGraphics.dispose();
                this.shadowImage = this.createShadow(rectangleImage);
            }
            graphics.drawImage((Image)this.shadowImage, this.xOffset - this.blurRadius, this.yOffset - this.blurRadius, null);
        } else {
            this.shadowImage = null;
        }
        return graphics;
    }

    public void update() {
    }

    public Bounds getBounds(Component component) {
        return new Bounds(this.xOffset - this.blurRadius, this.yOffset - this.blurRadius, component.getWidth() + this.blurRadius * 2, component.getHeight() + this.blurRadius * 2);
    }

    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }

    private BufferedImage createShadow(BufferedImage src) {
        int a;
        int aSum;
        int historyIdx;
        int shadowSize = this.blurRadius * 2;
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int dstWidth = srcWidth + shadowSize;
        int dstHeight = srcHeight + shadowSize;
        int left = this.blurRadius;
        int right = shadowSize - left;
        int yStop = dstHeight - right;
        int shadowRgb = this.shadowColor.getRGB() & 0xFFFFFF;
        int[] aHistory = new int[shadowSize];
        BufferedImage dst = new BufferedImage(dstWidth, dstHeight, 2);
        int[] dstBuffer = new int[dstWidth * dstHeight];
        int[] srcBuffer = new int[srcWidth * srcHeight];
        WritableRaster srcRaster = src.getRaster();
        srcRaster.getDataElements(0, 0, srcWidth, srcHeight, srcBuffer);
        int lastPixelOffset = right * dstWidth;
        float hSumDivider = 1.0f / (float)shadowSize;
        float vSumDivider = this.shadowOpacity / (float)shadowSize;
        int[] hSumLookup = new int[256 * shadowSize];
        for (int i = 0; i < hSumLookup.length; ++i) {
            hSumLookup[i] = (int)((float)i * hSumDivider);
        }
        int[] vSumLookup = new int[256 * shadowSize];
        for (int i = 0; i < vSumLookup.length; ++i) {
            vSumLookup[i] = (int)((float)i * vSumDivider);
        }
        int dstOffset = left * dstWidth;
        for (int srcY = 0; srcY < srcHeight; ++srcY) {
            historyIdx = 0;
            while (historyIdx < shadowSize) {
                aHistory[historyIdx++] = 0;
            }
            aSum = 0;
            historyIdx = 0;
            int srcOffset = srcY * srcWidth;
            for (int srcX = 0; srcX < srcWidth; ++srcX) {
                a = hSumLookup[aSum];
                dstBuffer[dstOffset++] = a << 24;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = srcBuffer[srcOffset + srcX] >>> 24;
                aSum += a;
                if (++historyIdx < shadowSize) continue;
                historyIdx -= shadowSize;
            }
            for (int i = 0; i < shadowSize; ++i) {
                a = hSumLookup[aSum];
                dstBuffer[dstOffset++] = a << 24;
                aSum -= aHistory[historyIdx];
                if (++historyIdx < shadowSize) continue;
                historyIdx -= shadowSize;
            }
        }
        int x = 0;
        int bufferOffset = 0;
        while (x < dstWidth) {
            aSum = 0;
            historyIdx = 0;
            while (historyIdx < left) {
                aHistory[historyIdx++] = 0;
            }
            int y = 0;
            while (y < right) {
                a = dstBuffer[bufferOffset] >>> 24;
                aHistory[historyIdx++] = a;
                aSum += a;
                ++y;
                bufferOffset += dstWidth;
            }
            bufferOffset = x;
            historyIdx = 0;
            y = 0;
            while (y < yStop) {
                a = vSumLookup[aSum];
                dstBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                aHistory[historyIdx] = a = dstBuffer[bufferOffset + lastPixelOffset] >>> 24;
                aSum += a;
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++y;
                bufferOffset += dstWidth;
            }
            y = yStop;
            while (y < dstHeight) {
                a = vSumLookup[aSum];
                dstBuffer[bufferOffset] = a << 24 | shadowRgb;
                aSum -= aHistory[historyIdx];
                if (++historyIdx >= shadowSize) {
                    historyIdx -= shadowSize;
                }
                ++y;
                bufferOffset += dstWidth;
            }
            bufferOffset = ++x;
        }
        WritableRaster dstRaster = dst.getRaster();
        dstRaster.setDataElements(0, 0, dstWidth, dstHeight, dstBuffer);
        return dst;
    }
}

