/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class GrayscaleDecorator
implements Decorator {
    private Graphics2D graphics = null;
    private BufferedImage bufferedImage = null;
    private Graphics2D bufferedImageGraphics = null;

    public Graphics2D prepare(Component component, Graphics2D graphics) {
        this.graphics = graphics;
        int width = component.getWidth();
        int height = component.getHeight();
        if (this.bufferedImage == null || this.bufferedImage.getWidth() < width || this.bufferedImage.getHeight() < height) {
            this.bufferedImage = new BufferedImage(width, height, 10);
        }
        this.bufferedImageGraphics = this.bufferedImage.createGraphics();
        this.bufferedImageGraphics.setClip(graphics.getClip());
        return this.bufferedImageGraphics;
    }

    public void update() {
        this.bufferedImageGraphics.dispose();
        this.bufferedImageGraphics = null;
        this.bufferedImage.flush();
        this.graphics.drawImage((Image)this.bufferedImage, 0, 0, null);
        this.bufferedImage = null;
        this.graphics = null;
    }

    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

