/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class RotationDecorator
implements Decorator {
    private double theta;

    public RotationDecorator() {
        this(0.0);
    }

    public RotationDecorator(double theta) {
        this.setTheta(theta);
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }

    public Graphics2D prepare(Component component, Graphics2D graphics) {
        graphics.rotate(this.theta, (double)component.getWidth() * 0.5, (double)component.getHeight() * 0.5);
        return graphics;
    }

    public void update() {
    }

    public Bounds getBounds(Component component) {
        int width = component.getWidth();
        int height = component.getHeight();
        double sinTheta = Math.abs(Math.sin(this.theta));
        double cosTheta = Math.abs(Math.cos(this.theta));
        int transformedWidth = (int)Math.ceil((double)height * sinTheta + (double)width * cosTheta);
        int transformedHeight = (int)Math.ceil((double)height * cosTheta + (double)width * sinTheta);
        int transformedX = (int)Math.floor((double)(width - transformedWidth) * 0.5);
        int transformedY = (int)Math.floor((double)(height - transformedHeight) * 0.5);
        return new Bounds(transformedX, transformedY, transformedWidth, transformedHeight);
    }

    public AffineTransform getTransform(Component component) {
        return AffineTransform.getRotateInstance(this.theta, (double)component.getWidth() * 0.5, (double)component.getHeight() * 0.5);
    }
}

