/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.effects.Decorator;

public class SaturationDecorator
implements Decorator {
    private float multiplier;
    private Graphics2D graphics = null;
    private BufferedImage componentImage = null;
    private Graphics2D componentGraphics = null;

    public SaturationDecorator() {
        this(1.0f);
    }

    public SaturationDecorator(float multiplier) {
        this.multiplier = multiplier;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(float multiplier) {
        this.multiplier = multiplier;
    }

    public void setMultiplier(Number multiplier) {
        if (multiplier == null) {
            throw new IllegalArgumentException("Multiplier is null.");
        }
        this.setMultiplier(multiplier.floatValue());
    }

    public Graphics2D prepare(Component component, Graphics2D graphics) {
        int x = 0;
        int y = 0;
        int width = component.getWidth();
        int height = component.getHeight();
        Rectangle clipBounds = graphics.getClipBounds();
        if (clipBounds != null) {
            x = clipBounds.x;
            y = clipBounds.y;
            width = clipBounds.width;
            height = clipBounds.height;
        }
        this.componentImage = new BufferedImage(width, height, 2);
        this.graphics = graphics;
        this.componentGraphics = this.componentImage.createGraphics();
        this.componentGraphics.translate(-x, -y);
        this.componentGraphics.setClip(graphics.getClip());
        return this.componentGraphics;
    }

    public void update() {
        int width = this.componentImage.getWidth();
        int height = this.componentImage.getHeight();
        int[] buffer = new int[width * height];
        WritableRaster raster = this.componentImage.getRaster();
        raster.getDataElements(0, 0, width, height, buffer);
        float[] hsb = new float[3];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int srcRGB = buffer[i * width + j];
                Color.RGBtoHSB(srcRGB >> 16 & 0xFF, srcRGB >> 8 & 0xFF, srcRGB & 0xFF, hsb);
                int dstRGB = Color.HSBtoRGB(hsb[0], Math.min(Math.max(hsb[1] * this.multiplier, 0.0f), 1.0f), hsb[2]);
                buffer[i * width + j] = dstRGB = srcRGB & 0xFF000000 | dstRGB & 0xFFFFFF;
            }
        }
        raster.setDataElements(0, 0, width, height, buffer);
        int x = 0;
        int y = 0;
        Rectangle clipBounds = this.componentGraphics.getClipBounds();
        if (clipBounds != null) {
            x = clipBounds.x;
            y = clipBounds.y;
        }
        this.componentGraphics.dispose();
        this.componentGraphics = null;
        this.graphics.drawImage((Image)this.componentImage, x, y, null);
        this.componentImage = null;
        this.graphics = null;
    }

    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

