/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.effects;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.net.URL;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.media.Image;

public class WatermarkDecorator
implements Decorator {
    private float opacity = 0.075f;
    private double theta = 0.7853981633974483;
    private BoxPane boxPane = new BoxPane(Orientation.HORIZONTAL);
    private ImageView imageView = new ImageView();
    private Label label = new Label();
    private Component component = null;
    private Graphics2D graphics = null;

    public WatermarkDecorator() {
        this(null, null);
    }

    public WatermarkDecorator(String text) {
        this(text, null);
    }

    public WatermarkDecorator(Image image) {
        this(null, image);
    }

    public WatermarkDecorator(String text, Image image) {
        this.boxPane.add(this.imageView);
        this.boxPane.add(this.label);
        this.boxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.imageView.getStyles().put("opacity", (Object)Float.valueOf(this.opacity));
        Font font = (Font)this.label.getStyles().get("font");
        this.label.getStyles().put("font", (Object)font.deriveFont(1, 60.0f));
        this.label.setText(text);
        this.imageView.setImage(image);
        this.validate();
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String text) {
        this.label.setText(text);
        this.validate();
    }

    public Font getFont() {
        return (Font)this.label.getStyles().get("font");
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.label.getStyles().put("font", (Object)font);
        this.validate();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        if (font.startsWith("{")) {
            try {
                this.setFont(Theme.deriveFont(JSONSerializer.parseMap((String)font)));
            }
            catch (SerializationException exception) {
                throw new IllegalArgumentException(exception);
            }
        } else {
            this.setFont(Font.decode(font));
        }
    }

    public Image getImage() {
        return this.imageView.getImage();
    }

    public void setImage(Image image) {
        this.imageView.setImage(image);
        this.validate();
    }

    public void setImage(URL imageURL) {
        if (imageURL == null) {
            throw new IllegalArgumentException("imageURL is null.");
        }
        Image image = (Image)ApplicationContext.getResourceCache().get(imageURL);
        if (image == null) {
            try {
                image = Image.load(imageURL);
            }
            catch (TaskExecutionException exception) {
                throw new IllegalArgumentException(exception);
            }
            ApplicationContext.getResourceCache().put(imageURL, (Object)image);
        }
        this.setImage(image);
    }

    public void setImage(String imageName) {
        if (imageName == null) {
            throw new IllegalArgumentException("imageName is null.");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.setImage(classLoader.getResource(imageName.substring(1)));
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
        this.imageView.getStyles().put("opacity", (Object)Float.valueOf(opacity));
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        if (theta < 0.0 || theta > 1.5707963267948966) {
            throw new IllegalArgumentException("Theta must be between 0 nd PI / 2.");
        }
        this.theta = theta;
    }

    private void validate() {
        this.boxPane.setSize(this.boxPane.getPreferredSize());
        this.boxPane.validate();
    }

    public Graphics2D prepare(Component component, Graphics2D graphics) {
        this.component = component;
        this.graphics = graphics;
        return graphics;
    }

    public void update() {
        int width = this.component.getWidth();
        int height = this.component.getHeight();
        double sinTheta = Math.sin(this.theta);
        double cosTheta = Math.cos(this.theta);
        Graphics2D watermarkGraphics = (Graphics2D)this.graphics.create();
        watermarkGraphics.clipRect(0, 0, this.component.getWidth(), this.component.getHeight());
        watermarkGraphics.setComposite(AlphaComposite.getInstance(3, this.opacity));
        watermarkGraphics.rotate(this.theta);
        int dX = (int)(1.5 * (double)this.boxPane.getWidth());
        int dY = 2 * this.boxPane.getHeight();
        int x = 0;
        int y = (int)((double)(-width) * sinTheta);
        watermarkGraphics.translate(x, y);
        int yStop = (int)((double)height * cosTheta);
        int p = 0;
        while (y < yStop) {
            int xStop = (int)((double)height * sinTheta + (double)width * cosTheta);
            while (x < xStop) {
                this.boxPane.paint(watermarkGraphics);
                watermarkGraphics.translate(dX, 0);
                x += dX;
            }
            watermarkGraphics.translate(-x, dY);
            x = 0;
            watermarkGraphics.translate((int)((0.5f - (float)p) * (float)this.boxPane.getWidth()), 0);
            y += dY;
            p = 1 - p;
        }
        watermarkGraphics.dispose();
        this.component = null;
        this.graphics = null;
    }

    public Bounds getBounds(Component component) {
        return new Bounds(0, 0, component.getWidth(), component.getHeight());
    }

    public AffineTransform getTransform(Component component) {
        return new AffineTransform();
    }
}

