/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.Action;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonListener;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.ButtonStateListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.skin.ComponentSkin;

public abstract class ButtonSkin
extends ComponentSkin
implements ButtonListener,
ButtonStateListener,
ButtonPressListener {
    protected boolean highlighted = false;

    public void install(Component component) {
        super.install(component);
        Button button = (Button)component;
        button.getButtonListeners().add((Object)this);
        button.getButtonStateListeners().add((Object)this);
        button.getButtonPressListeners().add((Object)this);
        button.setCursor(Cursor.HAND);
    }

    public void layout() {
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.highlighted = false;
        this.repaintComponent();
    }

    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        this.repaintComponent();
    }

    public void mouseOver(Component component) {
        super.mouseOver(component);
        this.highlighted = true;
        this.repaintComponent();
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.highlighted = false;
        this.repaintComponent();
    }

    public void buttonDataChanged(Button button, Object previousButtonData) {
        this.invalidateComponent();
    }

    public void dataRendererChanged(Button button, Button.DataRenderer previousDataRenderer) {
        this.invalidateComponent();
    }

    public void actionChanged(Button button, Action previousAction) {
    }

    public void toggleButtonChanged(Button button) {
    }

    public void triStateChanged(Button button) {
    }

    public void buttonGroupChanged(Button button, ButtonGroup previousButtonGroup) {
    }

    public void stateChanged(Button button, Button.State previousState) {
        this.repaintComponent();
    }

    public void buttonPressed(Button button) {
    }
}

