/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ColorChooser;
import org.apache.pivot.wtk.ColorChooserButton;
import org.apache.pivot.wtk.ColorChooserButtonSelectionListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;
import org.apache.pivot.wtk.skin.WindowSkin;

public abstract class ColorChooserButtonSkin
extends ButtonSkin
implements ColorChooserButton.Skin,
ColorChooserButtonSelectionListener {
    private ComponentKeyListener colorChooserPopupKeyListener = new ComponentKeyListener.Adapter(){

        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            ColorChooserButton colorChooserButton = (ColorChooserButton)ColorChooserButtonSkin.this.getComponent();
            switch (keyCode) {
                case 27: {
                    ColorChooserButtonSkin.this.colorChooserPopup.close();
                    break;
                }
                case 9: 
                case 10: {
                    ColorChooserButtonSkin.this.colorChooserPopup.close();
                    if (keyCode == 9) {
                        FocusTraversalDirection direction = Keyboard.isPressed(Keyboard.Modifier.SHIFT) ? FocusTraversalDirection.BACKWARD : FocusTraversalDirection.FORWARD;
                        colorChooserButton.transferFocus(direction);
                    }
                    Color color = ColorChooserButtonSkin.this.colorChooser.getSelectedColor();
                    colorChooserButton.setSelectedColor(color);
                    break;
                }
            }
            return false;
        }
    };
    private WindowStateListener colorChooserPopupWindowStateListener = new WindowStateListener(){

        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)ColorChooserButtonSkin.this.displayMouseListener);
            window.requestFocus();
        }

        public Vote previewWindowClose(Window window) {
            if (window.containsFocus()) {
                ColorChooserButtonSkin.this.getComponent().requestFocus();
            }
            return Vote.APPROVE;
        }

        public void windowCloseVetoed(Window window, Vote reason) {
            if (reason == Vote.DENY) {
                window.requestFocus();
            }
        }

        public void windowClosed(Window window, Display display, Window owner) {
            display.getContainerMouseListeners().remove((Object)ColorChooserButtonSkin.this.displayMouseListener);
            Window componentWindow = ColorChooserButtonSkin.this.getComponent().getWindow();
            if (componentWindow != null && !componentWindow.isClosing()) {
                componentWindow.moveToFront();
            }
        }
    };
    private ComponentMouseButtonListener colorChooserMouseButtonListener = new ComponentMouseButtonListener.Adapter(){

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            ColorChooserButton colorChooserButton = (ColorChooserButton)ColorChooserButtonSkin.this.getComponent();
            if (button == Mouse.Button.LEFT && count == 2) {
                ColorChooserButtonSkin.this.colorChooserPopup.close();
                Color color = ColorChooserButtonSkin.this.colorChooser.getSelectedColor();
                colorChooserButton.setSelectedColor(color);
            }
            return false;
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            ColorChooserButton colorChooserButton = (ColorChooserButton)ColorChooserButtonSkin.this.getComponent();
            Display display = (Display)container;
            Component descendant = display.getDescendantAt(x, y);
            if (!ColorChooserButtonSkin.this.colorChooserPopup.isAncestor(descendant) && descendant != colorChooserButton) {
                ColorChooserButtonSkin.this.colorChooserPopup.close();
                Color color = ColorChooserButtonSkin.this.colorChooser.getSelectedColor();
                colorChooserButton.setSelectedColor(color);
            }
            return false;
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            return true;
        }
    };
    protected ColorChooser colorChooser = new ColorChooser();
    protected ColorChooserPopup colorChooserPopup;
    protected boolean pressed = false;

    public ColorChooserButtonSkin() {
        this.colorChooser.getComponentMouseButtonListeners().add((Object)this.colorChooserMouseButtonListener);
        this.colorChooserPopup = new ColorChooserPopup();
        this.colorChooserPopup.getComponentKeyListeners().add((Object)this.colorChooserPopupKeyListener);
        this.colorChooserPopup.getWindowStateListeners().add((Object)this.colorChooserPopupWindowStateListener);
    }

    public void install(Component component) {
        super.install(component);
        ColorChooserButton colorChooserButton = (ColorChooserButton)component;
        colorChooserButton.getColorChooserButtonSelectionListeners().add((Object)this);
    }

    public Window getColorChooserPopup() {
        return this.colorChooserPopup;
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        if (!component.isEnabled()) {
            this.pressed = false;
        }
        this.repaintComponent();
        this.colorChooserPopup.close();
    }

    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        this.repaintComponent();
        if (!component.isFocused()) {
            this.pressed = false;
            if (!this.colorChooserPopup.containsFocus()) {
                this.colorChooserPopup.close();
            }
        }
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.pressed = false;
        this.repaintComponent();
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        this.pressed = true;
        this.repaintComponent();
        if (this.colorChooserPopup.isOpen()) {
            this.colorChooserPopup.close();
        } else {
            this.colorChooserPopup.open(component.getWindow());
        }
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        this.pressed = false;
        this.repaintComponent();
        return consumed;
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (keyCode == 32) {
            this.pressed = true;
            this.repaintComponent();
            if (this.colorChooserPopup.isOpen()) {
                this.colorChooserPopup.close();
            } else {
                this.colorChooserPopup.open(component.getWindow());
            }
            consumed = true;
        } else {
            consumed = super.keyPressed(component, keyCode, keyLocation);
        }
        return consumed;
    }

    public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (keyCode == 32) {
            this.pressed = false;
            this.repaintComponent();
        } else {
            consumed = super.keyReleased(component, keyCode, keyLocation);
        }
        return consumed;
    }

    public void selectedColorChanged(ColorChooserButton colorChooserButton, Color previousSelectedColor) {
        Color selectedColor = colorChooserButton.getSelectedColor();
        colorChooserButton.setButtonData(selectedColor);
        this.colorChooser.setSelectedColor(selectedColor);
    }

    public final class ColorChooserPopupSkin
    extends WindowSkin {
        private ColorChooserPopupSkin() {
        }

        public boolean isFocusable() {
            return true;
        }

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            component.requestFocus();
            return super.mouseClick(component, button, x, y, count);
        }
    }

    public final class ColorChooserPopup
    extends Window {
        private ColorChooserPopup() {
            this.setSkin(new ColorChooserPopupSkin());
        }
    }
}

