/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Font;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.ComponentMouseListener;
import org.apache.pivot.wtk.ComponentMouseWheelListener;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.ComponentTooltipListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.DragSource;
import org.apache.pivot.wtk.DropTarget;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MenuHandler;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Tooltip;

public abstract class ComponentSkin
implements Skin,
ComponentListener,
ComponentStateListener,
ComponentMouseListener,
ComponentMouseButtonListener,
ComponentMouseWheelListener,
ComponentKeyListener,
ComponentTooltipListener {
    private Component component = null;
    private int width = 0;
    private int height = 0;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public final int getBaseline() {
        return this.getBaseline(this.width, this.height);
    }

    public int getBaseline(int width, int height) {
        return -1;
    }

    public void install(Component component) {
        assert (this.component == null) : "Skin is already installed on a component.";
        component.getComponentListeners().add((Object)this);
        component.getComponentStateListeners().add((Object)this);
        component.getComponentMouseListeners().add((Object)this);
        component.getComponentMouseButtonListeners().add((Object)this);
        component.getComponentMouseWheelListeners().add((Object)this);
        component.getComponentKeyListeners().add((Object)this);
        component.getComponentTooltipListeners().add((Object)this);
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isOpaque() {
        return true;
    }

    public void parentChanged(Component component, Container previousParent) {
    }

    public void sizeChanged(Component component, int previousWidth, int previousHeight) {
    }

    public void preferredSizeChanged(Component component, int previousPreferredWidth, int previousPreferredHeight) {
    }

    public void widthLimitsChanged(Component component, int previousMinimumWidth, int previousMaximumWidth) {
    }

    public void heightLimitsChanged(Component component, int previousMinimumHeight, int previousMaximumHeight) {
    }

    public void locationChanged(Component component, int previousX, int previousY) {
    }

    public void visibleChanged(Component component) {
    }

    public void cursorChanged(Component component, Cursor previousCursor) {
    }

    public void tooltipTextChanged(Component component, String previousTooltipText) {
    }

    public void tooltipDelayChanged(Component component, int previousTooltipDelay) {
    }

    public void dragSourceChanged(Component component, DragSource previousDragSource) {
    }

    public void dropTargetChanged(Component component, DropTarget previousDropTarget) {
    }

    public void menuHandlerChanged(Component component, MenuHandler previousMenuHandler) {
    }

    public void nameChanged(Component component, String previousName) {
    }

    public void enabledChanged(Component component) {
    }

    public void focusedChanged(Component component, Component obverseComponent) {
    }

    public boolean mouseMove(Component component, int x, int y) {
        return false;
    }

    public void mouseOver(Component component) {
    }

    public void mouseOut(Component component) {
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        return false;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        return false;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        return false;
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        return false;
    }

    public boolean keyTyped(Component component, char character) {
        return false;
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (keyCode == 9 && this.getComponent().isFocused()) {
            FocusTraversalDirection direction = Keyboard.isPressed(Keyboard.Modifier.SHIFT) ? FocusTraversalDirection.BACKWARD : FocusTraversalDirection.FORWARD;
            Component focusedComponent = component.transferFocus(direction);
            if (component != focusedComponent && focusedComponent != null) {
                focusedComponent.scrollAreaToVisible(0, 0, focusedComponent.getWidth(), focusedComponent.getHeight());
            }
            consumed = true;
        }
        return consumed;
    }

    public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        return false;
    }

    public void tooltipTriggered(Component component, int x, int y) {
        String tooltipText = component.getTooltipText();
        if (tooltipText != null) {
            Tooltip tooltip = new Tooltip(new Label(tooltipText));
            Display display = component.getDisplay();
            Point location = component.mapPointToAncestor(display, x, y);
            int tooltipX = location.x + 16;
            int tooltipY = location.y;
            int tooltipHeight = tooltip.getPreferredHeight();
            if (tooltipY + tooltipHeight > display.getHeight()) {
                tooltipY -= tooltipHeight;
            }
            tooltip.setLocation(tooltipX, tooltipY);
            tooltip.open(component.getWindow());
        }
    }

    protected void invalidateComponent() {
        if (this.component != null) {
            this.component.invalidate();
            this.component.repaint();
        }
    }

    protected void repaintComponent() {
        this.repaintComponent(false);
    }

    protected void repaintComponent(boolean immediate) {
        if (this.component != null) {
            this.component.repaint(immediate);
        }
    }

    protected void repaintComponent(Bounds area) {
        assert (area != null) : "area is null.";
        if (this.component != null) {
            this.component.repaint(area.x, area.y, area.width, area.height);
        }
    }

    protected void repaintComponent(int x, int y, int width, int height) {
        if (this.component != null) {
            this.component.repaint(x, y, width, height);
        }
    }

    protected void repaintComponent(int x, int y, int width, int height, boolean immediate) {
        if (this.component != null) {
            this.component.repaint(x, y, width, height, immediate);
        }
    }

    public static Font decodeFont(String value) {
        Font font;
        if (value.startsWith("{")) {
            try {
                font = Theme.deriveFont(JSONSerializer.parseMap((String)value));
            }
            catch (SerializationException exception) {
                throw new IllegalArgumentException(exception);
            }
        } else {
            font = Font.decode(value);
        }
        return font;
    }
}

