/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.StringCharacterIterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.LabelListener;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.TextDecoration;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.skin.ComponentSkin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelSkin
extends ComponentSkin
implements LabelListener {
    private Font font;
    private Color color;
    private Color backgroundColor;
    private TextDecoration textDecoration;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private Insets padding;
    private boolean wrapText;
    private ArrayList<GlyphVector> glyphVectors = null;
    private float textHeight = 0.0f;

    public LabelSkin() {
        Theme theme = Theme.getTheme();
        this.font = theme.getFont();
        this.color = Color.BLACK;
        this.backgroundColor = null;
        this.textDecoration = null;
        this.horizontalAlignment = HorizontalAlignment.LEFT;
        this.verticalAlignment = VerticalAlignment.TOP;
        this.padding = Insets.NONE;
        this.wrapText = false;
    }

    @Override
    public void install(Component component) {
        super.install(component);
        Label label = (Label)this.getComponent();
        label.getLabelListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int height) {
        int preferredWidth;
        Label label = (Label)this.getComponent();
        String text = label.getText();
        if (text != null && text.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            Rectangle2D stringBounds = this.font.getStringBounds(text, fontRenderContext);
            preferredWidth = (int)Math.ceil(stringBounds.getWidth());
        } else {
            preferredWidth = 0;
        }
        return preferredWidth += this.padding.left + this.padding.right;
    }

    @Override
    public int getPreferredHeight(int width) {
        float preferredHeight;
        Label label = (Label)this.getComponent();
        String text = label.getText();
        if (text != null) {
            float lineHeight;
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
            preferredHeight = lineHeight = lm.getHeight();
            int n = text.length();
            if (n > 0 && this.wrapText && width != -1) {
                width -= this.padding.left + this.padding.right;
                float lineWidth = 0.0f;
                int lastWhitespaceIndex = -1;
                for (int i = 0; i < n; ++i) {
                    Rectangle2D characterBounds;
                    char c = text.charAt(i);
                    if (Character.isWhitespace(c)) {
                        lastWhitespaceIndex = i;
                    }
                    if (!((lineWidth = (float)((double)lineWidth + (characterBounds = this.font.getStringBounds(text, i, i + 1, fontRenderContext)).getWidth())) > (float)width) || lastWhitespaceIndex == -1) continue;
                    i = lastWhitespaceIndex;
                    lineWidth = 0.0f;
                    lastWhitespaceIndex = -1;
                    preferredHeight += lineHeight;
                }
            }
        } else {
            preferredHeight = 0.0f;
        }
        return (int)Math.ceil(preferredHeight += (float)(this.padding.top + this.padding.bottom));
    }

    @Override
    public Dimensions getPreferredSize() {
        int preferredWidth;
        Label label = (Label)this.getComponent();
        String text = label.getText();
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        if (text != null && text.length() > 0) {
            Rectangle2D stringBounds = this.font.getStringBounds(text, fontRenderContext);
            preferredWidth = (int)Math.ceil(stringBounds.getWidth());
        } else {
            preferredWidth = 0;
        }
        LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
        int preferredHeight = (int)Math.ceil(lm.getHeight()) + (this.padding.top + this.padding.bottom);
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right, preferredHeight);
    }

    @Override
    public int getBaseline(int width, int height) {
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
        float ascent = lm.getAscent();
        float textHeight = this.wrapText ? (float)Math.max(this.getPreferredHeight(width) - (this.padding.top + this.padding.bottom), 0) : (float)((int)Math.ceil(lm.getHeight()));
        int baseline = -1;
        switch (this.verticalAlignment) {
            case TOP: {
                baseline = Math.round((float)this.padding.top + ascent);
                break;
            }
            case CENTER: {
                baseline = Math.round(((float)height - textHeight) / 2.0f + ascent);
                break;
            }
            case BOTTOM: {
                baseline = Math.round((float)height - (textHeight + (float)this.padding.bottom) + ascent);
            }
        }
        return baseline;
    }

    @Override
    public void layout() {
        int n;
        Label label = (Label)this.getComponent();
        String text = label.getText();
        this.glyphVectors = new ArrayList();
        this.textHeight = 0.0f;
        if (text != null && (n = text.length()) > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            if (this.wrapText) {
                int i;
                int width = this.getWidth() - (this.padding.left + this.padding.right);
                int start = 0;
                float lineWidth = 0.0f;
                int lastWhitespaceIndex = -1;
                StringCharacterIterator ci = new StringCharacterIterator(text);
                for (i = 0; i < n; ++i) {
                    Rectangle2D characterBounds;
                    char c = text.charAt(i);
                    if (Character.isWhitespace(c)) {
                        lastWhitespaceIndex = i;
                    }
                    if (!((lineWidth = (float)((double)lineWidth + (characterBounds = this.font.getStringBounds(ci, i, i + 1, fontRenderContext)).getWidth())) > (float)width) || lastWhitespaceIndex == -1) continue;
                    this.appendLine(text, start, lastWhitespaceIndex, fontRenderContext);
                    i = lastWhitespaceIndex;
                    start = i + 1;
                    lineWidth = 0.0f;
                    lastWhitespaceIndex = -1;
                }
                this.appendLine(text, start, i, fontRenderContext);
            } else {
                this.appendLine(text, 0, text.length(), fontRenderContext);
            }
        }
    }

    private void appendLine(String text, int start, int end, FontRenderContext fontRenderContext) {
        StringCharacterIterator line = new StringCharacterIterator(text, start, end, start);
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, line);
        this.glyphVectors.add((Object)glyphVector);
        Rectangle2D textBounds = glyphVector.getLogicalBounds();
        this.textHeight = (float)((double)this.textHeight + textBounds.getHeight());
    }

    @Override
    public void paint(Graphics2D graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundColor != null) {
            graphics.setPaint(this.backgroundColor);
            graphics.fillRect(0, 0, width, height);
        }
        if (this.glyphVectors.getLength() > 0) {
            graphics.setFont(this.font);
            graphics.setPaint(this.color);
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
            float ascent = lm.getAscent();
            float lineHeight = lm.getHeight();
            float y = 0.0f;
            switch (this.verticalAlignment) {
                case TOP: {
                    y = this.padding.top;
                    break;
                }
                case BOTTOM: {
                    y = (float)height - (this.textHeight + (float)this.padding.bottom);
                    break;
                }
                case CENTER: {
                    y = ((float)height - this.textHeight) / 2.0f;
                }
            }
            int n = this.glyphVectors.getLength();
            for (int i = 0; i < n; ++i) {
                GlyphVector glyphVector = (GlyphVector)this.glyphVectors.get(i);
                Rectangle2D textBounds = glyphVector.getLogicalBounds();
                float lineWidth = (float)textBounds.getWidth();
                float x = 0.0f;
                switch (this.horizontalAlignment) {
                    case LEFT: {
                        x = this.padding.left;
                        break;
                    }
                    case RIGHT: {
                        x = (float)width - (lineWidth + (float)this.padding.right);
                        break;
                    }
                    case CENTER: {
                        x = ((float)width - lineWidth) / 2.0f;
                    }
                }
                graphics.drawGlyphVector(glyphVector, x, y + ascent);
                if (this.textDecoration != null) {
                    graphics.setStroke(new BasicStroke());
                    float offset = 0.0f;
                    switch (this.textDecoration) {
                        case UNDERLINE: {
                            offset = y + ascent + 2.0f;
                            break;
                        }
                        case STRIKETHROUGH: {
                            offset = y + lineHeight / 2.0f + 1.0f;
                        }
                    }
                    Line2D.Float line = new Line2D.Float(x, offset, x + lineWidth, offset);
                    graphics.draw(line);
                }
                y = (float)((double)y + textBounds.getHeight());
            }
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(LabelSkin.decodeFont(font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(color));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(backgroundColor));
    }

    public TextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    public void setTextDecoration(TextDecoration textDecoration) {
        this.textDecoration = textDecoration;
        this.repaintComponent();
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = horizontalAlignment;
        this.repaintComponent();
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new IllegalArgumentException("verticalAlignment is null.");
        }
        this.verticalAlignment = verticalAlignment;
        this.repaintComponent();
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(padding));
    }

    public boolean getWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
        this.invalidateComponent();
    }

    @Override
    public void textChanged(Label label, String previousText) {
        this.invalidateComponent();
    }
}

